/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.ext.awt.g2d.TransformStackElement;
import io.sf.carte.echosvg.svggen.SVGBasicStroke;
import io.sf.carte.echosvg.svggen.SVGClip;
import io.sf.carte.echosvg.svggen.SVGComposite;
import io.sf.carte.echosvg.svggen.SVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGFont;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGPaint;
import io.sf.carte.echosvg.svggen.SVGRenderingHints;
import io.sf.carte.echosvg.svggen.SVGTransform;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class SVGGraphicContextConverter {
    private static final int GRAPHIC_CONTEXT_CONVERTER_COUNT = 6;
    private SVGTransform transformConverter;
    private SVGPaint paintConverter;
    private SVGBasicStroke strokeConverter;
    private SVGComposite compositeConverter;
    private SVGClip clipConverter;
    private SVGRenderingHints hintsConverter;
    private SVGFont fontConverter;
    private SVGConverter[] converters = new SVGConverter[6];

    public SVGTransform getTransformConverter() {
        return this.transformConverter;
    }

    public SVGPaint getPaintConverter() {
        return this.paintConverter;
    }

    public SVGBasicStroke getStrokeConverter() {
        return this.strokeConverter;
    }

    public SVGComposite getCompositeConverter() {
        return this.compositeConverter;
    }

    public SVGClip getClipConverter() {
        return this.clipConverter;
    }

    public SVGRenderingHints getHintsConverter() {
        return this.hintsConverter;
    }

    public SVGFont getFontConverter() {
        return this.fontConverter;
    }

    public SVGGraphicContextConverter(SVGGeneratorContext sVGGeneratorContext) {
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.transformConverter = new SVGTransform(sVGGeneratorContext);
        this.paintConverter = new SVGPaint(sVGGeneratorContext);
        this.strokeConverter = new SVGBasicStroke(sVGGeneratorContext);
        this.compositeConverter = new SVGComposite(sVGGeneratorContext);
        this.clipConverter = new SVGClip(sVGGeneratorContext);
        this.hintsConverter = new SVGRenderingHints(sVGGeneratorContext);
        this.fontConverter = new SVGFont(sVGGeneratorContext);
        int n = 0;
        this.converters[n++] = this.paintConverter;
        this.converters[n++] = this.strokeConverter;
        this.converters[n++] = this.compositeConverter;
        this.converters[n++] = this.clipConverter;
        this.converters[n++] = this.hintsConverter;
        this.converters[n++] = this.fontConverter;
    }

    public String toSVG(TransformStackElement[] transformStackElementArray) {
        return this.transformConverter.toSVGTransform(transformStackElementArray);
    }

    public SVGGraphicContext toSVG(GraphicContext graphicContext) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (SVGConverter sVGConverter : this.converters) {
            SVGDescriptor sVGDescriptor = sVGConverter.toSVG(graphicContext);
            if (sVGDescriptor == null) continue;
            sVGDescriptor.getAttributeMap(hashMap);
        }
        return new SVGGraphicContext(hashMap, graphicContext.getTransformStack());
    }

    public List<Element> getDefinitionSet() {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (SVGConverter sVGConverter : this.converters) {
            linkedList.addAll(sVGConverter.getDefinitionSet());
        }
        return linkedList;
    }
}

