/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.TransformStackElement;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.util.SVGConstants;
import java.util.HashMap;
import java.util.Map;

public class SVGGraphicContext
implements SVGConstants,
ErrorConstants {
    private static final String[] leafOnlyAttributes = new String[]{"opacity", "filter", "clip-path"};
    private static final String[] defaultValues = new String[]{"1", "none", "none"};
    private Map<String, String> context;
    private Map<String, String> groupContext;
    private Map<String, String> graphicElementContext;
    private TransformStackElement[] transformStack;

    public SVGGraphicContext(Map<String, String> map, TransformStackElement[] transformStackElementArray) {
        if (map == null) {
            throw new SVGGraphics2DRuntimeException("context map(s) should not be null");
        }
        if (transformStackElementArray == null) {
            throw new SVGGraphics2DRuntimeException("transformer stack should not be null");
        }
        this.context = map;
        this.transformStack = transformStackElementArray;
        this.computeGroupAndGraphicElementContext();
    }

    public SVGGraphicContext(Map<String, String> map, Map<String, String> map2, TransformStackElement[] transformStackElementArray) {
        if (map == null || map2 == null) {
            throw new SVGGraphics2DRuntimeException("context map(s) should not be null");
        }
        if (transformStackElementArray == null) {
            throw new SVGGraphics2DRuntimeException("transformer stack should not be null");
        }
        this.groupContext = map;
        this.graphicElementContext = map2;
        this.transformStack = transformStackElementArray;
        this.computeContext();
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public Map<String, String> getGroupContext() {
        return this.groupContext;
    }

    public Map<String, String> getGraphicElementContext() {
        return this.graphicElementContext;
    }

    public TransformStackElement[] getTransformStack() {
        return this.transformStack;
    }

    private void computeContext() {
        if (this.context != null) {
            return;
        }
        this.context = new HashMap<String, String>(this.groupContext);
        this.context.putAll(this.graphicElementContext);
    }

    private void computeGroupAndGraphicElementContext() {
        if (this.groupContext != null) {
            return;
        }
        this.groupContext = new HashMap<String, String>(this.context);
        this.graphicElementContext = new HashMap<String, String>();
        for (int i = 0; i < leafOnlyAttributes.length; ++i) {
            String string = this.groupContext.get(leafOnlyAttributes[i]);
            if (string == null) continue;
            if (!string.equals(defaultValues[i])) {
                this.graphicElementContext.put(leafOnlyAttributes[i], string);
            }
            this.groupContext.remove(leafOnlyAttributes[i]);
        }
    }
}

