/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGPaintDescriptor;
import java.awt.Color;
import java.awt.Paint;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SVGColor
extends AbstractSVGConverter {
    public static final Color aqua = Color.cyan;
    public static final Color black = Color.black;
    public static final Color blue = Color.blue;
    public static final Color fuchsia = Color.magenta;
    public static final Color gray = Color.gray;
    public static final Color green = new Color(0, 128, 0);
    public static final Color lime = Color.green;
    public static final Color maroon = new Color(128, 0, 0);
    public static final Color navy = new Color(0, 0, 128);
    public static final Color olive = new Color(128, 128, 0);
    public static final Color purple = new Color(128, 0, 128);
    public static final Color red = Color.red;
    public static final Color silver = new Color(192, 192, 192);
    public static final Color teal = new Color(0, 128, 128);
    public static final Color white = Color.white;
    public static final Color yellow = Color.yellow;
    private static final Set<String> cssProfileNames;
    private static Map<Color, String> colorMap;

    public SVGColor(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Paint paint = graphicContext.getPaint();
        return SVGColor.toSVG((Color)paint, this.getGeneratorContext());
    }

    public static SVGPaintDescriptor toSVG(Color color, SVGGeneratorContext sVGGeneratorContext) {
        String string = colorMap.get(color);
        if (string == null) {
            string = SVGColor.serializeColor(color);
        }
        float f = (float)color.getAlpha() / 255.0f;
        String string2 = sVGGeneratorContext.doubleString(f);
        return new SVGPaintDescriptor(string, string2);
    }

    private static String serializeColor(Color color) {
        StringBuilder stringBuilder;
        ColorSpace colorSpace = color.getColorSpace();
        if (!colorSpace.isCS_sRGB()) {
            String string;
            float[] fArray = color.getColorComponents(null);
            if (!(colorSpace instanceof ICC_ColorSpace) || (string = SVGColor.lcColorProfileName((ICC_ColorSpace)colorSpace)) == null || !cssProfileNames.contains(string)) {
                string = "xyz-d50";
                fArray = colorSpace.toCIEXYZ(fArray);
            }
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ROOT);
            DecimalFormat decimalFormat = new DecimalFormat("#.#", decimalFormatSymbols);
            decimalFormat.setMaximumFractionDigits(6);
            stringBuilder = new StringBuilder(string.length() + 34);
            stringBuilder.append("color(").append(string);
            for (float f : fArray) {
                stringBuilder.append(' ').append(decimalFormat.format(f));
            }
            stringBuilder.append(')');
        } else {
            stringBuilder = new StringBuilder(16);
            stringBuilder.append("rgb(");
            stringBuilder.append(color.getRed());
            stringBuilder.append(",");
            stringBuilder.append(color.getGreen());
            stringBuilder.append(",");
            stringBuilder.append(color.getBlue());
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private static String lcColorProfileName(ICC_ColorSpace iCC_ColorSpace) {
        int n;
        ICC_Profile iCC_Profile = iCC_ColorSpace.getProfile();
        byte[] byArray = iCC_Profile.getData(1684370275);
        byte[] byArray2 = new byte[]{109, 108, 117, 99};
        String string = null;
        if (byArray != null && Arrays.equals(byArray, 0, 4, byArray2, 0, 4) && (n = SVGColor.uInt32Number(byArray, 8)) > 0) {
            int n2 = SVGColor.uInt32Number(byArray, 20);
            int n3 = SVGColor.uInt32Number(byArray, 24);
            int n4 = byArray.length - n3;
            if (n4 > 0) {
                n2 = Math.min(n2, n4);
                string = new String(byArray, n3, n2, StandardCharsets.UTF_16BE).trim();
                if ((string = string.toLowerCase(Locale.ROOT).replace(' ', '-')).contains("bt.2020")) {
                    string = "rec2020";
                } else if ("adobe-rgb-(1998)".equals(string)) {
                    string = "a98-rgb";
                }
            }
        }
        return string;
    }

    private static int uInt32Number(byte[] byArray, int n) {
        long l = (long)(byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16) | (long)(byArray[n] & 0xFF) << 24;
        return (int)l;
    }

    static {
        colorMap = new HashMap<Color, String>();
        colorMap.put(black, "black");
        colorMap.put(silver, "silver");
        colorMap.put(gray, "gray");
        colorMap.put(white, "white");
        colorMap.put(maroon, "maroon");
        colorMap.put(red, "red");
        colorMap.put(purple, "purple");
        colorMap.put(fuchsia, "fuchsia");
        colorMap.put(green, "green");
        colorMap.put(lime, "lime");
        colorMap.put(olive, "olive");
        colorMap.put(yellow, "yellow");
        colorMap.put(navy, "navy");
        colorMap.put(blue, "blue");
        colorMap.put(teal, "teal");
        colorMap.put(aqua, "aqua");
        String[] stringArray = new String[]{"display-p3", "a98-rgb", "prophoto-rgb", "rec2020"};
        cssProfileNames = new HashSet<String>(stringArray.length);
        Collections.addAll(cssProfileNames, stringArray);
    }
}

