/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.SVGEllipse;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicObjectConverter;
import io.sf.carte.echosvg.svggen.SVGLine;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.w3c.dom.Element;

public class SVGArc
extends SVGGraphicObjectConverter {
    private SVGLine svgLine;
    private SVGEllipse svgEllipse;

    public SVGArc(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public Element toSVG(Arc2D arc2D) {
        double d = arc2D.getAngleExtent();
        double d2 = arc2D.getWidth();
        double d3 = arc2D.getHeight();
        if (d2 == 0.0 || d3 == 0.0) {
            Line2D.Double double_ = new Line2D.Double(arc2D.getX(), arc2D.getY(), arc2D.getX() + d2, arc2D.getY() + d3);
            if (this.svgLine == null) {
                this.svgLine = new SVGLine(this.getGeneratorContext());
            }
            return this.svgLine.toSVG(double_);
        }
        if (d >= 360.0 || d <= -360.0) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(arc2D.getX(), arc2D.getY(), d2, d3);
            if (this.svgEllipse == null) {
                this.svgEllipse = new SVGEllipse(this.getGeneratorContext());
            }
            return this.svgEllipse.toSVG(double_);
        }
        Element element = this.getGeneratorContext().getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "path");
        StringBuilder stringBuilder = new StringBuilder(64);
        Point2D point2D = arc2D.getStartPoint();
        Point2D point2D2 = arc2D.getEndPoint();
        int n = arc2D.getArcType();
        stringBuilder.append("M");
        stringBuilder.append(this.doubleString(point2D.getX()));
        stringBuilder.append(" ");
        stringBuilder.append(this.doubleString(point2D.getY()));
        stringBuilder.append(" ");
        stringBuilder.append("A");
        stringBuilder.append(this.doubleString(d2 / 2.0));
        stringBuilder.append(" ");
        stringBuilder.append(this.doubleString(d3 / 2.0));
        stringBuilder.append(" ");
        stringBuilder.append('0');
        stringBuilder.append(" ");
        if (d > 0.0) {
            if (d > 180.0) {
                stringBuilder.append('1');
            } else {
                stringBuilder.append('0');
            }
            stringBuilder.append(" ");
            stringBuilder.append('0');
        } else {
            if (d < -180.0) {
                stringBuilder.append('1');
            } else {
                stringBuilder.append('0');
            }
            stringBuilder.append(" ");
            stringBuilder.append('1');
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.doubleString(point2D2.getX()));
        stringBuilder.append(" ");
        stringBuilder.append(this.doubleString(point2D2.getY()));
        if (n == 1) {
            stringBuilder.append("Z");
        } else if (n == 2) {
            double d4 = arc2D.getX() + d2 / 2.0;
            double d5 = arc2D.getY() + d3 / 2.0;
            stringBuilder.append("L");
            stringBuilder.append(" ");
            stringBuilder.append(this.doubleString(d4));
            stringBuilder.append(" ");
            stringBuilder.append(this.doubleString(d5));
            stringBuilder.append(" ");
            stringBuilder.append("Z");
        }
        element.setAttributeNS(null, "d", stringBuilder.toString());
        return element;
    }
}

