/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.DefaultCachedImageHandler;
import io.sf.carte.echosvg.svggen.ImageCacher;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.util.Base64EncoderStream;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;

public class CachedImageHandlerBase64Encoder
extends DefaultCachedImageHandler {
    public CachedImageHandlerBase64Encoder() {
        this.setImageCacher(new ImageCacher.Embedded());
    }

    @Override
    public Element createElement(SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "use");
        return element;
    }

    @Override
    public String getRefPrefix() {
        return "";
    }

    @Override
    protected AffineTransform handleTransform(Element element, double d, double d2, double d3, double d4, double d5, double d6, SVGGeneratorContext sVGGeneratorContext) {
        AffineTransform affineTransform = new AffineTransform();
        double d7 = d5 / d3;
        double d8 = d6 / d4;
        affineTransform.translate(d, d2);
        if (d7 != 1.0 || d8 != 1.0) {
            affineTransform.scale(d7, d8);
        }
        if (!affineTransform.isIdentity()) {
            return affineTransform;
        }
        return null;
    }

    @Override
    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        Base64EncoderStream base64EncoderStream = new Base64EncoderStream(outputStream);
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        imageWriter.writeImage((RenderedImage)bufferedImage, (OutputStream)base64EncoderStream);
        base64EncoderStream.close();
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension dimension, ColorModel colorModel) {
        BufferedImage bufferedImage;
        if (colorModel == null || colorModel.getColorSpace().isCS_sRGB()) {
            bufferedImage = new BufferedImage(dimension.width, dimension.height, this.getDefaultBufferedImageType());
        } else {
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(dimension.width, dimension.height);
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        }
        return bufferedImage;
    }

    @Override
    protected int getDefaultBufferedImageType() {
        return 2;
    }
}

