/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.anim.dom.XBLEventSupport;
import io.sf.carte.echosvg.anim.dom.XBLOMShadowTreeElement;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeUpdateHandler;
import io.sf.carte.echosvg.bridge.DocumentLoader;
import io.sf.carte.echosvg.bridge.ScriptingEnvironment;
import io.sf.carte.echosvg.bridge.URIResolver;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.bridge.svg12.BindingListener;
import io.sf.carte.echosvg.bridge.svg12.ContentSelectionChangedEvent;
import io.sf.carte.echosvg.bridge.svg12.ContentSelectionChangedListener;
import io.sf.carte.echosvg.bridge.svg12.DefaultXBLManager;
import io.sf.carte.echosvg.bridge.svg12.SVG12BridgeEventSupport;
import io.sf.carte.echosvg.bridge.svg12.SVG12BridgeUpdateHandler;
import io.sf.carte.echosvg.bridge.svg12.SVG12FocusManager;
import io.sf.carte.echosvg.bridge.svg12.SVG12ScriptingEnvironment;
import io.sf.carte.echosvg.bridge.svg12.SVG12URIResolver;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.dom.events.EventSupport;
import io.sf.carte.echosvg.dom.events.NodeEventTarget;
import io.sf.carte.echosvg.dom.xbl.NodeXBL;
import io.sf.carte.echosvg.dom.xbl.XBLManager;
import io.sf.carte.echosvg.script.Interpreter;
import io.sf.carte.echosvg.script.InterpreterPool;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public class SVG12BridgeContext
extends BridgeContext {
    protected XBLBindingListener bindingListener;
    protected XBLContentListener contentListener;
    protected EventTarget mouseCaptureTarget;
    protected boolean mouseCaptureSendAll;
    protected boolean mouseCaptureAutoRelease;

    public SVG12BridgeContext(UserAgent userAgent) {
        super(userAgent);
    }

    public SVG12BridgeContext(UserAgent userAgent, DocumentLoader documentLoader) {
        super(userAgent, documentLoader);
    }

    public SVG12BridgeContext(UserAgent userAgent, InterpreterPool interpreterPool, DocumentLoader documentLoader) {
        super(userAgent, interpreterPool, documentLoader);
    }

    @Override
    public URIResolver createURIResolver(SVGDocument sVGDocument, DocumentLoader documentLoader) {
        return new SVG12URIResolver(sVGDocument, documentLoader);
    }

    @Override
    public void addGVTListener(Document document) {
        SVG12BridgeEventSupport.addGVTListener(this, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.clearChildContexts();
        Set set = this.eventListenerSet;
        synchronized (set) {
            for (BridgeContext.EventListenerMememto eventListenerMememto : this.eventListenerSet) {
                String string;
                NodeEventTarget nodeEventTarget = eventListenerMememto.getTarget();
                EventListener eventListener = eventListenerMememto.getListener();
                boolean bl = eventListenerMememto.getUseCapture();
                String string2 = eventListenerMememto.getEventType();
                boolean bl2 = eventListenerMememto.getNamespaced();
                if (nodeEventTarget == null || eventListener == null || string2 == null) continue;
                if (eventListenerMememto instanceof ImplementationEventListenerMememto) {
                    string = eventListenerMememto.getNamespaceURI();
                    Node node = (Node)nodeEventTarget;
                    AbstractNode abstractNode = (AbstractNode)node.getOwnerDocument();
                    if (abstractNode == null) continue;
                    XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractNode.initializeEventSupport();
                    xBLEventSupport.removeImplementationEventListenerNS(string, string2, eventListener, bl);
                    continue;
                }
                if (bl2) {
                    string = eventListenerMememto.getNamespaceURI();
                    nodeEventTarget.removeEventListenerNS(string, string2, eventListener, bl);
                    continue;
                }
                nodeEventTarget.removeEventListener(string2, eventListener, bl);
            }
        }
        if (this.document != null) {
            this.removeDOMListeners();
            this.removeBindingListener();
        }
        if (this.animationEngine != null) {
            this.animationEngine.dispose();
            this.animationEngine = null;
        }
        for (Interpreter interpreter : this.interpreterMap.values()) {
            if (interpreter == null) continue;
            interpreter.dispose();
        }
        this.interpreterMap.clear();
        if (this.focusManager != null) {
            this.focusManager.dispose();
        }
    }

    public void addBindingListener() {
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        DefaultXBLManager defaultXBLManager = (DefaultXBLManager)abstractDocument.getXBLManager();
        if (defaultXBLManager != null) {
            this.bindingListener = new XBLBindingListener();
            defaultXBLManager.addBindingListener(this.bindingListener);
            this.contentListener = new XBLContentListener();
            defaultXBLManager.addContentSelectionChangedListener(this.contentListener);
        }
    }

    public void removeBindingListener() {
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLManager xBLManager = abstractDocument.getXBLManager();
        if (xBLManager instanceof DefaultXBLManager) {
            DefaultXBLManager defaultXBLManager = (DefaultXBLManager)xBLManager;
            defaultXBLManager.removeBindingListener(this.bindingListener);
            defaultXBLManager.removeContentSelectionChangedListener(this.contentListener);
        }
    }

    @Override
    public void addDOMListeners() {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)sVGOMDocument.initializeEventSupport();
        this.domAttrModifiedEventListener = new EventListenerWrapper(new BridgeContext.DOMAttrModifiedEventListener());
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedEventListener, true);
        this.domNodeInsertedEventListener = new EventListenerWrapper(new BridgeContext.DOMNodeInsertedEventListener());
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedEventListener, true);
        this.domNodeRemovedEventListener = new EventListenerWrapper(new BridgeContext.DOMNodeRemovedEventListener());
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        this.domCharacterDataModifiedEventListener = new EventListenerWrapper(new BridgeContext.DOMCharacterDataModifiedEventListener());
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.domCharacterDataModifiedEventListener, true);
        this.animatedAttributeListener = new BridgeContext.AnimatedAttrListener();
        sVGOMDocument.addAnimatedAttributeListener(this.animatedAttributeListener);
        this.focusManager = new SVG12FocusManager(this.document);
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        this.cssPropertiesChangedListener = new BridgeContext.CSSPropertiesChangedListener();
        cSSEngine.addCSSEngineListener(this.cssPropertiesChangedListener);
    }

    @Override
    public void addUIEventListeners(Document document) {
        EventTarget eventTarget = (EventTarget)((Object)document.getDocumentElement());
        AbstractNode abstractNode = (AbstractNode)eventTarget;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractNode.initializeEventSupport();
        EventListenerWrapper eventListenerWrapper = new EventListenerWrapper(new BridgeContext.DOMMouseOverEventListener());
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)eventListenerWrapper, true);
        this.storeImplementationEventListenerNS(eventTarget, "http://www.w3.org/2001/xml-events", "mouseover", eventListenerWrapper, true);
        EventListenerWrapper eventListenerWrapper2 = new EventListenerWrapper(new BridgeContext.DOMMouseOutEventListener());
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", (EventListener)eventListenerWrapper2, true);
        this.storeImplementationEventListenerNS(eventTarget, "http://www.w3.org/2001/xml-events", "mouseout", eventListenerWrapper2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUIEventListeners(Document document) {
        EventTarget eventTarget = (EventTarget)((Object)document.getDocumentElement());
        AbstractNode abstractNode = (AbstractNode)eventTarget;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractNode.initializeEventSupport();
        Set set = this.eventListenerSet;
        synchronized (set) {
            for (BridgeContext.EventListenerMememto eventListenerMememto : this.eventListenerSet) {
                String string;
                NodeEventTarget nodeEventTarget = eventListenerMememto.getTarget();
                if (nodeEventTarget != eventTarget) continue;
                EventListener eventListener = eventListenerMememto.getListener();
                boolean bl = eventListenerMememto.getUseCapture();
                String string2 = eventListenerMememto.getEventType();
                boolean bl2 = eventListenerMememto.getNamespaced();
                if (nodeEventTarget == null || eventListener == null || string2 == null) continue;
                if (eventListenerMememto instanceof ImplementationEventListenerMememto) {
                    string = eventListenerMememto.getNamespaceURI();
                    xBLEventSupport.removeImplementationEventListenerNS(string, string2, eventListener, bl);
                    continue;
                }
                if (bl2) {
                    string = eventListenerMememto.getNamespaceURI();
                    nodeEventTarget.removeEventListenerNS(string, string2, eventListener, bl);
                    continue;
                }
                nodeEventTarget.removeEventListener(string2, eventListener, bl);
            }
        }
    }

    @Override
    protected void removeDOMListeners() {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.document;
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedEventListener, true);
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedEventListener, true);
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.domCharacterDataModifiedEventListener, true);
        sVGOMDocument.removeAnimatedAttributeListener(this.animatedAttributeListener);
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        if (cSSEngine != null) {
            cSSEngine.removeCSSEngineListener(this.cssPropertiesChangedListener);
            cSSEngine.dispose();
            sVGOMDocument.setCSSEngine(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeImplementationEventListenerNS(EventTarget eventTarget, String string, String string2, EventListener eventListener, boolean bl) {
        Set set = this.eventListenerSet;
        synchronized (set) {
            ImplementationEventListenerMememto implementationEventListenerMememto = new ImplementationEventListenerMememto(eventTarget, string, string2, eventListener, bl, this);
            this.eventListenerSet.add(implementationEventListenerMememto);
        }
    }

    @Override
    public BridgeContext createSubBridgeContext(SVGOMDocument sVGOMDocument) {
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        if (cSSEngine != null) {
            return (BridgeContext)sVGOMDocument.getCSSEngine().getCSSContext();
        }
        BridgeContext bridgeContext = super.createSubBridgeContext(sVGOMDocument);
        if (this.isDynamic() && bridgeContext.isDynamic()) {
            this.setUpdateManager(bridgeContext, this.updateManager);
            if (this.updateManager != null) {
                ScriptingEnvironment scriptingEnvironment = sVGOMDocument.isSVG12() ? new SVG12ScriptingEnvironment(bridgeContext) : new ScriptingEnvironment(bridgeContext);
                scriptingEnvironment.loadScripts();
                scriptingEnvironment.dispatchSVGLoadEvent();
                if (sVGOMDocument.isSVG12()) {
                    DefaultXBLManager defaultXBLManager = new DefaultXBLManager((Document)sVGOMDocument, bridgeContext);
                    this.setXBLManager(bridgeContext, defaultXBLManager);
                    sVGOMDocument.setXBLManager((XBLManager)defaultXBLManager);
                    defaultXBLManager.startProcessing();
                }
            }
        }
        return bridgeContext;
    }

    public void startMouseCapture(EventTarget eventTarget, boolean bl, boolean bl2) {
        this.mouseCaptureTarget = eventTarget;
        this.mouseCaptureSendAll = bl;
        this.mouseCaptureAutoRelease = bl2;
    }

    public void stopMouseCapture() {
        this.mouseCaptureTarget = null;
    }

    protected static class EventListenerWrapper
    implements EventListener {
        protected EventListener listener;

        public EventListenerWrapper(EventListener eventListener) {
            this.listener = eventListener;
        }

        @Override
        public void handleEvent(Event event) {
            this.listener.handleEvent(EventSupport.getUltimateOriginalEvent((Event)event));
        }

        public String toString() {
            return super.toString() + " [wrapping " + this.listener.toString() + "]";
        }
    }

    protected static class ImplementationEventListenerMememto
    extends BridgeContext.EventListenerMememto {
        public ImplementationEventListenerMememto(EventTarget eventTarget, String string, EventListener eventListener, boolean bl, BridgeContext bridgeContext) {
            super(eventTarget, string, eventListener, bl, bridgeContext);
        }

        public ImplementationEventListenerMememto(EventTarget eventTarget, String string, String string2, EventListener eventListener, boolean bl, BridgeContext bridgeContext) {
            super(eventTarget, string, string2, eventListener, bl, bridgeContext);
        }
    }

    protected class XBLBindingListener
    implements BindingListener {
        protected XBLBindingListener() {
        }

        @Override
        public void bindingChanged(Element element, Element element2) {
            BridgeUpdateHandler bridgeUpdateHandler = SVG12BridgeContext.getBridgeUpdateHandler(element);
            if (bridgeUpdateHandler instanceof SVG12BridgeUpdateHandler) {
                SVG12BridgeUpdateHandler sVG12BridgeUpdateHandler = (SVG12BridgeUpdateHandler)bridgeUpdateHandler;
                try {
                    sVG12BridgeUpdateHandler.handleBindingEvent(element, element2);
                }
                catch (Exception exception) {
                    SVG12BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected class XBLContentListener
    implements ContentSelectionChangedListener {
        protected XBLContentListener() {
        }

        @Override
        public void contentSelectionChanged(ContentSelectionChangedEvent contentSelectionChangedEvent) {
            BridgeUpdateHandler bridgeUpdateHandler;
            Element element = (Element)contentSelectionChangedEvent.getContentElement().getParentNode();
            if (element instanceof XBLOMShadowTreeElement) {
                element = ((NodeXBL)element).getXblBoundElement();
            }
            if ((bridgeUpdateHandler = SVG12BridgeContext.getBridgeUpdateHandler(element)) instanceof SVG12BridgeUpdateHandler) {
                SVG12BridgeUpdateHandler sVG12BridgeUpdateHandler = (SVG12BridgeUpdateHandler)bridgeUpdateHandler;
                try {
                    sVG12BridgeUpdateHandler.handleContentSelectionChangedEvent(contentSelectionChangedEvent);
                }
                catch (Exception exception) {
                    SVG12BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }
}

