/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedPoints;
import io.sf.carte.echosvg.anim.dom.SVGOMPolylineElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.AWTPolylineProducer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;

public class SVGPolylineElementBridge
extends SVGDecoratedShapeElementBridge {
    @Override
    public String getLocalName() {
        return "polyline";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPolylineElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Object object;
        SVGOMPolylineElement sVGOMPolylineElement = (SVGOMPolylineElement)element;
        SVGOMAnimatedPoints sVGOMAnimatedPoints = sVGOMPolylineElement.getSVGOMAnimatedPoints();
        short s = sVGOMAnimatedPoints.check();
        if (s >= 0) {
            if (s == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
                return;
            }
            object = new LiveAttributeException(element, element.getLocalName(), s, sVGOMAnimatedPoints.getPoints().toString());
            BridgeException bridgeException = new BridgeException(bridgeContext, (LiveAttributeException)((Object)object));
            SVGPolylineElementBridge.displayErrorOrThrow(bridgeContext, bridgeException);
        }
        try {
            object = sVGOMAnimatedPoints.getAnimatedPoints();
            int n = object.getNumberOfItems();
            if (n == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
            } else {
                AWTPolylineProducer aWTPolylineProducer = new AWTPolylineProducer();
                aWTPolylineProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                aWTPolylineProducer.startPoints();
                for (int i = 0; i < n; ++i) {
                    SVGPoint sVGPoint = object.getItem(i);
                    aWTPolylineProducer.point(sVGPoint.getX(), sVGPoint.getY());
                }
                aWTPolylineProducer.endPoints();
                shapeNode.setVisible(CSSUtilities.convertVisibility(element));
                shapeNode.setShape(aWTPolylineProducer.getShape());
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && (string = animatedLiveAttributeValue.getLocalName()).equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }
}

