/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedPathData;
import io.sf.carte.echosvg.anim.dom.SVGOMPathElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGAnimatedPathDataSupport;
import io.sf.carte.echosvg.dom.svg.SVGPathContext;
import io.sf.carte.echosvg.ext.awt.geom.PathLength;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.AWTPathProducer;
import io.sf.carte.echosvg.parser.PathHandler;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge
implements SVGPathContext {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();
    protected Shape pathLengthShape;
    protected PathLength pathLength;

    @Override
    public String getLocalName() {
        return "path";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Object object;
        SVGOMPathElement sVGOMPathElement = (SVGOMPathElement)element;
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        SVGOMAnimatedPathData sVGOMAnimatedPathData = sVGOMPathElement.getAnimatedPathData();
        short s = sVGOMAnimatedPathData.check();
        if (s >= 0) {
            if (s == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
                return;
            }
            object = new LiveAttributeException(element, element.getLocalName(), s, sVGOMAnimatedPathData.getPathSegList().toString());
            BridgeException bridgeException = new BridgeException(bridgeContext, (LiveAttributeException)((Object)object));
            SVGPathElementBridge.displayErrorOrThrow(bridgeContext, bridgeException);
        }
        if (sVGOMAnimatedPathData.getPathSegList().getNumberOfItems() == 0) {
            shapeNode.setShape(EMPTY_SHAPE);
            shapeNode.setVisible(false);
            return;
        }
        object = sVGOMAnimatedPathData.getAnimatedPathSegList();
        try {
            aWTPathProducer.setWindingRule(CSSUtilities.convertFillRule(element));
            shapeNode.setVisible(CSSUtilities.convertVisibility(element));
            SVGAnimatedPathDataSupport.handlePathSegList((SVGPathSegList)object, (PathHandler)aWTPathProducer);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
        finally {
            shapeNode.setShape(aWTPathProducer.getShape());
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        if (animatedLiveAttributeValue.getNamespaceURI() == null && animatedLiveAttributeValue.getLocalName().equals("d")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
        }
    }

    @Override
    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    protected PathLength getPathLengthObj() {
        Shape shape = ((ShapeNode)this.node).getShape();
        if (this.pathLengthShape != shape) {
            this.pathLength = new PathLength(shape);
            this.pathLengthShape = shape;
        }
        return this.pathLength;
    }

    public float getTotalLength() {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.lengthOfPath();
    }

    public Point2D getPointAtLength(float f) {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.pointAtLength(f);
    }

    public int getPathSegAtLength(float f) {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.segmentAtLength(f);
    }
}

