/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedLength;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedTransformList;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.bridge.AnimatableSVGBridge;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.BridgeUpdateHandler;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.GenericBridge;
import io.sf.carte.echosvg.bridge.GraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.SVGSwitchElementBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineEvent;
import io.sf.carte.echosvg.css.engine.SVGCSSEngine;
import io.sf.carte.echosvg.dom.events.AbstractEvent;
import io.sf.carte.echosvg.dom.svg.AbstractSVGTransformList;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGContext;
import io.sf.carte.echosvg.dom.svg.SVGMotionAnimatableElement;
import io.sf.carte.echosvg.ext.awt.geom.SegmentList;
import io.sf.carte.echosvg.gvt.CanvasGraphicsNode;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.parser.UnitProcessor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGTransformable;

public abstract class AbstractGraphicsNodeBridge
extends AnimatableSVGBridge
implements SVGContext,
BridgeUpdateHandler,
GraphicsNodeBridge,
ErrorConstants {
    protected GraphicsNode node;
    protected boolean isSVG12;
    protected UnitProcessor.Context unitContext;
    protected SoftReference<Shape> bboxShape = null;
    protected Rectangle2D bbox = null;

    protected AbstractGraphicsNodeBridge() {
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        GraphicsNode graphicsNode = this.instantiateGraphicsNode();
        this.setTransform(graphicsNode, element, bridgeContext);
        graphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        this.associateSVGContext(bridgeContext, element, graphicsNode);
        return graphicsNode;
    }

    protected abstract GraphicsNode instantiateGraphicsNode();

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
    }

    float safeAnimatedLength(AbstractSVGAnimatedLength abstractSVGAnimatedLength) throws BridgeException {
        float f;
        try {
            f = abstractSVGAnimatedLength.getCheckedValue();
        }
        catch (LiveAttributeException liveAttributeException) {
            AbstractGraphicsNodeBridge.reportLiveAttributeException(this.ctx, liveAttributeException);
            f = abstractSVGAnimatedLength.getDefault();
        }
        return f;
    }

    float safeAnimatedLength(AbstractSVGAnimatedLength abstractSVGAnimatedLength, float f) throws BridgeException {
        float f2;
        try {
            f2 = abstractSVGAnimatedLength.getCheckedValue();
        }
        catch (LiveAttributeException liveAttributeException) {
            AbstractGraphicsNodeBridge.reportLiveAttributeException(this.ctx, liveAttributeException);
            f2 = f;
        }
        return f2;
    }

    @Override
    public boolean getDisplay(Element element) {
        return CSSUtilities.convertDisplay(element);
    }

    protected AffineTransform computeTransform(SVGTransformable sVGTransformable, BridgeContext bridgeContext) throws BridgeException {
        try {
            AffineTransform affineTransform;
            AbstractSVGTransformList abstractSVGTransformList;
            AffineTransform affineTransform2 = new AffineTransform();
            SVGOMAnimatedTransformList sVGOMAnimatedTransformList = (SVGOMAnimatedTransformList)sVGTransformable.getTransform();
            if (sVGOMAnimatedTransformList.isSpecified()) {
                sVGOMAnimatedTransformList.check();
                abstractSVGTransformList = (AbstractSVGTransformList)sVGTransformable.getTransform().getAnimVal();
                affineTransform2.concatenate(abstractSVGTransformList.getAffineTransform());
            }
            if (this.e instanceof SVGMotionAnimatableElement && (affineTransform = (abstractSVGTransformList = (SVGMotionAnimatableElement)this.e).getMotionTransform()) != null) {
                affineTransform2.concatenate(affineTransform);
            }
            return affineTransform2;
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    protected void setTransform(GraphicsNode graphicsNode, Element element, BridgeContext bridgeContext) {
        graphicsNode.setTransform(this.computeTransform((SVGTransformable)element, bridgeContext));
    }

    protected void associateSVGContext(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.e = element;
        this.node = graphicsNode;
        this.ctx = bridgeContext;
        this.unitContext = UnitProcessor.createContext(bridgeContext, element);
        this.isSVG12 = bridgeContext.isSVG12();
        ((SVGOMElement)element).setSVGContext((SVGContext)this);
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (bridgeContext.isInteractive()) {
            bridgeContext.bind(element, graphicsNode);
        }
    }

    @Override
    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
    }

    protected void handleGeometryChanged() {
        this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
        this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
        this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
        if (this.isSVG12) {
            if (!"use".equals(this.e.getLocalName())) {
                this.fireShapeChangeEvent();
            }
            this.fireBBoxChangeEvent();
        }
    }

    protected void fireShapeChangeEvent() {
        DocumentEvent documentEvent = (DocumentEvent)((Object)this.e.getOwnerDocument());
        AbstractEvent abstractEvent = (AbstractEvent)documentEvent.createEvent("SVGEvents");
        abstractEvent.initEventNS("http://www.w3.org/2000/svg", "shapechange", true, false);
        try {
            ((EventTarget)((Object)this.e)).dispatchEvent((Event)abstractEvent);
        }
        catch (RuntimeException runtimeException) {
            this.ctx.getUserAgent().displayError(runtimeException);
        }
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        Element element;
        Bridge bridge;
        if (mutationEvent.getTarget() instanceof Element && (bridge = this.ctx.getBridge(element = (Element)((Object)mutationEvent.getTarget()))) instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(this.ctx, element);
        }
    }

    @Override
    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        SVGContext sVGContext;
        Node node = this.e.getParentNode();
        if (node instanceof SVGOMElement && (sVGContext = ((SVGOMElement)node).getSVGContext()) instanceof SVGSwitchElementBridge) {
            ((SVGSwitchElementBridge)sVGContext).handleChildElementRemoved(this.e);
            return;
        }
        sVGContext = this.node.getParent();
        sVGContext.remove((Object)this.node);
        AbstractGraphicsNodeBridge.disposeTree(this.e);
    }

    @Override
    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
    }

    @Override
    public void dispose() {
        SVGOMElement sVGOMElement = (SVGOMElement)this.e;
        sVGOMElement.setSVGContext(null);
        this.ctx.unbind(this.e);
        this.bboxShape = null;
    }

    protected static void disposeTree(Node node) {
        AbstractGraphicsNodeBridge.disposeTree(node, true);
    }

    protected static void disposeTree(Node node, boolean bl) {
        Object object;
        SVGContext sVGContext;
        if (node instanceof SVGOMElement && (sVGContext = (object = (SVGOMElement)node).getSVGContext()) instanceof BridgeUpdateHandler) {
            BridgeUpdateHandler bridgeUpdateHandler = (BridgeUpdateHandler)sVGContext;
            if (bl) {
                object.setSVGContext(null);
            }
            bridgeUpdateHandler.dispose();
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            AbstractGraphicsNodeBridge.disposeTree((Node)object, bl);
        }
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        try {
            int[] nArray;
            SVGCSSEngine sVGCSSEngine = (SVGCSSEngine)cSSEngineEvent.getSource();
            for (int n : nArray = cSSEngineEvent.getProperties()) {
                this.handleCSSPropertyChanged(n);
                String string = sVGCSSEngine.getPropertyName(n);
                this.fireBaseAttributeListeners(string);
            }
        }
        catch (Exception exception) {
            this.ctx.getUserAgent().displayError(exception);
        }
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 57: {
                this.node.setVisible(CSSUtilities.convertVisibility(this.e));
                break;
            }
            case 38: {
                this.node.setComposite(CSSUtilities.convertOpacity(this.e));
                break;
            }
            case 18: {
                this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
                break;
            }
            case 37: {
                this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
                break;
            }
            case 3: {
                this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
                break;
            }
            case 40: {
                this.node.setPointerEventType(CSSUtilities.convertPointerEvents(this.e));
                break;
            }
            case 12: {
                if (this.getDisplay(this.e)) break;
                CompositeGraphicsNode compositeGraphicsNode = this.node.getParent();
                compositeGraphicsNode.remove((Object)this.node);
                AbstractGraphicsNodeBridge.disposeTree(this.e, false);
            }
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        if (animatedLiveAttributeValue.getNamespaceURI() == null && animatedLiveAttributeValue.getLocalName().equals("transform")) {
            this.setTransform(this.node, this.e, this.ctx);
            this.handleGeometryChanged();
        }
    }

    @Override
    public void handleOtherAnimationChanged(String string) {
        if (string.equals("motion")) {
            this.setTransform(this.node, this.e, this.ctx);
            this.handleGeometryChanged();
        }
    }

    protected void checkBBoxChange() {
        if (this.e != null) {
            this.fireBBoxChangeEvent();
        }
    }

    protected void fireBBoxChangeEvent() {
        DocumentEvent documentEvent = (DocumentEvent)((Object)this.e.getOwnerDocument());
        AbstractEvent abstractEvent = (AbstractEvent)documentEvent.createEvent("SVGEvents");
        abstractEvent.initEventNS("http://www.w3.org/2000/svg", "RenderedBBoxChange", true, false);
        try {
            ((EventTarget)((Object)this.e)).dispatchEvent((Event)abstractEvent);
        }
        catch (RuntimeException runtimeException) {
            this.ctx.getUserAgent().displayError(runtimeException);
        }
    }

    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    public Rectangle2D getBBox() {
        if (this.node == null) {
            return null;
        }
        Shape shape = this.node.getOutline();
        if (this.bboxShape != null && shape == this.bboxShape.get()) {
            return this.bbox;
        }
        this.bboxShape = new SoftReference<Shape>(shape);
        this.bbox = null;
        if (shape == null) {
            return this.bbox;
        }
        SegmentList segmentList = new SegmentList(shape);
        this.bbox = segmentList.getBounds2D();
        return this.bbox;
    }

    public AffineTransform getCTM() {
        GraphicsNode graphicsNode = this.node;
        AffineTransform affineTransform = new AffineTransform();
        Element element = this.e;
        while (element != null) {
            AffineTransform affineTransform2;
            if (element instanceof SVGFitToViewBox) {
                affineTransform2 = graphicsNode instanceof CanvasGraphicsNode ? ((CanvasGraphicsNode)graphicsNode).getViewingTransform() : graphicsNode.getTransform();
                if (affineTransform2 == null) break;
                affineTransform.preConcatenate(affineTransform2);
                break;
            }
            affineTransform2 = graphicsNode.getTransform();
            if (affineTransform2 != null) {
                affineTransform.preConcatenate(affineTransform2);
            }
            element = CSSEngine.getParentCSSStylableElement((Element)element);
            graphicsNode = graphicsNode.getParent();
        }
        return affineTransform;
    }

    public AffineTransform getScreenTransform() {
        return this.ctx.getUserAgent().getTransform();
    }

    public void setScreenTransform(AffineTransform affineTransform) {
        this.ctx.getUserAgent().setTransform(affineTransform);
    }

    public AffineTransform getGlobalTransform() {
        return this.node.getGlobalTransform();
    }

    public float getViewportWidth() {
        return this.ctx.getBlockWidth(this.e);
    }

    public float getViewportHeight() {
        return this.ctx.getBlockHeight(this.e);
    }

    public float getFontSize() {
        return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
    }
}

