/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.values;

import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableValue;

public class AnimatableLengthValue
extends AnimatableValue {
    protected static final String[] UNITS = new String[]{"", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"};
    protected short lengthType;
    protected float lengthValue;
    protected short percentageInterpretation;

    protected AnimatableLengthValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableLengthValue(AnimationTarget animationTarget, short s, float f, short s2) {
        super(animationTarget);
        this.lengthType = s;
        this.lengthValue = f;
        this.percentageInterpretation = s2;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        float f2;
        AnimatableLengthValue animatableLengthValue;
        AnimatableLengthValue animatableLengthValue2 = animatableValue == null ? new AnimatableLengthValue(this.target) : (AnimatableLengthValue)animatableValue;
        short s = animatableLengthValue2.lengthType;
        float f3 = animatableLengthValue2.lengthValue;
        short s2 = animatableLengthValue2.percentageInterpretation;
        animatableLengthValue2.lengthType = this.lengthType;
        animatableLengthValue2.lengthValue = this.lengthValue;
        animatableLengthValue2.percentageInterpretation = this.percentageInterpretation;
        if (animatableValue2 != null) {
            animatableLengthValue = (AnimatableLengthValue)animatableValue2;
            if (!AnimatableLengthValue.compatibleTypes(animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation)) {
                animatableLengthValue2.lengthValue = this.target.svgToUserSpace(animatableLengthValue2.lengthValue, animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation);
                animatableLengthValue2.lengthType = 1;
                f2 = animatableLengthValue.target.svgToUserSpace(animatableLengthValue.lengthValue, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation);
            } else {
                f2 = animatableLengthValue.lengthValue;
            }
            animatableLengthValue2.lengthValue += f * (f2 - animatableLengthValue2.lengthValue);
        }
        if (animatableValue3 != null) {
            animatableLengthValue = (AnimatableLengthValue)animatableValue3;
            if (!AnimatableLengthValue.compatibleTypes(animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation)) {
                animatableLengthValue2.lengthValue = this.target.svgToUserSpace(animatableLengthValue2.lengthValue, animatableLengthValue2.lengthType, animatableLengthValue2.percentageInterpretation);
                animatableLengthValue2.lengthType = 1;
                f2 = animatableLengthValue.target.svgToUserSpace(animatableLengthValue.lengthValue, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation);
            } else {
                f2 = animatableLengthValue.lengthValue;
            }
            animatableLengthValue2.lengthValue += (float)n * f2;
        }
        if (s2 != animatableLengthValue2.percentageInterpretation || s != animatableLengthValue2.lengthType || f3 != animatableLengthValue2.lengthValue) {
            animatableLengthValue2.hasChanged = true;
        }
        return animatableLengthValue2;
    }

    public static boolean compatibleTypes(short s, short s2, short s3, short s4) {
        return s == s3 && (s != 2 || s2 == s4) || s == 1 && s3 == 5 || s == 5 && s3 == 1;
    }

    public int getLengthType() {
        return this.lengthType;
    }

    public float getLengthValue() {
        return this.lengthValue;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableLengthValue animatableLengthValue = (AnimatableLengthValue)animatableValue;
        float f = this.target.svgToUserSpace(this.lengthValue, this.lengthType, this.percentageInterpretation);
        float f2 = this.target.svgToUserSpace(animatableLengthValue.lengthValue, animatableLengthValue.lengthType, animatableLengthValue.percentageInterpretation);
        return Math.abs(f - f2);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableLengthValue(this.target, 1, 0.0f, this.percentageInterpretation);
    }

    @Override
    public String getCssText() {
        return AnimatableLengthValue.formatNumber(this.lengthValue) + UNITS[this.lengthType - 1];
    }
}

