/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AnimatedAttributeListener;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGStylableElement;
import io.sf.carte.echosvg.anim.dom.SVGStyleSheetProcessingInstruction;
import io.sf.carte.echosvg.css.engine.CSSNavigableDocument;
import io.sf.carte.echosvg.css.engine.CSSNavigableDocumentListener;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractStylableDocument;
import io.sf.carte.echosvg.dom.ExtensibleDOMImplementation;
import io.sf.carte.echosvg.dom.GenericAttr;
import io.sf.carte.echosvg.dom.GenericAttrNS;
import io.sf.carte.echosvg.dom.GenericCDATASection;
import io.sf.carte.echosvg.dom.GenericComment;
import io.sf.carte.echosvg.dom.GenericDocumentFragment;
import io.sf.carte.echosvg.dom.GenericElement;
import io.sf.carte.echosvg.dom.GenericEntityReference;
import io.sf.carte.echosvg.dom.GenericProcessingInstruction;
import io.sf.carte.echosvg.dom.GenericText;
import io.sf.carte.echosvg.dom.StyleSheetFactory;
import io.sf.carte.echosvg.dom.events.EventSupport;
import io.sf.carte.echosvg.dom.svg.IdContainer;
import io.sf.carte.echosvg.dom.svg.SVGContext;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import io.sf.carte.echosvg.dom.util.XMLSupport;
import io.sf.carte.echosvg.i18n.LocalizableSupport;
import io.sf.carte.echosvg.util.ParsedURL;
import io.sf.carte.echosvg.util.SVGConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGOMDocument
extends AbstractStylableDocument
implements SVGDocument,
SVGConstants,
CSSNavigableDocument,
IdContainer {
    private static final long serialVersionUID = 1L;
    protected static final String RESOURCES = "io.sf.carte.echosvg.dom.svg.resources.Messages";
    protected String referrer = "";
    protected ParsedURL url;
    protected transient boolean readonly;
    protected boolean isSVG12;
    protected HashMap<CSSNavigableDocumentListener, EventListener[]> cssNavigableDocumentListeners = new HashMap();
    protected AnimatedAttributeListener mainAnimatedAttributeListener = new AnimAttrListener();
    protected LinkedList<AnimatedAttributeListener> animatedAttributeListeners = new LinkedList();
    protected transient SVGContext svgContext;

    protected SVGOMDocument() {
    }

    public SVGOMDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(documentType, dOMImplementation);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.localizableSupport.setLocale(locale);
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        try {
            return super.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return this.localizableSupport.formatMessage(string, objectArray);
        }
    }

    public String getTitle() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (object = this.getDocumentElement().getFirstChild(); object != null; object = object.getNextSibling()) {
            String string = object.getNamespaceURI();
            if (string == null || !string.equals("http://www.w3.org/2000/svg") || !object.getLocalName().equals("title")) continue;
            bl = ((SVGLangSpace)object).getXMLspace().equals("preserve");
            for (object = object.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 3) continue;
                stringBuilder.append(object.getNodeValue());
            }
            break;
        }
        object = stringBuilder.toString();
        return bl ? XMLSupport.preserveXMLSpace((String)object) : XMLSupport.defaultXMLSpace((String)object);
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String string) {
        this.referrer = string;
    }

    public String getDomain() {
        return this.url == null ? null : this.url.getHost();
    }

    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    public String getURL() {
        return this.documentURI;
    }

    public URL getURLObject() {
        try {
            return new URL(this.documentURI);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ParsedURL getParsedURL() {
        return this.url;
    }

    public void setURLObject(URL uRL) {
        this.setParsedURL(new ParsedURL(uRL));
    }

    public void setParsedURL(ParsedURL parsedURL) {
        this.url = parsedURL;
        this.documentURI = parsedURL == null ? null : parsedURL.toString();
    }

    public void setDocumentURI(String string) {
        this.documentURI = string;
        this.url = string == null ? null : new ParsedURL(string);
    }

    public Element createElement(String string) throws DOMException {
        return new GenericElement(string.intern(), (AbstractDocument)this);
    }

    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment((AbstractDocument)this);
    }

    public Text createTextNode(String string) {
        return new GenericText(string, (AbstractDocument)this);
    }

    public Comment createComment(String string) {
        return new GenericComment(string, (AbstractDocument)this);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new GenericCDATASection(string, (AbstractDocument)this);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if ("xml-stylesheet".equals(string)) {
            return new SVGStyleSheetProcessingInstruction(string2, (AbstractDocument)this, (StyleSheetFactory)this.getImplementation());
        }
        return new GenericProcessingInstruction(string, string2, (AbstractDocument)this);
    }

    public Attr createAttribute(String string) throws DOMException {
        return new GenericAttr(string.intern(), (AbstractDocument)this);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new GenericEntityReference(string, (AbstractDocument)this);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string == null) {
            return new GenericAttr(string2.intern(), (AbstractDocument)this);
        }
        return new GenericAttrNS(string.intern(), string2.intern(), (AbstractDocument)this);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)((Object)this.implementation);
        return sVGDOMImplementation.createElementNS((AbstractDocument)this, string, string2);
    }

    protected Element importElement(Node node, boolean bl) {
        SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)((Object)this.implementation);
        String string = node.getNamespaceURI();
        if ("http://www.w3.org/2000/svg".equals(string)) {
            String string2 = node.getNodeName();
            String string3 = DOMUtilities.getLocalName((String)string2);
            ExtensibleDOMImplementation.ElementFactory elementFactory = sVGDOMImplementation.factories.get(string3);
            if (elementFactory != null) {
                Element element = elementFactory.create(string3, (Document)((Object)this));
                elementFactory.importAttributes(element, node, bl);
                return element;
            }
            if ("div".equals(string3)) {
                string = "http://www.w3.org/1999/xhtml";
            }
        }
        return super.importElement(node, bl);
    }

    public boolean isSVG12() {
        return this.isSVG12;
    }

    public void setIsSVG12(boolean bl) {
        this.isSVG12 = bl;
    }

    public boolean isId(Attr attr) {
        if (attr.getNamespaceURI() == null) {
            return "id".equals(attr.getNodeName());
        }
        return attr.getNodeName().equals("xml:id");
    }

    public void setSVGContext(SVGContext sVGContext) {
        this.svgContext = sVGContext;
    }

    public SVGContext getSVGContext() {
        return this.svgContext;
    }

    public void addCSSNavigableDocumentListener(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
        if (this.cssNavigableDocumentListeners.containsKey(cSSNavigableDocumentListener)) {
            return;
        }
        DOMNodeInsertedListenerWrapper dOMNodeInsertedListenerWrapper = new DOMNodeInsertedListenerWrapper(cSSNavigableDocumentListener);
        DOMNodeRemovedListenerWrapper dOMNodeRemovedListenerWrapper = new DOMNodeRemovedListenerWrapper(cSSNavigableDocumentListener);
        DOMSubtreeModifiedListenerWrapper dOMSubtreeModifiedListenerWrapper = new DOMSubtreeModifiedListenerWrapper(cSSNavigableDocumentListener);
        DOMCharacterDataModifiedListenerWrapper dOMCharacterDataModifiedListenerWrapper = new DOMCharacterDataModifiedListenerWrapper(cSSNavigableDocumentListener);
        DOMAttrModifiedListenerWrapper dOMAttrModifiedListenerWrapper = new DOMAttrModifiedListenerWrapper(cSSNavigableDocumentListener);
        this.cssNavigableDocumentListeners.put(cSSNavigableDocumentListener, new EventListener[]{dOMNodeInsertedListenerWrapper, dOMNodeRemovedListenerWrapper, dOMSubtreeModifiedListenerWrapper, dOMCharacterDataModifiedListenerWrapper, dOMAttrModifiedListenerWrapper});
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", dOMNodeInsertedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", dOMNodeRemovedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", dOMSubtreeModifiedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", dOMCharacterDataModifiedListenerWrapper, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", dOMAttrModifiedListenerWrapper, false, null);
    }

    public void removeCSSNavigableDocumentListener(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
        EventListener[] eventListenerArray = this.cssNavigableDocumentListeners.get(cSSNavigableDocumentListener);
        if (eventListenerArray == null) {
            return;
        }
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", eventListenerArray[0], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", eventListenerArray[1], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", eventListenerArray[2], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", eventListenerArray[3], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", eventListenerArray[4], false);
        this.cssNavigableDocumentListeners.remove(cSSNavigableDocumentListener);
    }

    protected AnimatedAttributeListener getAnimatedAttributeListener() {
        return this.mainAnimatedAttributeListener;
    }

    protected void overrideStyleTextChanged(CSSStylableElement cSSStylableElement, String string) {
        for (CSSNavigableDocumentListener cSSNavigableDocumentListener : this.cssNavigableDocumentListeners.keySet()) {
            cSSNavigableDocumentListener.overrideStyleTextChanged(cSSStylableElement, string);
        }
    }

    protected void overrideStylePropertyRemoved(CSSStylableElement cSSStylableElement, String string) {
        for (CSSNavigableDocumentListener cSSNavigableDocumentListener : this.cssNavigableDocumentListeners.keySet()) {
            cSSNavigableDocumentListener.overrideStylePropertyRemoved(cSSStylableElement, string);
        }
    }

    protected void overrideStylePropertyChanged(CSSStylableElement cSSStylableElement, String string, String string2, String string3) {
        for (CSSNavigableDocumentListener cSSNavigableDocumentListener : this.cssNavigableDocumentListeners.keySet()) {
            cSSNavigableDocumentListener.overrideStylePropertyChanged(cSSStylableElement, string, string2, string3);
        }
    }

    public void addAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        if (this.animatedAttributeListeners.contains(animatedAttributeListener)) {
            return;
        }
        this.animatedAttributeListeners.add(animatedAttributeListener);
    }

    public void removeAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        this.animatedAttributeListeners.remove(animatedAttributeListener);
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        if (element instanceof SVGStylableElement && string == null) {
            return ((SVGStylableElement)((Object)element)).getOverrideStyle();
        }
        return null;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    protected Node newNode() {
        return new SVGOMDocument();
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)((Object)node);
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES, ((Object)((Object)this)).getClass().getClassLoader());
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)((Object)node);
        sVGOMDocument.localizableSupport = new LocalizableSupport(RESOURCES, ((Object)((Object)this)).getClass().getClassLoader());
        sVGOMDocument.referrer = this.referrer;
        sVGOMDocument.url = this.url;
        return node;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected class AnimAttrListener
    implements AnimatedAttributeListener {
        protected AnimAttrListener() {
        }

        @Override
        public void animatedAttributeChanged(Element element, AnimatedLiveAttributeValue animatedLiveAttributeValue) {
            for (AnimatedAttributeListener animatedAttributeListener : SVGOMDocument.this.animatedAttributeListeners) {
                animatedAttributeListener.animatedAttributeChanged(element, animatedLiveAttributeValue);
            }
        }

        @Override
        public void otherAnimationChanged(Element element, String string) {
            for (AnimatedAttributeListener animatedAttributeListener : SVGOMDocument.this.animatedAttributeListeners) {
                animatedAttributeListener.otherAnimationChanged(element, string);
            }
        }
    }

    protected static class DOMAttrModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMAttrModifiedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        @Override
        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent((Event)event);
            MutationEvent mutationEvent = (MutationEvent)event;
            this.listener.attrModified((Element)((Object)event.getTarget()), (Attr)mutationEvent.getRelatedNode(), mutationEvent.getAttrChange(), mutationEvent.getPrevValue(), mutationEvent.getNewValue());
        }
    }

    protected static class DOMCharacterDataModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMCharacterDataModifiedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        @Override
        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent((Event)event);
            this.listener.characterDataModified((Node)((Object)event.getTarget()));
        }
    }

    protected static class DOMNodeInsertedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMNodeInsertedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        @Override
        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent((Event)event);
            this.listener.nodeInserted((Node)((Object)event.getTarget()));
        }
    }

    protected static class DOMNodeRemovedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMNodeRemovedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        @Override
        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent((Event)event);
            this.listener.nodeToBeRemoved((Node)((Object)event.getTarget()));
        }
    }

    protected static class DOMSubtreeModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMSubtreeModifiedListenerWrapper(CSSNavigableDocumentListener cSSNavigableDocumentListener) {
            this.listener = cSSNavigableDocumentListener;
        }

        @Override
        public void handleEvent(Event event) {
            event = EventSupport.getUltimateOriginalEvent((Event)event);
            this.listener.subtreeModified((Node)((Object)event.getTarget()));
        }
    }
}

