/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableRectValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGOMRect;
import io.sf.carte.echosvg.parser.DefaultNumberListHandler;
import io.sf.carte.echosvg.parser.NumberListHandler;
import io.sf.carte.echosvg.parser.NumberListParser;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGRect;

public class SVGOMAnimatedRect
extends AbstractSVGAnimatedValue
implements SVGAnimatedRect {
    protected BaseSVGRect baseVal;
    protected AnimSVGRect animVal;
    protected boolean changing;
    protected String defaultValue;

    public SVGOMAnimatedRect(AbstractElement abstractElement, String string, String string2, String string3) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
    }

    public SVGRect getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGRect();
        }
        return this.baseVal;
    }

    public SVGRect getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGRect();
        }
        return this.animVal;
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableRectValue animatableRectValue = (AnimatableRectValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGRect();
            }
            this.animVal.setAnimatedValue(animatableRectValue.getX(), animatableRectValue.getY(), animatableRectValue.getWidth(), animatableRectValue.getHeight());
        }
        this.fireAnimatedAttributeListeners();
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        this.getBaseVal();
        float[] fArray = this.baseVal.toArray();
        return new AnimatableRectValue(animationTarget, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGRect
    extends SVGOMRect {
        protected AnimSVGRect() {
        }

        public float getX() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getX();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getX();
        }

        public float getY() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getY();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getY();
        }

        public float getWidth() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getWidth();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getWidth();
        }

        public float getHeight() {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.getHeight();
            }
            return SVGOMAnimatedRect.this.getBaseVal().getHeight();
        }

        public void setX(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setY(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setWidth(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        public void setHeight(float f) throws DOMException {
            throw SVGOMAnimatedRect.this.element.createDOMException((short)7, "readonly.length", null);
        }

        protected void setAnimatedValue(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
        }

        public float[] toArray() throws LiveAttributeException {
            if (SVGOMAnimatedRect.this.hasAnimVal) {
                return super.toArray();
            }
            return ((SVGOMRect)SVGOMAnimatedRect.this.getBaseVal()).toArray();
        }
    }

    protected class BaseSVGRect
    extends SVGOMRect {
        protected boolean valid;

        protected BaseSVGRect() {
        }

        public void invalidate() {
            this.valid = false;
        }

        protected void reset() {
            try {
                SVGOMAnimatedRect.this.changing = true;
                SVGOMAnimatedRect.this.element.setAttributeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName, Float.toString(this.x) + ' ' + this.y + ' ' + this.w + ' ' + this.h);
            }
            finally {
                SVGOMAnimatedRect.this.changing = false;
            }
        }

        protected void revalidate() throws LiveAttributeException {
            if (this.valid) {
                return;
            }
            Attr attr = SVGOMAnimatedRect.this.element.getAttributeNodeNS(SVGOMAnimatedRect.this.namespaceURI, SVGOMAnimatedRect.this.localName);
            final String string = attr == null ? SVGOMAnimatedRect.this.defaultValue : attr.getValue();
            final float[] fArray = new float[4];
            NumberListParser numberListParser = new NumberListParser();
            numberListParser.setNumberListHandler((NumberListHandler)new DefaultNumberListHandler(){
                protected int count;

                public void endNumberList() {
                    if (this.count != 4) {
                        throw new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, string);
                    }
                }

                public void numberValue(float f) throws ParseException {
                    if (this.count < 4) {
                        fArray[this.count] = f;
                    }
                    if (f < 0.0f && (this.count == 2 || this.count == 3)) {
                        throw new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, string);
                    }
                    ++this.count;
                }

                public void calcValue(int n, int n2) throws ParseException {
                    throw new CalcParseException("Cannot handle calc().", n, n2);
                }
            });
            try {
                numberListParser.parse(string);
            }
            catch (CalcParseException calcParseException) {
                ValueFactory valueFactory = new ValueFactory();
                try {
                    StyleValue styleValue = valueFactory.parseProperty(string);
                    if (!this.computeRectangle(styleValue, fArray)) {
                        throw new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, string);
                    }
                }
                catch (Exception exception) {
                    LiveAttributeException liveAttributeException = new LiveAttributeException((Element)((Object)SVGOMAnimatedRect.this.element), SVGOMAnimatedRect.this.localName, 1, string);
                    liveAttributeException.initCause((Throwable)exception);
                    throw liveAttributeException;
                }
            }
            this.x = fArray[0];
            this.y = fArray[1];
            this.w = fArray[2];
            this.h = fArray[3];
            this.valid = true;
        }

        private boolean computeRectangle(StyleValue styleValue, float[] fArray) throws DOMException {
            if (styleValue.getCssValueType() != CSSValue.CssType.LIST) {
                return false;
            }
            ValueList valueList = (ValueList)styleValue;
            if (valueList.getLength() != 4) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                StyleValue styleValue2 = valueList.item(i);
                if (styleValue2.getCssValueType() != CSSValue.CssType.TYPED) {
                    return false;
                }
                TypedValue typedValue = (TypedValue)styleValue2;
                switch (styleValue2.getPrimitiveType()) {
                    case NUMERIC: {
                        if (typedValue.getUnitType() == 0) break;
                        return false;
                    }
                    case EXPRESSION: {
                        Evaluator evaluator = new Evaluator();
                        typedValue = evaluator.evaluateExpression((ExpressionValue)typedValue);
                        if (typedValue.getUnitType() == 0) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                fArray[i] = typedValue.getFloatValue((short)0);
            }
            return true;
        }

        public float getX() {
            this.revalidate();
            return this.x;
        }

        public void setX(float f) throws DOMException {
            this.x = f;
            this.reset();
        }

        public float getY() {
            this.revalidate();
            return this.y;
        }

        public void setY(float f) throws DOMException {
            this.y = f;
            this.reset();
        }

        public float getWidth() {
            this.revalidate();
            return this.w;
        }

        public void setWidth(float f) throws DOMException {
            this.w = f;
            this.reset();
        }

        public float getHeight() {
            this.revalidate();
            return this.h;
        }

        public void setHeight(float f) throws DOMException {
            this.h = f;
            this.reset();
        }

        public float[] toArray() throws LiveAttributeException {
            this.revalidate();
            return super.toArray();
        }
    }

    static class CalcParseException
    extends ParseException {
        private static final long serialVersionUID = 1L;

        public CalcParseException(String string, int n, int n2) {
            super(string, n, n2);
        }
    }
}

