/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.dom.svg.AbstractSVGMatrix;
import io.sf.carte.echosvg.dom.svg.SVGContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public class SVGLocatableSupport {
    public static SVGElement getNearestViewportElement(Element element) {
        Element element2 = element;
        while (element2 != null && !((element2 = CSSEngine.getParentCSSStylableElement((Element)element2)) instanceof SVGFitToViewBox)) {
        }
        return (SVGElement)element2;
    }

    public static SVGElement getFarthestViewportElement(Element element) {
        Element element2 = element.getOwnerDocument().getDocumentElement();
        if (element == element2) {
            return null;
        }
        return (SVGElement)element2;
    }

    public static SVGRect getBBox(Element element) {
        final SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        SVGContext sVGContext = sVGOMElement.getSVGContext();
        if (sVGContext == null) {
            return null;
        }
        if (sVGContext.getBBox() == null) {
            return null;
        }
        return new SVGRect(){

            public float getX() {
                return (float)sVGOMElement.getSVGContext().getBBox().getX();
            }

            public void setX(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getY() {
                return (float)sVGOMElement.getSVGContext().getBBox().getY();
            }

            public void setY(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getWidth() {
                return (float)sVGOMElement.getSVGContext().getBBox().getWidth();
            }

            public void setWidth(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getHeight() {
                return (float)sVGOMElement.getSVGContext().getBBox().getHeight();
            }

            public void setHeight(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }
        };
    }

    public static SVGMatrix getCTM(Element element) {
        final SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        return new AbstractSVGMatrix(){

            protected AffineTransform getAffineTransform() {
                return sVGOMElement.getSVGContext().getCTM();
            }
        };
    }

    public static SVGMatrix getScreenCTM(Element element) {
        final SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        return new AbstractSVGMatrix(){

            protected AffineTransform getAffineTransform() {
                SVGContext sVGContext = sVGOMElement.getSVGContext();
                AffineTransform affineTransform = sVGContext.getGlobalTransform();
                AffineTransform affineTransform2 = sVGContext.getScreenTransform();
                if (affineTransform2 != null) {
                    affineTransform.preConcatenate(affineTransform2);
                }
                return affineTransform;
            }
        };
    }

    public static SVGMatrix getTransformToElement(Element element, SVGElement sVGElement) throws SVGException {
        final SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        final SVGOMElement sVGOMElement2 = (SVGOMElement)sVGElement;
        return new AbstractSVGMatrix(){

            protected AffineTransform getAffineTransform() {
                AffineTransform affineTransform;
                AffineTransform affineTransform2 = sVGOMElement.getSVGContext().getGlobalTransform();
                if (affineTransform2 == null) {
                    affineTransform2 = new AffineTransform();
                }
                if ((affineTransform = sVGOMElement2.getSVGContext().getGlobalTransform()) == null) {
                    affineTransform = new AffineTransform();
                }
                AffineTransform affineTransform3 = new AffineTransform(affineTransform2);
                try {
                    affineTransform3.preConcatenate(affineTransform.createInverse());
                    return affineTransform3;
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    throw sVGOMElement.createSVGException((short)2, "noninvertiblematrix", null);
                }
            }
        };
    }
}

