/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.wmf.tosvg;

import io.sf.carte.echosvg.svggen.SVGGraphics2D;
import io.sf.carte.echosvg.transcoder.ToSVGAbstractTranscoder;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.wmf.tosvg.WMFPainter;
import io.sf.carte.echosvg.transcoder.wmf.tosvg.WMFRecordStore;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WMFTranscoder
extends ToSVGAbstractTranscoder {
    public static final String WMF_EXTENSION = ".wmf";
    public static final String SVG_EXTENSION = ".svg";

    @Override
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        int n;
        int n2;
        float f;
        float f2;
        DataInputStream dataInputStream = this.getCompatibleInput(transcoderInput);
        WMFRecordStore wMFRecordStore = new WMFRecordStore();
        try {
            wMFRecordStore.read(dataInputStream);
        }
        catch (IOException iOException) {
            this.handler.fatalError(new TranscoderException(iOException));
            return;
        }
        float f3 = 1.0f;
        if (this.hints.containsKey(KEY_INPUT_WIDTH)) {
            f2 = ((Integer)this.hints.get(KEY_INPUT_WIDTH)).intValue();
            f = ((Integer)this.hints.get(KEY_INPUT_HEIGHT)).intValue();
        } else {
            f2 = wMFRecordStore.getWidthPixels();
            f = wMFRecordStore.getHeightPixels();
        }
        float f4 = f2;
        float f5 = f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f4 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
            f3 = f4 / f2;
            f5 = f5 * f4 / f2;
        }
        int n3 = 0;
        int n4 = 0;
        if (this.hints.containsKey(KEY_XOFFSET)) {
            n3 = (Integer)this.hints.get(KEY_XOFFSET);
        }
        if (this.hints.containsKey(KEY_YOFFSET)) {
            n4 = (Integer)this.hints.get(KEY_YOFFSET);
        }
        float f6 = wMFRecordStore.getUnitsToPixels() * f3;
        int n5 = (int)(wMFRecordStore.getVpX() * f6);
        int n6 = (int)(wMFRecordStore.getVpY() * f6);
        if (this.hints.containsKey(KEY_INPUT_WIDTH)) {
            n2 = (int)((float)((Integer)this.hints.get(KEY_INPUT_WIDTH)).intValue() * f3);
            n = (int)((float)((Integer)this.hints.get(KEY_INPUT_HEIGHT)).intValue() * f3);
        } else {
            n2 = (int)((float)wMFRecordStore.getWidthUnits() * f6);
            n = (int)((float)wMFRecordStore.getHeightUnits() * f6);
        }
        WMFPainter wMFPainter = new WMFPainter(wMFRecordStore, n3, n4, f3);
        Document document = this.createDocument(transcoderOutput);
        this.svgGenerator = new SVGGraphics2D(document);
        this.svgGenerator.getGeneratorContext().setPrecision(4);
        wMFPainter.paint((Graphics)this.svgGenerator);
        this.svgGenerator.setSVGCanvasSize(new Dimension(n2, n));
        Element element = this.svgGenerator.getRoot();
        element.setAttributeNS(null, "viewBox", String.valueOf(n5) + ' ' + n6 + ' ' + n2 + ' ' + n);
        this.writeSVGToOutput(this.svgGenerator, element, transcoderOutput);
    }

    private DataInputStream getCompatibleInput(TranscoderInput transcoderInput) throws TranscoderException {
        if (transcoderInput == null) {
            this.handler.fatalError(new TranscoderException(String.valueOf(65280)));
            return null;
        }
        InputStream inputStream = transcoderInput.getInputStream();
        if (inputStream != null) {
            return new DataInputStream(new BufferedInputStream(inputStream));
        }
        String string = transcoderInput.getURI();
        if (string != null) {
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
                return new DataInputStream(new BufferedInputStream(inputStream));
            }
            catch (MalformedURLException malformedURLException) {
                this.handler.fatalError(new TranscoderException(malformedURLException));
            }
            catch (IOException iOException) {
                this.handler.fatalError(new TranscoderException(iOException));
            }
        }
        this.handler.fatalError(new TranscoderException(String.valueOf(65281)));
        return null;
    }

    public static void main(String[] stringArray) throws TranscoderException {
        if (stringArray.length < 1) {
            System.out.println("Usage : WMFTranscoder.main <file 1> ... <file n>");
            System.exit(1);
        }
        WMFTranscoder wMFTranscoder = new WMFTranscoder();
        for (String string : stringArray) {
            if (!string.toLowerCase().endsWith(WMF_EXTENSION)) {
                System.err.println(string + " does not have the " + WMF_EXTENSION + " extension. It is ignored");
                continue;
            }
            System.out.print("Processing : " + string + "...");
            String string2 = string.substring(0, string.toLowerCase().indexOf(WMF_EXTENSION)) + SVG_EXTENSION;
            File file = new File(string);
            File file2 = new File(string2);
            try {
                TranscoderInput transcoderInput = new TranscoderInput(file.toURI().toURL().toString());
                TranscoderOutput transcoderOutput = new TranscoderOutput(new FileOutputStream(file2));
                wMFTranscoder.transcode(transcoderInput, transcoderOutput);
            }
            catch (MalformedURLException malformedURLException) {
                throw new TranscoderException(malformedURLException);
            }
            catch (IOException iOException) {
                throw new TranscoderException(iOException);
            }
            System.out.println(".... Done");
        }
        System.exit(0);
    }
}

