/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.impl;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class SizingHelper {
    SizingHelper() {
    }

    public static void defaultDimensions(Element element) {
        String string;
        String string2 = element.getAttribute("width").trim();
        String string3 = element.getAttribute("height").trim();
        if (string2.isEmpty() || "auto".equalsIgnoreCase(string2)) {
            SizingHelper.defaultWidth(element, string3);
        }
        if ((string3.isEmpty() || "auto".equalsIgnoreCase(string3)) && (string = element.getAttribute("viewBox").trim()).isEmpty()) {
            element.setAttribute("height", "150px");
        }
    }

    private static void defaultWidth(Element element, String string) {
        String string2;
        String string3 = element.getAttribute("viewBox").trim();
        if (string3.isEmpty()) {
            string2 = "300px";
        } else if (!string.isEmpty() && !"auto".equalsIgnoreCase(string)) {
            try {
                float f = SizingHelper.computeAspectRatio(string3);
                float f2 = SizingHelper.floatValue(string);
                if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                    string2 = Float.toString(f * f2);
                }
                string2 = "300px";
            }
            catch (TranscoderException transcoderException) {
                return;
            }
            catch (Exception exception) {
                string2 = "300px";
            }
        } else {
            return;
        }
        element.setAttribute("width", string2);
    }

    static float computeAspectRatio(String string) throws DOMException {
        float[] fArray;
        ValueFactory valueFactory = new ValueFactory();
        StyleValue styleValue = valueFactory.parseProperty(string);
        if (!SizingHelper.computeRectangle(styleValue, fArray = new float[4])) {
            throw new DOMException(12, "Wrong viewBox attribute.");
        }
        return fArray[2] / fArray[3];
    }

    static boolean computeRectangle(StyleValue styleValue, float[] fArray) throws DOMException {
        if (styleValue.getCssValueType() != CSSValue.CssType.LIST) {
            return false;
        }
        ValueList valueList = (ValueList)styleValue;
        if (valueList.getLength() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            TypedValue typedValue;
            StyleValue styleValue2 = valueList.item(i);
            if (styleValue2.getCssValueType() != CSSValue.CssType.TYPED) {
                return false;
            }
            switch (styleValue2.getPrimitiveType()) {
                case NUMERIC: {
                    typedValue = (TypedValue)styleValue2;
                    if (typedValue.getUnitType() == 0) break;
                    return false;
                }
                case EXPRESSION: {
                    Evaluator evaluator = new Evaluator();
                    typedValue = evaluator.evaluateExpression((ExpressionValue)styleValue2);
                    if (typedValue.getUnitType() == 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            fArray[i] = typedValue.getFloatValue((short)0);
        }
        return true;
    }

    static float floatValue(String string) throws TranscoderException, DOMException {
        TypedValue typedValue;
        ValueFactory valueFactory = new ValueFactory();
        StyleValue styleValue = valueFactory.parseProperty(string);
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new TranscoderException("Leave value unchanged.");
        }
        switch (styleValue.getPrimitiveType()) {
            case NUMERIC: {
                typedValue = (TypedValue)styleValue;
                if (typedValue.getUnitType() == 0) break;
                if (CSSUnit.isRelativeLengthUnitType((short)typedValue.getUnitType())) {
                    throw new TranscoderException("Leave value unchanged.");
                }
                return typedValue.getFloatValue((short)3);
            }
            case EXPRESSION: {
                Evaluator evaluator = new Evaluator();
                typedValue = evaluator.evaluateExpression((ExpressionValue)styleValue);
                if (typedValue.getUnitType() == 0) break;
                if (CSSUnit.isRelativeLengthUnitType((short)typedValue.getUnitType())) {
                    throw new TranscoderException("Leave value unchanged.");
                }
                return typedValue.getFloatValue((short)3);
            }
            default: {
                throw new DOMException(12, "Wrong dimension.");
            }
        }
        return typedValue.getFloatValue((short)0);
    }
}

