/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.FormatRed;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.TIFFTranscoder;
import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;

class TIFFTranscoderImageIOWriteAdapter
implements TIFFTranscoder.WriteAdapter {
    TIFFTranscoderImageIOWriteAdapter() {
    }

    @Override
    public void writeImage(TIFFTranscoder tIFFTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        Object object;
        TranscodingHints transcodingHints = tIFFTranscoder.getTranscodingHints();
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/tiff");
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        float f = tIFFTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n = (int)(25.4 / (double)f + 0.5);
        imageWriterParams.setResolution(n);
        if (transcodingHints.containsKey(TIFFTranscoder.KEY_COMPRESSION_METHOD)) {
            object = (String)transcodingHints.get(TIFFTranscoder.KEY_COMPRESSION_METHOD);
            if ("packbits".equals(object)) {
                imageWriterParams.setCompressionMethod("PackBits");
            } else if ("deflate".equals(object)) {
                imageWriterParams.setCompressionMethod("Deflate");
            } else if ("lzw".equals(object)) {
                imageWriterParams.setCompressionMethod("LZW");
            } else if ("jpeg".equals(object)) {
                imageWriterParams.setCompressionMethod("JPEG");
            }
        }
        try {
            object = transcoderOutput.getOutputStream();
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getNumBands();
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = i;
            }
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n2, n3, n4, n2 * n4, nArray);
            FormatRed formatRed = new FormatRed(GraphicsUtil.wrap((RenderedImage)bufferedImage), (SampleModel)pixelInterleavedSampleModel);
            imageWriter.writeImage((RenderedImage)formatRed, (OutputStream)object, imageWriterParams);
            ((OutputStream)object).flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

