/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGEncodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGImageEncoder;
import io.sf.carte.echosvg.ext.awt.image.rendered.IndexImage;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

class PNGTranscoderInternalCodecWriteAdapter
implements PNGTranscoder.WriteAdapter {
    PNGTranscoderInternalCodecWriteAdapter() {
    }

    @Override
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        String[] stringArray;
        PNGEncodeParam pNGEncodeParam;
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n = -1;
        if (transcodingHints.containsKey(PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)transcodingHints.get(PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)bufferedImage, (int)(1 << n));
        }
        if ((pNGEncodeParam = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)bufferedImage)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)pNGEncodeParam).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (transcodingHints.containsKey(PNGTranscoder.KEY_GAMMA)) {
            float f = ((Float)transcodingHints.get(PNGTranscoder.KEY_GAMMA)).floatValue();
            if (f > 0.0f) {
                pNGEncodeParam.setGamma(f);
            }
            pNGEncodeParam.setChromaticity(PNGTranscoder.DEFAULT_CHROMA);
        } else {
            pNGEncodeParam.setSRGBIntent(0);
        }
        Integer n2 = (Integer)transcodingHints.get(PNGTranscoder.KEY_COMPRESSION_LEVEL);
        if (n2 != null) {
            pNGEncodeParam.setCompressionLevel(n2.intValue());
        }
        if ((stringArray = (String[])transcodingHints.get(PNGTranscoder.KEY_KEYWORD_TEXT)) != null) {
            pNGEncodeParam.setText(stringArray);
        }
        if ((stringArray = (String[])transcodingHints.get(PNGTranscoder.KEY_INTERNATIONAL_TEXT)) != null) {
            pNGEncodeParam.setInternationalText(stringArray);
        }
        if ((stringArray = (String[])transcodingHints.get(PNGTranscoder.KEY_COMPRESSED_TEXT)) != null) {
            pNGEncodeParam.setCompressedText(stringArray);
        }
        float f = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n3 = (int)((double)(1000.0f / f) + 0.5);
        pNGEncodeParam.setPhysicalDimension(n3, n3, 1);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, pNGEncodeParam);
            pNGImageEncoder.encode((RenderedImage)bufferedImage);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

