/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.ext.awt.image.rendered.IndexImage;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.PNGImageWriterParams;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

public class PNGTranscoderImageIOWriteAdapter
implements PNGTranscoder.WriteAdapter {
    @Override
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        String[] stringArray;
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n = -1;
        if (transcodingHints.containsKey(PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)transcodingHints.get(PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)bufferedImage, (int)(1 << n));
        }
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        PNGImageWriterParams pNGImageWriterParams = new PNGImageWriterParams();
        Integer n2 = (Integer)transcodingHints.get(PNGTranscoder.KEY_COMPRESSION_LEVEL);
        if (n2 != null) {
            pNGImageWriterParams.setCompressionLevel(n2.intValue());
        }
        if ((stringArray = (String[])transcodingHints.get(PNGTranscoder.KEY_KEYWORD_TEXT)) != null) {
            pNGImageWriterParams.setText(stringArray);
        }
        if ((stringArray = (String[])transcodingHints.get(PNGTranscoder.KEY_INTERNATIONAL_TEXT)) != null) {
            pNGImageWriterParams.setInternationalText(stringArray);
        }
        if ((stringArray = (String[])transcodingHints.get(PNGTranscoder.KEY_COMPRESSED_TEXT)) != null) {
            pNGImageWriterParams.setCompressedText(stringArray);
        }
        float f = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n3 = (int)(25.4 / (double)f + 0.5);
        pNGImageWriterParams.setResolution(n3);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            imageWriter.writeImage((RenderedImage)bufferedImage, outputStream, (ImageWriterParams)pNGImageWriterParams);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

