/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder;

import io.sf.carte.echosvg.anim.dom.SAXSVGDocumentFactory;
import io.sf.carte.echosvg.anim.dom.SVG12DOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.BaseScriptingEnvironment;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.DefaultScriptSecurity;
import io.sf.carte.echosvg.bridge.ExternalResourceSecurity;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.NoLoadScriptSecurity;
import io.sf.carte.echosvg.bridge.RelaxedExternalResourceSecurity;
import io.sf.carte.echosvg.bridge.RelaxedScriptSecurity;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.ScriptSecurity;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.bridge.UserAgentAdapter;
import io.sf.carte.echosvg.bridge.ViewBox;
import io.sf.carte.echosvg.bridge.svg12.SVG12BridgeContext;
import io.sf.carte.echosvg.dom.AbstractParentNode;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.gvt.CanvasGraphicsNode;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.XMLAbstractTranscoder;
import io.sf.carte.echosvg.transcoder.impl.SizingHelper;
import io.sf.carte.echosvg.transcoder.keys.BooleanKey;
import io.sf.carte.echosvg.transcoder.keys.FloatKey;
import io.sf.carte.echosvg.transcoder.keys.LengthKey;
import io.sf.carte.echosvg.transcoder.keys.Rectangle2DKey;
import io.sf.carte.echosvg.transcoder.keys.StringKey;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGAbstractTranscoder
extends XMLAbstractTranscoder {
    public static final String DEFAULT_DEFAULT_FONT_FAMILY = "Arial, Helvetica, sans-serif";
    private Rectangle2D curAOI;
    private AffineTransform curTxf;
    private GraphicsNode root;
    private BridgeContext ctx;
    private GVTBuilder builder;
    protected float width = 400.0f;
    protected float height = 400.0f;
    private UserAgent userAgent = this.createUserAgent();
    public static final TranscodingHints.Key KEY_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_MAX_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_MAX_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_AOI = new Rectangle2DKey();
    public static final TranscodingHints.Key KEY_LANGUAGE = new StringKey();
    public static final TranscodingHints.Key KEY_MEDIA = new StringKey();
    public static final TranscodingHints.Key KEY_SVG_SELECTOR = new StringKey();
    public static final TranscodingHints.Key KEY_DEFAULT_FONT_FAMILY = new StringKey();
    public static final TranscodingHints.Key KEY_ALTERNATE_STYLESHEET = new StringKey();
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI = new StringKey();
    public static final TranscodingHints.Key KEY_PIXEL_UNIT_TO_MILLIMETER;
    @Deprecated
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM;
    public static final TranscodingHints.Key KEY_EXECUTE_ONLOAD;
    public static final TranscodingHints.Key KEY_SNAPSHOT_TIME;
    public static final TranscodingHints.Key KEY_ALLOWED_SCRIPT_TYPES;
    public static final String DEFAULT_ALLOWED_SCRIPT_TYPES = "text/ecmascript, application/ecmascript, text/javascript, application/javascript, application/java-archive";
    public static final TranscodingHints.Key KEY_CONSTRAIN_SCRIPT_ORIGIN;
    public static final TranscodingHints.Key KEY_ALLOW_EXTERNAL_RESOURCES;

    protected SVGAbstractTranscoder() {
        this.hints.put(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        this.hints.put(KEY_DOCUMENT_ELEMENT, (Object)"svg");
        this.hints.put(KEY_MEDIA, (Object)"screen");
        this.hints.put(KEY_DEFAULT_FONT_FAMILY, (Object)DEFAULT_DEFAULT_FONT_FAMILY);
        this.hints.put(KEY_EXECUTE_ONLOAD, (Object)Boolean.FALSE);
        this.hints.put(KEY_ALLOWED_SCRIPT_TYPES, (Object)DEFAULT_ALLOWED_SCRIPT_TYPES);
    }

    protected UserAgent createUserAgent() {
        return new SVGAbstractTranscoderUserAgent();
    }

    Rectangle2D getCurrentAOI() {
        return this.curAOI;
    }

    protected AffineTransform getCurrentAOITransform() {
        return this.curTxf;
    }

    protected BridgeContext getBridgeContext() {
        return this.ctx;
    }

    protected void setBridgeContext(BridgeContext bridgeContext) {
        this.ctx = bridgeContext;
    }

    protected GraphicsNode getCurrentGVTree() {
        return this.root;
    }

    protected void setCurrentGVTree(GraphicsNode graphicsNode) {
        this.root = graphicsNode;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    protected void setWidth(float f) {
        this.width = f;
    }

    protected void setHeight(float f) {
        this.height = f;
    }

    @Override
    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation) {
        return new SAXSVGDocumentFactory();
    }

    @Override
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        super.transcode(transcoderInput, transcoderOutput);
        if (this.ctx != null) {
            this.ctx.dispose();
        }
    }

    @Override
    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        AffineTransform affineTransform;
        Object object;
        float f;
        GraphicsNode graphicsNode;
        SVGOMDocument sVGOMDocument = !(document instanceof SVGOMDocument) ? this.importAsSVGDocument(document, string) : (SVGOMDocument)document;
        if (sVGOMDocument == null) {
            throw new TranscoderException("Document contains no valid SVG element.");
        }
        if (this.hints.containsKey(KEY_WIDTH)) {
            this.width = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        if (this.hints.containsKey(KEY_HEIGHT)) {
            this.height = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        SVGSVGElement sVGSVGElement = sVGOMDocument.getRootElement();
        this.ctx = this.createBridgeContext(sVGOMDocument);
        this.builder = new GVTBuilder();
        boolean bl = this.hints.containsKey(KEY_EXECUTE_ONLOAD) && (Boolean)this.hints.get(KEY_EXECUTE_ONLOAD) != false;
        try {
            if (bl) {
                this.ctx.setDynamicState(2);
            }
            if ((graphicsNode = this.builder.build(this.ctx, (Document)sVGOMDocument)) == null) {
                throw new TranscoderException("Could not build a bridge for the document at uri " + Objects.toString(string, "<unknown>"));
            }
            if (this.ctx.isDynamic()) {
                BaseScriptingEnvironment baseScriptingEnvironment = new BaseScriptingEnvironment(this.ctx);
                baseScriptingEnvironment.loadScripts();
                baseScriptingEnvironment.dispatchSVGLoadEvent();
                if (this.hints.containsKey(KEY_SNAPSHOT_TIME)) {
                    f = ((Float)this.hints.get(KEY_SNAPSHOT_TIME)).floatValue();
                    this.ctx.getAnimationEngine().setCurrentTime(f);
                } else if (this.ctx.isSVG12()) {
                    f = SVGUtilities.convertSnapshotTime((Element)sVGSVGElement, null);
                    this.ctx.getAnimationEngine().setCurrentTime(f);
                }
            }
        }
        catch (BridgeException bridgeException) {
            try {
                this.ctx.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new TranscoderException((Exception)((Object)bridgeException));
        }
        float f2 = (float)this.ctx.getDocumentSize().getWidth();
        f = (float)this.ctx.getDocumentSize().getHeight();
        this.setImageSize(f2, f);
        if (this.hints.containsKey(KEY_AOI)) {
            object = (Rectangle2D)this.hints.get(KEY_AOI);
            affineTransform = new AffineTransform();
            double d = (double)this.width / ((RectangularShape)object).getWidth();
            double d2 = (double)this.height / ((RectangularShape)object).getHeight();
            double d3 = Math.min(d, d2);
            affineTransform.scale(d3, d3);
            double d4 = -((RectangularShape)object).getX() + ((double)this.width / d3 - ((RectangularShape)object).getWidth()) / 2.0;
            double d5 = -((RectangularShape)object).getY() + ((double)this.height / d3 - ((RectangularShape)object).getHeight()) / 2.0;
            affineTransform.translate(d4, d5);
            this.curAOI = object;
        } else {
            object = new ParsedURL(string).getRef();
            String string2 = sVGSVGElement.getAttributeNS(null, "viewBox").trim();
            if (object != null && !((String)object).isEmpty()) {
                affineTransform = ViewBox.getViewTransform((String)object, (Element)sVGSVGElement, (float)this.width, (float)this.height, (BridgeContext)this.ctx);
            } else if (!string2.isEmpty()) {
                String string3 = sVGSVGElement.getAttributeNS(null, "preserveAspectRatio");
                affineTransform = ViewBox.getPreserveAspectRatioTransform((Element)sVGSVGElement, (String)string2, (String)string3, (float)this.width, (float)this.height, (BridgeContext)this.ctx);
                if (affineTransform == null) {
                    affineTransform = AffineTransform.getTranslateInstance(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                }
            } else {
                float f3 = this.width / f2;
                float f4 = this.height / f;
                float f5 = Math.min(f3, f4);
                affineTransform = AffineTransform.getScaleInstance(f5, f5);
            }
            this.curAOI = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
        }
        object = this.getCanvasGraphicsNode(graphicsNode);
        if (object != null) {
            object.setViewingTransform(affineTransform);
            this.curTxf = new AffineTransform();
        } else {
            this.curTxf = affineTransform;
        }
        this.root = graphicsNode;
    }

    private SVGOMDocument importAsSVGDocument(Document document, String string) throws TranscoderException {
        Object object;
        Object object2;
        Element element = document.getDocumentElement();
        if (element.getNamespaceURI() != "http://www.w3.org/2000/svg" && !"svg".equalsIgnoreCase(element.getTagName())) {
            object2 = (String)this.hints.get(KEY_SVG_SELECTOR);
            if (object2 != null && !((String)(object2 = ((String)object2).trim())).isEmpty()) {
                try {
                    element = ((AbstractParentNode)element).querySelector((String)object2);
                }
                catch (DOMException dOMException) {
                    throw new TranscoderException("Invalid selector: " + (String)object2 + '.', dOMException);
                }
                if (element == null || !"svg".equals(element.getLocalName()) && !"svg".equals(element.getTagName())) {
                    throw new TranscoderException("Selector " + (String)object2 + " points to no valid SVG element.");
                }
                object = element.getNamespaceURI();
                if (object == null) {
                    element = this.replaceSVGRoot(element);
                } else if (!"http://www.w3.org/2000/svg".equals(object)) {
                    throw new TranscoderException("Selector " + (String)object2 + " points to element in " + (String)object + " namespace.");
                }
            } else {
                element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "svg").item(0);
                if (element == null) {
                    if (document.getDocumentElement().getNamespaceURI() != null) {
                        return null;
                    }
                    element = (Element)document.getElementsByTagName("svg").item(0);
                    if (element == null) {
                        return null;
                    }
                    element = this.replaceSVGRoot(element);
                } else {
                    SizingHelper.defaultDimensions(element);
                }
            }
        }
        if ((object2 = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION)) == null) {
            object2 = "1.2".equals(element.getAttribute("version")) ? SVG12DOMImplementation.getDOMImplementation() : SVGDOMImplementation.getDOMImplementation();
        }
        object = (SVGOMDocument)SVGAbstractTranscoder.deepCloneDocument(document, element, (DOMImplementation)object2);
        if (string != null) {
            ParsedURL parsedURL = new ParsedURL(string);
            object.setParsedURL(parsedURL);
        }
        return object;
    }

    private Element replaceSVGRoot(Element element) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
        Element element2 = this.replaceNamespace(element);
        element.getParentNode().replaceChild(element2, element);
        SizingHelper.defaultDimensions(element2);
        return element2;
    }

    private Element replaceNamespace(Element element) {
        Element element2;
        block7: {
            block6: {
                Node node;
                Object object;
                if (element.getNamespaceURI() != null) break block6;
                element2 = element.getOwnerDocument().createElementNS("http://www.w3.org/2000/svg", element.getTagName());
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    for (int i = 0; i < object.getLength(); ++i) {
                        Node node2 = object.item(i);
                        element2.setAttributeNode((Attr)node2.cloneNode(true));
                    }
                }
                if (!element.hasChildNodes()) break block7;
                object = element.getChildNodes();
                int n = 0;
                while ((node = object.item(n)) != null) {
                    Element element3;
                    if (node.getNodeType() == 1 && (element3 = this.replaceNamespace((Element)node)) != node) {
                        ++n;
                        node = element3;
                    }
                    element2.appendChild(node);
                }
                break block7;
            }
            element2 = element;
            if (element.hasChildNodes()) {
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element4;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || (element4 = this.replaceNamespace((Element)node)) == node) continue;
                    element.replaceChild(element4, node);
                }
            }
        }
        return element2;
    }

    private static Document deepCloneDocument(Document document, Element element, DOMImplementation dOMImplementation) {
        Node node;
        boolean bl;
        Document document2 = dOMImplementation.createDocument(element.getNamespaceURI(), element.getNodeName(), null);
        Element element2 = document2.getDocumentElement();
        boolean bl2 = bl = element.getParentNode().getNodeType() == 9;
        if (bl) {
            node = document.getFirstChild();
        } else {
            node = element;
            SVGAbstractTranscoder.appendHeadStyleElements(document, document2, element2);
        }
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2 == element) {
                Object object;
                bl = false;
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        element2.setAttributeNode((Attr)document2.importNode(object.item(i), true));
                    }
                }
                for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                    element2.appendChild(document2.importNode((Node)object, true));
                }
                continue;
            }
            short s = node2.getNodeType();
            if (s != 10 && s != 8 && s != 7) continue;
            if (bl) {
                document2.insertBefore(document2.importNode(node2, true), element2);
                continue;
            }
            document2.appendChild(document2.importNode(node2, true));
        }
        return document2;
    }

    private static void appendHeadStyleElements(Document document, Document document2, Element element) {
        Element element2 = document.getDocumentElement();
        for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"head".equals(node.getNodeName()) && !"head".equals(node.getLocalName())) continue;
            Element element3 = (Element)node;
            NodeList nodeList = element2.getNamespaceURI() != null ? element3.getElementsByTagNameNS("*", "style") : element3.getElementsByTagName("style");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string = "style";
                String string2 = element.getPrefix();
                if (string2 != null) {
                    string = string2 + ':' + string;
                }
                Element element4 = document2.createElementNS("http://www.w3.org/2000/svg", string);
                int n2 = namedNodeMap.getLength();
                for (int j = 0; j < n2; ++j) {
                    element4.setAttributeNode((Attr)document2.importNode(namedNodeMap.item(j), true));
                }
                element4.setTextContent(node2.getTextContent());
                element.appendChild(element4);
            }
            break;
        }
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list.size() == 0) {
            return null;
        }
        graphicsNode = (GraphicsNode)list.get(0);
        if (!(graphicsNode instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)graphicsNode;
    }

    protected BridgeContext createBridgeContext(SVGOMDocument sVGOMDocument) {
        return this.createBridgeContext(sVGOMDocument.isSVG12() ? "1.2" : "1.x");
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    protected BridgeContext createBridgeContext(String string) {
        if ("1.2".equals(string)) {
            return new SVG12BridgeContext(this.userAgent);
        }
        return new BridgeContext(this.userAgent);
    }

    protected void setImageSize(float f, float f2) {
        float f3 = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f3 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float f4 = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            f4 = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (f3 > 0.0f && f4 > 0.0f) {
            this.width = f3;
            this.height = f4;
        } else if (f4 > 0.0f) {
            this.width = f * f4 / f2;
            this.height = f4;
        } else if (f3 > 0.0f) {
            this.width = f3;
            this.height = f2 * f3 / f;
        } else {
            this.width = f;
            this.height = f2;
        }
        float f5 = -1.0f;
        if (this.hints.containsKey(KEY_MAX_WIDTH)) {
            f5 = ((Float)this.hints.get(KEY_MAX_WIDTH)).floatValue();
        }
        float f6 = -1.0f;
        if (this.hints.containsKey(KEY_MAX_HEIGHT)) {
            f6 = ((Float)this.hints.get(KEY_MAX_HEIGHT)).floatValue();
        }
        if (f6 > 0.0f && this.height > f6) {
            this.width = f * f6 / f2;
            this.height = f6;
        }
        if (f5 > 0.0f && this.width > f5) {
            this.width = f5;
            this.height = f2 * f5 / f;
        }
    }

    static {
        KEY_PIXEL_TO_MM = KEY_PIXEL_UNIT_TO_MILLIMETER = new FloatKey();
        KEY_EXECUTE_ONLOAD = new BooleanKey();
        KEY_SNAPSHOT_TIME = new FloatKey();
        KEY_ALLOWED_SCRIPT_TYPES = new StringKey();
        KEY_CONSTRAIN_SCRIPT_ORIGIN = new BooleanKey();
        KEY_ALLOW_EXTERNAL_RESOURCES = new BooleanKey();
    }

    protected class SVGAbstractTranscoderUserAgent
    extends UserAgentAdapter {
        protected List<String> scripts;

        public SVGAbstractTranscoderUserAgent() {
            this.addStdFeatures();
        }

        public AffineTransform getTransform() {
            return SVGAbstractTranscoder.this.curTxf;
        }

        public void setTransform(AffineTransform affineTransform) {
            SVGAbstractTranscoder.this.curTxf = affineTransform;
        }

        public Dimension2D getViewportSize() {
            return new Dimension((int)SVGAbstractTranscoder.this.width, (int)SVGAbstractTranscoder.this.height);
        }

        public void displayError(String string) {
            try {
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException(transcoderException.getMessage());
            }
        }

        public void displayError(Exception exception) {
            try {
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException(transcoderException);
            }
        }

        public void displayMessage(String string) {
            try {
                SVGAbstractTranscoder.this.handler.warning(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException(transcoderException.getMessage());
            }
        }

        public float getPixelUnitToMillimeter() {
            Object object = SVGAbstractTranscoder.this.hints.get(KEY_PIXEL_UNIT_TO_MILLIMETER);
            if (object != null) {
                return ((Float)object).floatValue();
            }
            return super.getPixelUnitToMillimeter();
        }

        public String getLanguages() {
            if (SVGAbstractTranscoder.this.hints.containsKey(KEY_LANGUAGE)) {
                return (String)SVGAbstractTranscoder.this.hints.get(KEY_LANGUAGE);
            }
            return super.getLanguages();
        }

        public String getMedia() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_MEDIA);
            if (string != null) {
                return string;
            }
            return super.getMedia();
        }

        public String getDefaultFontFamily() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_DEFAULT_FONT_FAMILY);
            if (string != null) {
                return string;
            }
            return super.getDefaultFontFamily();
        }

        public String getAlternateStyleSheet() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_ALTERNATE_STYLESHEET);
            if (string != null) {
                return string;
            }
            return super.getAlternateStyleSheet();
        }

        public String getUserStyleSheetURI() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_USER_STYLESHEET_URI);
            if (string != null) {
                return string;
            }
            return super.getUserStyleSheetURI();
        }

        public boolean isXMLParserValidating() {
            Boolean bl = (Boolean)SVGAbstractTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING);
            if (bl != null) {
                return bl;
            }
            return super.isXMLParserValidating();
        }

        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (this.scripts == null) {
                this.computeAllowedScripts();
            }
            if (!this.scripts.contains(string)) {
                return new NoLoadScriptSecurity(string);
            }
            boolean bl = true;
            if (SVGAbstractTranscoder.this.hints.containsKey(KEY_CONSTRAIN_SCRIPT_ORIGIN)) {
                bl = (Boolean)SVGAbstractTranscoder.this.hints.get(KEY_CONSTRAIN_SCRIPT_ORIGIN);
            }
            if (bl) {
                return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
            }
            return new RelaxedScriptSecurity(string, parsedURL, parsedURL2);
        }

        protected void computeAllowedScripts() {
            if (!SVGAbstractTranscoder.this.hints.containsKey(KEY_ALLOWED_SCRIPT_TYPES)) {
                this.scripts = Collections.emptyList();
                return;
            }
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_ALLOWED_SCRIPT_TYPES);
            this.scripts = Arrays.asList(string.split(", "));
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (this.isAllowExternalResources()) {
                return new RelaxedExternalResourceSecurity(parsedURL, parsedURL2);
            }
            return super.getExternalResourceSecurity(parsedURL, parsedURL2);
        }

        public boolean isAllowExternalResources() {
            Boolean bl = (Boolean)SVGAbstractTranscoder.this.hints.get(KEY_ALLOW_EXTERNAL_RESOURCES);
            if (bl != null) {
                return bl;
            }
            return false;
        }
    }
}

