/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.swing;

import io.sf.carte.echosvg.ext.swing.GridBagConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class JGridBagPanel
extends JPanel
implements GridBagConstants {
    private static final long serialVersionUID = 1L;
    public static final InsetsManager ZERO_INSETS = new ZeroInsetsManager();
    public static final InsetsManager DEFAULT_INSETS = new DefaultInsetsManager();
    public InsetsManager insetsManager;

    public JGridBagPanel() {
        this(new DefaultInsetsManager());
    }

    public JGridBagPanel(InsetsManager insetsManager) {
        super(new GridBagLayout());
        this.insetsManager = insetsManager != null ? insetsManager : new DefaultInsetsManager();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof GridBagLayout) {
            super.setLayout(layoutManager);
        }
    }

    public void add(Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2) {
        Insets insets = this.insetsManager.getInsets(n, n2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.insets = insets;
        this.add(component, gridBagConstraints);
    }

    private static class DefaultInsetsManager
    implements InsetsManager {
        int leftInset = 5;
        int topInset = 5;
        public Insets positiveInsets = new Insets(this.topInset, this.leftInset, 0, 0);
        public Insets leftInsets = new Insets(this.topInset, 0, 0, 0);
        public Insets topInsets = new Insets(0, this.leftInset, 0, 0);
        public Insets topLeftInsets = new Insets(0, 0, 0, 0);

        private DefaultInsetsManager() {
        }

        @Override
        public Insets getInsets(int n, int n2) {
            if (n > 0) {
                if (n2 > 0) {
                    return this.positiveInsets;
                }
                return this.topInsets;
            }
            if (n2 > 0) {
                return this.leftInsets;
            }
            return this.topLeftInsets;
        }
    }

    public static interface InsetsManager {
        public Insets getInsets(int var1, int var2);
    }

    private static class ZeroInsetsManager
    implements InsetsManager {
        private Insets insets = new Insets(0, 0, 0, 0);

        private ZeroInsetsManager() {
        }

        @Override
        public Insets getInsets(int n, int n2) {
            return this.insets;
        }
    }
}

