/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.rendered;

import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractTiledRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public final class TurbulencePatternRed
extends AbstractRed {
    private StitchInfo stitchInfo = null;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private double baseFrequencyX;
    private double baseFrequencyY;
    private int numOctaves;
    private int seed;
    private Rectangle2D tile;
    private AffineTransform txf;
    private boolean isFractalNoise;
    private int[] channels;
    double[] tx = new double[]{1.0, 0.0};
    double[] ty = new double[]{0.0, 1.0};
    private static final int RAND_m = Integer.MAX_VALUE;
    private static final int RAND_a = 16807;
    private static final int RAND_q = 127773;
    private static final int RAND_r = 2836;
    private static final int BSize = 256;
    private static final int BM = 255;
    private static final double PerlinN = 4096.0;
    private final int[] latticeSelector = new int[257];
    private final double[] gradient = new double[2056];

    public double getBaseFrequencyX() {
        return this.baseFrequencyX;
    }

    public double getBaseFrequencyY() {
        return this.baseFrequencyY;
    }

    public int getNumOctaves() {
        return this.numOctaves;
    }

    public int getSeed() {
        return this.seed;
    }

    public Rectangle2D getTile() {
        return (Rectangle2D)this.tile.clone();
    }

    public boolean isFractalNoise() {
        return this.isFractalNoise;
    }

    public boolean[] getChannels() {
        boolean[] blArray = new boolean[4];
        for (int n : this.channels) {
            blArray[n] = true;
        }
        return blArray;
    }

    public final int setupSeed(int n) {
        if (n <= 0) {
            n = -(n % 0x7FFFFFFE) + 1;
        }
        if (n > 0x7FFFFFFE) {
            n = 0x7FFFFFFE;
        }
        return n;
    }

    public final int random(int n) {
        int n2 = 16807 * (n % 127773) - 2836 * (n / 127773);
        if (n2 <= 0) {
            n2 += Integer.MAX_VALUE;
        }
        return n2;
    }

    private void initLattice(int n) {
        int n2;
        double d;
        int n3;
        int n4;
        n = this.setupSeed(n);
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < 256; ++n3) {
                n = this.random(n);
                double d2 = n % 512 - 256;
                n = this.random(n);
                double d3 = n % 512 - 256;
                d = 1.0 / Math.sqrt(d2 * d2 + d3 * d3);
                this.gradient[n3 * 8 + n4 * 2] = d2 * d;
                this.gradient[n3 * 8 + n4 * 2 + 1] = d3 * d;
            }
        }
        for (n3 = 0; n3 < 256; ++n3) {
            this.latticeSelector[n3] = n3;
        }
        while (--n3 > 0) {
            n4 = this.latticeSelector[n3];
            n = this.random(n);
            n2 = n % 256;
            this.latticeSelector[n3] = this.latticeSelector[n2];
            this.latticeSelector[n2] = n4;
            int n5 = n3 << 3;
            int n6 = n2 << 3;
            for (n2 = 0; n2 < 8; ++n2) {
                d = this.gradient[n5 + n2];
                this.gradient[n5 + n2] = this.gradient[n6 + n2];
                this.gradient[n6 + n2] = d;
            }
        }
        this.latticeSelector[256] = this.latticeSelector[0];
        for (n2 = 0; n2 < 8; ++n2) {
            this.gradient[2048 + n2] = this.gradient[n2];
        }
    }

    private static final double s_curve(double d) {
        return d * d * (3.0 - 2.0 * d);
    }

    private static final double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    private final void noise2(double[] dArray, double d, double d2) {
        int n = (int)(d += 4096.0) & 0xFF;
        int n2 = this.latticeSelector[n];
        int n3 = this.latticeSelector[n + 1];
        double d3 = d - (double)((int)d);
        double d4 = d3 - 1.0;
        double d5 = TurbulencePatternRed.s_curve(d3);
        n = (int)(d2 += 4096.0);
        int n4 = (n3 + n & 0xFF) << 3;
        n = (n2 + n & 0xFF) << 3;
        double d6 = d2 - (double)((int)d2);
        double d7 = d6 - 1.0;
        double d8 = TurbulencePatternRed.s_curve(d6);
        switch (this.channels.length) {
            case 4: {
                dArray[3] = TurbulencePatternRed.lerp(d8, TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 6] + d6 * this.gradient[n + 7], d4 * this.gradient[n4 + 6] + d6 * this.gradient[n4 + 7]), TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 8 + 6] + d7 * this.gradient[n + 8 + 7], d4 * this.gradient[n4 + 8 + 6] + d7 * this.gradient[n4 + 8 + 7]));
            }
            case 3: {
                dArray[2] = TurbulencePatternRed.lerp(d8, TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 4] + d6 * this.gradient[n + 5], d4 * this.gradient[n4 + 4] + d6 * this.gradient[n4 + 5]), TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 8 + 4] + d7 * this.gradient[n + 8 + 5], d4 * this.gradient[n4 + 8 + 4] + d7 * this.gradient[n4 + 8 + 5]));
            }
            case 2: {
                dArray[1] = TurbulencePatternRed.lerp(d8, TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 2] + d6 * this.gradient[n + 3], d4 * this.gradient[n4 + 2] + d6 * this.gradient[n4 + 3]), TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 8 + 2] + d7 * this.gradient[n + 8 + 3], d4 * this.gradient[n4 + 8 + 2] + d7 * this.gradient[n4 + 8 + 3]));
            }
            case 1: {
                dArray[0] = TurbulencePatternRed.lerp(d8, TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 0] + d6 * this.gradient[n + 1], d4 * this.gradient[n4 + 0] + d6 * this.gradient[n4 + 1]), TurbulencePatternRed.lerp(d5, d3 * this.gradient[n + 8 + 0] + d7 * this.gradient[n + 8 + 1], d4 * this.gradient[n4 + 8 + 0] + d7 * this.gradient[n4 + 8 + 1]));
            }
        }
    }

    private final void noise2Stitch(double[] dArray, double d, double d2, StitchInfo stitchInfo) {
        double d3 = d + 4096.0;
        int n = (int)d3;
        int n2 = n + 1;
        if (n2 >= stitchInfo.wrapX) {
            if (n >= stitchInfo.wrapX) {
                n -= stitchInfo.width;
                n2 -= stitchInfo.width;
            } else {
                n2 -= stitchInfo.width;
            }
        }
        int n3 = this.latticeSelector[n & 0xFF];
        int n4 = this.latticeSelector[n2 & 0xFF];
        double d4 = d3 - (double)((int)d3);
        double d5 = d4 - 1.0;
        double d6 = TurbulencePatternRed.s_curve(d4);
        d3 = d2 + 4096.0;
        n = (int)d3;
        n2 = n + 1;
        if (n2 >= stitchInfo.wrapY) {
            if (n >= stitchInfo.wrapY) {
                n -= stitchInfo.height;
                n2 -= stitchInfo.height;
            } else {
                n2 -= stitchInfo.height;
            }
        }
        int n5 = (n3 + n & 0xFF) << 3;
        int n6 = (n4 + n & 0xFF) << 3;
        int n7 = (n3 + n2 & 0xFF) << 3;
        int n8 = (n4 + n2 & 0xFF) << 3;
        double d7 = d3 - (double)((int)d3);
        double d8 = d7 - 1.0;
        double d9 = TurbulencePatternRed.s_curve(d7);
        switch (this.channels.length) {
            case 4: {
                dArray[3] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n5 + 6] + d7 * this.gradient[n5 + 7], d5 * this.gradient[n6 + 6] + d7 * this.gradient[n6 + 7]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n7 + 6] + d8 * this.gradient[n7 + 7], d5 * this.gradient[n8 + 6] + d8 * this.gradient[n8 + 7]));
            }
            case 3: {
                dArray[2] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n5 + 4] + d7 * this.gradient[n5 + 5], d5 * this.gradient[n6 + 4] + d7 * this.gradient[n6 + 5]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n7 + 4] + d8 * this.gradient[n7 + 5], d5 * this.gradient[n8 + 4] + d8 * this.gradient[n8 + 5]));
            }
            case 2: {
                dArray[1] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n5 + 2] + d7 * this.gradient[n5 + 3], d5 * this.gradient[n6 + 2] + d7 * this.gradient[n6 + 3]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n7 + 2] + d8 * this.gradient[n7 + 3], d5 * this.gradient[n8 + 2] + d8 * this.gradient[n8 + 3]));
            }
            case 1: {
                dArray[0] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n5 + 0] + d7 * this.gradient[n5 + 1], d5 * this.gradient[n6 + 0] + d7 * this.gradient[n6 + 1]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n7 + 0] + d8 * this.gradient[n7 + 1], d5 * this.gradient[n8 + 0] + d8 * this.gradient[n8 + 1]));
            }
        }
    }

    private final int turbulence_4(double d, double d2, double[] dArray) {
        int n;
        int n2;
        double d3 = 255.0;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        for (int i = this.numOctaves; i > 0; --i) {
            double d4 = d + 4096.0;
            int n3 = (int)d4 & 0xFF;
            n2 = this.latticeSelector[n3];
            n = this.latticeSelector[n3 + 1];
            double d5 = d4 - (double)((int)d4);
            double d6 = d5 - 1.0;
            double d7 = TurbulencePatternRed.s_curve(d5);
            double d8 = d2 + 4096.0;
            n3 = (int)d8 & 0xFF;
            int n4 = n3 + 1 & 0xFF;
            n4 = (n + n3 & 0xFF) << 3;
            n3 = (n2 + n3 & 0xFF) << 3;
            double d9 = d8 - (double)((int)d8);
            double d10 = d9 - 1.0;
            double d11 = TurbulencePatternRed.s_curve(d9);
            double d12 = TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 0] + d9 * this.gradient[n3 + 1], d6 * this.gradient[n4 + 0] + d9 * this.gradient[n4 + 1]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 0] + d10 * this.gradient[n3 + 8 + 1], d6 * this.gradient[n4 + 8 + 0] + d10 * this.gradient[n4 + 8 + 1]));
            dArray[0] = d12 < 0.0 ? dArray[0] - d12 * d3 : dArray[0] + d12 * d3;
            d12 = TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 2] + d9 * this.gradient[n3 + 3], d6 * this.gradient[n4 + 2] + d9 * this.gradient[n4 + 3]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 2] + d10 * this.gradient[n3 + 8 + 3], d6 * this.gradient[n4 + 8 + 2] + d10 * this.gradient[n4 + 8 + 3]));
            dArray[1] = d12 < 0.0 ? dArray[1] - d12 * d3 : dArray[1] + d12 * d3;
            d12 = TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 4] + d9 * this.gradient[n3 + 5], d6 * this.gradient[n4 + 4] + d9 * this.gradient[n4 + 5]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 4] + d10 * this.gradient[n3 + 8 + 5], d6 * this.gradient[n4 + 8 + 4] + d10 * this.gradient[n4 + 8 + 5]));
            dArray[2] = d12 < 0.0 ? dArray[2] - d12 * d3 : dArray[2] + d12 * d3;
            d12 = TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 6] + d9 * this.gradient[n3 + 7], d6 * this.gradient[n4 + 6] + d9 * this.gradient[n4 + 7]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 6] + d10 * this.gradient[n3 + 8 + 7], d6 * this.gradient[n4 + 8 + 6] + d10 * this.gradient[n4 + 8 + 7]));
            dArray[3] = d12 < 0.0 ? dArray[3] - d12 * d3 : dArray[3] + d12 * d3;
            d3 *= 0.5;
            d *= 2.0;
            d2 *= 2.0;
        }
        n2 = (int)dArray[0];
        n = (n2 & 0xFFFFFF00) == 0 ? n2 << 16 : ((n2 & Integer.MIN_VALUE) != 0 ? 0 : 0xFF0000);
        n2 = (int)dArray[1];
        n = (n2 & 0xFFFFFF00) == 0 ? (n |= n2 << 8) : (n |= (n2 & Integer.MIN_VALUE) != 0 ? 0 : 65280);
        n2 = (int)dArray[2];
        n = (n2 & 0xFFFFFF00) == 0 ? (n |= n2) : (n |= (n2 & Integer.MIN_VALUE) != 0 ? 0 : 255);
        n2 = (int)dArray[3];
        n = (n2 & 0xFFFFFF00) == 0 ? (n |= n2 << 24) : (n |= (n2 & Integer.MIN_VALUE) != 0 ? 0 : -16777216);
        return n;
    }

    private final void turbulence(int[] nArray, double d, double d2, double[] dArray, double[] dArray2) {
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        double d3 = 255.0;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        switch (this.channels.length) {
            case 4: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2(dArray2, d, d2);
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d3 : dArray[1] + dArray2[1] * d3;
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d3 : dArray[2] + dArray2[2] * d3;
                    dArray[3] = dArray2[3] < 0.0 ? dArray[3] - dArray2[3] * d3 : dArray[3] + dArray2[3] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) != 0) {
                    nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[3] = (int)dArray[3];
                if ((nArray[3] & 0xFFFFFF00) == 0) break;
                nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 3: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2(dArray2, d, d2);
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d3 : dArray[2] + dArray2[2] * d3;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d3 : dArray[1] + dArray2[1] * d3;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                }
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 2: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2(dArray2, d, d2);
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d3 : dArray[1] + dArray2[1] * d3;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                }
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 1: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2(dArray2, d, d2);
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    private final void turbulenceStitch(int[] nArray, double d, double d2, double[] dArray, double[] dArray2, StitchInfo stitchInfo) {
        double d3 = 1.0;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        switch (this.channels.length) {
            case 4: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2Stitch(dArray2, d, d2, stitchInfo);
                    dArray[3] = dArray2[3] < 0.0 ? dArray[3] - dArray2[3] * d3 : dArray[3] + dArray2[3] * d3;
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d3 : dArray[2] + dArray2[2] * d3;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d3 : dArray[1] + dArray2[1] * d3;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[3] = (int)(dArray[3] * 255.0);
                if ((nArray[3] & 0xFFFFFF00) != 0) {
                    nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[2] = (int)(dArray[2] * 255.0);
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)(dArray[1] * 255.0);
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 3: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2Stitch(dArray2, d, d2, stitchInfo);
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d3 : dArray[2] + dArray2[2] * d3;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d3 : dArray[1] + dArray2[1] * d3;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[2] = (int)(dArray[2] * 255.0);
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)(dArray[1] * 255.0);
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 2: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2Stitch(dArray2, d, d2, stitchInfo);
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d3 : dArray[1] + dArray2[1] * d3;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[1] = (int)(dArray[1] * 255.0);
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 1: {
                for (int i = 0; i < this.numOctaves; ++i) {
                    this.noise2Stitch(dArray2, d, d2, stitchInfo);
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d3 : dArray[0] + dArray2[0] * d3;
                    d3 *= 0.5;
                    d *= 2.0;
                    d2 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    private final int turbulenceFractal_4(double d, double d2, double[] dArray) {
        int n;
        int n2;
        double d3 = 127.5;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        dArray[3] = 127.5;
        dArray[2] = 127.5;
        dArray[1] = 127.5;
        dArray[0] = 127.5;
        for (int i = this.numOctaves; i > 0; --i) {
            double d4 = d + 4096.0;
            int n3 = (int)d4 & 0xFF;
            n2 = this.latticeSelector[n3];
            n = this.latticeSelector[n3 + 1];
            double d5 = d4 - (double)((int)d4);
            double d6 = d5 - 1.0;
            double d7 = TurbulencePatternRed.s_curve(d5);
            double d8 = d2 + 4096.0;
            n3 = (int)d8 & 0xFF;
            int n4 = n3 + 1 & 0xFF;
            n4 = (n + n3 & 0xFF) << 3;
            n3 = (n2 + n3 & 0xFF) << 3;
            double d9 = d8 - (double)((int)d8);
            double d10 = d9 - 1.0;
            double d11 = TurbulencePatternRed.s_curve(d9);
            dArray[0] = dArray[0] + TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 0] + d9 * this.gradient[n3 + 1], d6 * this.gradient[n4 + 0] + d9 * this.gradient[n4 + 1]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 0] + d10 * this.gradient[n3 + 8 + 1], d6 * this.gradient[n4 + 8 + 0] + d10 * this.gradient[n4 + 8 + 1])) * d3;
            dArray[1] = dArray[1] + TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 2] + d9 * this.gradient[n3 + 3], d6 * this.gradient[n4 + 2] + d9 * this.gradient[n4 + 3]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 2] + d10 * this.gradient[n3 + 8 + 3], d6 * this.gradient[n4 + 8 + 2] + d10 * this.gradient[n4 + 8 + 3])) * d3;
            dArray[2] = dArray[2] + TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 4] + d9 * this.gradient[n3 + 5], d6 * this.gradient[n4 + 4] + d9 * this.gradient[n4 + 5]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 4] + d10 * this.gradient[n3 + 8 + 5], d6 * this.gradient[n4 + 8 + 4] + d10 * this.gradient[n4 + 8 + 5])) * d3;
            dArray[3] = dArray[3] + TurbulencePatternRed.lerp(d11, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 6] + d9 * this.gradient[n3 + 7], d6 * this.gradient[n4 + 6] + d9 * this.gradient[n4 + 7]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n3 + 8 + 6] + d10 * this.gradient[n3 + 8 + 7], d6 * this.gradient[n4 + 8 + 6] + d10 * this.gradient[n4 + 8 + 7])) * d3;
            d3 *= 0.5;
            d *= 2.0;
            d2 *= 2.0;
        }
        n2 = (int)dArray[0];
        n = (n2 & 0xFFFFFF00) == 0 ? n2 << 16 : ((n2 & Integer.MIN_VALUE) != 0 ? 0 : 0xFF0000);
        n2 = (int)dArray[1];
        n = (n2 & 0xFFFFFF00) == 0 ? (n |= n2 << 8) : (n |= (n2 & Integer.MIN_VALUE) != 0 ? 0 : 65280);
        n2 = (int)dArray[2];
        n = (n2 & 0xFFFFFF00) == 0 ? (n |= n2) : (n |= (n2 & Integer.MIN_VALUE) != 0 ? 0 : 255);
        n2 = (int)dArray[3];
        n = (n2 & 0xFFFFFF00) == 0 ? (n |= n2 << 24) : (n |= (n2 & Integer.MIN_VALUE) != 0 ? 0 : -16777216);
        return n;
    }

    private final void turbulenceFractal(int[] nArray, double d, double d2, double[] dArray, double[] dArray2) {
        double d3 = 127.5;
        dArray[3] = 127.5;
        dArray[2] = 127.5;
        dArray[1] = 127.5;
        dArray[0] = 127.5;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        for (int i = this.numOctaves; i > 0; --i) {
            this.noise2(dArray2, d, d2);
            switch (this.channels.length) {
                case 4: {
                    dArray[3] = dArray[3] + dArray2[3] * d3;
                }
                case 3: {
                    dArray[2] = dArray[2] + dArray2[2] * d3;
                }
                case 2: {
                    dArray[1] = dArray[1] + dArray2[1] * d3;
                }
                case 1: {
                    dArray[0] = dArray[0] + dArray2[0] * d3;
                }
            }
            d3 *= 0.5;
            d *= 2.0;
            d2 *= 2.0;
        }
        switch (this.channels.length) {
            case 4: {
                nArray[3] = (int)dArray[3];
                if ((nArray[3] & 0xFFFFFF00) != 0) {
                    nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 3: {
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 2: {
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 1: {
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    private final void turbulenceFractalStitch(int[] nArray, double d, double d2, double[] dArray, double[] dArray2, StitchInfo stitchInfo) {
        double d3 = 127.5;
        dArray[3] = 127.5;
        dArray[2] = 127.5;
        dArray[1] = 127.5;
        dArray[0] = 127.5;
        d *= this.baseFrequencyX;
        d2 *= this.baseFrequencyY;
        for (int i = this.numOctaves; i > 0; --i) {
            this.noise2Stitch(dArray2, d, d2, stitchInfo);
            switch (this.channels.length) {
                case 4: {
                    dArray[3] = dArray[3] + dArray2[3] * d3;
                }
                case 3: {
                    dArray[2] = dArray[2] + dArray2[2] * d3;
                }
                case 2: {
                    dArray[1] = dArray[1] + dArray2[1] * d3;
                }
                case 1: {
                    dArray[0] = dArray[0] + dArray2[0] * d3;
                }
            }
            d3 *= 0.5;
            d *= 2.0;
            d2 *= 2.0;
            stitchInfo.doubleFrequency();
        }
        switch (this.channels.length) {
            case 4: {
                nArray[3] = (int)dArray[3];
                if ((nArray[3] & 0xFFFFFF00) != 0) {
                    nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 3: {
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 2: {
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 1: {
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        if (writableRaster == null) {
            throw new IllegalArgumentException("Cannot generate a noise pattern into a null raster");
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getMinY();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n5 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n3 - writableRaster.getSampleModelTranslateX(), n4 - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int n6 = singlePixelPackedSampleModel.getScanlineStride() - n;
        int n7 = n5;
        int[] nArray2 = new int[4];
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        double d = this.tx[0];
        double d2 = this.tx[1];
        double d3 = this.ty[0] - (double)n * d;
        double d4 = this.ty[1] - (double)n * d2;
        double[] dArray3 = new double[]{n3, n4};
        this.txf.transform(dArray3, 0, dArray3, 0, 1);
        double d5 = dArray3[0];
        double d6 = dArray3[1];
        if (this.isFractalNoise) {
            if (this.stitchInfo == null) {
                if (this.channels.length == 4) {
                    for (int i = 0; i < n2; ++i) {
                        int n8 = n7 + n;
                        while (n7 < n8) {
                            nArray[n7] = this.turbulenceFractal_4(d5, d6, dArray);
                            d5 += d;
                            d6 += d2;
                            ++n7;
                        }
                        d5 += d3;
                        d6 += d4;
                        n7 += n6;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        int n9 = n7 + n;
                        while (n7 < n9) {
                            this.turbulenceFractal(nArray2, d5, d6, dArray, dArray2);
                            nArray[n7] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                            d5 += d;
                            d6 += d2;
                            ++n7;
                        }
                        d5 += d3;
                        d6 += d4;
                        n7 += n6;
                    }
                }
            } else {
                StitchInfo stitchInfo = new StitchInfo();
                for (int i = 0; i < n2; ++i) {
                    int n10 = n7 + n;
                    while (n7 < n10) {
                        stitchInfo.assign(this.stitchInfo);
                        this.turbulenceFractalStitch(nArray2, d5, d6, dArray, dArray2, stitchInfo);
                        nArray[n7] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                        d5 += d;
                        d6 += d2;
                        ++n7;
                    }
                    d5 += d3;
                    d6 += d4;
                    n7 += n6;
                }
            }
        } else if (this.stitchInfo == null) {
            if (this.channels.length == 4) {
                for (int i = 0; i < n2; ++i) {
                    int n11 = n7 + n;
                    while (n7 < n11) {
                        nArray[n7] = this.turbulence_4(d5, d6, dArray);
                        d5 += d;
                        d6 += d2;
                        ++n7;
                    }
                    d5 += d3;
                    d6 += d4;
                    n7 += n6;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n12 = n7 + n;
                    while (n7 < n12) {
                        this.turbulence(nArray2, d5, d6, dArray, dArray2);
                        nArray[n7] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                        d5 += d;
                        d6 += d2;
                        ++n7;
                    }
                    d5 += d3;
                    d6 += d4;
                    n7 += n6;
                }
            }
        } else {
            StitchInfo stitchInfo = new StitchInfo();
            for (int i = 0; i < n2; ++i) {
                int n13 = n7 + n;
                while (n7 < n13) {
                    stitchInfo.assign(this.stitchInfo);
                    this.turbulenceStitch(nArray2, d5, d6, dArray, dArray2, stitchInfo);
                    nArray[n7] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                    d5 += d;
                    d6 += d2;
                    ++n7;
                }
                d5 += d3;
                d6 += d4;
                n7 += n6;
            }
        }
        return writableRaster;
    }

    public TurbulencePatternRed(double d, double d2, int n, int n2, boolean bl, Rectangle2D rectangle2D, AffineTransform affineTransform, Rectangle rectangle, ColorSpace colorSpace, boolean bl2) {
        this.baseFrequencyX = d;
        this.baseFrequencyY = d2;
        this.seed = n2;
        this.isFractalNoise = bl;
        this.tile = rectangle2D;
        if (affineTransform == null) {
            affineTransform = IDENTITY;
        }
        this.txf = affineTransform;
        int n3 = colorSpace.getNumComponents();
        if (bl2) {
            ++n3;
        }
        this.channels = new int[n3];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = i;
        }
        affineTransform.deltaTransform(this.tx, 0, this.tx, 0, 1);
        affineTransform.deltaTransform(this.ty, 0, this.ty, 0, 1);
        double[] dArray = new double[]{0.5, 0.0};
        double[] dArray2 = new double[]{0.0, 0.5};
        affineTransform.deltaTransform(dArray, 0, dArray, 0, 1);
        affineTransform.deltaTransform(dArray2, 0, dArray2, 0, 1);
        double d3 = Math.max(Math.abs(dArray[0]), Math.abs(dArray2[0]));
        int n4 = -((int)Math.round((Math.log(d3) + Math.log(d)) / Math.log(2.0)));
        double d4 = Math.max(Math.abs(dArray[1]), Math.abs(dArray2[1]));
        int n5 = -((int)Math.round((Math.log(d4) + Math.log(d2)) / Math.log(2.0)));
        this.numOctaves = n > n4 ? n4 : n;
        int n6 = this.numOctaves = this.numOctaves > n5 ? n5 : this.numOctaves;
        if (this.numOctaves < 1 && n > 1) {
            this.numOctaves = 1;
        }
        if (this.numOctaves > 8) {
            this.numOctaves = 8;
        }
        if (rectangle2D != null) {
            double d5;
            double d6 = Math.floor(rectangle2D.getWidth() * d) / rectangle2D.getWidth();
            this.baseFrequencyX = d / d6 < (d5 = Math.ceil(rectangle2D.getWidth() * d) / rectangle2D.getWidth()) / d ? d6 : d5;
            d6 = Math.floor(rectangle2D.getHeight() * d2) / rectangle2D.getHeight();
            d5 = Math.ceil(rectangle2D.getHeight() * d2) / rectangle2D.getHeight();
            this.baseFrequencyY = d2 / d6 < d5 / d2 ? d6 : d5;
            this.stitchInfo = new StitchInfo();
            this.stitchInfo.width = (int)(rectangle2D.getWidth() * this.baseFrequencyX);
            this.stitchInfo.height = (int)(rectangle2D.getHeight() * this.baseFrequencyY);
            this.stitchInfo.wrapX = (int)(rectangle2D.getX() * this.baseFrequencyX + 4096.0 + (double)this.stitchInfo.width);
            this.stitchInfo.wrapY = (int)(rectangle2D.getY() * this.baseFrequencyY + 4096.0 + (double)this.stitchInfo.height);
            if (this.stitchInfo.width == 0) {
                this.stitchInfo.width = 1;
            }
            if (this.stitchInfo.height == 0) {
                this.stitchInfo.height = 1;
            }
        }
        this.initLattice(n2);
        DirectColorModel directColorModel = bl2 ? new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3) : new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
        int n7 = AbstractTiledRed.getDefaultTileSize();
        this.init((CachableRed)null, rectangle, (ColorModel)directColorModel, ((ColorModel)directColorModel).createCompatibleSampleModel(n7, n7), 0, 0, null);
    }

    static final class StitchInfo {
        int width;
        int height;
        int wrapX;
        int wrapY;

        StitchInfo() {
        }

        StitchInfo(StitchInfo stitchInfo) {
            this.width = stitchInfo.width;
            this.height = stitchInfo.height;
            this.wrapX = stitchInfo.wrapX;
            this.wrapY = stitchInfo.wrapY;
        }

        final void assign(StitchInfo stitchInfo) {
            this.width = stitchInfo.width;
            this.height = stitchInfo.height;
            this.wrapX = stitchInfo.wrapX;
            this.wrapY = stitchInfo.wrapY;
        }

        final void doubleFrequency() {
            this.width *= 2;
            this.height *= 2;
            this.wrapX *= 2;
            this.wrapY *= 2;
            this.wrapX = (int)((double)this.wrapX - 4096.0);
            this.wrapY = (int)((double)this.wrapY - 4096.0);
        }
    }
}

