/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.ProfileRed;
import io.sf.graphics.java2d.color.ICCColorSpaceWithIntent;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;

public class ProfileRable
extends AbstractRable {
    private ICCColorSpaceWithIntent colorSpace;

    public ProfileRable(Filter filter, ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        super(filter);
        this.colorSpace = iCCColorSpaceWithIntent;
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public void setColorSpace(ICCColorSpaceWithIntent iCCColorSpaceWithIntent) {
        this.touch();
        this.colorSpace = iCCColorSpaceWithIntent;
    }

    public ICCColorSpaceWithIntent getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = GraphicsUtil.wrap(renderedImage);
        return new ProfileRed(cachableRed, this.colorSpace);
    }
}

