/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Matrix4f;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.Recti;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.math.geom.Frustum;
import com.jogamp.opengl.util.SyncAction;
import com.jogamp.opengl.util.SyncBuffer;
import com.jogamp.opengl.util.SyncMatrices4f;
import com.jogamp.opengl.util.SyncMatrix4f;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public final class PMVMatrix
implements GLMatrixFunc {
    public static final int MODIFIED_PROJECTION = 1;
    public static final int MODIFIED_MODELVIEW = 2;
    public static final int MODIFIED_TEXTURE = 4;
    public static final int MODIFIED_ALL = 7;
    public static final int INVERSE_MODELVIEW = 2;
    public static final int INVERSE_TRANSPOSED_MODELVIEW = 4;
    public static final int FRUSTUM = 8;
    public static final int PREMUL_PMV = 16;
    public static final int PREMUL_PMVI = 32;
    public static final int MANUAL_BITS = 56;
    private static final String msgCantComputeInverse = "Invalid source Mv matrix, can't compute inverse";
    private final Matrix4f matP;
    private final Matrix4f matMv;
    private final Matrix4f matTex;
    private final Matrix4f matMvi;
    private final Matrix4f matMvit;
    private static final int mP_offset = 0;
    private static final int mMv_offset = 16;
    private final int mMvi_offset;
    private final int mMvit_offset;
    private final int mTex_offset;
    private final float[] matrixStore;
    private final FloatBuffer bufP;
    private final FloatBuffer bufMv;
    private final FloatBuffer bufTex;
    private final FloatBuffer bufMvi;
    private final FloatBuffer bufMvit;
    private final FloatBuffer bufP_Mv;
    private final FloatBuffer bufP_Mv_Mvi;
    private final FloatBuffer bufP_Mv_Mvi_Mvit;
    private final SyncMatrix4f syncP;
    private final SyncMatrix4f syncMv;
    private final SyncMatrix4f syncT;
    private final SyncMatrix4f syncMvi;
    private final SyncMatrix4f syncMvit;
    private final SyncMatrices4f syncP_Mv;
    private final SyncMatrices4f syncP_Mv_Mvi;
    private final SyncMatrices4f syncP_Mv_Mvi_Mvit;
    private final Matrix4f mat4Tmp1;
    private int matrixMode = 5888;
    private int modifiedBits = 7;
    private int dirtyBits = 0;
    private final int requestBits;
    private Matrix4f mat4Tmp2;
    private Matrix4f matPMv;
    private Matrix4f matPMvi;
    private boolean matPMviOK;
    private Frustum frustum;

    public static final boolean isMatrixModeName(int n) {
        switch (n) {
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixModeName2MatrixGetName(int n) {
        switch (n) {
            case 5888: {
                return 2982;
            }
            case 5889: {
                return 2983;
            }
            case 5890: {
                return 2984;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public static final boolean isMatrixGetName(int n) {
        switch (n) {
            case 2976: 
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixGetName2MatrixModeName(int n) {
        switch (n) {
            case 2982: {
                return 5888;
            }
            case 2983: {
                return 5889;
            }
            case 2984: {
                return 5890;
            }
        }
        throw new GLException("unsupported matrixGetName: " + n);
    }

    public PMVMatrix() {
        this(0);
    }

    public PMVMatrix(int n) {
        int n2 = 0;
        if (0 != (n & 6)) {
            n2 |= 2;
        }
        if (0 != (n & 4)) {
            n2 |= 4;
        }
        this.requestBits = n2;
        n2 = 3;
        this.matP = new Matrix4f();
        this.matMv = new Matrix4f();
        this.matTex = new Matrix4f();
        if (0 != (this.requestBits & 2)) {
            this.matMvi = new Matrix4f();
            this.mMvi_offset = 32;
            ++n2;
        } else {
            this.matMvi = null;
            this.mMvi_offset = -1;
        }
        if (0 != (this.requestBits & 4)) {
            this.matMvit = new Matrix4f();
            this.mMvit_offset = 48;
            ++n2;
        } else {
            this.matMvit = null;
            this.mMvit_offset = -1;
        }
        this.mTex_offset = (n2 - 1) * 16;
        this.matrixStore = new float[n2 * 16];
        this.bufP = Buffers.slice2Float((float[])this.matrixStore, (int)0, (int)16);
        this.syncP = new SyncBuffer0(this.matP, this.bufP);
        this.bufMv = Buffers.slice2Float((float[])this.matrixStore, (int)16, (int)16);
        this.syncMv = new SyncBuffer1(this.matMv, this.bufMv, 16);
        this.bufP_Mv = Buffers.slice2Float((float[])this.matrixStore, (int)0, (int)32);
        this.syncP_Mv = new SyncBufferN(new Matrix4f[]{this.matP, this.matMv}, this.bufP_Mv, 0);
        this.bufTex = Buffers.slice2Float((float[])this.matrixStore, (int)this.mTex_offset, (int)16);
        this.syncT = new SyncBuffer1(this.matTex, this.bufTex, this.mTex_offset);
        if (null != this.matMvi) {
            this.bufMvi = Buffers.slice2Float((float[])this.matrixStore, (int)this.mMvi_offset, (int)16);
            this.bufP_Mv_Mvi = Buffers.slice2Float((float[])this.matrixStore, (int)0, (int)48);
            this.syncMvi = new SyncBuffer1U(this.matMvi, this.bufMvi, this.mMvi_offset);
            this.syncP_Mv_Mvi = new SyncBufferNU(new Matrix4f[]{this.matP, this.matMv, this.matMvi}, this.bufP_Mv_Mvi, 0);
        } else {
            this.bufMvi = null;
            this.bufP_Mv_Mvi = null;
            this.syncMvi = null;
            this.syncP_Mv_Mvi = null;
        }
        if (null != this.matMvit) {
            this.bufMvit = Buffers.slice2Float((float[])this.matrixStore, (int)this.mMvit_offset, (int)16);
            this.bufP_Mv_Mvi_Mvit = Buffers.slice2Float((float[])this.matrixStore, (int)0, (int)64);
            this.syncMvit = new SyncBuffer1U(this.matMvit, this.bufMvit, this.mMvit_offset);
            this.syncP_Mv_Mvi_Mvit = new SyncBufferNU(new Matrix4f[]{this.matP, this.matMv, this.matMvi, this.matMvit}, this.bufP_Mv_Mvi_Mvit, 0);
        } else {
            this.bufMvit = null;
            this.bufP_Mv_Mvi_Mvit = null;
            this.syncMvit = null;
            this.syncP_Mv_Mvi_Mvit = null;
        }
        this.mat4Tmp1 = new Matrix4f();
        this.mat4Tmp2 = null;
        this.matPMv = null;
        this.matPMvi = null;
        this.matPMviOK = false;
        this.frustum = null;
        this.reset();
    }

    public final void reset() {
        this.matP.loadIdentity();
        this.matMv.loadIdentity();
        this.matTex.loadIdentity();
        this.modifiedBits = 7;
        this.dirtyBits = this.requestBits | 0x38;
        this.matrixMode = 5888;
    }

    public final int glGetMatrixMode() {
        return this.matrixMode;
    }

    private final Matrix4f getTmp2Mat() {
        if (null == this.mat4Tmp2) {
            this.mat4Tmp2 = new Matrix4f();
        }
        return this.mat4Tmp2;
    }

    public final Matrix4f getTMat() {
        return this.matTex;
    }

    public final SyncMatrix4f getSyncTMat() {
        return this.syncT;
    }

    public final Matrix4f getPMat() {
        return this.matP;
    }

    public final SyncMatrix4f getSyncPMat() {
        return this.syncP;
    }

    public final Matrix4f getMvMat() {
        return this.matMv;
    }

    public final SyncMatrix4f getSyncMvMat() {
        return this.syncMv;
    }

    public final SyncMatrices4f getSyncPMvMat() {
        return this.syncP_Mv;
    }

    public final Matrix4f getMviMat() {
        if (0 == (2 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        this.updateImpl(false);
        return this.matMvi;
    }

    public final SyncMatrix4f getSyncMviMat() {
        if (0 == (2 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncMvi;
    }

    public final Matrix4f getMvitMat() {
        if (0 == (4 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        this.updateImpl(false);
        return this.matMvit;
    }

    public final SyncMatrix4f getSyncMvitMat() {
        if (0 == (4 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncMvit;
    }

    public final SyncMatrices4f getSyncPMvMviMat() {
        if (0 == (2 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncP_Mv_Mvi;
    }

    public final SyncMatrices4f getSyncPMvMviMvitMat() {
        if (0 == (4 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncP_Mv_Mvi_Mvit;
    }

    public final Matrix4f getCurrentMat() {
        return this.getMat(this.matrixMode);
    }

    public final Matrix4f getMat(int n) {
        switch (n) {
            case 2982: 
            case 5888: {
                return this.matMv;
            }
            case 2983: 
            case 5889: {
                return this.matP;
            }
            case 2984: 
            case 5890: {
                return this.matTex;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public final Matrix4f mulPMvMat(Matrix4f matrix4f) {
        return matrix4f.mul(this.matP, this.matMv);
    }

    public final Matrix4f mulMvPMat(Matrix4f matrix4f) {
        return matrix4f.mul(this.matMv, this.matP);
    }

    public final Vec4f mulMvMatVec4f(Vec4f vec4f, Vec4f vec4f2) {
        return this.matMv.mulVec4f(vec4f, vec4f2);
    }

    public final Vec4f mulMvMatVec4f(Vec4f vec4f) {
        return this.matMv.mulVec4f(vec4f);
    }

    public final Vec3f mulMvMatVec3f(Vec3f vec3f, Vec3f vec3f2) {
        return this.matMv.mulVec3f(vec3f, vec3f2);
    }

    public final Vec3f mulMvMatVec3f(Vec3f vec3f) {
        return this.matMv.mulVec3f(vec3f);
    }

    public final Vec4f mulPMatVec4f(Vec4f vec4f, Vec4f vec4f2) {
        return this.matP.mulVec4f(vec4f, vec4f2);
    }

    public final Vec4f mulPMatVec4f(Vec4f vec4f) {
        return this.matP.mulVec4f(vec4f);
    }

    public final Vec3f mulPMatVec3f(Vec3f vec3f, Vec3f vec3f2) {
        return this.matP.mulVec3f(vec3f, vec3f2);
    }

    public final Vec3f mulPMatVec3f(Vec3f vec3f) {
        return this.matP.mulVec3f(vec3f);
    }

    public final Vec4f mulPMvMatVec4f(Vec4f vec4f, Vec4f vec4f2) {
        return this.matP.mulVec4f(this.matMv.mulVec4f(vec4f, vec4f2));
    }

    public final Vec4f mulPMvMatVec4f(Vec4f vec4f) {
        return this.matP.mulVec4f(this.matMv.mulVec4f(vec4f));
    }

    public final Vec3f mulPMvMatVec3f(Vec3f vec3f, Vec3f vec3f2) {
        return this.matP.mulVec3f(this.matMv.mulVec3f(vec3f, vec3f2));
    }

    public final Vec3f mulPMvMatVec3f(Vec3f vec3f) {
        return this.matP.mulVec3f(this.matMv.mulVec3f(vec3f));
    }

    @Override
    public final void glMatrixMode(int n) {
        switch (n) {
            case 5888: 
            case 5889: 
            case 5890: {
                break;
            }
            default: {
                throw new GLException("unsupported matrixName: " + n);
            }
        }
        this.matrixMode = n;
    }

    @Override
    public final void glGetFloatv(int n, FloatBuffer floatBuffer) {
        int n2 = floatBuffer.position();
        if (n == 2976) {
            floatBuffer.put(this.matrixMode);
        } else {
            this.getMat(n).get(floatBuffer);
        }
        floatBuffer.position(n2);
    }

    @Override
    public final void glGetFloatv(int n, float[] fArray, int n2) {
        if (n == 2976) {
            fArray[n2] = this.matrixMode;
        } else {
            this.getMat(n).get(fArray, n2);
        }
    }

    @Override
    public final void glGetIntegerv(int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        intBuffer.put(this.matrixMode);
        intBuffer.position(n2);
    }

    @Override
    public final void glGetIntegerv(int n, int[] nArray, int n2) {
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        nArray[n2] = this.matrixMode;
    }

    @Override
    public final void glLoadMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            this.matMv.load(fArray, n);
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.load(fArray, n);
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.load(fArray, n);
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glLoadMatrixf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        if (this.matrixMode == 5888) {
            this.matMv.load(floatBuffer);
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.load(floatBuffer);
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.load(floatBuffer);
            this.modifiedBits |= 4;
        }
        floatBuffer.position(n);
    }

    public final void glLoadMatrixf(Matrix4f matrix4f) {
        if (this.matrixMode == 5888) {
            this.matMv.load(matrix4f);
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.load(matrix4f);
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.load(matrix4f);
            this.modifiedBits |= 4;
        }
    }

    public final void glLoadMatrix(Quaternion quaternion) {
        if (this.matrixMode == 5888) {
            this.matMv.setToRotation(quaternion);
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.setToRotation(quaternion);
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.setToRotation(quaternion);
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glPopMatrix() {
        if (this.matrixMode == 5888) {
            this.matMv.pop();
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.pop();
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.pop();
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glPushMatrix() {
        if (this.matrixMode == 5888) {
            this.matMv.push();
        } else if (this.matrixMode == 5889) {
            this.matP.push();
        } else if (this.matrixMode == 5890) {
            this.matTex.push();
        }
    }

    @Override
    public final void glLoadIdentity() {
        if (this.matrixMode == 5888) {
            this.matMv.loadIdentity();
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.loadIdentity();
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.loadIdentity();
            this.modifiedBits |= 4;
        }
    }

    @Override
    public final void glMultMatrixf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        if (this.matrixMode == 5888) {
            this.matMv.mul(this.mat4Tmp1.load(floatBuffer));
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.mul(this.mat4Tmp1.load(floatBuffer));
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.mul(this.mat4Tmp1.load(floatBuffer));
            this.modifiedBits |= 4;
        }
        floatBuffer.position(n);
    }

    @Override
    public final void glMultMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            this.matMv.mul(this.mat4Tmp1.load(fArray, n));
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.mul(this.mat4Tmp1.load(fArray, n));
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.mul(this.mat4Tmp1.load(fArray, n));
            this.modifiedBits |= 4;
        }
    }

    public final PMVMatrix glMultMatrixf(Matrix4f matrix4f) {
        if (this.matrixMode == 5888) {
            this.matMv.mul(matrix4f);
            this.dirtyBits |= this.requestBits | 0x38;
            this.modifiedBits |= 2;
        } else if (this.matrixMode == 5889) {
            this.matP.mul(matrix4f);
            this.dirtyBits |= 0x38;
            this.modifiedBits |= 1;
        } else if (this.matrixMode == 5890) {
            this.matTex.mul(matrix4f);
            this.modifiedBits |= 4;
        }
        return this;
    }

    @Override
    public final void glTranslatef(float f, float f2, float f3) {
        this.glMultMatrixf(this.mat4Tmp1.setToTranslation(f, f2, f3));
    }

    public final PMVMatrix glTranslatef(Vec3f vec3f) {
        return this.glMultMatrixf(this.mat4Tmp1.setToTranslation(vec3f));
    }

    @Override
    public final void glScalef(float f, float f2, float f3) {
        this.glMultMatrixf(this.mat4Tmp1.setToScale(f, f2, f3));
    }

    public final PMVMatrix glScalef(Vec3f vec3f) {
        return this.glMultMatrixf(this.mat4Tmp1.setToScale(vec3f));
    }

    @Override
    public final void glRotatef(float f, float f2, float f3, float f4) {
        this.glMultMatrixf(this.mat4Tmp1.setToRotationAxis(FloatUtil.adegToRad(f), f2, f3, f4));
    }

    public final PMVMatrix glRotatef(float f, Vec3f vec3f) {
        return this.glMultMatrixf(this.mat4Tmp1.setToRotationAxis(f, vec3f));
    }

    public final PMVMatrix glRotate(Quaternion quaternion) {
        return this.glMultMatrixf(this.mat4Tmp1.setToRotation(quaternion));
    }

    @Override
    public final void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        this.glMultMatrixf(this.mat4Tmp1.setToOrtho(f, f2, f3, f4, f5, f6));
    }

    @Override
    public final void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) throws GLException {
        this.glMultMatrixf(this.mat4Tmp1.setToFrustum(f, f2, f3, f4, f5, f6));
    }

    public final void gluPerspective(float f, float f2, float f3, float f4) throws GLException {
        this.glMultMatrixf(this.mat4Tmp1.setToPerspective(FloatUtil.adegToRad(f), f2, f3, f4));
    }

    public final void gluLookAt(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        this.glMultMatrixf(this.mat4Tmp1.setToLookAt(vec3f, vec3f2, vec3f3, this.getTmp2Mat()));
    }

    public final boolean gluProject(Vec3f vec3f, Recti recti, Vec3f vec3f2) {
        return Matrix4f.mapObjToWin(vec3f, this.matMv, this.matP, recti, vec3f2);
    }

    public final boolean gluUnProject(float f, float f2, float f3, Recti recti, Vec3f vec3f) {
        return Matrix4f.mapWinToObj(f, f2, f3, this.getPMviMat(), recti, vec3f);
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, Recti recti, float f5, float f6, Vec4f vec4f) {
        return Matrix4f.mapWinToObj4(f, f2, f3, f4, this.getPMviMat(), recti, f5, f6, vec4f);
    }

    public final boolean gluUnProjectRay(float f, float f2, float f3, float f4, Recti recti, Ray ray) {
        return Matrix4f.mapWinToRay(f, f2, f3, f4, this.getPMviMat(), recti, ray);
    }

    public final void gluPickMatrix(float f, float f2, float f3, float f4, Recti recti) {
        if (null != this.mat4Tmp1.setToPick(f, f2, f3, f4, recti, this.getTmp2Mat())) {
            this.glMultMatrixf(this.mat4Tmp1);
        }
    }

    public StringBuilder toString(StringBuilder stringBuilder, String string) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = 0 != (0x10 & this.dirtyBits);
        boolean bl2 = null != this.matPMv;
        boolean bl3 = 0 != (0x20 & this.dirtyBits);
        boolean bl4 = null != this.matPMvi;
        boolean bl5 = 0 != (8 & this.dirtyBits);
        boolean bl6 = null != this.frustum;
        boolean bl7 = 0 != (2 & this.dirtyBits);
        boolean bl8 = 0 != (2 & this.requestBits);
        boolean bl9 = 0 != (4 & this.dirtyBits);
        boolean bl10 = 0 != (4 & this.requestBits);
        boolean bl11 = 0 != (1 & this.modifiedBits);
        boolean bl12 = 0 != (2 & this.modifiedBits);
        boolean bl13 = 0 != (4 & this.modifiedBits);
        int n = 3;
        stringBuilder.append("PMVMatrix[modified[P ").append(bl11).append(", Mv ").append(bl12).append(", T ").append(bl13);
        stringBuilder.append("], dirty/used[PMv ").append(bl).append("/").append(bl2).append(", Pmvi ").append(bl3).append("/").append(bl4).append(", Frustum ").append(bl5).append("/").append(bl6);
        stringBuilder.append("], dirty/req[Mvi ").append(bl7).append("/").append(bl8).append(", Mvit ").append(bl9).append("/").append(bl10).append("]").append(System.lineSeparator());
        stringBuilder.append(", Projection").append(System.lineSeparator());
        this.matP.toString(stringBuilder, null, string);
        stringBuilder.append(", Modelview").append(System.lineSeparator());
        this.matMv.toString(stringBuilder, null, string);
        stringBuilder.append(", Texture").append(System.lineSeparator());
        this.matTex.toString(stringBuilder, null, string);
        if (null != this.matPMv) {
            stringBuilder.append(", P * Mv").append(System.lineSeparator());
            this.matPMv.toString(stringBuilder, null, string);
            ++n;
        }
        if (null != this.matPMvi) {
            stringBuilder.append(", P * Mv").append(System.lineSeparator());
            this.matPMvi.toString(stringBuilder, null, string);
            ++n;
        }
        if (bl8) {
            stringBuilder.append(", Inverse Modelview").append(System.lineSeparator());
            this.matMvi.toString(stringBuilder, null, string);
            ++n;
        }
        if (bl10) {
            stringBuilder.append(", Inverse Transposed Modelview").append(System.lineSeparator());
            this.matMvit.toString(stringBuilder, null, string);
            ++n;
        }
        int n2 = 1;
        if (null != this.mat4Tmp2) {
            ++n2;
        }
        stringBuilder.append(", matrices " + n + " + " + n2 + " temp = " + (n + n2) + "]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null, "%10.5f").toString();
    }

    public final int getModifiedBits(boolean bl) {
        int n = this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        return n;
    }

    public final int getDirtyBits() {
        return this.dirtyBits;
    }

    public final boolean isReqDirty() {
        return 0 != (this.requestBits & this.dirtyBits);
    }

    public final int getReqBits() {
        return this.requestBits;
    }

    public final Matrix4f getPMvMat() {
        if (0 != (this.dirtyBits & 0x10)) {
            if (null == this.matPMv) {
                this.matPMv = new Matrix4f();
            }
            this.matPMv.mul(this.matP, this.matMv);
            this.dirtyBits &= 0xFFFFFFEF;
        }
        return this.matPMv;
    }

    public final Matrix4f getPMviMat() {
        if (0 != (this.dirtyBits & 0x20)) {
            if (null == this.matPMvi) {
                this.matPMvi = new Matrix4f();
            }
            Matrix4f matrix4f = this.getPMvMat();
            this.matPMviOK = this.matPMvi.invert(matrix4f);
            this.dirtyBits &= 0xFFFFFFDF;
        }
        return this.matPMviOK ? this.matPMvi : null;
    }

    public final Frustum getFrustum() {
        if (0 != (this.dirtyBits & 8)) {
            if (null == this.frustum) {
                this.frustum = new Frustum();
            }
            Matrix4f matrix4f = this.getPMvMat();
            this.frustum.updateFrustumPlanes(matrix4f);
            this.dirtyBits &= 0xFFFFFFF7;
        }
        return this.frustum;
    }

    public final boolean update() {
        return this.updateImpl(true);
    }

    private final boolean updateImpl(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = 0 != this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        if (0 != (this.requestBits & (this.dirtyBits & 6))) {
            if (!this.matMvi.invert(this.matMv)) {
                throw new GLException(msgCantComputeInverse);
            }
            this.dirtyBits &= 0xFFFFFFFD;
            bl2 = true;
        }
        if (0 != (this.requestBits & (this.dirtyBits & 4))) {
            this.matMvit.transpose(this.matMvi);
            this.dirtyBits &= 0xFFFFFFFB;
            bl2 = true;
        }
        return bl2;
    }

    private abstract class PMVSyncBuffer
    implements SyncMatrix4f {
        protected final Matrix4f mat;
        private final FloatBuffer fbuf;

        public PMVSyncBuffer(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            this.mat = matrix4f;
            this.fbuf = floatBuffer;
        }

        @Override
        public final Buffer getBuffer() {
            return this.fbuf;
        }

        @Override
        public final SyncBuffer sync() {
            this.getAction().sync();
            return this;
        }

        @Override
        public final Buffer getSyncBuffer() {
            this.getAction().sync();
            return this.fbuf;
        }

        @Override
        public final Matrix4f getMatrix() {
            return this.mat;
        }

        @Override
        public final FloatBuffer getSyncFloats() {
            this.getAction().sync();
            return this.fbuf;
        }
    }

    private abstract class PMVSyncBufferN
    implements SyncMatrices4f {
        protected final Matrix4f[] mats;
        private final FloatBuffer fbuf;

        public PMVSyncBufferN(Matrix4f[] matrix4fArray, FloatBuffer floatBuffer) {
            this.mats = matrix4fArray;
            this.fbuf = floatBuffer;
        }

        @Override
        public final Buffer getBuffer() {
            return this.fbuf;
        }

        @Override
        public final SyncBuffer sync() {
            this.getAction().sync();
            return this;
        }

        @Override
        public final Buffer getSyncBuffer() {
            this.getAction().sync();
            return this.fbuf;
        }

        @Override
        public Matrix4f[] getMatrices() {
            return this.mats;
        }

        @Override
        public final FloatBuffer getSyncFloats() {
            this.getAction().sync();
            return this.fbuf;
        }
    }

    private final class SyncBuffer0
    extends PMVSyncBuffer {
        private final SyncAction action;

        public SyncBuffer0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            super(matrix4f, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    SyncBuffer0.this.mat.get(PMVMatrix.this.matrixStore);
                }
            };
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBuffer1
    extends PMVSyncBuffer {
        private final int offset;
        private final SyncAction action;

        public SyncBuffer1(Matrix4f matrix4f, FloatBuffer floatBuffer, int n) {
            super(matrix4f, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    SyncBuffer1.this.mat.get(PMVMatrix.this.matrixStore, SyncBuffer1.this.offset);
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBuffer1U
    extends PMVSyncBuffer {
        private final int offset;
        private final SyncAction action;

        public SyncBuffer1U(Matrix4f matrix4f, FloatBuffer floatBuffer, int n) {
            super(matrix4f, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    PMVMatrix.this.updateImpl(true);
                    SyncBuffer1U.this.mat.get(PMVMatrix.this.matrixStore, SyncBuffer1U.this.offset);
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBufferN
    extends PMVSyncBufferN {
        private final int offset;
        private final SyncAction action;

        public SyncBufferN(Matrix4f[] matrix4fArray, FloatBuffer floatBuffer, int n) {
            super(matrix4fArray, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    int n = SyncBufferN.this.offset;
                    int n2 = 0;
                    while (n2 < SyncBufferN.this.mats.length) {
                        SyncBufferN.this.mats[n2].get(PMVMatrix.this.matrixStore, n);
                        ++n2;
                        n += 16;
                    }
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBufferNU
    extends PMVSyncBufferN {
        private final int offset;
        private final SyncAction action;

        public SyncBufferNU(Matrix4f[] matrix4fArray, FloatBuffer floatBuffer, int n) {
            super(matrix4fArray, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    PMVMatrix.this.updateImpl(true);
                    int n = SyncBufferNU.this.offset;
                    int n2 = 0;
                    while (n2 < SyncBufferNU.this.mats.length) {
                        SyncBufferNU.this.mats[n2].get(PMVMatrix.this.matrixStore, n);
                        ++n2;
                        n += 16;
                    }
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }
}

