/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class BaselineShiftManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 40;
    }

    @Override
    public String getPropertyName() {
        return "baseline-shift";
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.BASELINE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case IDENT: {
                Object object = values.get(lexicalUnit.getStringValue().toLowerCase().intern());
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
                }
                return (Value)object;
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s != 21) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        Object object = values.get(string.toLowerCase().intern());
        if (object == null) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return (Value)object;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getPrimitiveType() == 2) {
            styleMap.putLineHeightRelative(n, true);
            int n2 = cSSEngine.getLineHeightIndex();
            CSSStylableElement cSSStylableElement2 = (CSSStylableElement)cSSStylableElement.getParentNode();
            if (cSSStylableElement2 == null) {
                cSSStylableElement2 = cSSStylableElement;
            }
            Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, string, n2);
            float f = value2.getFloatValue();
            float f2 = value.getFloatValue();
            return new FloatValue(1, f * f2 / 100.0f);
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    @Override
    protected int getOrientation() {
        return 2;
    }

    static {
        values.put("baseline", SVGValueConstants.BASELINE_VALUE);
        values.put("sub", SVGValueConstants.SUB_VALUE);
        values.put("super", SVGValueConstants.SUPER_VALUE);
    }
}

