/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css2;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class FontFamilyManager
extends AbstractValueManager {
    protected static final ListValue DEFAULT_VALUE = new ListValue();
    protected static final StringMap values;

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 26;
    }

    @Override
    public String getPropertyName() {
        return "font-family";
    }

    @Override
    public Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
            }
            case IDENT: 
            case STRING: 
        }
        ListValue listValue = new ListValue();
        do {
            switch (lexicalUnit.getLexicalUnitType()) {
                case STRING: {
                    listValue.append(new StringValue(19, lexicalUnit.getStringValue()));
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    break;
                }
                case IDENT: {
                    StringBuilder stringBuilder = new StringBuilder(lexicalUnit.getStringValue());
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (lexicalUnit != null && this.isIdentOrNumber(lexicalUnit)) {
                        do {
                            stringBuilder.append(' ');
                            switch (lexicalUnit.getLexicalUnitType()) {
                                case IDENT: {
                                    stringBuilder.append(lexicalUnit.getStringValue());
                                    break;
                                }
                                case INTEGER: {
                                    stringBuilder.append(Integer.toString(lexicalUnit.getIntegerValue()));
                                }
                            }
                        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null && this.isIdentOrNumber(lexicalUnit));
                        listValue.append(new StringValue(19, stringBuilder.toString()));
                        break;
                    }
                    String string = stringBuilder.toString();
                    String string2 = string.toLowerCase().intern();
                    Value value = (Value)values.get(string2);
                    listValue.append(value != null ? value : new StringValue(19, string));
                    break;
                }
            }
            if (lexicalUnit == null) {
                return listValue;
            }
            if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    private boolean isIdentOrNumber(LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        switch (lexicalType) {
            case IDENT: 
            case INTEGER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value == DEFAULT_VALUE) {
            CSSContext cSSContext = cSSEngine.getCSSContext();
            value = cSSContext.getDefaultFontFamily();
        }
        return value;
    }

    static {
        DEFAULT_VALUE.append(new StringValue(19, "Arial"));
        DEFAULT_VALUE.append(new StringValue(19, "Helvetica"));
        DEFAULT_VALUE.append(new StringValue(21, "sans-serif"));
        values = new StringMap();
        values.put("cursive", ValueConstants.CURSIVE_VALUE);
        values.put("fantasy", ValueConstants.FANTASY_VALUE);
        values.put("monospace", ValueConstants.MONOSPACE_VALUE);
        values.put("serif", ValueConstants.SERIF_VALUE);
        values.put("sans-serif", ValueConstants.SANS_SERIF_VALUE);
    }
}

