/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.RectValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class RectManager
extends LengthManager {
    protected int orientation;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case FUNCTION: {
                if (!lexicalUnit.getFunctionName().equalsIgnoreCase("rect")) break;
            }
            case RECT_FUNCTION: {
                lexicalUnit = lexicalUnit.getParameters();
                Value value = this.createRectComponent(lexicalUnit);
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw this.createMalformedRectDOMException();
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                Value value2 = this.createRectComponent(lexicalUnit);
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw this.createMalformedRectDOMException();
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                Value value3 = this.createRectComponent(lexicalUnit);
                if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw this.createMalformedRectDOMException();
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                Value value4 = this.createRectComponent(lexicalUnit);
                return new RectValue(value, value2, value3, value4);
            }
        }
        throw this.createMalformedRectDOMException();
    }

    private Value createRectComponent(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                if (!lexicalUnit.getStringValue().equalsIgnoreCase("auto")) break;
                return ValueConstants.AUTO_VALUE;
            }
            case DIMENSION: {
                Value value = RectManager.createLength(lexicalUnit);
                if (value == null) break;
                return value;
            }
            case INTEGER: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
        }
        throw this.createMalformedRectDOMException();
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getCssValueType() != 1) {
            return value;
        }
        if (value.getPrimitiveType() != 24) {
            return value;
        }
        RectValue rectValue = (RectValue)value;
        this.orientation = 1;
        Value value2 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getTop());
        Value value3 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getBottom());
        this.orientation = 0;
        Value value4 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getLeft());
        Value value5 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getRight());
        if (value2 != rectValue.getTop() || value5 != rectValue.getRight() || value3 != rectValue.getBottom() || value4 != rectValue.getLeft()) {
            return new RectValue(value2, value5, value3, value4);
        }
        return value;
    }

    @Override
    protected int getOrientation() {
        return this.orientation;
    }

    private DOMException createMalformedRectDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string = Messages.formatMessage("malformed.rect", objectArray);
        return new DOMException(12, string);
    }
}

