/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.echosvg.css.dom.CSSOMValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMStyleDeclaration
implements CSSStyleDeclaration {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected CSSRule parentRule;
    protected Map<String, CSSValue> values;

    public CSSOMStyleDeclaration(ValueProvider valueProvider, CSSRule cSSRule) {
        this.valueProvider = valueProvider;
        this.parentRule = cSSRule;
    }

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.handler = modificationHandler;
    }

    @Override
    public String getCssText() {
        return this.valueProvider.getText();
    }

    @Override
    public void setCssText(String string) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.values = null;
        this.handler.textChanged(string);
    }

    @Override
    public String getPropertyValue(String string) {
        Value value = this.valueProvider.getValue(string);
        if (value == null) {
            return "";
        }
        return value.getCssText();
    }

    @Override
    public CSSValue getPropertyCSSValue(String string) {
        Value value = this.valueProvider.getValue(string);
        if (value == null) {
            return null;
        }
        return this.getCSSValue(string);
    }

    @Override
    public String removeProperty(String string) throws DOMException {
        String string2 = this.getPropertyValue(string);
        if (string2.length() > 0) {
            if (this.handler == null) {
                throw new DOMException(7, "");
            }
            if (this.values != null) {
                this.values.remove(string);
            }
            this.handler.propertyRemoved(string);
        }
        return string2;
    }

    @Override
    public String getPropertyPriority(String string) {
        return this.valueProvider.isImportant(string) ? "important" : "";
    }

    @Override
    public void setProperty(String string, String string2, String string3) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.propertyChanged(string, string2, string3);
    }

    @Override
    public int getLength() {
        return this.valueProvider.getLength();
    }

    @Override
    public String item(int n) {
        return this.valueProvider.item(n);
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    protected CSSValue getCSSValue(String string) {
        CSSValue cSSValue = null;
        if (this.values != null) {
            cSSValue = this.values.get(string);
        }
        if (cSSValue == null) {
            cSSValue = this.createCSSValue(string);
            if (this.values == null) {
                this.values = new HashMap<String, CSSValue>(11);
            }
            this.values.put(string, cSSValue);
        }
        return cSSValue;
    }

    protected CSSValue createCSSValue(String string) {
        return new StyleDeclarationValue(string);
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void propertyRemoved(String var1) throws DOMException;

        public void propertyChanged(String var1, String var2, String var3) throws DOMException;
    }

    public class StyleDeclarationValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        protected String property;

        public StyleDeclarationValue(String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMValue.AbstractModificationHandler(){

                @Override
                protected Value getValue() {
                    return StyleDeclarationValue.this.getValue();
                }

                @Override
                public void textChanged(String string) throws DOMException {
                    if (CSSOMStyleDeclaration.this.values == null || StyleDeclarationValue.this.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String string2 = CSSOMStyleDeclaration.this.getPropertyPriority(StyleDeclarationValue.this.property);
                    CSSOMStyleDeclaration.this.handler.propertyChanged(StyleDeclarationValue.this.property, string, string2);
                }
            });
            this.property = string;
        }

        @Override
        public Value getValue() {
            return CSSOMStyleDeclaration.this.valueProvider.getValue(this.property);
        }
    }

    public static interface ValueProvider {
        public Value getValue(String var1);

        public boolean isImportant(String var1);

        public String getText();

        public int getLength();

        public String item(int var1);
    }
}

