/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.swing.svg;

import io.sf.carte.echosvg.bridge.DocumentLoader;
import io.sf.carte.echosvg.swing.svg.SVGDocumentLoaderEvent;
import io.sf.carte.echosvg.swing.svg.SVGDocumentLoaderListener;
import io.sf.carte.echosvg.util.EventDispatcher;
import io.sf.carte.echosvg.util.HaltingThread;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.svg.SVGDocument;

public class SVGDocumentLoader
extends HaltingThread {
    protected String url;
    protected DocumentLoader loader;
    protected Exception exception;
    protected List<Object> listeners = Collections.synchronizedList(new LinkedList());
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingStarted((SVGDocumentLoaderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingCompleted((SVGDocumentLoaderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingCancelled((SVGDocumentLoaderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((SVGDocumentLoaderListener)object).documentLoadingFailed((SVGDocumentLoaderEvent)object2);
        }
    };

    public SVGDocumentLoader(String string, DocumentLoader documentLoader) {
        this.url = string;
        this.loader = documentLoader;
    }

    public void run() {
        SVGDocumentLoaderEvent sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent((Object)this, null);
        try {
            this.fireEvent(startedDispatcher, sVGDocumentLoaderEvent);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, sVGDocumentLoaderEvent);
                return;
            }
            SVGDocument sVGDocument = (SVGDocument)this.loader.loadDocument(this.url);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, sVGDocumentLoaderEvent);
                return;
            }
            sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent((Object)this, sVGDocument);
            this.fireEvent(completedDispatcher, sVGDocumentLoaderEvent);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.fireEvent(cancelledDispatcher, sVGDocumentLoaderEvent);
        }
        catch (Exception exception) {
            this.exception = exception;
            this.fireEvent(failedDispatcher, sVGDocumentLoaderEvent);
        }
        catch (ThreadDeath threadDeath) {
            this.exception = new Exception(threadDeath.getMessage());
            this.fireEvent(failedDispatcher, sVGDocumentLoaderEvent);
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.exception = new Exception(throwable.getMessage());
            this.fireEvent(failedDispatcher, sVGDocumentLoaderEvent);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.listeners.add(sVGDocumentLoaderListener);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.listeners.remove(sVGDocumentLoaderListener);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, this.listeners, (Object)object, (boolean)true);
    }
}

