/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.swing.gvt;

import io.sf.carte.echosvg.swing.gvt.InteractorAdapter;
import io.sf.carte.echosvg.swing.gvt.JGVTComponent;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public abstract class AbstractPanInteractor
extends InteractorAdapter {
    public static final Cursor PAN_CURSOR = new Cursor(13);
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;
    protected Cursor previousCursor;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.finished) {
            this.mouseExited(mouseEvent);
            return;
        }
        this.finished = false;
        this.xStart = mouseEvent.getX();
        this.yStart = mouseEvent.getY();
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.previousCursor = jGVTComponent.getCursor();
        jGVTComponent.setCursor(PAN_CURSOR);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.xCurrent = mouseEvent.getX();
        this.yCurrent = mouseEvent.getY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.xCurrent - this.xStart, this.yCurrent - this.yStart);
        AffineTransform affineTransform2 = (AffineTransform)jGVTComponent.getRenderingTransform().clone();
        affineTransform2.preConcatenate(affineTransform);
        jGVTComponent.setRenderingTransform(affineTransform2);
        if (jGVTComponent.getCursor() == PAN_CURSOR) {
            jGVTComponent.setCursor(this.previousCursor);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        jGVTComponent.setPaintingTransform(null);
        if (jGVTComponent.getCursor() == PAN_CURSOR) {
            jGVTComponent.setCursor(this.previousCursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.xCurrent = mouseEvent.getX();
        this.yCurrent = mouseEvent.getY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.xCurrent - this.xStart, this.yCurrent - this.yStart);
        jGVTComponent.setPaintingTransform(affineTransform);
    }
}

