/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.extension.svg;

import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.extension.svg.EchoSVGExtConstants;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.UnitProcessor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Element;

public class EchoSVGStarElementBridge
extends SVGDecoratedShapeElementBridge
implements EchoSVGExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "star";
    }

    public Bridge getInstance() {
        return new EchoSVGStarElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        UnitProcessor.Context context = UnitProcessor.createContext((BridgeContext)bridgeContext, (Element)element);
        String string = element.getAttributeNS(null, "cx");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)string, (String)"cx", (UnitProcessor.Context)context);
        }
        string = element.getAttributeNS(null, "cy");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace((String)string, (String)"cy", (UnitProcessor.Context)context);
        }
        if ((string = element.getAttributeNS(null, "r")).length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"r", string});
        }
        float f3 = UnitProcessor.svgOtherLengthToUserSpace((String)string, (String)"r", (UnitProcessor.Context)context);
        string = element.getAttributeNS(null, "ir");
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"ir", string});
        }
        float f4 = UnitProcessor.svgOtherLengthToUserSpace((String)string, (String)"ir", (UnitProcessor.Context)context);
        int n = EchoSVGStarElementBridge.convertSides(element, "sides", 3, bridgeContext);
        GeneralPath generalPath = new GeneralPath();
        double d = Math.PI * 2 / (double)n;
        double d2 = 1.5707963267948966;
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i * d - 1.5707963267948966;
            double d4 = (double)f + (double)f4 * Math.cos(d3);
            double d5 = (double)f2 - (double)f4 * Math.sin(d3);
            if (i == 0) {
                generalPath.moveTo((float)d4, (float)d5);
            } else {
                generalPath.lineTo((float)d4, (float)d5);
            }
            d3 = ((double)i + 0.5) * d - 1.5707963267948966;
            d4 = (double)f + (double)f3 * Math.cos(d3);
            d5 = (double)f2 - (double)f3 * Math.sin(d3);
            generalPath.lineTo((float)d4, (float)d5);
        }
        generalPath.closePath();
        shapeNode.setShape((Shape)generalPath);
    }

    protected static int convertSides(Element element, String string, int n, BridgeContext bridgeContext) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = SVGUtilities.convertSVGInteger((String)string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, (Exception)numberFormatException, "attribute.malformed", new Object[]{string, string2});
        }
        if (n2 < 3) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{string, string2});
        }
        return n2;
    }
}

