/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt;

import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StrokeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected Shape strokedShape;
    protected Stroke stroke;
    protected Paint paint;

    public StrokeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.strokedShape = null;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.stroke != null && this.paint != null) {
            graphics2D.setPaint(this.paint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.shape);
        }
    }

    @Override
    public Shape getPaintedArea() {
        if (this.paint == null || this.stroke == null) {
            return null;
        }
        if (this.strokedShape == null) {
            this.strokedShape = this.stroke.createStrokedShape(this.shape);
        }
        return this.strokedShape;
    }

    @Override
    public Rectangle2D getPaintedBounds2D() {
        Shape shape = this.getPaintedArea();
        if (shape == null) {
            return null;
        }
        return shape.getBounds2D();
    }

    @Override
    public boolean inPaintedArea(Point2D point2D) {
        Shape shape = this.getPaintedArea();
        if (shape == null) {
            return false;
        }
        return shape.contains(point2D);
    }

    @Override
    public Shape getSensitiveArea() {
        if (this.stroke == null) {
            return null;
        }
        if (this.strokedShape == null) {
            this.strokedShape = this.stroke.createStrokedShape(this.shape);
        }
        return this.strokedShape;
    }

    @Override
    public Rectangle2D getSensitiveBounds2D() {
        Shape shape = this.getSensitiveArea();
        if (shape == null) {
            return null;
        }
        return shape.getBounds2D();
    }

    @Override
    public boolean inSensitiveArea(Point2D point2D) {
        Shape shape = this.getSensitiveArea();
        if (shape == null) {
            return false;
        }
        return shape.contains(point2D);
    }

    @Override
    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
        this.strokedShape = null;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }
}

