/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.awt;

import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.om.AbstractStyleDatabase;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.DOMException;

public class AWTStyleDatabase
extends AbstractStyleDatabase {
    private static final long serialVersionUID = 1L;
    private GraphicsConfiguration gConfiguration = null;
    private float defaultWidth = 595.0f;
    private float defaultHeight = 842.0f;
    private final Map<String, Font> fontfaceNames = new HashMap<String, Font>();

    public AWTStyleDatabase() {
        this(null);
    }

    public AWTStyleDatabase(GraphicsConfiguration graphicsConfiguration) {
        this.gConfiguration = graphicsConfiguration;
    }

    public String getDefaultGenericFontFamily(String string) {
        if (string == null) {
            return "SansSerif";
        }
        string = string.toLowerCase(Locale.ROOT);
        String string2 = null;
        if (string.equals("serif")) {
            string2 = "Serif";
        } else if (string.equals("sans-serif") || string.equals("sans serif") || string.equals("sansserif")) {
            string2 = "SansSerif";
        } else if (string.equals("monospace")) {
            string2 = "Monospaced";
        }
        return string2;
    }

    protected boolean isFontFamilyAvailable(String string) {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isFontFaceName(String string) {
        return this.fontfaceNames.containsKey(string);
    }

    protected boolean loadFontFace(String string, AbstractStyleDatabase.FontFormat fontFormat, InputStream inputStream, CSSFontFaceRule cSSFontFaceRule) throws IOException {
        Font font;
        int n;
        if (fontFormat == null || (n = this.fontFormatFromEnum(fontFormat)) == -1) {
            return false;
        }
        try {
            font = Font.createFont(n, inputStream);
        }
        catch (FontFormatException fontFormatException) {
            cSSFontFaceRule.getParentStyleSheet().getErrorHandler().fontFormatError(cSSFontFaceRule, (Exception)fontFormatException);
            return false;
        }
        this.fontfaceNames.put(string, font);
        return true;
    }

    private int fontFormatFromEnum(AbstractStyleDatabase.FontFormat fontFormat) {
        int n;
        switch (fontFormat) {
            case TRUETYPE: 
            case OPENTYPE: {
                n = 0;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public Font getFont(String string) {
        return this.fontfaceNames.get(string);
    }

    protected GraphicsConfiguration getGraphicsConfiguration() {
        return this.gConfiguration;
    }

    public void setGraphicsConfiguration(GraphicsConfiguration graphicsConfiguration) {
        this.gConfiguration = graphicsConfiguration;
    }

    protected float deviceResolutionFactor() {
        return this.getDeviceWidth() / 595.0f;
    }

    public float getFontSizeFromIdentifier(String string, String string2) throws DOMException {
        float f;
        float f2 = Math.max(0.9f, this.deviceResolutionFactor());
        if (string2.equals("xx-small")) {
            f = 8.0f * f2;
        } else if (string2.equals("x-small")) {
            f = 9.0f * f2;
        } else if (string2.equals("small")) {
            f = 10.0f * f2;
        } else if (string2.equals("medium")) {
            f = 12.0f * f2;
        } else if (string2.equals("large")) {
            f = 14.0f * f2;
        } else if (string2.equals("x-large")) {
            f = 18.0f * f2;
        } else if (string2.equals("xx-large")) {
            f = 24.0f * f2;
        } else {
            throw new DOMException(15, "Unknown size identifier: " + string2);
        }
        return f;
    }

    public float getWidthSize(String string, float f) throws DOMException {
        float f2 = Math.max(0.62f, this.deviceResolutionFactor());
        if ("thin".equalsIgnoreCase(string)) {
            return 1.0f * f2;
        }
        if ("thick".equalsIgnoreCase(string)) {
            return 4.0f * f2;
        }
        if ("medium".equalsIgnoreCase(string)) {
            return 2.0f * f2;
        }
        throw new DOMException(12, "Unknown identifier " + string);
    }

    public short getNaturalUnit() {
        return 6;
    }

    public float getDeviceHeight() {
        float f = this.gConfiguration != null ? (float)this.getGraphicsConfiguration().getBounds().getHeight() : this.defaultHeight;
        return f;
    }

    public float getDeviceWidth() {
        float f = this.gConfiguration != null ? (float)this.getGraphicsConfiguration().getBounds().getWidth() : this.defaultWidth;
        return f;
    }

    public void setDefaultWidth(float f) {
        this.defaultWidth = f;
    }

    public void setDefaultHeight(float f) {
        this.defaultHeight = f;
    }

    public int getColorDepth() {
        int n = 255;
        if (this.gConfiguration != null) {
            int[] nArray = this.gConfiguration.getColorModel().getComponentSize();
            for (int i = 0; i < 3; ++i) {
                if (n <= nArray[i]) continue;
                n = nArray[i];
            }
        }
        return n;
    }
}

