/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StringValue;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.DOMException;

public class URIValue
extends StringValue {
    private static final long serialVersionUID = 1L;

    public URIValue(byte by) {
        super(CSSValue.Type.URI, by);
    }

    protected URIValue(URIValue uRIValue) {
        super(uRIValue);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new URILexicalSetter();
    }

    @Override
    public void setCssText(String string) throws DOMException {
        LexicalUnit lexicalUnit;
        this.checkModifiableProperty();
        if (string.indexOf(40) == -1 && string.indexOf(41) == -1) {
            string = "url(" + string + ")";
        }
        PrimitiveValue.LexicalSetter lexicalSetter = this.newLexicalSetter();
        CSSParser cSSParser = new CSSParser();
        try {
            lexicalUnit = cSSParser.parsePropertyValue(new StringReader(string));
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, "Error parsing text: " + cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (IOException iOException) {
            lexicalUnit = null;
        }
        if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.URI) {
            throw new DOMException(13, "Not a URI value.");
        }
        lexicalSetter.setLexicalUnit(lexicalUnit);
    }

    @Override
    boolean usesDoubleQuote(String string) {
        int n = string.lastIndexOf(41);
        while (n > 0) {
            char c;
            if ((c = string.charAt(--n)) == ' ') continue;
            return c == '\"';
        }
        return false;
    }

    @Override
    protected void setUnescapedCssText(String string) {
        int n = (string = ParseHelper.escapeBackslash(string).toString()).indexOf(39);
        if (n != -1) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 8);
            stringBuilder.append(string.subSequence(0, n));
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                if (c == this.quote) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            string = stringBuilder.toString();
        }
        this.setPlainCssText("url(" + this.quote + string + this.quote + ')');
    }

    @Override
    public String getMinifiedCssText(String string) {
        String string2;
        String string3 = this.getStringValue();
        if (string3 != null) {
            String string4 = ParseHelper.quote(string3, this.quote);
            StringBuilder stringBuilder = new StringBuilder(string4.length() + 5);
            stringBuilder.append("url(").append(string4).append(')');
            string2 = stringBuilder.toString();
        } else {
            string2 = "url()";
        }
        return string2;
    }

    public URL getURLValue() {
        URL uRL;
        String string = this.getStringValue();
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        switch (cSSValueSyntax.getCategory()) {
            case url: 
            case image: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = this.getCssValueType().hashCode();
        n2 = 31 * n2 + this.getPrimitiveType().hashCode();
        String string = this.getStringValue();
        return 31 * n2 + (string == null ? 0 : string.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URIValue)) {
            return false;
        }
        URIValue uRIValue = (URIValue)object;
        String string = this.getStringValue();
        if (string == null) {
            return uRIValue.getStringValue() == null;
        }
        return string.equals(uRIValue.getStringValue());
    }

    public boolean isEquivalent(URIValue uRIValue) {
        if (this.getMinifiedCssText(null).equals(uRIValue.getMinifiedCssText(null))) {
            return true;
        }
        String string = this.getStringValue();
        if (string == null) {
            return uRIValue.getStringValue() == null;
        }
        return string.equals(uRIValue.getStringValue());
    }

    @Override
    public URIValue clone() {
        return new URIValue(this);
    }

    class URILexicalSetter
    extends StringValue.MyLexicalSetter {
        URILexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            if (lexicalUnit.getParameters() != null) {
                throw new CSSLexicalProcessingException("var() found.");
            }
            super.setLexicalUnit(lexicalUnit);
        }
    }
}

