/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.doc.style.css.property.VarValue;
import org.w3c.dom.DOMException;

public abstract class TypedValue
extends PrimitiveValue
implements CSSTypedValue {
    private static final long serialVersionUID = 1L;

    protected TypedValue(CSSValue.Type type) {
        super(type);
    }

    @Override
    public CSSValue.CssType getCssValueType() {
        return CSSValue.CssType.TYPED;
    }

    protected TypedValue(TypedValue typedValue) {
        super(typedValue);
    }

    @Override
    public void setFloatValue(short s, float f) throws DOMException {
        throw new DOMException(15, "Not a <number>.");
    }

    @Override
    public float getFloatValue(short s) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public void setStringValue(CSSValue.Type type, String string) throws DOMException {
        if (type != this.getPrimitiveType()) {
            throw new DOMException(13, "Type not supported.");
        }
        throw new DOMException(15, "Cannot be modified as a String");
    }

    @Override
    public String getStringValue() throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        throw new DOMException(15, "Not an RGB Color");
    }

    @Override
    public boolean isCalculatedNumber() {
        return false;
    }

    @Override
    public boolean isNumberZero() {
        return false;
    }

    static boolean isCSSIdentifier(PrimitiveValue primitiveValue, String string) {
        return primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT && string.equalsIgnoreCase(((CSSTypedValue)((Object)primitiveValue)).getStringValue());
    }

    static boolean isOrContainsType(StyleValue styleValue, CSSValue.Type type) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (styleValue.isPrimitiveValue()) {
            return TypedValue.isOrContainsType((CSSPrimitiveValue)((Object)styleValue), type);
        }
        if (cssType == CSSValue.CssType.LIST) {
            return TypedValue.listContainsType((ValueList)styleValue, type);
        }
        return false;
    }

    private static boolean listContainsType(ValueList valueList, CSSValue.Type type) {
        for (StyleValue styleValue : valueList) {
            if (!TypedValue.isOrContainsType(styleValue, type)) continue;
            return true;
        }
        return false;
    }

    static boolean isOrContainsType(CSSPrimitiveValue cSSPrimitiveValue, CSSValue.Type type) {
        CSSValue.Type type2 = cSSPrimitiveValue.getPrimitiveType();
        if (type2 == type) {
            return true;
        }
        if (type2 == CSSValue.Type.FUNCTION || type2 == CSSValue.Type.MATH_FUNCTION) {
            return TypedValue.functionContainsType((FunctionValue)cSSPrimitiveValue, type);
        }
        if (type2 == CSSValue.Type.EXPRESSION) {
            return TypedValue.expressionContainsType(((ExpressionValue)cSSPrimitiveValue).getExpression(), type);
        }
        if (type2 == CSSValue.Type.VAR) {
            LexicalUnit lexicalUnit = ((VarValue)cSSPrimitiveValue).getFallback();
            return lexicalUnit != null && TypedValue.isOrContainsType(lexicalUnit, type);
        }
        return false;
    }

    private static boolean functionContainsType(FunctionValue functionValue, CSSValue.Type type) {
        LinkedCSSValueList linkedCSSValueList = functionValue.getArguments();
        for (StyleValue styleValue : linkedCSSValueList) {
            if (!TypedValue.isOrContainsType(styleValue, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean expressionContainsType(CSSExpression cSSExpression, CSSValue.Type type) {
        switch (cSSExpression.getPartType()) {
            case SUM: 
            case PRODUCT: {
                AlgebraicExpression algebraicExpression = (AlgebraicExpression)cSSExpression;
                int n = algebraicExpression.getLength();
                for (int i = 0; i < n; ++i) {
                    if (!TypedValue.expressionContainsType(algebraicExpression.item(i), type)) continue;
                    return true;
                }
                break;
            }
            case OPERAND: {
                OperandExpression operandExpression = (OperandExpression)cSSExpression;
                CSSPrimitiveValue cSSPrimitiveValue = operandExpression.getOperand();
                if (!TypedValue.isOrContainsType(cSSPrimitiveValue, type)) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isOrContainsType(LexicalUnit lexicalUnit, CSSValue.Type type) {
        if (type == CSSValue.Type.ATTR) {
            return TypedValue.hasLexicalUnitType(lexicalUnit, LexicalUnit.LexicalType.ATTR);
        }
        return false;
    }

    private static boolean hasLexicalUnitType(LexicalUnit lexicalUnit, LexicalUnit.LexicalType lexicalType) {
        do {
            if (lexicalUnit.getLexicalUnitType() != lexicalType) continue;
            return true;
        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
        return false;
    }

    public StyleValue getComponent(int n) {
        return null;
    }

    public void setComponent(int n, StyleValue styleValue) throws DOMException {
    }

    public int getComponentCount() {
        return 0;
    }

    @Override
    public abstract TypedValue clone();
}

