/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class NumberValue
extends TypedValue {
    private static final long serialVersionUID = 1L;
    private short unitType;
    protected float realvalue = 0.0f;
    private String dimensionUnitText = "";
    private boolean asInteger = false;
    boolean lengthUnitType = false;
    private boolean calculated = false;
    private boolean specified = true;
    private int maxFractionDigits = -1;

    public NumberValue() {
        super(CSSValue.Type.NUMERIC);
        this.unitType = 0;
    }

    protected NumberValue(NumberValue numberValue) {
        super(numberValue);
        this.unitType = numberValue.unitType;
        this.realvalue = numberValue.realvalue;
        this.asInteger = numberValue.asInteger;
        this.calculated = numberValue.calculated;
        this.specified = numberValue.specified;
        this.maxFractionDigits = numberValue.maxFractionDigits;
        this.lengthUnitType = numberValue.lengthUnitType;
        this.dimensionUnitText = numberValue.dimensionUnitText;
        this.maxFractionDigits = numberValue.maxFractionDigits;
    }

    @Override
    public short getUnitType() {
        return this.unitType;
    }

    void setUnitType(short s) {
        this.unitType = s;
    }

    @Override
    public String getCssText() {
        boolean bl;
        boolean bl2 = bl = this.unitType != 0;
        if (this.realvalue == 0.0f && !bl) {
            return "0";
        }
        if (Float.isInfinite(this.realvalue)) {
            return this.serializeInfinite();
        }
        double d = Math.rint(this.realvalue);
        if (this.asInteger) {
            return Integer.toString((int)d);
        }
        if ((double)this.realvalue == d && bl) {
            return (int)d + this.dimensionUnitText;
        }
        String string = this.serializeNumber(this.realvalue);
        StringBuilder stringBuilder = new StringBuilder(string.length() + this.dimensionUnitText.length());
        stringBuilder.append(string);
        stringBuilder.append(this.dimensionUnitText);
        return stringBuilder.toString();
    }

    private String serializeNumber(float f) {
        String string;
        if (this.specified && !this.calculated) {
            string = Float.toString(f);
        } else {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
            numberFormat.setMinimumFractionDigits(0);
            int n = this.maxFractionDigits;
            if (n < 0) {
                n = NumberValue.fractionDigits(this.getUnitType());
            }
            numberFormat.setMaximumFractionDigits(n);
            string = numberFormat.format(f);
        }
        return string;
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        this.writeCssText(simpleWriter, this.realvalue);
    }

    void writeCssText(SimpleWriter simpleWriter, float f) throws IOException {
        boolean bl;
        boolean bl2 = bl = this.getUnitType() != 0;
        if (f == 0.0f && !bl) {
            simpleWriter.write('0');
            return;
        }
        if (Float.isInfinite(f)) {
            this.writeInfinite(simpleWriter);
            return;
        }
        double d = Math.rint(f);
        if (this.asInteger) {
            simpleWriter.write((CharSequence)Integer.toString((int)d));
            return;
        }
        if ((double)f == d && bl) {
            simpleWriter.write((CharSequence)Integer.toString((int)d));
            simpleWriter.write((CharSequence)this.dimensionUnitText);
            return;
        }
        String string = this.serializeNumber(f);
        simpleWriter.write((CharSequence)string);
        simpleWriter.write((CharSequence)this.dimensionUnitText);
    }

    private void writeInfinite(SimpleWriter simpleWriter) throws IOException {
        if (this.realvalue > 0.0f) {
            simpleWriter.write((CharSequence)"calc(1/0)");
        } else {
            simpleWriter.write((CharSequence)"calc(-1/0)");
        }
    }

    public void serializeAbsolute(SimpleWriter simpleWriter) throws IOException {
        this.writeCssText(simpleWriter, Math.abs(this.realvalue));
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.getMinifiedCssText(string, this.realvalue);
    }

    private String getMinifiedCssText(String string, float f) {
        if (f == 0.0f && this.getUnitType() != 2 && this.isLengthUnitType() && !this.isSubproperty() && this.isSpecified()) {
            return "0";
        }
        if (Float.isInfinite(f)) {
            return this.serializeInfinite();
        }
        double d = Math.rint(f);
        if (this.asInteger) {
            return Integer.toString((int)d);
        }
        if ((double)f == d) {
            boolean bl;
            String string2 = Integer.toString((int)d);
            boolean bl2 = bl = this.getUnitType() != 0;
            if (bl) {
                return string2 + this.dimensionUnitText;
            }
            return string2;
        }
        String string3 = this.serializeNumber(f);
        int n = string3.length();
        StringBuilder stringBuilder = new StringBuilder(n + this.dimensionUnitText.length());
        char c = string3.charAt(0);
        if (c == '-' && string3.charAt(1) == '0') {
            stringBuilder.append('-');
            stringBuilder.append(string3.subSequence(2, n));
        } else if (c == '0' && n > 2) {
            stringBuilder.append(string3.subSequence(1, n));
        } else {
            stringBuilder.append(string3);
        }
        stringBuilder.append(this.dimensionUnitText);
        return stringBuilder.toString();
    }

    private String serializeInfinite() {
        if (this.realvalue > 0.0f) {
            return "calc(1/0)";
        }
        return "calc(-1/0)";
    }

    public String minifyAbsolute(String string) {
        return this.getMinifiedCssText(string, Math.abs(this.realvalue));
    }

    private boolean isLengthUnitType() {
        return this.lengthUnitType;
    }

    @Override
    public void setFloatValue(short s, float f) throws DOMException {
        this.checkModifiableProperty();
        this.setUnitType(s);
        this.realvalue = f;
        this.dimensionUnitText = CSSUnit.dimensionUnitString(s);
        this.asInteger = s == 0 && (float)Math.rint(f) == this.realvalue;
        this.lengthUnitType = CSSUnit.isLengthUnitType(s);
    }

    public void setFloatValuePt(float f) {
        this.setUnitType((short)6);
        this.realvalue = f;
        this.dimensionUnitText = "pt";
        this.asInteger = false;
        this.lengthUnitType = true;
    }

    public void setIntegerValue(int n) {
        this.realvalue = n;
        this.setUnitType((short)0);
        this.asInteger = true;
        this.lengthUnitType = false;
    }

    @Override
    public void setExpectInteger() {
        if (this.getUnitType() != 0) {
            super.setExpectInteger();
        } else if (this.calculated) {
            this.asInteger = true;
            this.realvalue = Math.round(this.realvalue);
        } else if (!this.asInteger) {
            super.setExpectInteger();
        }
    }

    void roundToInteger() throws DOMException {
        this.asInteger = true;
        this.setExpectInteger();
        this.realvalue = Math.round(this.realvalue);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "Cannot use setCssText here");
    }

    @Override
    public boolean isCalculatedNumber() {
        return this.calculated;
    }

    void setCalculatedNumber(boolean bl) {
        this.calculated = bl;
        this.specified = this.specified && !bl;
    }

    public void setAbsolutizedUnit() {
        this.specified = false;
    }

    void setSpecified(boolean bl) {
        this.specified = bl;
    }

    boolean isSpecified() {
        return this.specified;
    }

    public void setMaximumFractionDigits(int n) {
        this.maxFractionDigits = n;
    }

    @Override
    public boolean isNegativeNumber() {
        return this.realvalue < 0.0f;
    }

    @Override
    public boolean isNumberZero() {
        return this.realvalue == 0.0f;
    }

    @Override
    public float getFloatValue(short s) throws DOMException {
        if (s == this.getUnitType()) {
            return this.realvalue;
        }
        if (s == 0 && this.getUnitType() != 2) {
            return this.realvalue;
        }
        return NumberValue.floatValueConversion(this.realvalue, this.getUnitType(), s);
    }

    public static float floatValueConversion(float f, short s, short s2) throws DOMException {
        String string;
        String string2;
        if (f == 0.0f) {
            return 0.0f;
        }
        if (s == s2) {
            return f;
        }
        switch (s) {
            case 6: {
                if (s2 == 3) {
                    return f / 0.75f;
                }
                if (s2 == 4) {
                    return f / 72.0f;
                }
                if (s2 == 5) {
                    return f / 12.0f;
                }
                if (s2 == 7) {
                    return f / 28.346457f;
                }
                if (s2 == 8) {
                    return f / 2.8346457f;
                }
                if (s2 != 9) break;
                return f * 1.4111111f;
            }
            case 3: {
                if (s2 == 6) {
                    return f * 0.75f;
                }
                if (s2 == 4) {
                    return f / 96.0f;
                }
                if (s2 == 5) {
                    return f / 16.0f;
                }
                if (s2 == 7) {
                    return f / 37.795277f;
                }
                if (s2 == 8) {
                    return f / 3.7795277f;
                }
                if (s2 != 9) break;
                return f * 1.0583333f;
            }
            case 5: {
                if (s2 == 6) {
                    return f * 12.0f;
                }
                if (s2 == 4) {
                    return f / 6.0f;
                }
                if (s2 == 3) {
                    return f * 16.0f;
                }
                if (s2 == 7) {
                    return f * 0.42333332f;
                }
                if (s2 == 8) {
                    return f * 4.233333f;
                }
                if (s2 != 9) break;
                return f * 16.933332f;
            }
            case 4: {
                if (s2 == 3) {
                    return f * 96.0f;
                }
                if (s2 == 6) {
                    return f * 72.0f;
                }
                if (s2 == 5) {
                    return f * 6.0f;
                }
                if (s2 == 7) {
                    return f * 2.54f;
                }
                if (s2 == 8) {
                    return f * 25.4f;
                }
                if (s2 != 9) break;
                return f * 101.6f;
            }
            case 7: {
                if (s2 == 6) {
                    return f * 28.346457f;
                }
                if (s2 == 4) {
                    return f / 2.54f;
                }
                if (s2 == 3) {
                    return f * 37.795277f;
                }
                if (s2 == 5) {
                    return f * 2.3622048f;
                }
                if (s2 == 8) {
                    return f * 10.0f;
                }
                if (s2 != 9) break;
                return f * 40.0f;
            }
            case 8: {
                if (s2 == 6) {
                    return f * 2.8346457f;
                }
                if (s2 == 4) {
                    return f / 25.4f;
                }
                if (s2 == 3) {
                    return f * 3.7795277f;
                }
                if (s2 == 5) {
                    return f * 0.23622046f;
                }
                if (s2 == 7) {
                    return f * 0.1f;
                }
                if (s2 != 9) break;
                return f * 4.0f;
            }
            case 9: {
                if (s2 == 6) {
                    return f * 0.7086614f;
                }
                if (s2 == 4) {
                    return f / 101.6f;
                }
                if (s2 == 3) {
                    return f * 0.9448819f;
                }
                if (s2 == 5) {
                    return f / 16.933332f;
                }
                if (s2 == 8) {
                    return f * 0.25f;
                }
                if (s2 != 7) break;
                return f * 0.025f;
            }
            case 91: {
                if (s2 != 90) break;
                return f * 0.001f;
            }
            case 90: {
                if (s2 != 91) break;
                return f * 1000.0f;
            }
            case 83: {
                if (s2 == 81) {
                    return f * 2.0f * (float)Math.PI;
                }
                if (s2 == 82) {
                    return f * 400.0f;
                }
                if (s2 != 80) break;
                return f * 360.0f;
            }
            case 81: {
                if (s2 == 80) {
                    return (float)Math.toDegrees(f);
                }
                if (s2 == 82) {
                    return f * 63.661976f;
                }
                if (s2 != 83) break;
                return f * 0.15915494f;
            }
            case 80: {
                if (s2 == 81) {
                    return (float)Math.toRadians(f);
                }
                if (s2 == 82) {
                    return f * 1.1111112f;
                }
                if (s2 != 83) break;
                return f / 360.0f;
            }
            case 82: {
                if (s2 == 80) {
                    return f * 0.9f;
                }
                if (s2 == 81) {
                    return f * 0.015707964f;
                }
                if (s2 != 83) break;
                return f * 0.0025f;
            }
            case 0: {
                if (s2 == 80) {
                    return f;
                }
            }
            case 100: {
                if (s2 != 101) break;
                return f * 0.001f;
            }
            case 101: {
                if (s2 != 100) break;
                return f * 1000.0f;
            }
            case 60: {
                if (s2 == 61) {
                    return f / 2.54f;
                }
                if (s2 != 62) break;
                return f / 96.0f;
            }
            case 61: {
                if (s2 == 60) {
                    return f * 2.54f;
                }
                if (s2 != 62) break;
                return f / 37.795277f;
            }
            case 62: {
                if (s2 == 60) {
                    return f * 96.0f;
                }
                if (s2 != 61) break;
                return f * 37.795277f;
            }
            default: {
                if (1 != s2) break;
                return f;
            }
        }
        if ((string2 = CSSUnit.dimensionUnitString(s)).length() == 0) {
            string2 = '<' + Integer.toString(s) + '>';
        }
        try {
            string = CSSUnit.dimensionUnitString(s2);
            if (string.length() == 0) {
                string = "<number>";
            }
        }
        catch (DOMException dOMException) {
            string = '<' + Integer.toString(s2) + '>';
        }
        throw new DOMException(15, "Cannot transform unit " + string2 + " to " + string);
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        switch (cSSValueSyntax.getCategory()) {
            case length: {
                return this.isLengthCompatible() ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case lengthPercentage: {
                return this.isLengthCompatible() || this.getUnitType() == 2 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case percentage: {
                return this.getUnitType() == 2 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case number: {
                return this.getUnitType() == 0 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case integer: {
                return this.getUnitType() == 0 && (this.asInteger || this.isCalculatedNumber()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case angle: {
                return CSSUnit.isAngleUnitType(this.getUnitType()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case time: {
                return CSSUnit.isTimeUnitType(this.getUnitType()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case resolution: {
                return CSSUnit.isResolutionUnitType(this.getUnitType()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case frequency: {
                return this.getUnitType() == 100 || this.getUnitType() == 101 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case flex: {
                return this.getUnitType() == 70 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private boolean isLengthCompatible() {
        return CSSUnit.isLengthUnitType(this.getUnitType()) || this.getUnitType() == 0 && this.isNumberZero();
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = this.getCssValueType().hashCode();
        n2 = 31 * n2 + this.getPrimitiveType().hashCode();
        short s = this.realvalue != 0.0f ? this.getUnitType() : (short)0;
        n2 = 31 * n2 + s;
        n2 = 31 * n2 + Float.floatToIntBits(this.realvalue);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NumberValue)) {
            return false;
        }
        NumberValue numberValue = (NumberValue)object;
        if (Float.floatToIntBits(this.realvalue) != Float.floatToIntBits(numberValue.realvalue)) {
            return false;
        }
        return this.getUnitType() == numberValue.getUnitType() || this.realvalue == 0.0f;
    }

    @Override
    public NumberValue clone() {
        return new NumberValue(this);
    }

    NumberValue immutable() {
        return new ImmutableCSSNumberValue(this);
    }

    private static int fractionDigits(short s) {
        switch (s) {
            case 0: 
            case 81: {
                return 3;
            }
            case 7: 
            case 83: 
            case 101: {
                return 4;
            }
        }
        return 2;
    }

    public static NumberValue createCSSNumberValue(short s, float f) {
        NumberValue numberValue = s != 2 ? new NumberValue() : new PercentageValue();
        numberValue.setFloatValue(s, f);
        return numberValue;
    }

    private static class ImmutableCSSNumberValue
    extends NumberValue {
        private static final long serialVersionUID = 1L;

        ImmutableCSSNumberValue(NumberValue numberValue) {
            super(numberValue);
        }

        @Override
        public void setFloatValue(short s, float f) throws DOMException {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setFloatValuePt(float f) {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setIntegerValue(int n) {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public NumberValue clone() {
            return this;
        }
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(NumberValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            super.setLexicalUnit(lexicalUnit);
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
            switch (lexicalUnit.getLexicalUnitType()) {
                case INTEGER: {
                    NumberValue.this.realvalue = lexicalUnit.getIntegerValue();
                    NumberValue.this.asInteger = true;
                    NumberValue.this.setUnitType((short)0);
                    break;
                }
                default: {
                    NumberValue.this.realvalue = lexicalUnit.getFloatValue();
                    NumberValue.this.asInteger = false;
                    NumberValue.this.dimensionUnitText = lexicalUnit.getDimensionUnitText();
                    NumberValue.this.setUnitType(lexicalUnit.getCssUnit());
                }
            }
        }
    }
}

