/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSLexicalValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.impl.AttrUtil;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.MathFunctionHelper;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class LexicalValue
extends ProxyValue
implements CSSLexicalValue {
    private static final long serialVersionUID = 1L;
    private LexicalUnit lexicalUnit;

    public LexicalValue() {
        super(CSSValue.Type.LEXICAL);
    }

    protected LexicalValue(LexicalValue lexicalValue) {
        super(lexicalValue);
        this.lexicalUnit = lexicalValue.lexicalUnit;
    }

    @Override
    public LexicalUnit getLexicalUnit() {
        return this.lexicalUnit;
    }

    public void setLexicalUnit(LexicalUnit lexicalUnit) {
        this.lexicalUnit = lexicalUnit;
    }

    @Override
    public CSSValue.Type getFinalType() {
        CSSValue.Type type;
        LexicalUnit lexicalUnit = this.lexicalUnit.getNextLexicalUnit();
        if (lexicalUnit != null) {
            if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH && this.isRatioCompUnit(this.lexicalUnit.getLexicalUnitType()) && (lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null && this.isRatioCompUnit(lexicalUnit.getLexicalUnitType())) {
                return CSSValue.Type.RATIO;
            }
            return CSSValue.Type.UNKNOWN;
        }
        switch (this.lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                type = CSSValue.Type.IDENT;
                break;
            }
            case ATTR: {
                type = LexicalValue.finalAttrType(this.lexicalUnit);
                break;
            }
            case STRING: {
                type = CSSValue.Type.STRING;
                break;
            }
            case URI: {
                type = CSSValue.Type.URI;
                break;
            }
            case DIMENSION: 
            case PERCENTAGE: 
            case REAL: 
            case INTEGER: {
                type = CSSValue.Type.NUMERIC;
                break;
            }
            case RGBCOLOR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: {
                type = CSSValue.Type.COLOR;
                break;
            }
            case CALC: {
                type = CSSValue.Type.EXPRESSION;
                break;
            }
            case FUNCTION: {
                String string = this.lexicalUnit.getFunctionName().toLowerCase(Locale.ROOT);
                if (string.endsWith("linear-gradient") || string.endsWith("radial-gradient") || string.endsWith("conic-gradient")) {
                    type = CSSValue.Type.GRADIENT;
                    break;
                }
                if ("env".equals(string)) {
                    type = CSSValue.Type.ENV;
                    break;
                }
                if (MathFunctionHelper.getMathFunction(string) != null) {
                    type = CSSValue.Type.MATH_FUNCTION;
                    break;
                }
                type = CSSValue.Type.FUNCTION;
                break;
            }
            case COLOR_MIX: {
                type = CSSValue.Type.COLOR_MIX;
                break;
            }
            case CUBIC_BEZIER_FUNCTION: {
                type = CSSValue.Type.CUBIC_BEZIER;
                break;
            }
            case STEPS_FUNCTION: {
                type = CSSValue.Type.STEPS;
                break;
            }
            case UNICODE_RANGE: {
                type = CSSValue.Type.UNICODE_RANGE;
                break;
            }
            case UNICODE_WILDCARD: {
                type = CSSValue.Type.UNICODE_WILDCARD;
                break;
            }
            case RECT_FUNCTION: {
                type = CSSValue.Type.RECT;
                break;
            }
            case COUNTER_FUNCTION: {
                type = CSSValue.Type.COUNTER;
                break;
            }
            case COUNTERS_FUNCTION: {
                type = CSSValue.Type.COUNTERS;
                break;
            }
            case ELEMENT_REFERENCE: {
                type = CSSValue.Type.ELEMENT_REFERENCE;
                break;
            }
            default: {
                type = CSSValue.Type.UNKNOWN;
            }
        }
        return type;
    }

    private boolean isRatioCompUnit(LexicalUnit.LexicalType lexicalType) {
        return lexicalType == LexicalUnit.LexicalType.INTEGER || lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.CALC || lexicalType == LexicalUnit.LexicalType.FUNCTION;
    }

    private static CSSValue.Type finalAttrType(LexicalUnit lexicalUnit) {
        String string;
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
        if (lexicalUnit2 == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
            return CSSValue.Type.UNKNOWN;
        }
        if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
            return CSSValue.Type.STRING;
        }
        LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
        if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
            string = "string";
        } else {
            if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                string = lexicalUnit2.getStringValue().toLowerCase(Locale.ROOT);
            } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_MOD) {
                string = "percentage";
            } else {
                return CSSValue.Type.UNKNOWN;
            }
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 == null) {
                return LexicalValue.attrTypeToCSSOMType(string);
            }
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                return CSSValue.Type.UNKNOWN;
            }
        }
        LexicalUnit lexicalUnit3 = lexicalUnit2.getNextLexicalUnit();
        if (lexicalUnit3 == null) {
            return CSSValue.Type.UNKNOWN;
        }
        if (!AttrUtil.unitFitsAttrType(lexicalUnit3, string)) {
            return CSSValue.Type.UNKNOWN;
        }
        return LexicalValue.attrTypeToCSSOMType(string);
    }

    private static CSSValue.Type attrTypeToCSSOMType(String string) {
        CSSValue.Type type;
        switch (string) {
            case "string": {
                type = CSSValue.Type.STRING;
                break;
            }
            case "url": {
                type = CSSValue.Type.URI;
                break;
            }
            case "ident": {
                type = CSSValue.Type.IDENT;
                break;
            }
            case "color": {
                type = CSSValue.Type.COLOR;
                break;
            }
            case "number": 
            case "percentage": 
            case "length": 
            case "angle": 
            case "time": 
            case "frequency": 
            case "flex": {
                type = CSSValue.Type.NUMERIC;
                break;
            }
            default: {
                type = ParseHelper.unitFromString(string.intern()) != 1 ? CSSValue.Type.NUMERIC : CSSValue.Type.UNKNOWN;
            }
        }
        return type;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        return this.lexicalUnit.matches(cSSValueSyntax);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax cSSValueSyntax2 = cSSValueSyntax.shallowClone();
        return this.lexicalUnit.matches(cSSValueSyntax2);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.checkModifiableProperty();
        CSSOMParser cSSOMParser = new CSSOMParser();
        try {
            this.lexicalUnit = cSSOMParser.parsePropertyValue(new StringReader(string));
        }
        catch (CSSException | IOException exception) {
            DOMException dOMException = new DOMException(12, exception.getMessage());
            dOMException.initCause(exception);
            throw dOMException;
        }
    }

    @Override
    public String getCssText() {
        return this.lexicalUnit.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.getCssText());
    }

    @Override
    public String getMinifiedCssText(String string) {
        return LexicalValue.serializeMinifiedSequence(this.lexicalUnit);
    }

    public static String serializeMinifiedSequence(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getNextLexicalUnit() == null) {
            return LexicalValue.serializeMinified(lexicalUnit).toString();
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        boolean bl = false;
        for (LexicalUnit lexicalUnit2 = lexicalUnit; lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            switch (lexicalUnit2.getLexicalUnitType()) {
                case OPERATOR_EXP: 
                case OPERATOR_GE: 
                case OPERATOR_GT: 
                case OPERATOR_LE: 
                case OPERATOR_LT: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_SLASH: 
                case OPERATOR_TILDE: 
                case LEFT_BRACKET: 
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: {
                    bl = false;
                    break;
                }
                case RIGHT_BRACKET: {
                    bl = true;
                    break;
                }
                default: {
                    if (bl) {
                        stringBuilder.append(' ');
                        break;
                    }
                    bl = true;
                }
            }
            stringBuilder.append(LexicalValue.serializeMinified(lexicalUnit2));
        }
        return stringBuilder.toString();
    }

    private static CharSequence serializeMinified(LexicalUnit lexicalUnit) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case RGBCOLOR: {
                String string = lexicalUnit.getCssText();
                if (string.length() < 10) {
                    return string;
                }
            }
            case ATTR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case CALC: 
            case FUNCTION: 
            case COLOR_MIX: 
            case CUBIC_BEZIER_FUNCTION: 
            case STEPS_FUNCTION: 
            case RECT_FUNCTION: 
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: 
            case VAR: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(lexicalUnit.getFunctionName()).append('(');
                LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
                if (lexicalUnit2 != null) {
                    stringBuilder.append(LexicalValue.serializeMinifiedSequence(lexicalUnit2));
                }
                stringBuilder.append(')');
                return stringBuilder;
            }
            case SUB_EXPRESSION: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                LexicalUnit lexicalUnit3 = lexicalUnit.getSubValues();
                if (lexicalUnit3 != null) {
                    stringBuilder.append(LexicalValue.serializeMinifiedSequence(lexicalUnit3));
                }
                stringBuilder.append(')');
                return stringBuilder;
            }
            case URI: {
                LexicalUnit lexicalUnit4 = lexicalUnit.getParameters();
                if (lexicalUnit4 == null) break;
                CharSequence charSequence = LexicalValue.serializeMinified(lexicalUnit4);
                StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 5);
                stringBuilder.append("url(");
                stringBuilder.append(charSequence);
                stringBuilder.append(')');
                return stringBuilder;
            }
        }
        return lexicalUnit.getCssText();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LexicalValue lexicalValue = (LexicalValue)object;
        return this.getCssText().equals(lexicalValue.getCssText());
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.getCssText().hashCode();
        return n2;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public LexicalValue clone() {
        return new LexicalValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(LexicalValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            LexicalValue.this.lexicalUnit = lexicalUnit;
        }
    }
}

