/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.BaseProfiledColor;
import io.sf.carte.doc.style.css.property.ColorSpaceHelper;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.DOMException;

class ColorFunction
extends ColorValue {
    private static final long serialVersionUID = 1L;
    private BaseColor color;

    ColorFunction() {
    }

    ColorFunction(BaseColor baseColor) {
        this.color = baseColor;
    }

    ColorFunction(ColorFunction colorFunction) {
        super(colorFunction);
        this.color = colorFunction.color.clone();
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        ColorValue colorValue = (ColorValue)styleValue;
        this.color.set((BaseColor)colorValue.getColor());
    }

    @Override
    public String getCssText() {
        return this.color.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.color.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        int n = this.color.getLength();
        simpleWriter.write((CharSequence)"color(");
        simpleWriter.write((CharSequence)this.color.getColorSpace());
        for (int i = 1; i < n; ++i) {
            simpleWriter.write(' ');
            this.color.item(i).writeCssText(simpleWriter);
        }
        if (this.color.isNonOpaque()) {
            simpleWriter.write((CharSequence)" / ");
            this.color.appendAlphaChannel(simpleWriter);
        }
        simpleWriter.write(')');
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.color.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.color.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean bl) throws DOMException {
        if (!this.color.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        switch (this.color.getSpace()) {
            case sRGB: {
                return (RGBColor)this.color;
            }
            case CIE_XYZ: 
            case CIE_XYZ_D50: {
                return ((XYZColorImpl)this.color).toSRGBColor(bl);
            }
        }
        if (this.getColorModel() == CSSColorValue.ColorModel.RGB) {
            return ((ProfiledRGBColor)this.color).toSRGBColor(bl);
        }
        throw new DOMException(9, "Custom color profile is not supported.");
    }

    @Override
    public CSSColor getColor() {
        return this.color;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.color.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        BaseColor baseColor;
        LABColor lABColor;
        if (!this.color.hasConvertibleComponents() || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (cSSColorValue.getColorModel()) {
            case LAB: {
                lABColor = (LABColor)cSSColorValue.getColor();
                break;
            }
            case LCH: {
                lABColor = cSSColorValue.toLABColorValue().getColor();
                break;
            }
            case RGB: {
                baseColor = (RGBColor)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                baseColor.toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            case XYZ: {
                XYZColorImpl xYZColorImpl = (XYZColorImpl)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xYZColorImpl.toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            default: {
                RGBAColor rGBAColor = cSSColorValue.toRGBColor(false);
                CSSColorValue cSSColorValue2 = rGBAColor.packInValue();
                lABColor = cSSColorValue2.toLABColorValue().getColor();
            }
        }
        baseColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
        switch (this.color.getColorModel()) {
            case RGB: {
                ((ProfiledRGBColor)this.color).toLABColor((LABColorImpl)baseColor);
                break;
            }
            case XYZ: {
                ((XYZColorImpl)this.color).toLABColor((LABColorImpl)baseColor);
                break;
            }
            default: {
                throw new DOMException(9, "Color space is not supported.");
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)((Object)((LABColorImpl)baseColor).getLightness())).getFloatValue((short)0), ((CSSTypedValue)((Object)((LABColorImpl)baseColor).getA())).getFloatValue((short)0), ((CSSTypedValue)((Object)((LABColorImpl)baseColor).getB())).getFloatValue((short)0), ((CSSTypedValue)lABColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getA()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private static void checkComponentValidity(PrimitiveValue primitiveValue, LexicalUnit lexicalUnit) throws DOMException {
        if (!(ColorFunction.isComponentUnit(primitiveValue.getUnitType()) || primitiveValue.getCssValueType() == CSSValue.CssType.TYPED && (primitiveValue.getPrimitiveType() == CSSValue.Type.EXPRESSION || primitiveValue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)primitiveValue).getStringValue())))) {
            throw new DOMException(17, "Type not compatible with a color component: " + (lexicalUnit != null ? lexicalUnit.getCssText() : primitiveValue.getCssText()));
        }
    }

    private static boolean isComponentUnit(short s) {
        return s == 0 || s == 2;
    }

    private void setComponents(List<PrimitiveValue> list) {
        PrimitiveValue primitiveValue;
        int n;
        int n2 = this.color.getLength() - 1;
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            primitiveValue = list.get(n);
            primitiveValue = ColorFunction.enforceColorComponentType(primitiveValue);
            this.color.setComponent(n + 1, primitiveValue);
        }
        for (n = n3; n < n2; ++n) {
            primitiveValue = NumberValue.createCSSNumberValue((short)0, 0.0f);
            primitiveValue.setSubproperty(true);
            this.color.setComponent(n + 1, primitiveValue);
        }
    }

    static PrimitiveValue enforceColorComponentType(PrimitiveValue primitiveValue) throws DOMException {
        if (primitiveValue.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            PercentageEvaluator percentageEvaluator = new PercentageEvaluator();
            primitiveValue = percentageEvaluator.evaluateExpression((ExpressionValue)primitiveValue);
            ColorFunction.setMaximumPrecision(primitiveValue);
        } else if (primitiveValue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            PercentageEvaluator percentageEvaluator = new PercentageEvaluator();
            primitiveValue = percentageEvaluator.evaluateFunction((CSSMathFunctionValue)((Object)primitiveValue));
            ColorFunction.setMaximumPrecision(primitiveValue);
        }
        ColorFunction.checkComponentValidity(primitiveValue, null);
        return primitiveValue;
    }

    private static void setMaximumPrecision(PrimitiveValue primitiveValue) {
        short s = primitiveValue.getUnitType();
        if (s == 0) {
            ((NumberValue)primitiveValue).setMaximumFractionDigits(6);
        } else if (s == 2) {
            ((NumberValue)primitiveValue).setMaximumFractionDigits(3);
        }
    }

    @Override
    public LABColorValue toLABColorValue() {
        LABColorValue lABColorValue = new LABColorValue();
        LABColorImpl lABColorImpl = (LABColorImpl)lABColorValue.getColor();
        switch (this.color.getColorModel()) {
            case RGB: {
                ((ProfiledRGBColor)this.color).toLABColor(lABColorImpl);
                break;
            }
            case XYZ: {
                ((XYZColorImpl)this.color).toLABColor(lABColorImpl);
                break;
            }
            default: {
                throw new DOMException(9, "Custom profiles are not suported.");
            }
        }
        return lABColorValue;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(this.color);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColorFunction colorFunction = (ColorFunction)object;
        return Objects.equals(this.color, colorFunction.color);
    }

    @Override
    public ColorFunction clone() {
        return new ColorFunction(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(ColorFunction.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) throws DOMException {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.COLOR_FUNCTION) {
                    throw new IllegalStateException("No color() value: " + lexicalUnit.toString());
                }
                this.setLexical(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                DOMException dOMException = new DOMException(12, "Wrong value: " + lexicalUnit.toString());
                dOMException.initCause(runtimeException);
                throw dOMException;
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setLexical(LexicalUnit lexicalUnit) throws DOMException {
            PrimitiveValue primitiveValue;
            String string;
            ArrayList<PrimitiveValue> arrayList;
            block6: {
                LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
                ValueFactory valueFactory = new ValueFactory();
                arrayList = new ArrayList<PrimitiveValue>(5);
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                    this.checkProxyValue(lexicalUnit2);
                    throw new DOMException(17, "Color space must be identifier: " + lexicalUnit.toString());
                }
                string = lexicalUnit2.getStringValue();
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                    throw new DOMException(12, "Wrong value: " + lexicalUnit.toString());
                }
                primitiveValue = null;
                do {
                    PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                    ColorFunction.checkComponentValidity(primitiveValue2, lexicalUnit);
                    arrayList.add(primitiveValue2);
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 == null) break block6;
                } while (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    throw new DOMException(12, "Wrong value: " + lexicalUnit.toString());
                }
            }
            ColorFunction.this.color = ColorSpaceHelper.createProfiledColor(string);
            if (ColorFunction.this.color == null) {
                if (!string.startsWith("--")) throw new DOMException(9, "Unsupported color space: " + string);
                PrimitiveValue[] primitiveValueArray = arrayList.toArray(new PrimitiveValue[0]);
                ColorFunction.this.color = new BaseProfiledColor(string, primitiveValueArray);
            } else {
                ColorFunction.this.setComponents(arrayList);
            }
            if (primitiveValue == null) return;
            ColorFunction.this.color.setAlpha(primitiveValue);
        }
    }
}

