/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.MediaQuery;
import io.sf.carte.doc.style.css.MediaQueryHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.MediaQueryListListener;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.parser.AbstractMediaQuery;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.NSACMediaQueryFactory;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class NSACMediaQueryList
implements MediaQueryList {
    private final LinkedList<NSACMediaQuery> queryList = new LinkedList();
    private LinkedList<CSSParseException> queryErrorList = null;
    boolean invalidQueryList = false;

    NSACMediaQueryList() {
    }

    @Override
    public String getMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.queryList.iterator();
        stringBuilder.append(((NSACMediaQuery)iterator.next()).getMedia());
        while (iterator.hasNext()) {
            stringBuilder.append(',').append(((NSACMediaQuery)iterator.next()).getMedia());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMinifiedMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.queryList.iterator();
        stringBuilder.append(((NSACMediaQuery)iterator.next()).getMinifiedMedia());
        while (iterator.hasNext()) {
            stringBuilder.append(',').append(((NSACMediaQuery)iterator.next()).getMinifiedMedia());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMediaText() {
        return this.getMedia();
    }

    @Override
    public void setMediaText(String string) throws DOMException {
        this.queryList.clear();
        this.parse(string, null);
    }

    @Override
    public int getLength() {
        int n = this.queryList.size();
        if (n == 0 && this.invalidQueryList) {
            return 1;
        }
        return n;
    }

    @Override
    public String item(int n) {
        int n2 = this.queryList.size();
        if (n2 == 0 && this.invalidQueryList && n == 0) {
            return "not all";
        }
        if (n < 0 || n >= n2) {
            return null;
        }
        return this.queryList.get(n).getMedia();
    }

    @Override
    public MediaQuery getMediaQuery(int n) {
        int n2 = this.queryList.size();
        if (n < 0 || n >= n2 || this.invalidQueryList) {
            return null;
        }
        return this.queryList.get(n);
    }

    @Override
    public void appendMedium(String string) throws DOMException {
        throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
    }

    @Override
    public void deleteMedium(String string) throws DOMException {
        throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
    }

    @Override
    public boolean matches(String string, CSSCanvas cSSCanvas) {
        for (NSACMediaQuery nSACMediaQuery : this.queryList) {
            if (!nSACMediaQuery.matches(string, cSSCanvas)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MediaQueryList mediaQueryList) {
        if (mediaQueryList == null) {
            return !this.isNotAllMedia();
        }
        if (mediaQueryList.isNotAllMedia()) {
            return false;
        }
        if (this.isAllMedia()) {
            return true;
        }
        if (mediaQueryList.isAllMedia()) {
            return false;
        }
        if (mediaQueryList.getClass() != NSACMediaQueryList.class) {
            return this.oldMatch(mediaQueryList);
        }
        NSACMediaQueryList nSACMediaQueryList = (NSACMediaQueryList)mediaQueryList;
        HashSet<NSACMediaQuery> hashSet = new HashSet<NSACMediaQuery>(nSACMediaQueryList.queryList.size());
        hashSet.addAll(nSACMediaQueryList.queryList);
        for (NSACMediaQuery nSACMediaQuery : this.queryList) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                NSACMediaQuery nSACMediaQuery2 = (NSACMediaQuery)iterator.next();
                if (!nSACMediaQuery.matches(nSACMediaQuery2)) continue;
                iterator.remove();
            }
            if (!hashSet.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean oldMatch(MediaQueryList mediaQueryList) {
        int n;
        int n2 = this.getLength();
        HashSet<String> hashSet = new HashSet<String>(n2);
        for (n = 0; n < n2; ++n) {
            String string = this.item(n).toLowerCase(Locale.ROOT);
            hashSet.add(string);
        }
        n = mediaQueryList.getLength();
        for (int i = 0; i < n; ++i) {
            String string = mediaQueryList.item(i).toLowerCase(Locale.ROOT);
            if (!hashSet.contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(MediaQueryListListener mediaQueryListListener) throws DOMException {
        throw new DOMException(9, "You should use CSSCanvas for this");
    }

    @Override
    public void removeListener(MediaQueryListListener mediaQueryListListener) throws DOMException {
        throw new DOMException(9, "You should use CSSCanvas for this");
    }

    @Override
    public boolean isAllMedia() {
        return this.queryList.isEmpty() && !this.invalidQueryList;
    }

    @Override
    public boolean isNotAllMedia() {
        return this.invalidQueryList || this.queryList.size() == 1 && this.queryList.get(0).isNotAllMedia();
    }

    @Override
    public boolean hasErrors() {
        return this.invalidQueryList || this.queryErrorList != null;
    }

    public LinkedList<CSSParseException> getExceptions() {
        return this.queryErrorList;
    }

    public int hashCode() {
        int n = 1;
        if (this.queryList != null) {
            for (MediaQuery mediaQuery : this.queryList) {
                n += mediaQuery.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NSACMediaQueryList nSACMediaQueryList = (NSACMediaQueryList)object;
        return !(this.queryList == null ? nSACMediaQueryList.queryList != null : this.queryList.size() != nSACMediaQueryList.queryList.size() || !this.queryList.containsAll(nSACMediaQueryList.queryList));
    }

    public String toString() {
        return this.getMedia();
    }

    boolean parse(String string, Node node) {
        CSSParser cSSParser = new CSSParser();
        return this.parse(cSSParser, string, node);
    }

    boolean parse(Parser parser, String string, Node node) throws CSSBudgetException {
        this.invalidQueryList = false;
        MyMediaQueryHandler myMediaQueryHandler = new MyMediaQueryHandler(node);
        parser.parseMediaQueryList(string, new NSACMediaQueryFactory(), myMediaQueryHandler);
        return !this.invalidQueryList;
    }

    class MyMediaQueryHandler
    implements MediaQueryHandler {
        private NSACMediaQuery currentQuery;
        private boolean invalidQuery = false;
        private boolean compatQuery = false;
        private boolean allMedia = false;
        private final Node ownerNode;

        MyMediaQueryHandler(Node node) {
            this.ownerNode = node;
        }

        @Override
        public void startQuery() {
            this.currentQuery = new NSACMediaQuery();
        }

        @Override
        public void mediaType(String string) {
            String string2;
            try {
                string2 = ParseHelper.unescapeStringValue(string, false, false);
            }
            catch (DOMNullCharacterException dOMNullCharacterException) {
                string2 = string;
            }
            this.currentQuery.setMediaType(string2);
        }

        @Override
        public void negativeQuery() {
            this.currentQuery.setNegative(true);
        }

        @Override
        public void onlyPrefix() {
            this.currentQuery.setOnlyPrefix(true);
        }

        @Override
        public void condition(BooleanCondition booleanCondition) {
            this.currentQuery.setFeaturePredicate(booleanCondition);
        }

        @Override
        public void endQuery() {
            if (!this.invalidQuery) {
                if (!this.currentQuery.isNotAllMedia() || !this.containsNotAll()) {
                    NSACMediaQueryList.this.queryList.add(this.currentQuery);
                }
                if (NSACMediaQueryList.this.invalidQueryList && !this.compatQuery) {
                    NSACMediaQueryList.this.invalidQueryList = false;
                }
                if (this.currentQuery.isAllMedia()) {
                    this.allMedia = true;
                }
            }
            this.currentQuery = null;
            this.invalidQuery = false;
            this.compatQuery = false;
        }

        private boolean containsNotAll() {
            for (NSACMediaQuery nSACMediaQuery : NSACMediaQueryList.this.queryList) {
                if (!nSACMediaQuery.isNotAllMedia()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endQueryList() {
            if (this.allMedia) {
                NSACMediaQueryList.this.queryList.clear();
            }
        }

        @Override
        public boolean reportsErrors() {
            return this.ownerNode != null;
        }

        @Override
        public MediaQueryList getMediaQueryList() {
            return NSACMediaQueryList.this;
        }

        @Override
        public void invalidQuery(CSSParseException cSSParseException) {
            this.invalidQuery = true;
            NSACMediaQueryList.this.invalidQueryList = true;
            if (NSACMediaQueryList.this.queryErrorList == null) {
                NSACMediaQueryList.this.queryErrorList = new LinkedList();
            }
            NSACMediaQueryList.this.queryErrorList.add(cSSParseException);
            if (this.ownerNode != null) {
                CSSMediaException cSSMediaException = new CSSMediaException(cSSParseException);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryError(this.ownerNode, cSSMediaException);
            }
        }

        @Override
        public void compatQuery(CSSParseException cSSParseException) {
            NSACMediaQueryList.this.invalidQueryList = true;
            this.compatQuery = true;
            if (NSACMediaQueryList.this.queryErrorList == null) {
                NSACMediaQueryList.this.queryErrorList = new LinkedList();
            }
            NSACMediaQueryList.this.queryErrorList.add(cSSParseException);
            if (this.ownerNode != null) {
                CSSMediaException cSSMediaException = new CSSMediaException(cSSParseException);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryWarning(this.ownerNode, cSSMediaException);
            }
        }
    }

    private class NSACMediaQuery
    extends AbstractMediaQuery {
        private static final long serialVersionUID = 1L;

        private NSACMediaQuery() {
        }

        @Override
        protected boolean matchesPredicate(BooleanCondition booleanCondition, CSSCanvas cSSCanvas) {
            return true;
        }

        @Override
        protected byte matches(BooleanCondition booleanCondition, BooleanCondition booleanCondition2, byte by) {
            return 2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            return object instanceof MediaQuery && this.getMedia().equals(((MediaQuery)object).getMedia());
        }
    }
}

