/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.MediaFeature;
import io.sf.carte.doc.style.css.om.MediaPredicate;
import io.sf.carte.doc.style.css.om.MediaQueryImpl;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RatioValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Objects;
import org.w3c.dom.DOMException;

class MediaFeaturePredicateImpl
extends MediaPredicate
implements MediaFeature {
    private static final long serialVersionUID = 1L;
    private CSSTypedValue value1 = null;
    private CSSTypedValue value2 = null;
    private byte rangeType;

    MediaFeaturePredicateImpl(String string) {
        super(string);
    }

    @Override
    public int getPredicateType() {
        return 1;
    }

    @Override
    public void setRangeType(byte by) {
        this.rangeType = by;
    }

    @Override
    public byte getRangeType() {
        return this.rangeType;
    }

    @Override
    public CSSTypedValue getValue() {
        return this.value1;
    }

    @Override
    public void setValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit != null) {
            StyleValue styleValue = new ValueFactory().createCSSValue(lexicalUnit);
            if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                throw new DOMException(17, "Expected typed value, got: " + (Object)((Object)styleValue.getCssValueType()));
            }
            this.value1 = (CSSTypedValue)((Object)styleValue);
        } else {
            this.value1 = null;
        }
    }

    @Override
    public CSSTypedValue getRangeSecondValue() {
        return this.value2;
    }

    @Override
    public void setValueRange(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        StyleValue styleValue = new ValueFactory().createCSSValue(lexicalUnit);
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new DOMException(17, "Expected typed value, got: " + (Object)((Object)styleValue.getCssValueType()));
        }
        this.value1 = (CSSTypedValue)((Object)styleValue);
        styleValue = new ValueFactory().createCSSValue(lexicalUnit2);
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new DOMException(17, "Expected typed value, got: " + (Object)((Object)styleValue.getCssValueType()));
        }
        this.value2 = (CSSTypedValue)((Object)styleValue);
    }

    @Override
    public boolean matches(MediaPredicate mediaPredicate, byte by) {
        float f;
        PrimitiveValue primitiveValue;
        PrimitiveValue primitiveValue2;
        float f2;
        if (this.getPredicateType() != mediaPredicate.getPredicateType()) {
            return false;
        }
        MediaFeaturePredicateImpl mediaFeaturePredicateImpl = (MediaFeaturePredicateImpl)mediaPredicate;
        String string = this.getName();
        String string2 = mediaFeaturePredicateImpl.getName();
        byte by2 = this.getRangeType();
        byte by3 = mediaFeaturePredicateImpl.getRangeType();
        if (by2 == 0) {
            if (string.startsWith("min-")) {
                if ((string = string.substring(4)).startsWith("device-")) {
                    string = string.substring(7);
                }
                by2 = 5;
            } else if (string.startsWith("max-")) {
                if ((string = string.substring(4)).startsWith("device-")) {
                    string = string.substring(7);
                }
                by2 = 3;
            } else {
                if (string.startsWith("device-")) {
                    string = string.substring(7);
                }
                by2 = this.value1 != null ? (byte)1 : 4;
            }
        }
        if (by3 == 0) {
            if (string2.startsWith("min-")) {
                if ((string2 = string2.substring(4)).startsWith("device-")) {
                    string2 = string2.substring(7);
                }
                by3 = 5;
            } else if (string2.startsWith("max-")) {
                if ((string2 = string2.substring(4)).startsWith("device-")) {
                    string2 = string2.substring(7);
                }
                by3 = 3;
            } else {
                if (string2.startsWith("device-")) {
                    string2 = string2.substring(7);
                }
                by3 = mediaFeaturePredicateImpl.value1 != null ? (byte)1 : 4;
            }
        }
        if (!string.equals(string2)) {
            return false;
        }
        if (by == 2) {
            by3 = MediaFeaturePredicateImpl.negateType(by3);
        } else if (by == 1) {
            by2 = MediaFeaturePredicateImpl.negateType(by2);
        }
        CSSTypedValue cSSTypedValue = mediaFeaturePredicateImpl.value1;
        CSSTypedValue cSSTypedValue2 = mediaFeaturePredicateImpl.value2;
        boolean bl = false;
        boolean bl2 = false;
        switch (by2) {
            case 1: {
                if (this.value1.getPrimitiveType() != CSSValue.Type.IDENT) break;
                if (cSSTypedValue != null && cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT && this.value1.getStringValue().equalsIgnoreCase(cSSTypedValue.getStringValue())) {
                    return by == 0 || by == 3;
                }
                return by == 1;
            }
            case 2: {
                if (by3 == 3) {
                    by3 = 2;
                    bl = true;
                    break;
                }
                if (by3 == 1) {
                    by3 = 2;
                    bl = true;
                    break;
                }
                if (by3 == 36 || by3 == 44) {
                    by3 = 2;
                    break;
                }
                if (by3 == 37 || by3 == 45) {
                    by3 = 2;
                    bl = true;
                    break;
                }
                if (by3 == 19 || by3 == 18) {
                    by3 = 2;
                    cSSTypedValue = cSSTypedValue2;
                    break;
                }
                if (by3 != 27 && by3 != 26) break;
                by3 = 2;
                bl = true;
                cSSTypedValue = cSSTypedValue2;
                break;
            }
            case 3: {
                if (by3 == 2) {
                    by2 = 2;
                    break;
                }
                if (by3 == 1) {
                    by3 = 3;
                    break;
                }
                if (by3 == 36 || by3 == 44) {
                    by2 = 2;
                    by3 = 2;
                    break;
                }
                if (by3 == 37 || by3 == 45) {
                    by3 = 3;
                    break;
                }
                if (by3 == 19 || by3 == 18) {
                    by2 = 2;
                    by3 = 2;
                    cSSTypedValue = cSSTypedValue2;
                    break;
                }
                if (by3 != 27 && by3 != 26) break;
                by3 = 3;
                cSSTypedValue = cSSTypedValue2;
                break;
            }
            case 4: {
                if (by3 == 5) {
                    by3 = 4;
                    bl = true;
                    break;
                }
                if (by3 == 1) {
                    by3 = 4;
                    bl = true;
                    break;
                }
                if (by3 == 18 || by3 == 26) {
                    by3 = 4;
                    break;
                }
                if (by3 == 19 || by3 == 27) {
                    by3 = 4;
                    bl = true;
                    break;
                }
                if (by3 == 37 || by3 == 36) {
                    by3 = 4;
                    cSSTypedValue = cSSTypedValue2;
                    break;
                }
                if (by3 != 45 && by3 != 44) break;
                by3 = 4;
                bl = true;
                cSSTypedValue = cSSTypedValue2;
                break;
            }
            case 5: {
                if (by3 == 4) {
                    by2 = 4;
                    break;
                }
                if (by3 == 1) {
                    by3 = 5;
                    break;
                }
                if (by3 == 18 || by3 == 26) {
                    by2 = 4;
                    by3 = 4;
                    break;
                }
                if (by3 == 19 || by3 == 27) {
                    by2 = 4;
                    by3 = 4;
                    break;
                }
                if (by3 == 37 || by3 == 36) {
                    by2 = 4;
                    by3 = 4;
                    cSSTypedValue = cSSTypedValue2;
                    break;
                }
                if (by3 != 44 && by3 != 45) break;
                by3 = 5;
                cSSTypedValue = cSSTypedValue2;
                break;
            }
            case 18: {
                if (by3 == 19) {
                    by3 = 18;
                    bl = true;
                    break;
                }
                if (by3 == 26) {
                    by3 = 18;
                    bl2 = true;
                    break;
                }
                if (by3 == 27) {
                    by3 = 18;
                    bl = true;
                    bl2 = true;
                    break;
                }
                if (by3 != 1) break;
                by3 = 18;
                bl = true;
                bl2 = true;
                cSSTypedValue2 = cSSTypedValue;
                break;
            }
            case 19: {
                if (by3 == 18) {
                    by2 = 18;
                    break;
                }
                if (by3 == 27) {
                    by3 = 19;
                    bl2 = true;
                    break;
                }
                if (by3 == 26) {
                    by2 = 18;
                    by3 = 18;
                    bl2 = true;
                    break;
                }
                if (by3 != 1) break;
                by3 = 19;
                bl2 = true;
                cSSTypedValue2 = cSSTypedValue;
                break;
            }
            case 26: {
                if (by3 == 18) {
                    by2 = 18;
                    break;
                }
                if (by3 == 27) {
                    by3 = 26;
                    bl = true;
                    break;
                }
                if (by3 == 19) {
                    by2 = 18;
                    by3 = 18;
                    bl = true;
                    break;
                }
                if (by3 != 1) break;
                by3 = 26;
                bl = true;
                cSSTypedValue2 = cSSTypedValue;
                break;
            }
            case 27: {
                if (by3 == 18) {
                    by2 = 18;
                    break;
                }
                if (by3 == 26) {
                    by2 = 26;
                    break;
                }
                if (by3 == 19) {
                    by2 = 19;
                    break;
                }
                if (by3 != 1) break;
                by3 = 27;
                cSSTypedValue2 = cSSTypedValue;
                break;
            }
            case 36: {
                if (by3 == 37) {
                    by3 = 36;
                    bl = true;
                    break;
                }
                if (by3 == 44) {
                    by3 = 36;
                    bl2 = true;
                    break;
                }
                if (by3 == 45) {
                    by3 = 36;
                    bl = true;
                    bl2 = true;
                    break;
                }
                if (by3 != 1) break;
                by3 = 36;
                bl = true;
                bl2 = true;
                cSSTypedValue2 = cSSTypedValue;
                break;
            }
            case 37: {
                if (by3 == 36) {
                    by2 = 36;
                    break;
                }
                if (by3 == 45) {
                    by3 = 37;
                    bl2 = true;
                    break;
                }
                if (by3 == 44) {
                    by2 = 36;
                    by3 = 36;
                    bl2 = true;
                    break;
                }
                if (by3 != 1) break;
                by3 = 37;
                bl2 = true;
                cSSTypedValue2 = cSSTypedValue;
                break;
            }
            case 44: {
                if (by3 == 36) {
                    by2 = 36;
                    break;
                }
                if (by3 == 45) {
                    by3 = 44;
                    bl = true;
                    break;
                }
                if (by3 == 37) {
                    by2 = 36;
                    by3 = 36;
                    bl = true;
                    break;
                }
                if (by3 != 1) break;
                by3 = 44;
                bl = true;
                cSSTypedValue2 = cSSTypedValue;
                break;
            }
            case 45: {
                if (by3 == 36) {
                    by2 = 36;
                    break;
                }
                if (by3 == 44) {
                    by2 = 44;
                    break;
                }
                if (by3 == 37) {
                    by2 = 37;
                    break;
                }
                if (by3 != 1) break;
                by3 = 45;
                cSSTypedValue2 = cSSTypedValue;
            }
        }
        if (by2 != by3) {
            return false;
        }
        float f3 = 1.0f;
        boolean bl3 = false;
        short s = 0;
        if (this.value1 == null) {
            if (cSSTypedValue == null) {
                boolean bl4 = by == 1 || by == 2;
                return !bl4;
            }
            f2 = 0.0f;
        } else {
            s = this.value1.getUnitType();
            if (this.value1.getPrimitiveType() != CSSValue.Type.RATIO) {
                f2 = this.value1.getFloatValue(s);
            } else {
                RatioValue ratioValue = (RatioValue)this.value1;
                primitiveValue2 = ratioValue.getAntecedentValue();
                primitiveValue = ratioValue.getConsequentValue();
                s = primitiveValue2.getUnitType();
                if (s != 0 || primitiveValue.getUnitType() != 0) {
                    return false;
                }
                try {
                    f2 = ((CSSTypedValue)((Object)primitiveValue2)).getFloatValue(s);
                    f3 = ((CSSTypedValue)((Object)primitiveValue)).getFloatValue(s);
                }
                catch (DOMException dOMException) {
                    return false;
                }
                bl3 = true;
            }
        }
        if (cSSTypedValue == null) {
            f = 0.0f;
        } else {
            if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.RATIO) {
                float f4;
                primitiveValue2 = (RatioValue)cSSTypedValue;
                primitiveValue = ((RatioValue)primitiveValue2).getAntecedentValue();
                PrimitiveValue primitiveValue3 = ((RatioValue)primitiveValue2).getConsequentValue();
                if (primitiveValue.getUnitType() != 0 || primitiveValue3.getUnitType() != 0) {
                    return false;
                }
                try {
                    f = ((CSSTypedValue)((Object)primitiveValue)).getFloatValue(s);
                    f4 = ((CSSTypedValue)((Object)primitiveValue3)).getFloatValue(s);
                }
                catch (DOMException dOMException) {
                    return false;
                }
                f2 *= f4;
            } else {
                try {
                    f = cSSTypedValue.getFloatValue(s);
                }
                catch (DOMException dOMException) {
                    return false;
                }
            }
            if (bl3) {
                f *= f3;
            }
        }
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        if (this.value2 != null) {
            if (cSSTypedValue2 == null) {
                return false;
            }
            boolean bl5 = false;
            s = this.value2.getUnitType();
            if (this.value2.getPrimitiveType() != CSSValue.Type.RATIO) {
                try {
                    f5 = this.value2.getFloatValue(s);
                }
                catch (DOMException dOMException) {
                    return false;
                }
            }
            RatioValue ratioValue = (RatioValue)this.value2;
            PrimitiveValue primitiveValue4 = ratioValue.getAntecedentValue();
            PrimitiveValue primitiveValue5 = ratioValue.getConsequentValue();
            s = primitiveValue4.getUnitType();
            if (s != 0 || primitiveValue5.getUnitType() != 0) {
                return false;
            }
            try {
                f5 = ((CSSTypedValue)((Object)primitiveValue4)).getFloatValue(s);
                f3 = ((CSSTypedValue)((Object)primitiveValue5)).getFloatValue(s);
            }
            catch (DOMException dOMException) {
                return false;
            }
            bl5 = true;
            if (cSSTypedValue2.getPrimitiveType() == CSSValue.Type.RATIO) {
                float f7;
                RatioValue ratioValue2 = (RatioValue)cSSTypedValue2;
                primitiveValue4 = ratioValue2.getAntecedentValue();
                primitiveValue5 = ratioValue2.getConsequentValue();
                if (primitiveValue4.getUnitType() != 0 || primitiveValue5.getUnitType() != 0) {
                    return false;
                }
                try {
                    f6 = ((CSSTypedValue)((Object)primitiveValue4)).getFloatValue(s);
                    f7 = ((CSSTypedValue)((Object)primitiveValue5)).getFloatValue(s);
                }
                catch (DOMException dOMException) {
                    return false;
                }
                f5 *= f7;
            } else {
                try {
                    f6 = cSSTypedValue2.getFloatValue(s);
                }
                catch (DOMException dOMException) {
                    return false;
                }
            }
            if (bl5) {
                f6 *= f3;
            }
        }
        switch (by2) {
            case 1: {
                boolean bl6;
                boolean bl7 = bl6 = by == 1 || by == 2;
                if (MediaQueryImpl.floatEquals(f2, f)) {
                    return !bl6;
                }
                return bl6;
            }
            case 2: 
            case 3: {
                return bl ? f2 > f : f2 >= f;
            }
            case 4: 
            case 5: {
                return bl ? f2 < f : f2 <= f;
            }
            case 18: 
            case 19: 
            case 26: 
            case 27: {
                boolean bl8;
                boolean bl9 = bl ? f2 < f : (bl8 = f2 <= f);
                boolean bl10 = bl2 ? f6 < f5 : f6 <= f5;
                return bl8 && bl10;
            }
            case 36: 
            case 37: 
            case 44: 
            case 45: {
                boolean bl11;
                boolean bl12 = bl ? f2 > f : (bl11 = f2 >= f);
                boolean bl13 = bl2 ? f6 > f5 : f6 >= f5;
                return bl11 && bl13;
            }
        }
        return false;
    }

    private static byte negateType(byte by) {
        switch (by) {
            case 2: {
                by = (byte)5;
                break;
            }
            case 3: {
                by = (byte)4;
                break;
            }
            case 4: {
                by = (byte)3;
                break;
            }
            case 5: {
                by = (byte)2;
                break;
            }
            case 27: {
                by = (byte)36;
                break;
            }
            case 19: {
                by = (byte)44;
                break;
            }
            case 26: {
                by = (byte)37;
                break;
            }
            case 18: {
                by = (byte)45;
                break;
            }
            case 45: {
                by = (byte)18;
                break;
            }
            case 37: {
                by = (byte)26;
                break;
            }
            case 44: {
                by = (byte)19;
                break;
            }
            case 36: {
                by = (byte)27;
            }
        }
        return by;
    }

    @Override
    public void appendText(StringBuilder stringBuilder) {
        stringBuilder.append('(');
        switch (this.rangeType) {
            case 0: 
            case 1: {
                this.appendFeatureName(stringBuilder);
                if (this.value1 == null) break;
                stringBuilder.append(": ");
                stringBuilder.append(this.value1.getCssText());
                break;
            }
            case 2: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" < ");
                stringBuilder.append(this.value1.getCssText());
                break;
            }
            case 3: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" <= ");
                stringBuilder.append(this.value1.getCssText());
                break;
            }
            case 4: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" > ");
                stringBuilder.append(this.value1.getCssText());
                break;
            }
            case 5: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" >= ");
                stringBuilder.append(this.value1.getCssText());
                break;
            }
            case 26: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" < ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" <= ");
                stringBuilder.append(this.value2.getCssText());
                break;
            }
            case 18: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" < ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" < ");
                stringBuilder.append(this.value2.getCssText());
                break;
            }
            case 19: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" <= ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" < ");
                stringBuilder.append(this.value2.getCssText());
                break;
            }
            case 27: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" <= ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" <= ");
                stringBuilder.append(this.value2.getCssText());
                break;
            }
            case 36: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" > ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" > ");
                stringBuilder.append(this.value2.getCssText());
                break;
            }
            case 37: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" >= ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" > ");
                stringBuilder.append(this.value2.getCssText());
                break;
            }
            case 44: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" > ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" >= ");
                stringBuilder.append(this.value2.getCssText());
                break;
            }
            case 45: {
                stringBuilder.append(this.value1.getCssText());
                stringBuilder.append(" >= ");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(" >= ");
                stringBuilder.append(this.value2.getCssText());
            }
        }
        stringBuilder.append(')');
    }

    @Override
    public void appendMinifiedText(StringBuilder stringBuilder) {
        stringBuilder.append('(');
        switch (this.rangeType) {
            case 0: 
            case 1: {
                this.appendFeatureName(stringBuilder);
                if (this.value1 == null) break;
                stringBuilder.append(':');
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 2: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append('<');
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 3: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append("<=");
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 4: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append('>');
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 5: {
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(">=");
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 26: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append('<');
                this.appendFeatureName(stringBuilder);
                stringBuilder.append("<=");
                stringBuilder.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 18: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append('<');
                this.appendFeatureName(stringBuilder);
                stringBuilder.append('<');
                stringBuilder.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 19: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append("<=");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append('<');
                stringBuilder.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 27: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append("<=");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append("<=");
                stringBuilder.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 36: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append('>');
                this.appendFeatureName(stringBuilder);
                stringBuilder.append('>');
                stringBuilder.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 37: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append(">=");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append('>');
                stringBuilder.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 44: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append('>');
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(">=");
                stringBuilder.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 45: {
                stringBuilder.append(this.value1.getMinifiedCssText(""));
                stringBuilder.append(">=");
                this.appendFeatureName(stringBuilder);
                stringBuilder.append(">=");
                stringBuilder.append(this.value2.getMinifiedCssText(""));
            }
        }
        stringBuilder.append(')');
    }

    private void appendFeatureName(StringBuilder stringBuilder) {
        stringBuilder.append(ParseHelper.escape(this.getName()));
    }

    @Override
    public int hashCode() {
        byte by = this.rangeType == 0 ? (byte)1 : this.rangeType;
        return 17 + 31 * Objects.hash(this.getName(), by, this.value1, this.value2);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MediaFeaturePredicateImpl mediaFeaturePredicateImpl = (MediaFeaturePredicateImpl)object;
        byte by = this.rangeType == 0 ? (byte)1 : this.rangeType;
        byte by2 = mediaFeaturePredicateImpl.rangeType == 0 ? (byte)1 : mediaFeaturePredicateImpl.rangeType;
        return Objects.equals(this.getName(), mediaFeaturePredicateImpl.getName()) && by == by2 && Objects.equals(this.value1, mediaFeaturePredicateImpl.value1) && Objects.equals(this.value2, mediaFeaturePredicateImpl.value2);
    }
}

