/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSColorMixFunction;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.DefaultDeclarationFormattingContext;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;

public class ColorDeclarationFormattingContext
extends DefaultDeclarationFormattingContext {
    private static final long serialVersionUID = 1L;

    @Override
    public void writeValue(SimpleWriter simpleWriter, String string, CSSValue cSSValue) throws IOException {
        if (cSSValue.getCssValueType() == CSSValue.CssType.LIST) {
            this.writeList(simpleWriter, string, (ValueList)cSSValue);
            return;
        }
        switch (cSSValue.getPrimitiveType()) {
            case COLOR: {
                this.writeColor(simpleWriter, string, (CSSColorValue)cSSValue);
                break;
            }
            case COLOR_MIX: {
                this.writeColorMix(simpleWriter, string, (CSSColorMixFunction)cSSValue);
                break;
            }
            case FUNCTION: 
            case MATH_FUNCTION: 
            case GRADIENT: {
                this.writeFunction(simpleWriter, string, (CSSFunctionValue)cSSValue);
                break;
            }
            default: {
                super.writeValue(simpleWriter, string, cSSValue);
            }
        }
    }

    private void writeList(SimpleWriter simpleWriter, String string, ValueList valueList) throws IOException {
        if (valueList.isCommaSeparated()) {
            this.writeCSList(simpleWriter, string, valueList);
        } else if (!valueList.isBracketList()) {
            this.writeWSList(simpleWriter, string, valueList);
        } else {
            super.writeValue(simpleWriter, string, valueList);
        }
    }

    private void writeCSList(SimpleWriter simpleWriter, String string, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeValue(simpleWriter, string, valueList.item(0));
            int n = valueList.getLength();
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(',');
                simpleWriter.write(' ');
                this.writeValue(simpleWriter, string, valueList.item(i));
            }
        }
    }

    private void writeWSList(SimpleWriter simpleWriter, String string, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeValue(simpleWriter, string, valueList.item(0));
            int n = valueList.getLength();
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(' ');
                this.writeValue(simpleWriter, string, valueList.item(i));
            }
        }
    }

    protected void writeColor(SimpleWriter simpleWriter, String string, CSSColorValue cSSColorValue) throws IOException {
        cSSColorValue.writeCssText(simpleWriter);
    }

    protected void writeColorMix(SimpleWriter simpleWriter, String string, CSSColorMixFunction cSSColorMixFunction) throws IOException {
        cSSColorMixFunction.writeCssText(simpleWriter);
    }

    private void writeFunction(SimpleWriter simpleWriter, String string, CSSFunctionValue cSSFunctionValue) throws IOException {
        LinkedCSSValueList linkedCSSValueList = cSSFunctionValue.getArguments();
        simpleWriter.write((CharSequence)cSSFunctionValue.getFunctionName());
        simpleWriter.write('(');
        int n = linkedCSSValueList.size();
        if (n == 1) {
            StyleValue styleValue = (StyleValue)linkedCSSValueList.get(0);
            if (styleValue.getPrimitiveType() == CSSValue.Type.EXPRESSION && ((CSSExpressionValue)((Object)styleValue)).getStringValue().length() == 0) {
                ((CSSExpressionValue)((Object)styleValue)).getExpression().writeCssText(simpleWriter);
            } else {
                this.writeValue(simpleWriter, string, styleValue);
            }
        } else if (n != 0) {
            this.writeValue(simpleWriter, string, (CSSValue)linkedCSSValueList.get(0));
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(',');
                simpleWriter.write(' ');
                this.writeValue(simpleWriter, string, (CSSValue)linkedCSSValueList.get(i));
            }
        }
        simpleWriter.write(')');
    }

    @Override
    public void writeMinifiedValue(SimpleWriter simpleWriter, String string, CSSValue cSSValue) throws IOException {
        if (cSSValue.getCssValueType() == CSSValue.CssType.LIST) {
            this.writeMinifiedList(simpleWriter, string, (ValueList)cSSValue);
            return;
        }
        switch (cSSValue.getPrimitiveType()) {
            case COLOR: {
                this.writeMinifiedColor(simpleWriter, string, (CSSColorValue)cSSValue);
                break;
            }
            case COLOR_MIX: {
                this.writeColorMix(simpleWriter, string, (CSSColorMixFunction)cSSValue);
                break;
            }
            case FUNCTION: 
            case MATH_FUNCTION: 
            case GRADIENT: {
                this.writeMinifiedFunction(simpleWriter, string, (CSSFunctionValue)cSSValue);
                break;
            }
            default: {
                super.writeMinifiedValue(simpleWriter, string, cSSValue);
            }
        }
    }

    private void writeMinifiedList(SimpleWriter simpleWriter, String string, ValueList valueList) throws IOException {
        if (valueList.isCommaSeparated()) {
            this.writeMinifiedCSList(simpleWriter, string, valueList);
        } else if (!valueList.isBracketList()) {
            this.writeMinifiedWSList(simpleWriter, string, valueList);
        } else {
            super.writeMinifiedValue(simpleWriter, string, valueList);
        }
    }

    private void writeMinifiedCSList(SimpleWriter simpleWriter, String string, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeMinifiedValue(simpleWriter, string, valueList.item(0));
            int n = valueList.getLength();
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(',');
                this.writeMinifiedValue(simpleWriter, string, valueList.item(i));
            }
        }
    }

    private void writeMinifiedWSList(SimpleWriter simpleWriter, String string, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeMinifiedValue(simpleWriter, string, valueList.item(0));
            int n = valueList.getLength();
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(' ');
                this.writeMinifiedValue(simpleWriter, string, valueList.item(i));
            }
        }
    }

    protected void writeMinifiedColor(SimpleWriter simpleWriter, String string, CSSColorValue cSSColorValue) throws IOException {
        super.writeMinifiedValue(simpleWriter, string, cSSColorValue);
    }

    protected void writeMinifiedColorMix(SimpleWriter simpleWriter, String string, CSSColorMixFunction cSSColorMixFunction) throws IOException {
        super.writeMinifiedValue(simpleWriter, string, cSSColorMixFunction);
    }

    private void writeMinifiedFunction(SimpleWriter simpleWriter, String string, CSSFunctionValue cSSFunctionValue) throws IOException {
        LinkedCSSValueList linkedCSSValueList = cSSFunctionValue.getArguments();
        simpleWriter.write((CharSequence)cSSFunctionValue.getFunctionName());
        simpleWriter.write('(');
        int n = linkedCSSValueList.size();
        if (n == 1) {
            StyleValue styleValue = (StyleValue)linkedCSSValueList.get(0);
            if (styleValue.getPrimitiveType() == CSSValue.Type.EXPRESSION && ((CSSExpressionValue)((Object)styleValue)).getStringValue().length() == 0) {
                simpleWriter.write((CharSequence)((CSSExpressionValue)((Object)styleValue)).getExpression().getMinifiedCssText());
            } else {
                this.writeMinifiedValue(simpleWriter, string, styleValue);
            }
        } else if (n != 0) {
            this.writeMinifiedValue(simpleWriter, string, (CSSValue)linkedCSSValueList.get(0));
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(',');
                this.writeMinifiedValue(simpleWriter, string, (CSSValue)linkedCSSValueList.get(i));
            }
        }
        simpleWriter.write(')');
    }
}

