/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractRuleList;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.CompatStyleDeclaration;
import io.sf.carte.doc.style.css.om.CounterStyleRule;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.FontFeatureValuesRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MarginRuleList;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.NamespaceRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.PropertyRule;
import io.sf.carte.doc.style.css.om.SheetHandler;
import io.sf.carte.doc.style.css.om.StandAloneErrorHandler;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import io.sf.carte.doc.style.css.om.UnknownRule;
import io.sf.carte.doc.style.css.om.ViewportRule;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import io.sf.carte.util.Visitor;
import io.sf.carte.util.agent.AgentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.MediaList;

public abstract class BaseCSSStyleSheet
extends AbstractCSSStyleSheet {
    private static final long serialVersionUID = 1L;
    private AbstractCSSStyleSheet parent = null;
    private String href = null;
    private final AbstractCSSRule ownerRule;
    private final byte sheetOrigin;
    final CSSRuleArrayList cssRules;
    private int currentInsertionIndex = 0;
    private MediaQueryList destinationMedia;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private boolean disabled = false;
    private SheetErrorHandler sheetErrorHandler = null;
    private static final int MAX_IMPORT_RECURSION = 8;

    protected BaseCSSStyleSheet(String string, MediaQueryList mediaQueryList, AbstractCSSRule abstractCSSRule, byte by) {
        super(string);
        this.ownerRule = abstractCSSRule;
        this.destinationMedia = mediaQueryList == null ? MediaQueryListImpl.createUnmodifiable() : mediaQueryList;
        this.sheetOrigin = by;
        this.cssRules = new CSSRuleArrayList(64);
    }

    protected void copyAllTo(BaseCSSStyleSheet baseCSSStyleSheet) {
        this.copyFieldsTo(baseCSSStyleSheet);
        this.copyRulesTo(baseCSSStyleSheet);
    }

    protected void copyFieldsTo(BaseCSSStyleSheet baseCSSStyleSheet) {
        baseCSSStyleSheet.currentInsertionIndex = this.currentInsertionIndex;
        baseCSSStyleSheet.setDisabled(this.getDisabled());
        baseCSSStyleSheet.namespaces = this.namespaces;
        if (this.parent != null) {
            baseCSSStyleSheet.setParentStyleSheet(this.parent);
        }
    }

    protected void copyRulesTo(BaseCSSStyleSheet baseCSSStyleSheet) {
        baseCSSStyleSheet.cssRules.ensureCapacity(this.cssRules.getLength());
        Iterator iterator = this.cssRules.iterator();
        while (iterator.hasNext()) {
            baseCSSStyleSheet.cssRules.add(((AbstractCSSRule)iterator.next()).clone(baseCSSStyleSheet));
        }
    }

    @Override
    public abstract BaseCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public AbstractCSSRule getOwnerRule() {
        return this.ownerRule;
    }

    @Override
    public Node getOwnerNode() {
        return null;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.destinationMedia;
    }

    @Override
    protected void setMedia(MediaQueryList mediaQueryList) throws DOMException {
        if (mediaQueryList.hasErrors()) {
            throw new DOMException(11, "Media query has errors");
        }
        this.destinationMedia = mediaQueryList;
    }

    @Override
    public byte getOrigin() {
        return this.sheetOrigin;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String string, int n) throws DOMException {
        if (n > this.getCssRules().getLength() || n < 0) {
            throw new DOMException(1, "Invalid index: " + n);
        }
        StringReader stringReader = new StringReader(string);
        Parser parser = this.getStyleSheetFactory().createSACParser();
        SheetHandler sheetHandler = this.createSheetHandler((short)0);
        parser.setDocumentHandler(sheetHandler);
        parser.setErrorHandler(sheetHandler);
        this.currentInsertionIndex = n - 1;
        try {
            parser.parseRule(stringReader, sheetHandler);
        }
        catch (CSSNamespaceParseException cSSNamespaceParseException) {
            DOMException dOMException = new DOMException(14, cSSNamespaceParseException.getMessage());
            dOMException.initCause(cSSNamespaceParseException);
            throw dOMException;
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        if (this.currentInsertionIndex != n && sheetHandler.getOutOfRuleException() != null) {
            DOMException dOMException = sheetHandler.getOutOfRuleException().getClass() == CSSNamespaceParseException.class ? new DOMException(14, sheetHandler.getOutOfRuleException().getMessage()) : new DOMException(12, sheetHandler.getOutOfRuleException().getMessage());
            dOMException.initCause(sheetHandler.getOutOfRuleException());
            throw dOMException;
        }
        return this.currentInsertionIndex;
    }

    @Override
    public void addRule(AbstractCSSRule abstractCSSRule) throws DOMException {
        if (abstractCSSRule.getType() == 10) {
            CSSNamespaceRule cSSNamespaceRule = (CSSNamespaceRule)((Object)abstractCSSRule);
            if (this.namespaces.containsKey(cSSNamespaceRule.getNamespaceURI())) {
                throw new DOMException(14, "Rule for this namespace URI already exists: " + cSSNamespaceRule.getNamespaceURI());
            }
            this.registerNamespace(cSSNamespaceRule);
        }
        abstractCSSRule.setParentStyleSheet(this);
        this.addLocalRule(abstractCSSRule);
    }

    void setNamespace(String string, String string2) {
        this.namespaces.put(string2, string);
    }

    @Override
    protected void registerNamespace(CSSNamespaceRule cSSNamespaceRule) {
        this.namespaces.put(cSSNamespaceRule.getNamespaceURI(), cSSNamespaceRule.getPrefix());
    }

    @Override
    protected void unregisterNamespace(String string) {
        this.namespaces.remove(string);
    }

    protected void addLocalRule(CSSRule cSSRule) {
        this.currentInsertionIndex = this.cssRules.insertRule(cSSRule, ++this.currentInsertionIndex);
    }

    @Override
    public void deleteRule(int n) throws DOMException {
        CSSRule cSSRule;
        try {
            cSSRule = (CSSRule)this.cssRules.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMException(1, indexOutOfBoundsException.getMessage());
        }
        if (cSSRule.getType() == 10 && this.containsRuleWithNamespace(((CSSNamespaceRule)cSSRule).getNamespaceURI())) {
            throw new DOMException(14, "There are style rules with ");
        }
        this.cssRules.remove(n);
    }

    private boolean containsRuleWithNamespace(String string) {
        for (CSSRule cSSRule : this.cssRules) {
            CSSStyleDeclarationRule cSSStyleDeclarationRule;
            if (cSSRule.getType() != 1 || !BaseCSSStyleSheet.selectorListHasNamespace((cSSStyleDeclarationRule = (CSSStyleDeclarationRule)cSSRule).getSelectorList(), string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addStyleSheet(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        if (!abstractCSSStyleSheet.getDisabled()) {
            MediaList mediaList = abstractCSSStyleSheet.getMedia();
            if (mediaList.isAllMedia()) {
                CSSRuleArrayList cSSRuleArrayList = abstractCSSStyleSheet.getCssRules();
                this.addRuleList(cSSRuleArrayList, abstractCSSStyleSheet, 0);
            } else if (!mediaList.isNotAllMedia()) {
                CSSRuleArrayList cSSRuleArrayList = abstractCSSStyleSheet.getCssRules();
                MediaRule mediaRule = this.createMediaRule((MediaQueryList)mediaList);
                this.addToMediaRule(mediaRule, cSSRuleArrayList, abstractCSSStyleSheet, 0);
                this.addLocalRule(mediaRule);
            }
            this.getErrorHandler().mergeState(abstractCSSStyleSheet.getErrorHandler());
        }
    }

    private void addRuleList(CSSRuleArrayList cSSRuleArrayList, AbstractCSSStyleSheet abstractCSSStyleSheet, int n) {
        int n2 = cSSRuleArrayList.getLength();
        for (int i = 0; i < n2; ++i) {
            Object object;
            Serializable serializable;
            AbstractCSSRule abstractCSSRule = (AbstractCSSRule)cSSRuleArrayList.item(i);
            if (abstractCSSRule.getType() != 3) {
                this.addLocalRule(abstractCSSRule.clone(abstractCSSStyleSheet));
                continue;
            }
            if (++n == 8) {
                serializable = new DOMException(3, "Too many nested imports");
                object = abstractCSSRule.getCssText();
                abstractCSSStyleSheet.getErrorHandler().badAtRule((DOMException)serializable, (String)object);
                this.getErrorHandler().badAtRule((DOMException)serializable, (String)object);
                return;
            }
            serializable = (ImportRule)abstractCSSRule.clone(abstractCSSStyleSheet);
            object = ((ImportRule)serializable).getStyleSheet();
            CSSRuleArrayList cSSRuleArrayList2 = ((AbstractCSSStyleSheet)object).getCssRules();
            MediaQueryList mediaQueryList = ((ImportRule)serializable).getMedia();
            if (mediaQueryList.isAllMedia()) {
                this.addRuleList(cSSRuleArrayList2, (AbstractCSSStyleSheet)object, n);
                continue;
            }
            if (mediaQueryList.isNotAllMedia()) continue;
            MediaRule mediaRule = this.createMediaRule(((ImportRule)serializable).getMedia());
            this.addToMediaRule(mediaRule, cSSRuleArrayList2, (AbstractCSSStyleSheet)object, n);
            this.addLocalRule(mediaRule);
        }
    }

    private void addToMediaRule(MediaRule mediaRule, CSSRuleArrayList cSSRuleArrayList, AbstractCSSStyleSheet abstractCSSStyleSheet, int n) {
        int n2 = cSSRuleArrayList.getLength();
        for (int i = 0; i < n2; ++i) {
            Object object;
            Serializable serializable;
            AbstractCSSRule abstractCSSRule = (AbstractCSSRule)cSSRuleArrayList.item(i);
            if (abstractCSSRule.getType() != 3) {
                mediaRule.addRule(abstractCSSRule.clone(abstractCSSStyleSheet));
                continue;
            }
            if (++n == 8) {
                serializable = new DOMException(3, "Too many nested imports");
                object = abstractCSSRule.getCssText();
                abstractCSSStyleSheet.getErrorHandler().badAtRule((DOMException)serializable, (String)object);
                this.getErrorHandler().badAtRule((DOMException)serializable, (String)object);
                return;
            }
            serializable = (ImportRule)abstractCSSRule.clone(abstractCSSStyleSheet);
            object = ((ImportRule)serializable).getStyleSheet();
            CSSRuleArrayList cSSRuleArrayList2 = ((AbstractCSSStyleSheet)object).getCssRules();
            MediaQueryList mediaQueryList = ((ImportRule)serializable).getMedia();
            if (mediaRule.getMedia().equals(mediaQueryList)) {
                this.addToMediaRule(mediaRule, cSSRuleArrayList2, (AbstractCSSStyleSheet)object, n);
                continue;
            }
            MediaRule mediaRule2 = this.createMediaRule(mediaQueryList);
            this.addToMediaRule(mediaRule2, cSSRuleArrayList2, (AbstractCSSStyleSheet)object, n);
            mediaRule.addRule(mediaRule2);
        }
    }

    private static boolean selectorListHasNamespace(SelectorList selectorList, String string) {
        for (int i = 0; i < selectorList.getLength(); ++i) {
            if (!BaseCSSStyleSheet.selectorHasNamespace(selectorList.item(i), string)) continue;
            return true;
        }
        return false;
    }

    private static boolean selectorHasNamespace(Selector selector, String string) {
        switch (selector.getSelectorType()) {
            case ELEMENT: 
            case UNIVERSAL: {
                return string.equals(((ElementSelector)selector).getNamespaceURI());
            }
            case CONDITIONAL: {
                ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                return BaseCSSStyleSheet.selectorHasNamespace(conditionalSelector.getSimpleSelector(), string) || BaseCSSStyleSheet.conditionHasNamespace(conditionalSelector.getCondition(), string);
            }
            case CHILD: 
            case DESCENDANT: 
            case DIRECT_ADJACENT: 
            case SUBSEQUENT_SIBLING: 
            case COLUMN_COMBINATOR: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                return BaseCSSStyleSheet.selectorHasNamespace(combinatorSelector.getSelector(), string) || BaseCSSStyleSheet.selectorHasNamespace(combinatorSelector.getSecondSelector(), string);
            }
        }
        return false;
    }

    private static boolean conditionHasNamespace(Condition condition, String string) {
        switch (condition.getConditionType()) {
            case ATTRIBUTE: 
            case BEGIN_HYPHEN_ATTRIBUTE: 
            case ONE_OF_ATTRIBUTE: 
            case BEGINS_ATTRIBUTE: 
            case ENDS_ATTRIBUTE: 
            case SUBSTRING_ATTRIBUTE: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return string.equals(attributeCondition.getNamespaceURI());
            }
            case AND: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                return BaseCSSStyleSheet.conditionHasNamespace(combinatorCondition.getFirstCondition(), string) || BaseCSSStyleSheet.conditionHasNamespace(combinatorCondition.getSecondCondition(), string);
            }
            case POSITIONAL: {
                SelectorList selectorList = ((PositionalCondition)condition).getOfList();
                if (selectorList == null) break;
                return BaseCSSStyleSheet.selectorListHasNamespace(selectorList, string);
            }
            case SELECTOR_ARGUMENT: {
                ArgumentCondition argumentCondition = (ArgumentCondition)condition;
                SelectorList selectorList = argumentCondition.getSelectors();
                if (selectorList == null) break;
                return BaseCSSStyleSheet.selectorListHasNamespace(selectorList, string);
            }
        }
        return false;
    }

    @Override
    public CounterStyleRule createCounterStyleRule(String string) throws DOMException {
        CounterStyleRule counterStyleRule = new CounterStyleRule(this, this.getOrigin());
        counterStyleRule.setName(string);
        return counterStyleRule;
    }

    @Override
    public FontFaceRule createFontFaceRule() {
        return new FontFaceRule(this, this.getOrigin());
    }

    @Override
    public FontFeatureValuesRule createFontFeatureValuesRule(String[] stringArray) {
        FontFeatureValuesRule fontFeatureValuesRule = new FontFeatureValuesRule(this, this.getOrigin());
        fontFeatureValuesRule.setFontFamily(stringArray);
        return fontFeatureValuesRule;
    }

    @Override
    public ImportRule createImportRule(MediaQueryList mediaQueryList, String string) {
        if (string == null) {
            throw new NullPointerException("Null @import URI");
        }
        return new ImportRule(this, ((MediaListAccess)((Object)mediaQueryList)).unmodifiable(), string, this.getOrigin());
    }

    @Override
    public KeyframesRule createKeyframesRule(String string) {
        KeyframesRule keyframesRule = new KeyframesRule((AbstractCSSStyleSheet)this, this.getOrigin());
        keyframesRule.setName(string);
        return keyframesRule;
    }

    @Override
    public MarginRule createMarginRule(String string) {
        return new MarginRule((AbstractCSSStyleSheet)this, this.getOrigin(), string);
    }

    @Override
    public MediaRule createMediaRule(MediaQueryList mediaQueryList) {
        return new MediaRule((AbstractCSSStyleSheet)this, mediaQueryList, this.getOrigin());
    }

    @Override
    public NamespaceRule createNamespaceRule(String string, String string2) {
        if (string == null || string2 == null) {
            throw new DOMException(15, "Null parameter");
        }
        return new NamespaceRule(this, this.getOrigin(), string, string2);
    }

    @Override
    public PageRule createPageRule() {
        return new PageRule(this, this.getOrigin());
    }

    @Override
    public PropertyRule createPropertyRule(String string) {
        PropertyRule propertyRule = new PropertyRule(this, this.getOrigin());
        propertyRule.setName(string);
        return propertyRule;
    }

    @Override
    public StyleRule createStyleRule() {
        return new StyleRule(this, this.getOrigin());
    }

    @Override
    public SupportsRule createSupportsRule(BooleanCondition booleanCondition) {
        return new SupportsRule((AbstractCSSStyleSheet)this, booleanCondition, this.getOrigin());
    }

    @Override
    public SupportsRule createSupportsRule(String string) throws DOMException {
        SupportsRule supportsRule = new SupportsRule((AbstractCSSStyleSheet)this, this.getOrigin());
        supportsRule.setConditionText(string);
        return supportsRule;
    }

    @Override
    @Deprecated
    public SupportsRule createSupportsRule() {
        return new SupportsRule((AbstractCSSStyleSheet)this, this.getOrigin());
    }

    @Override
    public ViewportRule createViewportRule() {
        return new ViewportRule(this, this.getOrigin());
    }

    @Override
    public UnknownRule createUnknownRule() {
        return new UnknownRule(this, this.getOrigin());
    }

    @Override
    protected BaseCSSStyleDeclaration createStyleDeclaration(BaseCSSDeclarationRule baseCSSDeclarationRule) {
        if (baseCSSDeclarationRule.getType() == 5) {
            return new WrappedCSSStyleDeclaration(baseCSSDeclarationRule);
        }
        BaseCSSStyleSheetFactory baseCSSStyleSheetFactory = this.getStyleSheetFactory();
        if (!baseCSSStyleSheetFactory.hasCompatValueFlags()) {
            return new BaseCSSStyleDeclaration(baseCSSDeclarationRule);
        }
        return new CompatStyleDeclaration(baseCSSDeclarationRule);
    }

    @Override
    public BaseCSSStyleDeclaration createStyleDeclaration() {
        return new BaseCSSStyleDeclaration();
    }

    @Override
    public boolean hasRuleErrorsOrWarnings() {
        for (AbstractCSSRule abstractCSSRule : this.cssRules) {
            if (!abstractCSSRule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SheetErrorHandler getErrorHandler() {
        if (this.sheetErrorHandler == null) {
            this.sheetErrorHandler = this.getStyleSheetFactory().createSheetErrorHandler(this);
        }
        return this.sheetErrorHandler;
    }

    @Override
    protected ErrorHandler getDocumentErrorHandler() {
        Node node = null;
        for (AbstractCSSStyleSheet abstractCSSStyleSheet = this; abstractCSSStyleSheet != null && (node = abstractCSSStyleSheet.getOwnerNode()) == null; abstractCSSStyleSheet = ((AbstractCSSStyleSheet)abstractCSSStyleSheet).getParentStyleSheet()) {
        }
        ErrorHandler errorHandler = node != null ? ((CSSDocument)node.getOwnerDocument()).getErrorHandler() : StandAloneErrorHandler.getInstance(this);
        return errorHandler;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    @Override
    protected String getNamespacePrefix(String string) {
        return this.namespaces.get(string);
    }

    String getNamespaceURI(String string) {
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String string2 = entry.getValue();
            if (!string.equals(string2)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected boolean hasDefaultNamespace() {
        return this.namespaces.containsValue("");
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parent;
    }

    @Override
    protected void setParentStyleSheet(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        this.parent = abstractCSSStyleSheet;
        this.sheetErrorHandler = abstractCSSStyleSheet.getErrorHandler();
    }

    @Override
    public String getHref() {
        if (this.href == null && this.ownerRule != null) {
            return this.ownerRule.getParentStyleSheet().getHref();
        }
        return this.href;
    }

    @Override
    public void setHref(String string) {
        this.href = string;
    }

    @Override
    public boolean loadStyleSheet(URL uRL, String string) throws DOMException, IOException {
        boolean bl = false;
        URLConnection uRLConnection = this.openConnection(uRL, string);
        uRLConnection.connect();
        try (InputStream inputStream = uRLConnection.getInputStream();){
            String string2 = uRLConnection.getContentEncoding();
            String string3 = uRLConnection.getContentType();
            if (this.isInvalidContentType(uRL, string3) && !this.isRedirect(uRLConnection)) {
                String string4;
                if (string3 != null) {
                    string3 = string3.replaceAll("\\p{Cc}", "*CTRL*");
                    string4 = "Style sheet at " + uRL.toExternalForm() + " served with invalid type (" + string3 + ").";
                } else {
                    string4 = "Style sheet at " + uRL.toExternalForm() + " has no content type nor ends with '.css' extension.";
                }
                this.getDocumentErrorHandler().policyError(this.getOwnerNode(), string4);
                throw new DOMPolicyException(string4);
            }
            Reader reader = AgentUtil.inputStreamToReader((InputStream)inputStream, (String)string3, (String)string2, (Charset)StandardCharsets.UTF_8);
            try {
                this.setHref(uRL.toExternalForm());
                bl = this.parseStyleSheet(reader);
            }
            catch (DOMException dOMException) {
                this.getDocumentErrorHandler().linkedSheetError(dOMException, this);
                throw dOMException;
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
        return bl;
    }

    private boolean isInvalidContentType(URL uRL, String string) {
        String string2;
        if (!(string == null || "content/unknown".equalsIgnoreCase(string) || "jar".equals(string2 = uRL.getProtocol()) || "file".equals(string2))) {
            int n = string.indexOf(59);
            if (n != -1) {
                string = string.substring(0, n);
            }
            return !"text/css".equalsIgnoreCase(string) && !uRL.getPath().toLowerCase(Locale.ROOT).endsWith(".css");
        }
        string2 = uRL.getProtocol();
        return !"file".equals(string2) && !"jar".equals(string2) && !uRL.getPath().toLowerCase(Locale.ROOT).endsWith(".css");
    }

    private boolean isRedirect(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            try {
                int n = ((HttpURLConnection)uRLConnection).getResponseCode();
                return n > 300 && n < 400 && n != 304;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public CSSRuleArrayList getRulesForProperty(String string) {
        CSSRuleArrayList cSSRuleArrayList = new CSSRuleArrayList();
        BaseCSSStyleSheet.scanRulesForPropertyDeclaration(this.cssRules, string, cSSRuleArrayList);
        if (cSSRuleArrayList.isEmpty()) {
            return null;
        }
        return cSSRuleArrayList;
    }

    private static void scanRulesForPropertyDeclaration(CSSRuleArrayList cSSRuleArrayList, String string, CSSRuleArrayList cSSRuleArrayList2) {
        for (CSSRule cSSRule : cSSRuleArrayList) {
            switch (cSSRule.getType()) {
                case 1: 
                case 6: {
                    CSSStyleDeclarationRule cSSStyleDeclarationRule = (CSSStyleDeclarationRule)cSSRule;
                    if (!((BaseCSSStyleDeclaration)cSSStyleDeclarationRule.getStyle()).isPropertySet(string)) break;
                    cSSRuleArrayList2.add(cSSStyleDeclarationRule);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule groupingRule = (GroupingRule)cSSRule;
                    BaseCSSStyleSheet.scanRulesForPropertyDeclaration(groupingRule.getCssRules(), string, cSSRuleArrayList2);
                }
            }
        }
    }

    @Override
    public Selector[] getSelectorsForProperty(String string) {
        LinkedList<Selector> linkedList = new LinkedList<Selector>();
        BaseCSSStyleSheet.scanRulesForPropertyDeclaration(this.cssRules, string, linkedList);
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.toArray(new Selector[0]);
    }

    private static void scanRulesForPropertyDeclaration(CSSRuleArrayList cSSRuleArrayList, String string, LinkedList<Selector> linkedList) {
        block4: for (CSSRule cSSRule : cSSRuleArrayList) {
            switch (cSSRule.getType()) {
                case 1: {
                    CSSStyleDeclarationRule cSSStyleDeclarationRule = (CSSStyleDeclarationRule)cSSRule;
                    if (!((BaseCSSStyleDeclaration)cSSStyleDeclarationRule.getStyle()).isPropertySet(string)) break;
                    Object object = cSSStyleDeclarationRule.getSelectorList();
                    for (int i = 0; i < object.getLength(); ++i) {
                        linkedList.add(object.item(i));
                    }
                    continue block4;
                }
                case 4: 
                case 12: {
                    Object object = (GroupingRule)cSSRule;
                    BaseCSSStyleSheet.scanRulesForPropertyDeclaration(((GroupingRule)object).getCssRules(), string, linkedList);
                }
            }
        }
    }

    public Selector[] getSelectorsForPropertyValue(String string, String string2) {
        LinkedList<Selector> linkedList = new LinkedList<Selector>();
        BaseCSSStyleSheet.scanRulesForValue(this.cssRules, string, string2, linkedList);
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.toArray(new Selector[0]);
    }

    private static void scanRulesForValue(CSSRuleArrayList cSSRuleArrayList, String string, String string2, LinkedList<Selector> linkedList) {
        block4: for (CSSRule cSSRule : cSSRuleArrayList) {
            switch (cSSRule.getType()) {
                case 1: {
                    CSSStyleDeclarationRule cSSStyleDeclarationRule = (CSSStyleDeclarationRule)cSSRule;
                    if (!string2.equalsIgnoreCase(cSSStyleDeclarationRule.getStyle().getPropertyValue(string))) break;
                    Object object = cSSStyleDeclarationRule.getSelectorList();
                    for (int i = 0; i < object.getLength(); ++i) {
                        linkedList.add(object.item(i));
                    }
                    continue block4;
                }
                case 4: 
                case 12: {
                    Object object = (GroupingRule)cSSRule;
                    BaseCSSStyleSheet.scanRulesForValue(((GroupingRule)object).getCssRules(), string, string2, linkedList);
                }
            }
        }
    }

    @Override
    public StyleRule getFirstStyleRule(SelectorList selectorList) {
        return BaseCSSStyleSheet.scanRulesForSelector(this.cssRules, selectorList);
    }

    private static StyleRule scanRulesForSelector(CSSRuleArrayList cSSRuleArrayList, SelectorList selectorList) {
        for (CSSRule cSSRule : cSSRuleArrayList) {
            switch (cSSRule.getType()) {
                case 1: {
                    StyleRule styleRule = (StyleRule)cSSRule;
                    SelectorList selectorList2 = styleRule.getSelectorList();
                    if (!selectorList2.equals(selectorList)) break;
                    return styleRule;
                }
                case 4: 
                case 12: {
                    GroupingRule groupingRule = (GroupingRule)cSSRule;
                    StyleRule styleRule = BaseCSSStyleSheet.scanRulesForSelector(groupingRule.getCssRules(), selectorList);
                    if (styleRule == null) break;
                    return styleRule;
                }
            }
        }
        return null;
    }

    @Override
    public CSSRuleArrayList getStyleRules(Selector selector) {
        CSSRuleArrayList cSSRuleArrayList = new CSSRuleArrayList();
        BaseCSSStyleSheet.scanRulesForSelector(this.cssRules, selector, cSSRuleArrayList);
        if (cSSRuleArrayList.isEmpty()) {
            return null;
        }
        return cSSRuleArrayList;
    }

    private static void scanRulesForSelector(CSSRuleArrayList cSSRuleArrayList, Selector selector, CSSRuleArrayList cSSRuleArrayList2) {
        for (CSSRule cSSRule : cSSRuleArrayList) {
            switch (cSSRule.getType()) {
                case 1: {
                    StyleRule styleRule = (StyleRule)cSSRule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    if (!selectorList.contains(selector)) break;
                    cSSRuleArrayList2.add(styleRule);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule groupingRule = (GroupingRule)cSSRule;
                    BaseCSSStyleSheet.scanRulesForSelector(groupingRule.getCssRules(), selector, cSSRuleArrayList2);
                }
            }
        }
    }

    @Override
    public void acceptStyleRuleVisitor(Visitor<CSSStyleRule> visitor) {
        this.acceptStyleRuleVisitor(this.cssRules, visitor);
    }

    private void acceptStyleRuleVisitor(CSSRuleArrayList cSSRuleArrayList, Visitor<CSSStyleRule> visitor) {
        for (CSSRule cSSRule : cSSRuleArrayList) {
            switch (cSSRule.getType()) {
                case 1: {
                    StyleRule styleRule = (StyleRule)cSSRule;
                    visitor.visit((Object)styleRule);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule groupingRule = (GroupingRule)cSSRule;
                    this.acceptStyleRuleVisitor(groupingRule.getCssRules(), visitor);
                }
            }
        }
    }

    @Override
    public void acceptDeclarationRuleVisitor(Visitor<CSSDeclarationRule> visitor) {
        this.acceptDeclarationRuleVisitor(this.cssRules, visitor);
    }

    private void acceptDeclarationRuleVisitor(AbstractRuleList<? extends CSSRule> abstractRuleList, Visitor<CSSDeclarationRule> visitor) {
        for (CSSRule cSSRule : abstractRuleList) {
            switch (cSSRule.getType()) {
                case 1: 
                case 5: 
                case 8: 
                case 9: 
                case 11: 
                case 15: 
                case 18: {
                    CSSDeclarationRule cSSDeclarationRule = (CSSDeclarationRule)cSSRule;
                    visitor.visit((Object)cSSDeclarationRule);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule groupingRule = (GroupingRule)cSSRule;
                    this.acceptDeclarationRuleVisitor(groupingRule.getCssRules(), visitor);
                    break;
                }
                case 6: {
                    PageRule pageRule = (PageRule)cSSRule;
                    MarginRuleList marginRuleList = pageRule.getMarginRules();
                    if (marginRuleList != null) {
                        this.acceptDeclarationRuleVisitor(marginRuleList, visitor);
                    }
                    visitor.visit((Object)pageRule);
                    break;
                }
                case 7: {
                    KeyframesRule keyframesRule = (KeyframesRule)cSSRule;
                    this.acceptDeclarationRuleVisitor(keyframesRule.getCssRules(), visitor);
                }
            }
        }
    }

    @Override
    public void acceptDescriptorRuleVisitor(Visitor<CSSDeclarationRule> visitor) {
        this.acceptDescriptorRuleVisitor(this.cssRules, visitor);
    }

    private void acceptDescriptorRuleVisitor(AbstractRuleList<? extends CSSRule> abstractRuleList, Visitor<CSSDeclarationRule> visitor) {
        for (CSSRule cSSRule : abstractRuleList) {
            switch (cSSRule.getType()) {
                case 5: 
                case 8: 
                case 9: 
                case 11: 
                case 15: 
                case 18: {
                    CSSDeclarationRule cSSDeclarationRule = (CSSDeclarationRule)cSSRule;
                    visitor.visit((Object)cSSDeclarationRule);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule groupingRule = (GroupingRule)cSSRule;
                    this.acceptDescriptorRuleVisitor(groupingRule.getCssRules(), visitor);
                    break;
                }
                case 6: {
                    PageRule pageRule = (PageRule)cSSRule;
                    MarginRuleList marginRuleList = pageRule.getMarginRules();
                    if (marginRuleList != null) {
                        this.acceptDescriptorRuleVisitor(marginRuleList, visitor);
                    }
                    visitor.visit((Object)pageRule);
                    break;
                }
                case 7: {
                    KeyframesRule keyframesRule = (KeyframesRule)cSSRule;
                    this.acceptDescriptorRuleVisitor(keyframesRule.getCssRules(), visitor);
                }
            }
        }
    }

    protected String getTargetMedium() {
        return null;
    }

    @Override
    public String toMinifiedString() {
        return this.getCssRules().toMinifiedString();
    }

    public String toString() {
        StyleFormattingContext styleFormattingContext = this.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.getCssRules().getLength() * 20 + 32);
        try {
            this.getCssRules().writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
            styleFormattingContext.endRuleList((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String toStyleString() {
        StyleFormattingContext styleFormattingContext = this.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.getCssRules().getLength() * 20 + 92);
        try {
            bufferSimpleWriter.write((CharSequence)"<style type=\"text/css\"");
            if (!this.destinationMedia.isAllMedia()) {
                bufferSimpleWriter.write((CharSequence)" media=\"");
                bufferSimpleWriter.write((CharSequence)this.destinationMedia.getMediaText());
                bufferSimpleWriter.write('\"');
            }
            if (this.getTitle() != null) {
                bufferSimpleWriter.write((CharSequence)" title=\"");
                bufferSimpleWriter.write((CharSequence)this.getTitle());
                bufferSimpleWriter.write('\"');
            }
            bufferSimpleWriter.write('>');
            bufferSimpleWriter.newLine();
            this.getCssRules().writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
            styleFormattingContext.endRuleList((SimpleWriter)bufferSimpleWriter);
            bufferSimpleWriter.newLine();
            bufferSimpleWriter.write((CharSequence)"</style>");
            bufferSimpleWriter.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    SheetHandler createSheetHandler(short s) {
        return new SheetHandler(this, this.getOrigin(), s);
    }

    SheetHandler createSheetHandler(byte by, short s) {
        return new SheetHandler(this, by, s);
    }

    @Override
    public boolean parseStyleSheet(Reader reader) throws DOMException, IOException {
        return this.parseStyleSheet(reader, (short)2);
    }

    @Override
    public boolean parseStyleSheet(Reader reader, short s) throws DOMException, IOException {
        Object object2;
        if (this.sheetErrorHandler != null) {
            this.sheetErrorHandler.reset();
        }
        byte by = this.getOrigin();
        for (Object object2 : this.getCssRules()) {
            byte by2 = ((AbstractCSSRule)object2).getOrigin();
            if (by2 >= by) continue;
            by = by2;
        }
        Parser parser = this.getStyleSheetFactory().createSACParser();
        object2 = this.createSheetHandler(by, s);
        parser.setDocumentHandler((CSSHandler)object2);
        parser.setErrorHandler((CSSErrorHandler)object2);
        this.parseStyleSheet(reader, parser);
        return !this.getErrorHandler().hasSacErrors();
    }

    private void parseStyleSheet(Reader reader, Parser parser) throws DOMException, IOException {
        try {
            parser.parseStyleSheet(reader);
        }
        catch (CSSNamespaceParseException cSSNamespaceParseException) {
            DOMException dOMException = new DOMException(14, cSSNamespaceParseException.getMessage());
            dOMException.initCause(cSSNamespaceParseException);
            throw dOMException;
        }
        catch (CSSBudgetException cSSBudgetException) {
            DOMException dOMException = new DOMException(9, cSSBudgetException.getMessage());
            dOMException.initCause(cSSBudgetException);
            throw dOMException;
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, "Parse error at [" + cSSParseException.getLineNumber() + ',' + cSSParseException.getColumnNumber() + "]: " + cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(15, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
        catch (RuntimeException runtimeException) {
            String string = runtimeException.getMessage();
            String string2 = this.getHref();
            if (string2 != null) {
                string = "Error in stylesheet at " + string2 + ": " + string;
            }
            DOMException dOMException = new DOMException(11, string);
            dOMException.initCause(runtimeException);
            throw dOMException;
        }
    }

    boolean match(MediaQueryList mediaQueryList, MediaQueryList mediaQueryList2) {
        if (mediaQueryList.isAllMedia()) {
            return true;
        }
        if (mediaQueryList2 == null) {
            return !mediaQueryList.isNotAllMedia();
        }
        if (mediaQueryList2.isAllMedia()) {
            return true;
        }
        return mediaQueryList.matches(mediaQueryList2);
    }
}

