/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.Node;

public abstract class AbstractStyleDatabase
implements StyleDatabase,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_GENERIC_FONT_FAMILY = "serif";
    private static final TypedValue DEFAULT_INITIAL_COLOR = (TypedValue)new ValueFactory().parseProperty("#000000");
    private CSSTypedValue initialColor = DEFAULT_INITIAL_COLOR;

    @Override
    public CSSTypedValue getInitialColor() {
        return this.initialColor;
    }

    @Override
    public void setInitialColor(String string) {
        this.initialColor = (TypedValue)new ValueFactory().parseProperty(string);
        ((ColorValue)this.initialColor).setSystemDefault();
    }

    @Override
    public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily(DEFAULT_GENERIC_FONT_FAMILY);
    }

    @Override
    public String getUsedFontFamily(CSSComputedProperties cSSComputedProperties) {
        String string = this.scanFontFamilyValue(cSSComputedProperties);
        if (string == null) {
            string = this.getDefaultGenericFontFamily();
        }
        return string;
    }

    private String scanFontFamilyValue(CSSComputedProperties cSSComputedProperties) {
        Object object;
        CSSValue cSSValue = cSSComputedProperties.getPropertyCSSValue("font-family");
        String string = null;
        if (cSSValue != null) {
            if (cSSValue.getCssValueType() == CSSValue.CssType.LIST) {
                object = (ValueList)cSSValue;
                Iterator<StyleValue> iterator = ((ValueList)object).iterator();
                while (iterator.hasNext()) {
                    StyleValue styleValue = iterator.next();
                    string = this.stringValueOrNull(styleValue);
                    if (string == null || !this.isFontFamilyAvailable(string, cSSComputedProperties)) continue;
                    return string;
                }
            } else {
                string = this.stringValueOrNull(cSSValue);
                if (string != null && this.isFontFamilyAvailable(string, cSSComputedProperties)) {
                    return string;
                }
            }
        }
        if ((object = cSSComputedProperties.getParentComputedStyle()) != null) {
            string = this.scanFontFamilyValue((CSSComputedProperties)object);
        }
        return string;
    }

    private String stringValueOrNull(CSSValue cSSValue) {
        CSSTypedValue cSSTypedValue;
        CSSValue.Type type;
        String string = cSSValue.getCssValueType() == CSSValue.CssType.TYPED && ((type = (cSSTypedValue = (CSSTypedValue)cSSValue).getPrimitiveType()) == CSSValue.Type.STRING || type == CSSValue.Type.IDENT) ? cSSTypedValue.getStringValue() : null;
        return string;
    }

    protected boolean isFontFamilyAvailable(String string, CSSComputedProperties cSSComputedProperties) {
        if (this.isFontFamilyAvailable(string = string.toLowerCase(Locale.ROOT))) {
            return true;
        }
        return this.isFontFaceName(string);
    }

    @Override
    public void loadFontFaceRule(CSSFontFaceRule cSSFontFaceRule) {
        String string = cSSFontFaceRule.getStyle().getPropertyValue("font-family");
        if (string == null) {
            cSSFontFaceRule.getStyleDeclarationErrorHandler().missingRequiredProperty(string);
            return;
        }
        if (!this.isFontFaceName(string = string.toLowerCase(Locale.ROOT))) {
            CSSStyleDeclaration cSSStyleDeclaration = cSSFontFaceRule.getStyle();
            CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("src");
            if (cSSValue.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList valueList = (ValueList)cSSValue;
                if (valueList.isCommaSeparated()) {
                    for (StyleValue styleValue : valueList) {
                        if (!(styleValue.getCssValueType() == CSSValue.CssType.LIST ? this.loadFont(string, (ValueList)styleValue, cSSFontFaceRule) : this.loadFont(string, (TypedValue)styleValue, null, cSSFontFaceRule))) continue;
                        return;
                    }
                } else if (this.loadFont(string, valueList, cSSFontFaceRule)) {
                    return;
                }
            } else if (this.loadFont(string, (TypedValue)cSSValue, null, cSSFontFaceRule)) {
                return;
            }
        }
    }

    private boolean loadFont(String string, ValueList valueList, CSSFontFaceRule cSSFontFaceRule) {
        if (!valueList.isCommaSeparated()) {
            ValueList valueList2 = valueList;
            TypedValue typedValue = null;
            String string2 = null;
            for (StyleValue styleValue : valueList2) {
                if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                    StyleValue styleValue2;
                    LinkedCSSValueList linkedCSSValueList;
                    TypedValue typedValue2 = (TypedValue)styleValue;
                    CSSValue.Type type = typedValue2.getPrimitiveType();
                    if (type == CSSValue.Type.URI || type == CSSValue.Type.STRING) {
                        if (typedValue == null) {
                            typedValue = typedValue2;
                            continue;
                        }
                    } else if (type == CSSValue.Type.FUNCTION && "format".equalsIgnoreCase(typedValue2.getStringValue()) && (linkedCSSValueList = ((FunctionValue)typedValue2).getArguments()).size() == 1 && (styleValue2 = linkedCSSValueList.item(0)).getCssValueType() == CSSValue.CssType.TYPED && ((type = (typedValue2 = (TypedValue)styleValue2).getPrimitiveType()) == CSSValue.Type.STRING || type == CSSValue.Type.IDENT)) {
                        string2 = typedValue2.getStringValue();
                        continue;
                    }
                }
                this.errorSrc(styleValue, cSSFontFaceRule);
                return false;
            }
            if (typedValue != null) {
                return this.loadFont(string, typedValue, string2, cSSFontFaceRule);
            }
            this.errorSrc(valueList, cSSFontFaceRule);
            return false;
        }
        this.errorSrc(valueList, cSSFontFaceRule);
        return false;
    }

    private void errorSrc(StyleValue styleValue, CSSDeclarationRule cSSDeclarationRule) {
        CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Expected primitive value.");
        cSSPropertyValueException.setValueText(styleValue.getCssText());
        cSSDeclarationRule.getStyleDeclarationErrorHandler().wrongValue("src", cSSPropertyValueException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFont(String string, TypedValue typedValue, String string2, CSSFontFaceRule cSSFontFaceRule) {
        CSSValue.Type type = typedValue.getPrimitiveType();
        if (type == CSSValue.Type.URI) {
            URL uRL;
            String string3 = typedValue.getStringValue();
            Node node = cSSFontFaceRule.getParentStyleSheet().getOwnerNode();
            CSSDocument cSSDocument = node.getNodeType() != 9 ? (CSSDocument)node.getOwnerDocument() : (CSSDocument)node;
            try {
                uRL = cSSDocument.getURL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                cSSDocument.getErrorHandler().ioError(string3, malformedURLException);
                return false;
            }
            if (!cSSDocument.isAuthorizedOrigin(uRL)) {
                cSSDocument.getErrorHandler().policyError(node, "Unauthorized URL: " + uRL.toExternalForm());
                return false;
            }
            InputStream inputStream = null;
            try {
                int n;
                FontFormat fontFormat = null;
                URLConnection uRLConnection = cSSDocument.openConnection(uRL);
                uRLConnection.setConnectTimeout(10000);
                uRLConnection.connect();
                String string4 = uRLConnection.getContentType();
                if (string4 != null) {
                    n = string4.indexOf(59);
                    if (n != -1) {
                        string4 = string4.substring(0, n);
                    }
                    string4 = string4.toLowerCase(Locale.ROOT);
                    fontFormat = this.fontFormatFromContentType(string4);
                }
                if (fontFormat == null && string2 != null) {
                    fontFormat = this.fontFormatFromRule(string2.toLowerCase(Locale.ROOT));
                }
                inputStream = uRLConnection.getInputStream();
                this.loadFontFace(string, fontFormat, inputStream, cSSFontFaceRule);
                n = 1;
                return n != 0;
            }
            catch (IOException iOException) {
                cSSDocument.getErrorHandler().ioError(uRL.toExternalForm(), iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (type == CSSValue.Type.FUNCTION) {
            StyleValue styleValue;
            String string5 = typedValue.getStringValue();
            FunctionValue functionValue = (FunctionValue)typedValue;
            if ("local".equalsIgnoreCase(string5) && functionValue.getArguments().size() == 1 && (styleValue = (StyleValue)functionValue.getArguments().get(0)).getPrimitiveType() == CSSValue.Type.STRING) {
                return this.isFontFamilyAvailable(typedValue.getStringValue());
            }
        }
        return false;
    }

    protected FontFormat fontFormatFromContentType(String string) {
        FontFormat fontFormat = "application/font-ttf".equals(string) || "application/x-font-ttf".equals(string) || "application/font-sfnt".equals(string) || "font/ttf".equals(string) ? FontFormat.TRUETYPE : ("application/font-woff".equals(string) || "application/x-font-woff".equals(string) || "font/woff".equals(string) ? FontFormat.WOFF : ("application/font-woff2".equals(string) || "font/woff2".equals(string) ? FontFormat.WOFF2 : ("application/font-opentype".equals(string) || "application/x-font-opentype".equals(string) || "application/vnd.ms-opentype".equals(string) || "font/otf".equals(string) || "font/opentype".equals(string) ? FontFormat.OPENTYPE : ("application/vnd.ms-fontobject".equals(string) || "font/eot".equals(string) ? FontFormat.EMBEDDED_OPENTYPE : ("image/svg+xml".equals(string) ? FontFormat.SVG : null)))));
        return fontFormat;
    }

    protected FontFormat fontFormatFromRule(String string) {
        FontFormat fontFormat = "truetype".equals(string) ? FontFormat.TRUETYPE : ("woff".equals(string) ? FontFormat.WOFF : ("woff2".equals(string) ? FontFormat.WOFF2 : ("opentype".equals(string) ? FontFormat.OPENTYPE : ("embedded-opentype".equals(string) ? FontFormat.EMBEDDED_OPENTYPE : ("opentype".equals(string) ? FontFormat.OPENTYPE : ("svg".equals(string) ? FontFormat.SVG : null))))));
        return fontFormat;
    }

    protected boolean loadFontFace(String string, FontFormat fontFormat, InputStream inputStream, CSSFontFaceRule cSSFontFaceRule) throws IOException {
        return false;
    }

    protected abstract boolean isFontFamilyAvailable(String var1);

    static {
        ((ColorValue)DEFAULT_INITIAL_COLOR).setSystemDefault();
    }

    public static enum FontFormat {
        TRUETYPE,
        OPENTYPE,
        EMBEDDED_OPENTYPE,
        SVG,
        WOFF,
        WOFF2;

    }
}

