/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.impl;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import java.util.Locale;

public class AttrUtil {
    public static boolean isProxyAttr(LexicalUnit lexicalUnit) {
        String string;
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters().getNextLexicalUnit();
        if (lexicalUnit2 == null) {
            return false;
        }
        LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
        if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
            string = "string";
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                return false;
            }
        } else {
            LexicalUnit lexicalUnit3 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit3 == null) {
                return false;
            }
            if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                string = lexicalUnit2.getStringValue().toLowerCase(Locale.ROOT);
            } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_MOD) {
                string = "percentage";
            } else {
                return false;
            }
            if (lexicalUnit3.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || (lexicalUnit2 = lexicalUnit3.getNextLexicalUnit()) == null) {
                return false;
            }
        }
        return !AttrUtil.unitFitsAttrType(lexicalUnit2, string);
    }

    public static boolean unitFitsAttrType(LexicalUnit lexicalUnit, String string) {
        CSSValueSyntax cSSValueSyntax;
        if ("ident".equalsIgnoreCase(string)) {
            string = "custom-ident";
        }
        if ((cSSValueSyntax = SyntaxParser.createSimpleSyntax(string)) != null) {
            return lexicalUnit.matches(cSSValueSyntax) == CSSValueSyntax.Match.TRUE || lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.STRING && string.equals("url");
        }
        string = string.intern();
        short s = ParseHelper.unitFromString(string);
        short s2 = lexicalUnit.getCssUnit();
        return s != 1 && s2 != 255;
    }
}

