/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import io.sf.carte.echosvg.util.ParsedURLData;
import io.sf.carte.echosvg.util.ParsedURLDataProtocolHandler;
import io.sf.carte.echosvg.util.ParsedURLDefaultProtocolHandler;
import io.sf.carte.echosvg.util.ParsedURLJarProtocolHandler;
import io.sf.carte.echosvg.util.ParsedURLProtocolHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class ParsedURL {
    ParsedURLData data;
    String userAgent;
    private static Map<String, ParsedURLProtocolHandler> handlersMap = null;
    private static ParsedURLProtocolHandler defaultHandler = new ParsedURLDefaultProtocolHandler();
    private static String globalUserAgent = System.getProperty("http.agent", "Mozilla/4.0 (compatible; EchoSVG)");

    public static String getGlobalUserAgent() {
        return globalUserAgent;
    }

    public static void setGlobalUserAgent(String string) {
        globalUserAgent = string;
    }

    private static synchronized Map<String, ParsedURLProtocolHandler> getHandlersMap() {
        if (handlersMap != null) {
            return handlersMap;
        }
        handlersMap = new HashMap<String, ParsedURLProtocolHandler>();
        ParsedURL.registerHandler(new ParsedURLDataProtocolHandler());
        ParsedURL.registerHandler(new ParsedURLJarProtocolHandler());
        ServiceLoader<ParsedURLProtocolHandler> serviceLoader = ServiceLoader.load(ParsedURLProtocolHandler.class);
        for (ParsedURLProtocolHandler parsedURLProtocolHandler : serviceLoader) {
            ParsedURL.registerHandler(parsedURLProtocolHandler);
        }
        return handlersMap;
    }

    public static synchronized ParsedURLProtocolHandler getHandler(String string) {
        if (string == null) {
            return defaultHandler;
        }
        Map<String, ParsedURLProtocolHandler> map = ParsedURL.getHandlersMap();
        ParsedURLProtocolHandler parsedURLProtocolHandler = map.get(string);
        if (parsedURLProtocolHandler == null) {
            parsedURLProtocolHandler = defaultHandler;
        }
        return parsedURLProtocolHandler;
    }

    public static synchronized void registerHandler(ParsedURLProtocolHandler parsedURLProtocolHandler) {
        if (parsedURLProtocolHandler.getProtocolHandled() == null) {
            defaultHandler = parsedURLProtocolHandler;
            return;
        }
        Map<String, ParsedURLProtocolHandler> map = ParsedURL.getHandlersMap();
        map.put(parsedURLProtocolHandler.getProtocolHandled(), parsedURLProtocolHandler);
    }

    public static InputStream checkGZIP(InputStream inputStream) throws IOException {
        return ParsedURLData.checkGZIP(inputStream);
    }

    public ParsedURL(String string) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = ParsedURL.parseURL(string);
    }

    public ParsedURL(URL uRL) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = new ParsedURLData(uRL);
    }

    public ParsedURL(String string, String string2) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = string != null ? ParsedURL.parseURL(string, string2) : ParsedURL.parseURL(string2);
    }

    public ParsedURL(URL uRL, String string) {
        this.userAgent = ParsedURL.getGlobalUserAgent();
        this.data = uRL != null ? ParsedURL.parseURL(new ParsedURL(uRL), string) : ParsedURL.parseURL(string);
    }

    public ParsedURL(ParsedURL parsedURL, String string) {
        if (parsedURL != null) {
            this.userAgent = parsedURL.getUserAgent();
            this.data = ParsedURL.parseURL(parsedURL, string);
        } else {
            this.data = ParsedURL.parseURL(string);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public String getPostConnectionURL() {
        return this.data.getPostConnectionURL();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ParsedURL)) {
            return false;
        }
        ParsedURL parsedURL = (ParsedURL)object;
        return this.data.equals(parsedURL.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean complete() {
        return this.data.complete();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public String getProtocol() {
        return this.data.protocol;
    }

    public String getHost() {
        return this.data.host;
    }

    public int getPort() {
        return this.data.port;
    }

    public String getPath() {
        return this.data.path;
    }

    public String getRef() {
        return this.data.ref;
    }

    public String getPortStr() {
        return this.data.getPortStr();
    }

    public String getContentType() {
        return this.data.getContentType(this.userAgent);
    }

    public String getContentTypeMediaType() {
        return this.data.getContentTypeMediaType(this.userAgent);
    }

    public String getContentTypeCharset() {
        return this.data.getContentTypeCharset(this.userAgent);
    }

    public boolean hasContentTypeParameter(String string) {
        return this.data.hasContentTypeParameter(this.userAgent, string);
    }

    public String getContentEncoding() {
        return this.data.getContentEncoding(this.userAgent);
    }

    public InputStream openStream() throws IOException {
        return this.data.openStream(this.userAgent, null);
    }

    public InputStream openStream(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        return this.data.openStream(this.userAgent, arrayList.iterator());
    }

    public InputStream openStream(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return this.data.openStream(this.userAgent, arrayList.iterator());
    }

    public InputStream openStream(Iterator<String> iterator) throws IOException {
        return this.data.openStream(this.userAgent, iterator);
    }

    public InputStream openStreamRaw() throws IOException {
        return this.data.openStreamRaw(this.userAgent, null);
    }

    public InputStream openStreamRaw(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        return this.data.openStreamRaw(this.userAgent, arrayList.iterator());
    }

    public InputStream openStreamRaw(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        arrayList.addAll(Arrays.asList(stringArray));
        return this.data.openStreamRaw(this.userAgent, arrayList.iterator());
    }

    public InputStream openStreamRaw(Iterator<String> iterator) throws IOException {
        return this.data.openStreamRaw(this.userAgent, iterator);
    }

    public boolean sameFile(ParsedURL parsedURL) {
        return this.data.sameFile(parsedURL.data);
    }

    protected static String getProtocol(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        char c = string.charAt(n);
        while (c == '-' || c == '+' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            if (++n == n2) {
                c = '\u0000';
                break;
            }
            c = string.charAt(n);
        }
        if (c == ':') {
            return string.substring(0, n).toLowerCase();
        }
        return null;
    }

    public static ParsedURLData parseURL(String string) {
        if (string != null && !string.contains(":") && !string.startsWith("#")) {
            string = "file:" + string;
        }
        ParsedURLProtocolHandler parsedURLProtocolHandler = ParsedURL.getHandler(ParsedURL.getProtocol(string));
        return parsedURLProtocolHandler.parseURL(string);
    }

    public static ParsedURLData parseURL(String string, String string2) {
        if (string == null) {
            return ParsedURL.parseURL(string2);
        }
        ParsedURL parsedURL = new ParsedURL(string);
        return ParsedURL.parseURL(parsedURL, string2);
    }

    public static ParsedURLData parseURL(ParsedURL parsedURL, String string) {
        if (parsedURL == null) {
            return ParsedURL.parseURL(string);
        }
        String string2 = ParsedURL.getProtocol(string);
        if (string2 == null) {
            string2 = parsedURL.getProtocol();
        }
        ParsedURLProtocolHandler parsedURLProtocolHandler = ParsedURL.getHandler(string2);
        return parsedURLProtocolHandler.parseURL(parsedURL, string);
    }
}

