/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util.gui.xmleditor;

import io.sf.carte.echosvg.util.gui.xmleditor.XMLContext;
import io.sf.carte.echosvg.util.gui.xmleditor.XMLDocument;
import io.sf.carte.echosvg.util.gui.xmleditor.XMLView;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class XMLEditorKit
extends DefaultEditorKit {
    private static final long serialVersionUID = 1L;
    public static final String XML_MIME_TYPE = "text/xml";
    protected XMLContext context;
    protected ViewFactory factory = new XMLViewFactory();

    public XMLEditorKit() {
        this(null);
    }

    public XMLEditorKit(XMLContext xMLContext) {
        this.context = xMLContext == null ? new XMLContext() : xMLContext;
    }

    public XMLContext getStylePreferences() {
        return this.context;
    }

    @Override
    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        Font font = this.context.getSyntaxFont("default");
        if (font != null) {
            jEditorPane.setFont(font);
        }
    }

    @Override
    public String getContentType() {
        return XML_MIME_TYPE;
    }

    @Override
    public Object clone() {
        XMLEditorKit xMLEditorKit = new XMLEditorKit();
        xMLEditorKit.context = this.context;
        return xMLEditorKit;
    }

    @Override
    public Document createDefaultDocument() {
        XMLDocument xMLDocument = new XMLDocument(this.context);
        return xMLDocument;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }

    protected class XMLViewFactory
    implements ViewFactory {
        protected XMLViewFactory() {
        }

        @Override
        public View create(Element element) {
            return new XMLView(XMLEditorKit.this.context, element);
        }
    }
}

