/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util.gui;

import io.sf.carte.echosvg.util.gui.ExtendedGridBagConstraints;
import io.sf.carte.echosvg.util.gui.resource.ActionMap;
import io.sf.carte.echosvg.util.gui.resource.ButtonFactory;
import io.sf.carte.echosvg.util.gui.resource.MissingListenerException;
import io.sf.carte.echosvg.util.resources.ResourceManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LanguageDialog
extends JDialog
implements ActionMap {
    private static final long serialVersionUID = 1L;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected static final String RESOURCES = "io.sf.carte.echosvg.util.gui.resources.LanguageDialogMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("io.sf.carte.echosvg.util.gui.resources.LanguageDialogMessages", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Map<String, AbstractAction> listeners = new HashMap<String, AbstractAction>();
    protected Panel panel = new Panel();
    protected int returnCode;

    public LanguageDialog(JFrame jFrame) {
        super(jFrame);
        this.setModal(true);
        this.setTitle(resources.getString("Dialog.title"));
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.getContentPane().add(this.panel);
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
        this.pack();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnCode;
    }

    public void setLanguages(String string) {
        this.panel.setLanguages(string);
    }

    public String getLanguages() {
        return this.panel.getLanguages();
    }

    @Override
    public Action getAction(String string) throws MissingListenerException {
        return this.listeners.get(string);
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
        jPanel.add(buttonFactory.createJButton("OKButton"));
        jPanel.add(buttonFactory.createJButton("CancelButton"));
        return jPanel;
    }

    protected class CancelButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected CancelButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LanguageDialog.this.returnCode = 1;
            LanguageDialog.this.dispose();
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected OKButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LanguageDialog.this.returnCode = 0;
            LanguageDialog.this.dispose();
        }
    }

    public static class Panel
    extends JPanel
    implements ActionMap {
        private static final long serialVersionUID = 1L;
        protected JList<Object> userList;
        protected JList<Object> languageList;
        protected DefaultListModel<Object> userListModel = new DefaultListModel();
        protected DefaultListModel<Object> languageListModel = new DefaultListModel();
        protected JButton addLanguageButton;
        protected JButton removeLanguageButton;
        protected JButton upLanguageButton;
        protected JButton downLanguageButton;
        protected JButton clearLanguageButton;
        protected Map<String, AbstractAction> listeners = new HashMap<String, AbstractAction>();
        private static Map<String, ImageIcon> iconMap = null;

        public Panel() {
            super(new GridBagLayout());
            Panel.initCountryIcons();
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Panel.title")));
            this.listeners.put("AddLanguageButtonAction", new AddLanguageButtonAction());
            this.listeners.put("RemoveLanguageButtonAction", new RemoveLanguageButtonAction());
            this.listeners.put("UpLanguageButtonAction", new UpLanguageButtonAction());
            this.listeners.put("DownLanguageButtonAction", new DownLanguageButtonAction());
            this.listeners.put("ClearLanguageButtonAction", new ClearLanguageButtonAction());
            this.userList = new JList<Object>(this.userListModel);
            this.userList.setCellRenderer(new IconAndTextCellRenderer());
            this.languageList = new JList<Object>(this.languageListModel);
            this.languageList.setCellRenderer(new IconAndTextCellRenderer());
            StringTokenizer stringTokenizer = new StringTokenizer(resources.getString("Country.list"), " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.languageListModel.addElement(stringTokenizer.nextToken());
            }
            ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
            extendedGridBagConstraints.insets = new Insets(5, 5, 5, 5);
            extendedGridBagConstraints.weightx = 1.0;
            extendedGridBagConstraints.weighty = 1.0;
            extendedGridBagConstraints.fill = 1;
            extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("Languages.title")), BorderFactory.createLoweredBevelBorder()));
            jScrollPane.getViewport().add(this.languageList);
            this.add((Component)jScrollPane, extendedGridBagConstraints);
            this.languageList.setSelectionMode(0);
            this.languageList.addListSelectionListener(new LanguageListSelectionListener());
            extendedGridBagConstraints.setGridBounds(2, 0, 1, 1);
            JScrollPane jScrollPane2 = new JScrollPane();
            jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("User.title")), BorderFactory.createLoweredBevelBorder()));
            jScrollPane2.getViewport().add(this.userList);
            this.add((Component)jScrollPane2, extendedGridBagConstraints);
            this.userList.setSelectionMode(0);
            this.userList.addListSelectionListener(new UserListSelectionListener());
            extendedGridBagConstraints.setGridBounds(0, 1, 3, 1);
            extendedGridBagConstraints.weightx = 0.0;
            extendedGridBagConstraints.weighty = 0.0;
            this.add((Component)new JLabel(resources.getString("InfoLabel.text")), extendedGridBagConstraints);
            ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
            JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 3));
            this.addLanguageButton = buttonFactory.createJButton("AddLanguageButton");
            jPanel.add(this.addLanguageButton);
            this.addLanguageButton.setEnabled(false);
            this.removeLanguageButton = buttonFactory.createJButton("RemoveLanguageButton");
            jPanel.add(this.removeLanguageButton);
            this.removeLanguageButton.setEnabled(false);
            this.upLanguageButton = buttonFactory.createJButton("UpLanguageButton");
            jPanel.add(this.upLanguageButton);
            this.upLanguageButton.setEnabled(false);
            this.downLanguageButton = buttonFactory.createJButton("DownLanguageButton");
            jPanel.add(this.downLanguageButton);
            this.downLanguageButton.setEnabled(false);
            this.clearLanguageButton = buttonFactory.createJButton("ClearLanguageButton");
            jPanel.add(this.clearLanguageButton);
            this.clearLanguageButton.setEnabled(false);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            extendedGridBagConstraints.setGridBounds(1, 0, 1, 1);
            this.add((Component)jPanel2, extendedGridBagConstraints);
            extendedGridBagConstraints.fill = 2;
            extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
            extendedGridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel2.add((Component)jPanel, extendedGridBagConstraints);
            jScrollPane2.setPreferredSize(jScrollPane.getPreferredSize());
        }

        public static synchronized void initCountryIcons() {
            if (iconMap == null) {
                iconMap = new HashMap<String, ImageIcon>();
                StringTokenizer stringTokenizer = new StringTokenizer(resources.getString("Country.list"), " ");
                while (stringTokenizer.hasMoreTokens()) {
                    Panel.computeCountryIcon(Panel.class, stringTokenizer.nextToken());
                }
            }
        }

        public String getLanguages() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.userListModel.getSize() > 0) {
                stringBuilder.append(this.userListModel.getElementAt(0));
                for (int i = 1; i < this.userListModel.getSize(); ++i) {
                    stringBuilder.append(',');
                    stringBuilder.append(this.userListModel.getElementAt(i));
                }
            }
            return stringBuilder.toString();
        }

        public void setLanguages(String string) {
            Object object;
            int n = this.userListModel.getSize();
            for (int i = 0; i < n; ++i) {
                String string2;
                int n2;
                object = this.userListModel.getElementAt(0);
                this.userListModel.removeElementAt(0);
                String string3 = (String)object;
                int n3 = this.languageListModel.getSize();
                for (n2 = 0; n2 < n3 && string3.compareTo(string2 = (String)this.languageListModel.getElementAt(n2)) <= 0; ++n2) {
                }
                this.languageListModel.insertElementAt(object, n2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                this.userListModel.addElement(object);
                this.languageListModel.removeElement(object);
            }
            this.updateButtons();
        }

        protected void updateButtons() {
            int n = this.userListModel.size();
            int n2 = this.userList.getSelectedIndex();
            boolean bl = n == 0;
            boolean bl2 = n2 != -1;
            boolean bl3 = n2 == 0;
            boolean bl4 = n2 == n - 1;
            this.removeLanguageButton.setEnabled(!bl && bl2);
            this.upLanguageButton.setEnabled(!bl && bl2 && !bl3);
            this.downLanguageButton.setEnabled(!bl && bl2 && !bl4);
            this.clearLanguageButton.setEnabled(!bl);
            n = this.languageListModel.size();
            n2 = this.languageList.getSelectedIndex();
            bl = n == 0;
            bl2 = n2 != -1;
            this.addLanguageButton.setEnabled(!bl && bl2);
        }

        protected String getCountryText(String string) {
            return resources.getString(string + ".text");
        }

        protected Icon getCountryIcon(String string) {
            return Panel.computeCountryIcon(this.getClass(), string);
        }

        private static Icon computeCountryIcon(Class<?> clazz, String string) {
            ImageIcon imageIcon = null;
            try {
                imageIcon = iconMap.get(string);
                if (imageIcon != null) {
                    return imageIcon;
                }
                String string2 = resources.getString(string + ".icon");
                URL uRL = clazz.getResource(string2);
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                    iconMap.put(string, imageIcon);
                    return imageIcon;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return new ImageIcon(clazz.getResource("resources/blank.gif"));
        }

        @Override
        public Action getAction(String string) throws MissingListenerException {
            return this.listeners.get(string);
        }

        protected class AddLanguageButtonAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            protected AddLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Panel.this.languageList.getSelectedIndex();
                Object object = Panel.this.languageListModel.getElementAt(n);
                Panel.this.languageListModel.removeElementAt(n);
                Panel.this.userListModel.addElement(object);
                Panel.this.userList.setSelectedValue(object, true);
            }
        }

        protected class ClearLanguageButtonAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            protected ClearLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Panel.this.userListModel.getSize();
                for (int i = 0; i < n; ++i) {
                    String string;
                    int n2;
                    Object object = Panel.this.userListModel.getElementAt(0);
                    Panel.this.userListModel.removeElementAt(0);
                    String string2 = (String)object;
                    int n3 = Panel.this.languageListModel.getSize();
                    for (n2 = 0; n2 < n3 && string2.compareTo(string = (String)Panel.this.languageListModel.getElementAt(n2)) <= 0; ++n2) {
                    }
                    Panel.this.languageListModel.insertElementAt(object, n2);
                }
                Panel.this.updateButtons();
            }
        }

        protected class DownLanguageButtonAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            protected DownLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Panel.this.userList.getSelectedIndex();
                Object object = Panel.this.userListModel.getElementAt(n);
                Panel.this.userListModel.removeElementAt(n);
                Panel.this.userListModel.insertElementAt(object, n + 1);
                Panel.this.userList.setSelectedIndex(n + 1);
            }
        }

        protected class IconAndTextCellRenderer
        extends JLabel
        implements ListCellRenderer<Object> {
            private static final long serialVersionUID = 1L;

            public IconAndTextCellRenderer() {
                this.setOpaque(true);
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            }

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                String string = (String)object;
                this.setText(Panel.this.getCountryText(string));
                this.setIcon(Panel.this.getCountryIcon(string));
                this.setEnabled(jList.isEnabled());
                this.setFont(jList.getFont());
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                return this;
            }
        }

        protected class LanguageListSelectionListener
        implements ListSelectionListener {
            protected LanguageListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = Panel.this.languageList.getSelectedIndex();
                Panel.this.userList.getSelectionModel().clearSelection();
                Panel.this.languageList.setSelectedIndex(n);
                Panel.this.updateButtons();
            }
        }

        protected class RemoveLanguageButtonAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            protected RemoveLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                int n;
                int n2 = Panel.this.userList.getSelectedIndex();
                Object object = Panel.this.userListModel.getElementAt(n2);
                Panel.this.userListModel.removeElementAt(n2);
                String string2 = (String)object;
                int n3 = Panel.this.languageListModel.getSize();
                for (n = 0; n < n3 && string2.compareTo(string = (String)Panel.this.languageListModel.getElementAt(n)) <= 0; ++n) {
                }
                Panel.this.languageListModel.insertElementAt(object, n);
                Panel.this.languageList.setSelectedValue(object, true);
                Panel.this.updateButtons();
            }
        }

        protected class UpLanguageButtonAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            protected UpLanguageButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Panel.this.userList.getSelectedIndex();
                Object object = Panel.this.userListModel.getElementAt(n);
                Panel.this.userListModel.removeElementAt(n);
                Panel.this.userListModel.insertElementAt(object, n - 1);
                Panel.this.userList.setSelectedIndex(n - 1);
            }
        }

        protected class UserListSelectionListener
        implements ListSelectionListener {
            protected UserListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = Panel.this.userList.getSelectedIndex();
                Panel.this.languageList.getSelectionModel().clearSelection();
                Panel.this.userList.setSelectedIndex(n);
                Panel.this.updateButtons();
            }
        }
    }
}

