define(["exports","./layoutmanager.js","./emby-apiclient/events.js"],function(_exports,_layoutmanager,_events){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var defaultScope=document.body,scopes=[],_currentScope=defaultScope;function isAutoFocusEnabled(elem){if(_layoutmanager.default.tv)return!0;if(elem)switch(elem.tagName){case"INPUT":switch(elem.type){case"checkbox":case"radio":case"file":case"hidden":case"range":return!1;default:return!0}case"TEXTAREA":return!0}return!1}function getElementToAutoFocus(view,options){var element;return options&&!1===options.findAutoFocusElement||!(element=view.querySelector(".autofocus"))||!isCurrentlyFocusableInternal(element,!0)?getFocusableElements(view,1,".noautofocus",options)[0]||getFocusableElements(view,1,null,options)[0]:element}function autoFocus(view,options){view=getElementToAutoFocus(view,options);return view&&focus(view,options)}function focus(element,options){for(;element.classList.contains("focusable");){var autoFocusElement=getElementToAutoFocus(element,options);if(!autoFocusElement)break;element=autoFocusElement}return null!=options&&options.skipIfNotEnabled&&!isAutoFocusEnabled(element)?null:(focusInternal(element,options),element)}var lastFocusInfo={};function focusInternal(element,options){try{lastFocusInfo={element:element,options:options},element.focus({preventScroll:!0})}catch(err){console.log("Error in focusManager.focusInternal: "+err)}}var focusableTagNames=["INPUT","TEXTAREA","SELECT","BUTTON","A","DIV[tabindex]"],focusableQuerySelectors=focusableTagNames.map(function(t){return"A"===t&&(t+="[href]"),t+':not([tabindex="-1"]):not(:disabled)'}),focusableQuery=(focusableQuerySelectors.push(".focusable"),focusableQuerySelectors.join(","));var focusableTagNameQuery=focusableTagNames.join(","),focusableParentQuery=focusableTagNames.join(",")+",.focusable";function focusableParent(elem,includeGroups){return!1===includeGroups?elem.closest(focusableTagNameQuery):elem.closest(focusableParentQuery)}function isCurrentlyFocusableInternal(elem,checkOffsetParent){return!checkOffsetParent||null!==elem.offsetParent}function getFocusableElements(parent,limit,excludeSelector,options){for(var elems,fn=(parent=parent||_currentScope).getFocusableElements,focusableElements=(elems=(elems=fn?fn(parent,document.activeElement,null,options):elems)||parent.querySelectorAll(function(excludeSelector){if(!excludeSelector)return focusableQuery;for(var newQuerySelectors=[focusableQuerySelectors.length],i=0,length=focusableQuerySelectors.length;i<length;i++)newQuerySelectors[i]=focusableQuerySelectors[i]+":not("+excludeSelector+")";return newQuerySelectors.join(",")}(excludeSelector)),[]),i=0,length=elems.length;i<length;i++){var elem=elems[i];if(isCurrentlyFocusableInternal(elem,limit)&&(focusableElements.push(elem),limit)&&limit<=focusableElements.length)break}return focusableElements}var focusContainerQueries=[".focuscontainer,.focuscontainer-x",".focuscontainer,.focuscontainer-x",".focuscontainer,.focuscontainer-y,.focuscontainer-up",".focuscontainer,.focuscontainer-y,.focuscontainer-down"];function getFocusContainer(elem,direction){var defaultScopeResult,direction=focusContainerQueries[direction],direction=elem.closest(direction);return direction||((direction=_currentScope)===(defaultScopeResult=defaultScope)||direction.contains(elem)?direction:defaultScopeResult)}function getNearestElement(activeElement,activeElementRect,direction,focusableElements,enableSingleElementOptimization,focusableContainer){var nearestElement,nearestElementRect;if(enableSingleElementOptimization)return{element:enableSingleElementOptimization=focusableElements[0],rect:null==enableSingleElementOptimization?void 0:enableSingleElementOptimization.getBoundingClientRect()};for(var activeElementTop=activeElementRect.top,activeElementLeft=activeElementRect.left,point1x=parseFloat(activeElementLeft)||0,point1y=parseFloat(activeElementTop)||0,point2x=parseFloat(point1x+activeElementRect.width-1)||point1x,point2y=parseFloat(point1y+activeElementRect.height-1)||point1y,minDistance=1/0,i=0,length=focusableElements.length;i<length;i++){var curr=focusableElements[i];if(curr!==activeElement&&curr!==focusableContainer){var elementRect=curr.getBoundingClientRect(),elementRectWidth=elementRect.width,elementRectHeight=elementRect.height;if(elementRectWidth&&elementRectHeight){var elementRectLeft=elementRect.left,elementRectTop=elementRect.top;switch(direction){case 0:if(activeElementLeft<=elementRectLeft)continue;if(elementRect.right===activeElementRect.right)continue;break;case 1:if(elementRect.right<=activeElementRect.right)continue;if(elementRectLeft===activeElementLeft)continue;break;case 2:if(activeElementTop<=elementRectTop)continue;if(elementRect.bottom>=activeElementRect.bottom)continue;break;case 3:if(elementRect.bottom<=activeElementRect.bottom)continue;if(elementRectTop<=activeElementTop)continue}var x2=elementRectLeft+elementRectWidth-1,y2=elementRectTop+elementRectHeight-1,distX=void 0,distY=void 0;switch(direction){case 0:var intersectY=intersection(point1y,point2y,elementRectTop,y2),distX=Math.abs(point1x-Math.min(point1x,x2)),distY=intersectY||1+Math.min(Math.abs(point1y-y2),Math.abs(point2y-elementRectTop));break;case 1:intersectY=intersection(point1y,point2y,elementRectTop,y2);distX=Math.abs(point2x-Math.max(point2x,elementRectLeft)),distY=intersectY||1+Math.min(Math.abs(point1y-y2),Math.abs(point2y-elementRectTop));break;case 2:var intersectX=intersection(point1x,point2x,elementRectLeft,x2);distY=Math.abs(point1y-Math.min(point1y,y2)),distX=intersectX||1+Math.min(Math.abs(point1x-x2),Math.abs(point2x-elementRectLeft));break;case 3:intersectX=intersection(point1x,point2x,elementRectLeft,x2);distY=Math.abs(point2y-Math.max(point2y,elementRectTop)),distX=intersectX||1+Math.min(Math.abs(point1x-x2),Math.abs(point2x-elementRectLeft))}elementRectWidth=Math.sqrt(distX*distX+distY*distY);elementRectWidth<minDistance&&(nearestElement=curr,nearestElementRect=elementRect,minDistance=elementRectWidth)}}}return{element:nearestElement,rect:nearestElementRect}}function intersection(a1,a2,b1,b2){b1=Math.max(a1,b1),b2=Math.min(a2,b2);return b2<=b1?null:1e-9+(1-(b2-b1)/(a2-a1))}function navOuter(sourceElement,direction){var _container$controller,newElement,container=sourceElement?getFocusContainer(sourceElement,direction):_currentScope;if(container===sourceElement)return null!=(_container$controller=container.controller)&&_container$controller.autoFocus?container.controller.autoFocus({skipIfNotEnabled:!1,preventScroll:!1}):autoFocus(container,{preventScroll:!1});for(;container&&!(newElement=function(activeElement,direction,container){var parent,activeElementRect,fn,nearestElement,_enableSingleElementOptimization,elems,enableSingleElementOptimization,focusable;return(activeElement=(activeElement=activeElement||document.activeElement)&&(parent=focusableParent(activeElement))?parent:activeElement)?(parent=activeElement.closest(".focusable"),(fn=container.getFocusableElements)&&(focusable=fn(nearestElement,activeElement,direction))&&(enableSingleElementOptimization=focusable.length<2),(enableSingleElementOptimization=focusable?enableSingleElementOptimization:0===(focusable=container.querySelectorAll(focusableQuery)).length)||(activeElementRect=activeElement.getBoundingClientRect()),(nearestElement=(fn=getNearestElement(activeElement,activeElementRect,direction,focusable,enableSingleElementOptimization,parent)).element)?"autofocus"===(enableSingleElementOptimization=(nearestElement=activeElement&&(focusable=nearestElement.closest(".focusable"))&&focusable!==nearestElement&&parent!==focusable?focusable:nearestElement).getAttribute("data-focusabletype"))?autoFocus(nearestElement,{preventScroll:!1,itemBoundingClientRect:fn.rect}):"nearest"===enableSingleElementOptimization?((focusable=nearestElement.getFocusableElements)&&(elems=focusable(nearestElement,activeElement,direction))&&(_enableSingleElementOptimization=elems.length<2),(_enableSingleElementOptimization=elems?_enableSingleElementOptimization:0===(elems=nearestElement.querySelectorAll(focusableQuery)).length)||(activeElementRect=activeElementRect||activeElement.getBoundingClientRect()),(focusable=(enableSingleElementOptimization=getNearestElement(activeElement,activeElementRect,direction,elems,_enableSingleElementOptimization,parent)).element)?(focusInternal(focusable,{preventScroll:!1,itemBoundingClientRect:enableSingleElementOptimization.rect,direction:direction}),focusable):autoFocus(nearestElement,{preventScroll:!1})):(focusInternal(nearestElement,{preventScroll:!1,itemBoundingClientRect:fn.rect,direction:direction}),nearestElement):void 0):autoFocus(container,{findAutoFocusElement:!1,preventScroll:!1})}(sourceElement,direction,container))&&function(container,direction){var classList=container.classList;switch(direction){case 0:case 1:return classList.contains("navout-x");case 2:return classList.contains("navout-up");case 3:return classList.contains("navout-down");default:return}}(container,direction);){var newContainerParent=(container.getNavOutDestination?container.getNavOutDestination(direction):null)||container.parentNode;if(!newContainerParent)break;container=getFocusContainer(newContainerParent,direction)}return newElement}var focusManager={autoFocus:autoFocus,focus:focus,focusableParent:focusableParent,moveLeft:function(sourceElement){sourceElement=navOuter(sourceElement,0);return sourceElement&&_events.default.trigger(focusManager,"move"),sourceElement},moveRight:function(sourceElement){sourceElement=navOuter(sourceElement,1);return sourceElement&&_events.default.trigger(focusManager,"move"),sourceElement},moveUp:function(sourceElement){sourceElement=navOuter(sourceElement,2);return sourceElement&&_events.default.trigger(focusManager,"move"),sourceElement},moveDown:function(sourceElement){sourceElement=navOuter(sourceElement,3);return sourceElement&&_events.default.trigger(focusManager,"move"),sourceElement},sendText:function(text){document.activeElement.value=text},isCurrentlyFocusable:function(elem){return!!elem.matches(focusableQuery)&&isCurrentlyFocusableInternal(elem,!0)},pushScope:function(elem){scopes.includes(elem)||(scopes.push(elem),_currentScope=elem)},popScope:function(elem){var arr;elem=elem,-1<(elem=(arr=scopes).indexOf(elem))&&arr.splice(elem,1),_currentScope=scopes[scopes.length-1]||defaultScope},hasExclusiveFocusScope:function(){return scopes.length},getCurrentScope:function(){return _currentScope},isAutoFocusEnabled:isAutoFocusEnabled,getLastFocusInfo:function(){return lastFocusInfo},directions:{left:0,right:1,up:2,down:3}};_exports.default=focusManager});