define(["exports","./events.js","./../common/servicelocator.js","./../common/querystring.js"],function(_exports,_events,_servicelocator,_querystring){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;function isLocalId(str){return str&&str.startsWith("local")}function isNotLocalId(id){return!isLocalId(id)}function replaceAll(originalString,strReplace,strWith){strReplace=new RegExp(strReplace,"ig");return originalString.replace(strReplace,strWith)}function getFetchPromise(instance,request,signal){var err,fetchRequest,boundAbort,abortController;return signal&&signal.aborted?Promise.reject(((err=new Error("AbortError")).name="AbortError",err)):(err=request.headers||{},"json"===request.dataType&&(err.accept="application/json"),fetchRequest={headers:err,method:request.type,credentials:"same-origin"},request.timeout&&(boundAbort=(abortController=new AbortController).abort.bind(abortController),signal&&signal.addEventListener("abort",boundAbort),setTimeout(boundAbort,request.timeout),signal=abortController.signal),signal&&(fetchRequest.signal=signal),boundAbort=request.contentType,request.data&&("string"==typeof request.data?fetchRequest.body=request.data:(fetchRequest.body=_querystring.default.paramsToString(request.data),boundAbort=boundAbort||"application/x-www-form-urlencoded; charset=UTF-8")),abortController=request.url,"application/json"===boundAbort&&(boundAbort="text/plain",abortController=abortController+(abortController.includes("?")?"&":"?")+"reqformat=json"),boundAbort&&(err["Content-Type"]=boundAbort),fetch(abortController,fetchRequest))}function setServerAddress(instance,address){instance._serverAddress=address,_events.default.trigger(instance,"serveraddresschanged",[{apiClient:instance,address:address}])}function _onNetworkChanged(instance,resetAddress){resetAddress&&(instance.connected=!1,(resetAddress=getAddresses(instance.serverInfo())).length)&&setServerAddress(instance,resetAddress[0].url),instance._endPointInfo=null}function getAddresses(serverInfo){var address,addresses=[],addressesStrings=[];return!serverInfo.ManualAddress||!(address=serverInfo.ManualAddress).includes("://127.0.0.1")&&!address.toLowerCase().includes("://localhost")||addressesStrings.includes(serverInfo.ManualAddress.toLowerCase())||(addresses.push({url:serverInfo.ManualAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.LocalAddress&&!addressesStrings.includes(serverInfo.LocalAddress.toLowerCase())&&(addresses.push({url:serverInfo.LocalAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.ManualAddress&&!addressesStrings.includes(serverInfo.ManualAddress.toLowerCase())&&(addresses.push({url:serverInfo.ManualAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.RemoteAddress&&!addressesStrings.includes(serverInfo.RemoteAddress.toLowerCase())&&(addresses.push({url:serverInfo.RemoteAddress}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),console.log("getAddresses: ".concat(addressesStrings.join("|"))),addresses}function setTimeoutPromise(timeout){return new Promise(function(resolve){setTimeout(resolve,timeout)})}function tryReconnectInternal(instance,signal){var addresses=getAddresses(instance.serverInfo());if(!addresses.length)return Promise.reject();if(1===addresses.length)return Promise.resolve(addresses[0].url);for(var abortController=new AbortController,boundAbort=abortController.abort.bind(abortController),promises=(signal&&signal.addEventListener("abort",boundAbort),signal=abortController.signal,[]),i=0,length=addresses.length;i<length;i++)promises.push(function(instance,url,delay,signal){return console.log("tryReconnectToUrl: ".concat(url)),setTimeoutPromise(delay).then(function(){return getFetchPromise(0,{url:instance.getUrl("system/info/public",null,url),type:"GET",dataType:"json",timeout:15e3},signal).then(function(){return url})})}(instance,addresses[i].url,200*i,signal));return Promise.any(promises).then(function(url){return instance.serverAddress(url),abortController.abort(),Promise.resolve(url)})}function tryReconnect(instance,signal,argument_2){var retryCount=2<arguments.length&&void 0!==argument_2?argument_2:0,promise=tryReconnectInternal(instance,signal);return 2<=retryCount?promise:promise.catch(function(err){return console.log("error in tryReconnectInternal: ".concat(err||"")),setTimeoutPromise(500).then(function(){return tryReconnect(instance,signal,retryCount+1)})})}function getUserCacheKey(userId,serverId){return"user-".concat(userId,"-").concat(serverId)}function getCachedUser(instance,userId){instance=instance.serverId();return instance&&(userId=_servicelocator.appStorage.getItem(getUserCacheKey(userId,instance)))?((userId=JSON.parse(userId))&&setUserProperties(userId,instance),userId):null}function saveUserInCache(instance,user,forceSave){setUserProperties(user,instance.serverId()),(forceSave||function(instance,userId){for(var allUsers=instance._allUsers||[],i=0,length=allUsers.length;i<length;i++)if(allUsers[i].UserId===userId)return 1;return userId===instance.getCurrentUserId()}(instance,user.Id))&&(user.DateLastFetched=Date.now(),_servicelocator.appStorage.setItem(getUserCacheKey(user.Id,user.ServerId),JSON.stringify(user)))}function updateCachedUser(instance,userId){return instance.getUser(userId,!1)}var messageIdsReceived={};function onMessageReceivedInternal(instance,msg){var messageId=msg.MessageId;if(messageId){if(messageIdsReceived[messageId])return;messageIdsReceived[messageId]=!0}var user,messageId=msg.MessageType;"UserUpdated"===messageId||"UserConfigurationUpdated"===messageId||"UserPolicyUpdated"===messageId?(user=msg.Data).Id===instance.getCurrentUserId()&&(saveUserInCache(instance,user),instance._userViewsPromise=null):"LibraryChanged"===messageId&&(instance._userViewsPromise=null),_events.default.trigger(instance,"message",[msg])}function detectBitrateWithEndpointInfo(instance,_ref){return _ref.IsInNetwork?2e8:function(){if("undefined"!=typeof navigator){var connection=navigator.connection;if(connection){var downlink=connection.downlink;if(downlink&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink=downlink*1e6*.7,downlink=parseInt(downlink);if((downlink=connection.downlinkMax)&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink=downlink*1e6*.7,downlink=parseInt(downlink)}}return null}()||4000002}function getRemoteImagePrefix(instance,options){var urlPrefix="Items/".concat(options.itemId);return delete options.itemId,urlPrefix}function setUsersProperties(items,serverId){for(var i=0,length=items.length;i<length;i++)setUserProperties(items[i],serverId);Promise.resolve(items)}function setUserProperties(user,serverId){user.Type="User",user.ServerId=serverId}function normalizeImageOptions(_ref2,options){var _ref2=_ref2._devicePixelRatio;!1!==options.adjustForPixelRatio&&(_ref2=_ref2||1)&&(options.width&&(options.width=Math.round(options.width*_ref2)),options.height&&(options.height=Math.round(options.height*_ref2)),options.maxWidth&&(options.maxWidth=Math.round(options.maxWidth*_ref2)),options.maxHeight)&&(options.maxHeight=Math.round(options.maxHeight*_ref2)),delete options.adjustForPixelRatio,!1===options.keepAnimation&&delete options.keepAnimation,options.quality||("Backdrop"===options.type?options.quality=70:options.quality=90)}function mapToId(i){return i.Id}function mapToAccessToken(i){return i.AccessToken}function removeItemAll(arr,value){for(var i=0;i<arr.length;)arr[i]===value?arr.splice(i,1):++i;return arr}var startingPlaySession=Date.now();function onUserDataUpdated(userData){var instance=this.instance,itemId=this.itemId,userId=this.userId;return userData.ItemId=itemId,_events.default.trigger(instance,"message",[{MessageType:"UserDataChanged",Data:{UserId:userId,UserDataList:[userData],IsLocalEvent:!0}}]),userData}function onUserNotificationsDeleted(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"UserNotificationsDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}function onItemUpdated(result){var instance=this.instance,itemId=this.itemId;return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:[],ItemsUpdated:[itemId],IsLocalEvent:!0}}]),result}function onItemsDeleted(result){for(var instance=this.instance,items=this.items,foldersRemovedFrom=[],itemsRemoved=[],i=0,length=items.length;i<length;i++){var item=items[i];item.ParentId&&foldersRemovedFrom.push(item.ParentId),itemsRemoved.push(item.Id)}return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:itemsRemoved,ItemsUpdated:[],FoldersRemovedFrom:foldersRemovedFrom,IsLocalEvent:!0}}]),result}function getCachedWakeOnLanInfo(instance){instance=instance.serverId(),instance=_servicelocator.appStorage.getItem("server-".concat(instance,"-wakeonlaninfo"));return instance?JSON.parse(instance):[]}function refreshWakeOnLanInfoIfNeeded(instance){!_servicelocator.wakeOnLan.isSupported()||instance.isMinServerVersion("4.8.2")||instance.serverVersion()&&instance.isLoggedIn()&&!1!==instance.enableAutomaticBitrateDetection&&(console.log("refreshWakeOnLanInfoIfNeeded"),setTimeout(function(){var instance=this;console.log("refreshWakeOnLanInfo"),instance.getWakeOnLanInfo().then(function(info){return onWakeOnLanInfoFetched(instance,info),info},function(err){return console.log("Error in getWakeOnLanInfo: ".concat(err||"")),[]})}.bind(instance),1e4))}function onWakeOnLanInfoFetched(instance,info){instance=instance.serverId();_servicelocator.appStorage.setItem("server-".concat(instance,"-wakeonlaninfo"),JSON.stringify(info))}function setScheduledTaskProperties(item,apiClient){for(var serverId=apiClient.serverId(),triggers=(item.Type="ScheduledTask",item.ServerId=serverId,item.Triggers||[]),i=0,length=triggers.length;i<length;i++){var trigger=triggers[i];trigger.ScheduledTaskId=item.Id,trigger.TriggerIndex=i,trigger.TriggerType=trigger.Type,trigger.Type="ScheduledTaskTrigger",trigger.ServerId=serverId}}function getUrl(name,params,serverAddress){if(!name)throw new Error("Url name cannot be empty");var lowered,serverAddress=serverAddress||this._serverAddress;if(serverAddress)return(lowered=(serverAddress=serverAddress.endsWith("/")?serverAddress.substring(0,serverAddress.length-1):serverAddress).toLowerCase()).endsWith("/emby")||lowered.endsWith("/mediabrowser")||(serverAddress+="/emby"),name&&(name.startsWith("/")||(serverAddress+="/"),serverAddress+=name),(params=params&&_querystring.default.paramsToString(params))&&(serverAddress+="?".concat(params)),serverAddress;throw new Error("serverAddress is yet not set")}var StandardWidths=[480,720,1280,1920,2560,3840],ApiClient=function(){return babelHelpers.createClass(function ApiClient(serverAddress,appName,appVersion,deviceName,deviceId,devicePixelRatio){if(babelHelpers.classCallCheck(this,ApiClient),!serverAddress)throw new Error("Must supply a serverAddress");if(!appName)throw new Error("Must supply a appName");if(!appVersion)throw new Error("Must supply a appVersion");if(!deviceName)throw new Error("Must supply a deviceName");if(!deviceId)throw new Error("Must supply a deviceId");console.log("ApiClient serverAddress: ".concat(serverAddress)),console.log("ApiClient appName: ".concat(appName)),console.log("ApiClient appVersion: ".concat(appVersion)),console.log("ApiClient deviceName: ".concat(deviceName)),console.log("ApiClient deviceId: ".concat(deviceId)),this._serverInfo={},this._userAuthInfo={},this._serverAddress=serverAddress,this._deviceId=deviceId,this._deviceName=deviceName,this._appName=appName,this._appVersion=appVersion,this._devicePixelRatio=devicePixelRatio},[{key:"appName",value:function(){return this._appName}},{key:"setAuthorizationInfoIntoRequest",value:function(request,includeAccessToken){var authValues={},appName=this._appName,includeAccessToken=(appName&&(authValues["X-Emby-Client"]=appName),this._deviceName&&(authValues["X-Emby-Device-Name"]=this._deviceName),this._deviceId&&(authValues["X-Emby-Device-Id"]=this._deviceId),this._appVersion&&(authValues["X-Emby-Client-Version"]=this._appVersion),!1!==includeAccessToken&&(appName=this.accessToken())&&(authValues["X-Emby-Token"]=appName),this.getCurrentLocale()),appName=(includeAccessToken&&(authValues["X-Emby-Language"]=includeAccessToken),new URLSearchParams(authValues).toString());appName&&(includeAccessToken=request.url,includeAccessToken+=includeAccessToken.includes("?")?"&":"?",request.url=includeAccessToken+=appName)}},{key:"appVersion",value:function(){return this._appVersion}},{key:"deviceName",value:function(){return this._deviceName}},{key:"deviceId",value:function(){return this._deviceId}},{key:"serverAddress",value:function(val){if(null!=val){if(!val.toLowerCase().startsWith("http"))throw new Error("Invalid url: ".concat(val));setServerAddress(this,val),_onNetworkChanged(this)}return this._serverAddress}},{key:"onNetworkChanged",value:function(){_onNetworkChanged(this,!0)}},{key:"fetchWithFailover",value:function(request,enableReconnection,signal){console.log("apiclient.fetchWithFailover ".concat(request.url)),request.timeout=3e4;var instance=this;return getFetchPromise(0,request,signal).then(function(response){return instance.connected=!0,response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||(response.headers.get("Content-Type")||"").toLowerCase().startsWith("text/")||204===response.status?response.text():response:Promise.reject(response)},function(error){var previousServerAddress;if(error?"AbortError"===error.name?console.log("AbortError: ".concat(request.url)):console.log("Request failed to ".concat(request.url," ").concat(error.status||""," ").concat(error.toString())):console.log("Request timed out to ".concat(request.url)),error&&error.status||!enableReconnection)throw console.log("Reporting request failure"),error;return console.log("Attempting reconnection"),previousServerAddress=instance.serverAddress(),tryReconnect(instance,signal,null).then(function(newServerAddress){return console.log("Reconnect succeeded to ".concat(newServerAddress)),instance.connected=!0,instance.enableWebSocketAutoConnect&&instance.ensureWebSocket(),request.url=request.url.replace(previousServerAddress,newServerAddress),console.log("Retrying request with new url: ".concat(request.url)),instance.fetchWithFailover(request,!1,signal)})})}},{key:"fetch",value:function(request,includeAccessToken,signal){if(request)return request.headers=request.headers||{},this.setAuthorizationInfoIntoRequest(request,includeAccessToken),!1===this.enableAutomaticNetworking||"GET"!==request.type?getFetchPromise(0,request,signal).then(function(response){return response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||(response.headers.get("Content-Type")||"").toLowerCase().startsWith("text/")||204===response.status?response.text():response:Promise.reject(response)}):this.fetchWithFailover(request,!0,signal);throw new Error("Request cannot be null")}},{key:"setAuthenticationInfo",value:function(userAuthInfo,allUsers){this._userAuthInfo.UserId!==(userAuthInfo=userAuthInfo||{}).UserId&&(this._userViewsPromise=null),this._allUsers=allUsers||[],this._userAuthInfo=userAuthInfo,refreshWakeOnLanInfoIfNeeded(this)}},{key:"serverInfo",value:function(info){var currentUserId;return info&&(currentUserId=this.getCurrentUserId(),this._serverInfo=info,currentUserId!==this.getCurrentUserId())&&(this._userViewsPromise=null),this._serverInfo}},{key:"getCurrentUserName",value:function(){var userId=this.getCurrentUserId();return!userId||null==(userId=getCachedUser(this,userId))?null:userId.Name}},{key:"getCurrentUserId",value:function(){return this._userAuthInfo.UserId}},{key:"accessToken",value:function(){return this._userAuthInfo.AccessToken}},{key:"serverId",value:function(){return this.serverInfo().Id}},{key:"serverName",value:function(){return this.serverInfo().Name}},{key:"ajax",value:function(request,includeAccessToken){if(request)return this.fetch(request,includeAccessToken,request.signal);throw new Error("Request cannot be null")}},{key:"getCurrentUser",value:function(options){var userId=this.getCurrentUserId();return userId?this.getUser(userId,(options=options||{}).enableCache,options.signal):Promise.reject()}},{key:"isLoggedIn",value:function(){var info=this._userAuthInfo;return!!(info&&info.UserId&&info.AccessToken)}},{key:"logout",value:function(){function done(){return _this.clearAuthenticationInfo(),Promise.resolve()}var url,_this=this;this.closeWebSocket();return this.isLoggedIn()?(url=this.getUrl("Sessions/Logout"),this.ajax({type:"POST",url:url,timeout:1e4}).then(done,done)):done()}},{key:"authenticateUserByName",value:function(name,password){var url,instance;return name?(url=this.getUrl("Users/authenticatebyname"),(instance=this).ajax({type:"POST",url:url,data:{Username:name,Pw:password||""},dataType:"json"}).then(function(result){instance._userViewsPromise=null,saveUserInCache(instance,result.User,!0);function afterOnAuthenticated(){return instance.getSystemInfo(),refreshWakeOnLanInfoIfNeeded(instance),result}return instance.onAuthenticated?instance.onAuthenticated(instance,result).then(afterOnAuthenticated):(afterOnAuthenticated(),result)})):Promise.reject()}},{key:"ensureWebSocket",value:function(){if(this.connected&&!this.isWebSocketOpenOrConnecting()&&this.isWebSocketSupported())try{this.openWebSocket()}catch(err){console.log("Error opening web socket: ".concat(err||""))}}},{key:"openWebSocket",value:function(){var accessToken=this.accessToken();if(!accessToken)throw new Error("Cannot open web socket without access token.");var apiClient,socket,serverUrl=this._serverAddress||"",url=(serverUrl=serverUrl.endsWith("/")?serverUrl.substring(0,serverUrl.length-1):serverUrl).toLowerCase().endsWith("/emby")?this.getUrl("embywebsocket"):replaceAll(url=this.getUrl("socket"),"emby/socket","embywebsocket"),serverUrl=(url=replaceAll(url,"https:","wss:"),url=replaceAll(url,"http:","ws:"),url=(url+="?api_key=".concat(accessToken))+"&deviceId=".concat(this.deviceId()),console.log("opening web socket with url: ".concat(url)),new WebSocket(url));serverUrl.onmessage=function(msg){onMessageReceivedInternal(this,msg=JSON.parse(msg.data))}.bind(this),serverUrl.onopen=function(){console.log("web socket connection opened"),_events.default.trigger(this,"websocketopen");var list=this.messageListeners;if(list)for(var i=0,length=(list=list.slice(0)).length;i<length;i++){var listener=list[i];this.startMessageListener(listener.name,listener.options)}}.bind(this),serverUrl.onerror=function(){_events.default.trigger(this,"websocketerror")}.bind(this),apiClient=this,(socket=serverUrl).onclose=function(){console.log("web socket closed"),apiClient._webSocket===socket&&(console.log("nulling out web socket"),apiClient._webSocket=null),setTimeout(function(){_events.default.trigger(apiClient,"websocketclose")},0)},this._webSocket=serverUrl}},{key:"closeWebSocket",value:function(){var socket=this._webSocket;socket&&socket.readyState===WebSocket.OPEN&&socket.close()}},{key:"sendWebSocketMessage",value:function(name,data){console.log("Sending web socket message: ".concat(name));name={MessageType:name};data&&(name.Data=data),name=JSON.stringify(name),this._webSocket.send(name)}},{key:"startMessageListener",value:function(name,options){console.log("apiclient starting message listener ".concat(name," with options ").concat(options)),this.sendMessage("".concat(name,"Start"),options);var list=this.messageListeners;list||(this.messageListeners=list=[]);for(var i=0,length=list.length;i<length;i++)if(list[i].name===name)return;list.push({name:name,options:options})}},{key:"stopMessageListener",value:function(name){var list=this.messageListeners;list&&(this.messageListeners=list.filter(function(n){return n.name!==name})),console.log("apiclient stopping message listener ".concat(name)),this.sendMessage("".concat(name,"Stop"))}},{key:"sendMessage",value:function(name,data){this.isWebSocketOpen()&&this.sendWebSocketMessage(name,data)}},{key:"isMessageChannelOpen",value:function(){return this.isWebSocketOpen()}},{key:"isWebSocketOpen",value:function(){var socket=this._webSocket;return!!socket&&socket.readyState===WebSocket.OPEN}},{key:"isWebSocketOpenOrConnecting",value:function(){var socket=this._webSocket;return!!socket&&(socket.readyState===WebSocket.OPEN||socket.readyState===WebSocket.CONNECTING)}},{key:"get",value:function(url){return this.ajax({type:"GET",url:url})}},{key:"getJSON",value:function(url,signal){return this.fetch({url:url,type:"GET",dataType:"json"},null,signal)}},{key:"getText",value:function(url,signal){return this.fetch({url:url,type:"GET",dataType:"text"},null,signal)}},{key:"updateServerInfo",value:function(server,serverUrl){if(null==server)throw new Error("server cannot be null");if(this.serverInfo(server),!serverUrl)throw new Error("serverUrl cannot be null. serverInfo: ".concat(JSON.stringify(server)));console.log("Setting server address to ".concat(serverUrl)),this.serverAddress(serverUrl)}},{key:"isWebSocketSupported",value:function(){try{return null!=WebSocket}catch(err){return!1}}},{key:"clearAuthenticationInfo",value:function(){this.setAuthenticationInfo(null,null)}},{key:"encodeName",value:function(name){name=(name=(name=name.split("/").join("-")).split("&").join("-")).split("?").join("-");name=new URLSearchParams({name:name}).toString();return name.substring(name.indexOf("=")+1).replace("'","%27")}},{key:"getProductNews",value:function(){var url=this.getUrl("News/Product",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{});return this.getJSON(url)}},{key:"detectBitrate",value:function(signal){return this.getEndpointInfo(signal).then(function(info){return detectBitrateWithEndpointInfo(0,info)},function(err){return console.log("error in getEndpointInfo: ".concat(err||"")),detectBitrateWithEndpointInfo(0,{})})}},{key:"getItem",value:function(userId,itemId,options,signal){var fields;if(itemId)return null!=options&&options.fields&&!_servicelocator.appHost.supports("sync")&&(fields=removeItemAll(fields=options.fields.split(","),"SyncStatus"),fields=removeItemAll(fields,"ContainerSyncStatus"),options.fields=fields.join(",")),fields=userId?this.getUrl("Users/".concat(userId,"/Items/").concat(itemId),options):this.getUrl("Items/".concat(itemId),options),this.getJSON(fields,signal);throw new Error("null itemId")}},{key:"getRootFolder",value:function(userId){if(userId)return userId=this.getUrl("Users/".concat(userId,"/Items/Root")),this.getJSON(userId);throw new Error("null userId")}},{key:"getCurrentLocale",value:function(){return this.currentLocale}},{key:"setCurrentLocale",value:function(value){this.currentLocale=value}},{key:"getNotificationTypes",value:function(options){return this.getJSON(this.getUrl("Notifications/Types",options="string"==typeof options?{}:options))}},{key:"sendTestUserNotification",value:function(options){var url=this.getUrl("Notifications/Services/Test");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"})}},{key:"saveUserNotification",value:function(options){var url=this.getUrl("Notifications/Services/Configured");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"UserNotificationsSaved",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:[]}))}},{key:"deleteUserNotifications",value:function(items){var instance=this;return Promise.all(items.map(function(item){return instance.ajax({url:instance.getUrl("Notifications/Services/Configured",{Id:item.Id,UserId:item.UserId}),type:"DELETE"})})).then(onUserNotificationsDeleted.bind({instance:this,items:items}),onUserNotificationsDeleted.bind({instance:this,items:items}))}},{key:"getFeatures",value:function(query){return this.isMinServerVersion("4.8.0.20")?this.getJSON(this.getUrl("Features",query)):Promise.resolve([])}},{key:"getRemoteImageProviders",value:function(options){var urlPrefix;if(options)return urlPrefix=getRemoteImagePrefix(0,options),urlPrefix=this.getUrl("".concat(urlPrefix,"/RemoteImages/Providers"),options),this.getJSON(urlPrefix);throw new Error("null options")}},{key:"getAvailableRemoteImages",value:function(options){var urlPrefix;if(options)return urlPrefix=getRemoteImagePrefix(0,options),urlPrefix=this.getUrl("".concat(urlPrefix,"/RemoteImages"),options),this.getJSON(urlPrefix);throw new Error("null options")}},{key:"downloadRemoteImage",value:function(options){var itemId,urlPrefix;if(options)return itemId=options.itemId,urlPrefix=getRemoteImagePrefix(0,options),urlPrefix=this.getUrl("".concat(urlPrefix,"/RemoteImages/Download"),options),this.ajax({type:"POST",url:urlPrefix}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null options")}},{key:"getRecordingFolders",value:function(userId){userId=this.getUrl("LiveTv/Recordings/Folders",{userId:userId});return this.getJSON(userId)}},{key:"getLiveTvInfo",value:function(options){options=this.getUrl("LiveTv/Info",options||{});return this.getJSON(options)}},{key:"getLiveTvGuideInfo",value:function(options){options=this.getUrl("LiveTv/GuideInfo",options||{});return this.getJSON(options)}},{key:"getLiveTvChannel",value:function(id,userId){var options;if(id)return options={},userId&&(options.userId=userId),userId=this.getUrl("LiveTv/Channels/".concat(id),options),this.getJSON(userId);throw new Error("null id")}},{key:"getLiveTvChannelsForManagement",value:function(query){query=this.getUrl("LiveTv/Manage/Channels",query);return this.getJSON(query)}},{key:"setChannelDisabled",value:function(item,disabled){var id=item.Id,item=this.getUrl("LiveTv/Manage/Channels/".concat(id,"/Disabled"),{ManagementId:item.ManagementId,Disabled:disabled});return this.ajax({type:"POST",url:item,contentType:"application/json",dataType:"json"}).then(function(result){var instance=this.instance,id=this.id;return _events.default.trigger(instance,"message",[{MessageType:"ChannelManagementInfoUpdated",Data:{Channel:result,Id:id,IsLocalEvent:!0}}]),result}.bind({instance:this,id:id}))}},{key:"setChannelSortIndex",value:function(item,newIndex){var id=item.Id,item=this.getUrl("LiveTv/Manage/Channels/".concat(id,"/SortIndex"),{ManagementId:item.ManagementId,NewIndex:newIndex});return this.ajax({type:"POST",url:item}).then(function(result){var instance=this.instance,id=this.id;return _events.default.trigger(instance,"message",[{MessageType:"ChannelManagementInfoUpdated",Data:{Id:id,IsLocalEvent:!0}}]),result}.bind({instance:this,id:id}))}},{key:"getLiveTvChannels",value:function(options){options=this.getUrl("LiveTv/Channels",options||{});return this.getJSON(options)}},{key:"getLiveTvPrograms",value:function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return options.channelIds&&1800<options.channelIds.length?this.ajax({type:"POST",url:this.getUrl("LiveTv/Programs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}):this.getJSON(this.getUrl("LiveTv/Programs",options))}},{key:"getEpg",value:function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return options.AddCurrentProgram=!1,options.EnableUserData=!1,options.EnableImageTypes="Primary",options.UserId=this.getCurrentUserId(),0!==options.Limit||this.isMinServerVersion("4.8.0.46")||(options.Limit=1),this.getJSON(this.getUrl("LiveTv/EPG",options)).then(function(result){return result.Items.forEach(function(result){result.Type="EpgChannel",result.ServerId=this.serverId(),result.Id=result.Channel.Id}.bind(this)),result}.bind(this))}},{key:"getLiveTvRecommendedPrograms",value:function(){return this.getJSON(this.getUrl("LiveTv/Programs/Recommended",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{}))}},{key:"getLiveTvRecordings",value:function(options,signal){options=this.getUrl("LiveTv/Recordings",options||{});return this.getJSON(options,signal)}},{key:"getLiveTvRecordingSeries",value:function(options){options=this.getUrl("LiveTv/Recordings/Series",options||{});return this.getJSON(options)}},{key:"getLiveTvRecording",value:function(id,userId){var options;if(id)return options={},userId&&(options.userId=userId),userId=this.getUrl("LiveTv/Recordings/".concat(id),options),this.getJSON(userId);throw new Error("null id")}},{key:"getLiveTvProgram",value:function(id,userId){var options;if(id)return options={},userId&&(options.userId=userId),userId=this.getUrl("LiveTv/Programs/".concat(id),options),this.getJSON(userId);throw new Error("null id")}},{key:"cancelLiveTvTimer",value:function(id){if(id)return id=this.getUrl("LiveTv/Timers/".concat(id,"/Delete")),this.ajax({type:"POST",url:id});throw new Error("null id")}},{key:"getLiveTvTimers",value:function(options){options=this.getUrl("LiveTv/Timers",options||{});return this.getJSON(options)}},{key:"getLiveTvTimer",value:function(id){if(id)return id=this.getUrl("LiveTv/Timers/".concat(id)),this.getJSON(id);throw new Error("null id")}},{key:"getNewLiveTvTimerDefaults",value:function(){var url=this.getUrl("LiveTv/Timers/Defaults",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{});return this.getJSON(url)}},{key:"createLiveTvTimer",value:function(item){var url;if(item)return url=this.getUrl("LiveTv/Timers"),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"});throw new Error("null item")}},{key:"updateLiveTvTimer",value:function(item){var url;if(item)return url=this.getUrl("LiveTv/Timers/".concat(item.Id)),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"});throw new Error("null item")}},{key:"resetLiveTvTuner",value:function(id){if(id)return id=this.getUrl("LiveTv/Tuners/".concat(id,"/Reset")),this.ajax({type:"POST",url:id});throw new Error("null id")}},{key:"getLiveTvSeriesTimers",value:function(query,signal){return this.getJSON(this.getUrl("LiveTv/SeriesTimers",query),signal)}},{key:"getLiveTvSeriesTimer",value:function(id){if(id)return id=this.getUrl("LiveTv/SeriesTimers/".concat(id)),this.getJSON(id);throw new Error("null id")}},{key:"cancelLiveTvSeriesTimer",value:function(id){var url;if(id)return url=this.getUrl("LiveTv/SeriesTimers/".concat(id,"/Delete")),this.ajax({type:"POST",url:url}).then(function(result){var instance=this.instance,itemId=this.itemId;return _events.default.trigger(instance,"message",[{MessageType:"SeriesTimerCancelled",Data:{Id:itemId,IsLocalEvent:!0}}]),result}.bind({instance:this,itemId:id}));throw new Error("null id")}},{key:"createLiveTvSeriesTimer",value:function(item){var url;if(item)return url=this.getUrl("LiveTv/SeriesTimers"),this.ajax({type:"POST",url:url,dataType:this.isMinServerVersion("4.9.0.13")?"json":null,data:JSON.stringify(item),contentType:"application/json"}).then(function(result){var instance=this.instance;return result=result||{},_events.default.trigger(instance,"message",[{MessageType:"SeriesTimerCreated",Data:Object.assign({IsLocalEvent:!0},result)}]),result}.bind({instance:this}));throw new Error("null item")}},{key:"updateLiveTvSeriesTimer",value:function(item){var itemId,url;if(item)return itemId=item.Id,url=this.getUrl("LiveTv/SeriesTimers/".concat(itemId)),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"}).then(function(result){var instance=this.instance,itemId=this.itemId;return _events.default.trigger(instance,"message",[{MessageType:"SeriesTimerUpdated",Data:{Id:itemId,IsLocalEvent:!0}}]),result}.bind({instance:this,itemId:itemId}));throw new Error("null item")}},{key:"getRegistrationInfo",value:function(feature){feature=this.getUrl("Registrations/".concat(feature));return this.getJSON(feature)}},{key:"getSystemInfo",value:function(){var url=this.getUrl("System/Info"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})}},{key:"getSyncStatus",value:function(item){return isLocalId(item.Id)?Promise.resolve({}):item.SyncStatus||this.isMinServerVersion("4.8.0.53")?Promise.resolve({Status:item.SyncStatus}):(item=this.getUrl("Sync/".concat(item.Id,"/Status")),this.ajax({url:item,type:"POST",dataType:"json",contentType:"application/json",data:JSON.stringify({TargetId:this.deviceId()})}))}},{key:"getPublicSystemInfo",value:function(){var url=this.getUrl("System/Info/Public"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})}},{key:"getInstantMixFromItem",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):(itemId=this.getUrl("Items/".concat(itemId,"/InstantMix"),options),this.getJSON(itemId))}},{key:"getEpisodes",value:function(itemId,options,signal){var requiresStartItemIdPostProcess=!1,itemId=((options=options||{}).SeasonId||!options.StartItemId||this.isMinServerVersion("4.8.0.29")||(requiresStartItemIdPostProcess=!(options.Limit=null)),this.getUrl("Shows/".concat(itemId,"/Episodes"),options)),itemId=this.getJSON(itemId,signal);return requiresStartItemIdPostProcess?itemId.then(function(result){for(var index=-1,i=0,length=result.Items.length;i<length;i++)if(options.StartItemId===result.Items[i].Id){index=i;break}return-1!==index&&(result.Items=result.Items.slice(index),!1!==options.EnableTotalRecordCount)&&(result.TotalRecordCount=result.Items.length),result}):itemId}},{key:"getDisplayPreferences",value:function(userId){var instance=this;return instance.isMinServerVersion("4.9.0.23")?instance.getJSON(instance.getUrl("usersettings/"+userId)):this.getJSON(this.getUrl("DisplayPreferences/usersettings",{userId:userId,client:"emby"})).then(function(result){return instance._displayPreferencesId=result.Id,result.CustomPrefs||{}})}},{key:"updatePartialDisplayPreferences",value:function(obj,userId){if(this.isMinServerVersion("4.9.0.23"))return this.ajax({type:"POST",url:this.getUrl("usersettings/"+userId+"/Partial"),data:JSON.stringify(obj),contentType:"application/json"});throw new Error("unsupported server version")}},{key:"updateDisplayPreferences",value:function(obj,userId){return this.isMinServerVersion("4.9.0.23")?this.ajax({type:"POST",url:this.getUrl("usersettings/"+userId),data:obj,contentType:"application/json"}):this.ajax({type:"POST",url:this.getUrl("DisplayPreferences/usersettings",{userId:userId,client:"emby"}),data:JSON.stringify({CustomPrefs:obj,Client:"emby",Id:this._displayPreferencesId||"3ce5b65de116d73165d1efc4a30ec35c"}),contentType:"application/json"})}},{key:"getSeasons",value:function(itemId,options){itemId=this.getUrl("Shows/".concat(itemId,"/Seasons"),options);return this.getJSON(itemId)}},{key:"getSimilarItems",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):(itemId=this.getUrl("Items/".concat(itemId,"/Similar"),options),this.getJSON(itemId))}},{key:"getCultures",value:function(){var url=this.getUrl("Localization/cultures");return this.getJSON(url)}},{key:"getCountries",value:function(){var url=this.getUrl("Localization/countries");return this.getJSON(url)}},{key:"getPlaybackInfo",value:function(itemId,options,deviceProfile,signal){deviceProfile={DeviceProfile:deviceProfile};return this.ajax({url:this.getUrl("Items/".concat(itemId,"/PlaybackInfo"),options),type:"POST",data:JSON.stringify(deviceProfile),contentType:"application/json",dataType:"json",signal:signal})}},{key:"getLiveStreamMediaInfo",value:function(liveStreamId){liveStreamId={LiveStreamId:liveStreamId};return this.ajax({url:this.getUrl("LiveStreams/MediaInfo"),type:"POST",data:JSON.stringify(liveStreamId),contentType:"application/json",dataType:"json"})}},{key:"getIntros",value:function(itemId,signal){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):this.getJSON(this.getUrl("Users/".concat(this.getCurrentUserId(),"/Items/").concat(itemId,"/Intros")),signal)}},{key:"getDirectoryContents",value:function(path,options){if(!path)throw new Error("null path");if("string"!=typeof path)throw new Error("invalid path");return(options=options||{}).path=path,this.isMinServerVersion("4.8.0.53")?this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",dataType:"json",url:this.getUrl("Environment/DirectoryContents")}):this.getJSON(this.getUrl("Environment/DirectoryContents",options))}},{key:"getNetworkShares",value:function(path){var options;if(path)return(options={}).path=path,path=this.getUrl("Environment/NetworkShares",options),this.getJSON(path);throw new Error("null path")}},{key:"getParentPath",value:function(path){var options;if(path)return(options={}).path=path,path=this.getUrl("Environment/ParentPath",options),this.ajax({type:"GET",url:path,dataType:"text"});throw new Error("null path")}},{key:"getDrives",value:function(){var url=this.getUrl("Environment/Drives");return this.getJSON(url)}},{key:"getNetworkDevices",value:function(){var url=this.getUrl("Environment/NetworkDevices");return this.getJSON(url)}},{key:"getActivityLog",value:function(options){var options=this.getUrl("System/ActivityLog/Entries",options||{}),serverId=this.serverId();return this.getJSON(options).then(function(result){for(var items=result.Items,i=0,length=items.length;i<length;i++){var item=items[i];item.Type="ActivityLogEntry",item.ServerId=serverId}return result})}},{key:"cancelPackageInstallation",value:function(installationId){if(installationId)return installationId=this.getUrl("Packages/Installing/".concat(installationId,"/Delete")),this.ajax({type:"POST",url:installationId});throw new Error("null installationId")}},{key:"refreshItems",value:function(items,options){var instance;if(items)return instance=this,Promise.all(items.map(function(item){return instance.ajax({type:"POST",url:instance.getUrl("Items/".concat(item.Id,"/Refresh"),options)})}));throw new Error("null items")}},{key:"installPlugin",value:function(name,guid,updateClass,version){if(!name)throw new Error("null name");if(updateClass)return updateClass={updateClass:updateClass,AssemblyGuid:guid},version&&(updateClass.version=version),guid=this.getUrl("Packages/Installed/".concat(name),updateClass),this.ajax({type:"POST",url:guid});throw new Error("null updateClass")}},{key:"restartServer",value:function(){var url=this.getUrl("System/Restart");return this.ajax({type:"POST",url:url})}},{key:"shutdownServer",value:function(){var url=this.getUrl("System/Shutdown");return this.ajax({type:"POST",url:url})}},{key:"getPackageInfo",value:function(name,guid){if(name)return guid={AssemblyGuid:guid},name=this.getUrl("Packages/".concat(name),guid),this.getJSON(name);throw new Error("null name")}},{key:"getAvailableApplicationUpdate",value:function(){var url=this.getUrl("Packages/Updates",{PackageType:"System"});return this.getJSON(url)}},{key:"getAvailablePluginUpdates",value:function(){var url=this.getUrl("Packages/Updates",{PackageType:"UserInstalled"});return this.getJSON(url)}},{key:"getVirtualFolders",value:function(query,signal){var serverId=this.serverId();return this.getJSON(this.getUrl("Library/VirtualFolders/Query",query="string"==typeof query?{userId:query}:query),signal).then(function(result){for(var i=0,length=result.Items.length;i<length;i++){var item=result.Items[i];!function(item){item.Type="VirtualFolder",item.Id=item.ItemId,item.IsFolder=!0}(item),item.ServerId=serverId}return result})}},{key:"getPhysicalPaths",value:function(){var url=this.getUrl("Library/PhysicalPaths");return this.getJSON(url)}},{key:"getServerConfiguration",value:function(){var url=this.getUrl("System/Configuration");return this.getJSON(url)}},{key:"getDevices",value:function(query){var instance=this;return this.getJSON(this.getUrl("Devices",query)).then(function(result){for(var item,apiClient,iconUrl,i=0,length=result.Items.length;i<length;i++)item=result.Items[i],apiClient=instance,iconUrl=void 0,item.Type="Device",item.ServerId=apiClient.serverId(),item.PrimaryImageAspectRatio=1,(iconUrl=item.IconUrl)&&-1===iconUrl.indexOf("://")&&(iconUrl=apiClient.getUrl(iconUrl)),item.ImageUrl=iconUrl;return result})}},{key:"getDevicesOptions",value:function(){var url=this.getUrl("System/Configuration/devices");return this.getJSON(url)}},{key:"getContentUploadHistory",value:function(){var url=this.getUrl("Devices/CameraUploads",{DeviceId:this.deviceId()});return this.getJSON(url)}},{key:"getNamedConfiguration",value:function(name){name=this.getUrl("System/Configuration/".concat(name));return this.getJSON(name)}},{key:"getHardwareAccelerations",value:function(){var url=this.getUrl("Encoding/HardwareAccelerations");return this.getJSON(url)}},{key:"getVideoCodecInformation",value:function(){var url=this.getUrl("Encoding/CodecInformation/Video");return this.getJSON(url)}},{key:"getScheduledTasks",value:function(){var url=this.getUrl("ScheduledTasks",0<arguments.length&&void 0!==arguments[0]?arguments[0]:{}),instance=this;return this.getJSON(url).then(function(result){for(var i=0,length=result.length;i<length;i++)setScheduledTaskProperties(result[i],instance);return result})}},{key:"startScheduledTask",value:function(id){if(id)return id=this.getUrl("ScheduledTasks/Running/".concat(id)),this.ajax({type:"POST",url:id});throw new Error("null id")}},{key:"getScheduledTask",value:function(id){var instance;if(id)return id=(instance=this).getUrl("ScheduledTasks/".concat(id)),this.getJSON(id).then(function(result){return setScheduledTaskProperties(result,instance),result});throw new Error("null id")}},{key:"getNextUpAudioBookItems",value:function(options,signal){return options.AlbumId&&isLocalId(options.AlbumId)?Promise.resolve({Items:[],TotalRecordCount:0}):(options=this.getUrl("AudioBooks/NextUp",options),this.getJSON(options,signal))}},{key:"getNextUpEpisodes",value:function(options,signal){return options.SeriesId&&isLocalId(options.SeriesId)?Promise.resolve({Items:[],TotalRecordCount:0}):(options=this.getUrl("Shows/NextUp",options),this.getJSON(options,signal))}},{key:"stopScheduledTask",value:function(id){if(id)return id=this.getUrl("ScheduledTasks/Running/".concat(id,"/Delete")),this.ajax({type:"POST",url:id});throw new Error("null id")}},{key:"getPluginConfiguration",value:function(id){if(id)return id=this.getUrl("Plugins/".concat(id,"/Configuration")),this.getJSON(id);throw new Error("null Id")}},{key:"getAvailablePlugins",value:function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},options=(options.PackageType="UserInstalled",this.getUrl("Packages",options));return this.getJSON(options)}},{key:"uninstallPlugin",value:function(id){if(id)return this.uninstallPlugins([{Id:id}]);throw new Error("null Id")}},{key:"uninstallPluginSingle",value:function(id){if(id)return id=this.getUrl("Plugins/".concat(id,"/Delete")),this.ajax({type:"POST",url:id});throw new Error("null Id")}},{key:"uninstallPlugins",value:function(items){return Promise.all(items.map(mapToId).map(this.uninstallPluginSingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"PluginsUninstalled",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))}},{key:"removeVirtualFolder",value:function(virtualFolder,refreshLibrary){var instance,id,url;if(virtualFolder)return id=virtualFolder.Id,url=(instance=this).getUrl(url="Library/VirtualFolders/Delete",{refreshLibrary:!!refreshLibrary,id:id,name:virtualFolder.Name}),this.ajax({type:"POST",url:url}).then(onItemsDeleted.bind({instance:this,items:[virtualFolder]})).then(function(){instance._userViewsPromise=null});throw new Error("null virtualFolder")}},{key:"addVirtualFolder",value:function(name,type,refreshLibrary,libraryOptions){var options,instance;if(name)return options={},type&&(options.collectionType=type),options.refreshLibrary=!!refreshLibrary,options.name=name,type=this.getUrl(type="Library/VirtualFolders",options),(instance=this).ajax({type:"POST",url:type,data:JSON.stringify({LibraryOptions:libraryOptions}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null});throw new Error("null name")}},{key:"updateVirtualFolderOptions",value:function(id,libraryOptions){var url,instance;if(id)return url=this.getUrl(url="Library/VirtualFolders/LibraryOptions"),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify({Id:id,LibraryOptions:libraryOptions}),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:id})).then(function(){instance._userViewsPromise=null});throw new Error("null name")}},{key:"renameVirtualFolder",value:function(virtualFolder,newName,refreshLibrary){var url,instance;if(virtualFolder)return url=this.getUrl(url="Library/VirtualFolders/Name",{refreshLibrary:!!refreshLibrary,newName:newName,name:virtualFolder.Name,Id:virtualFolder.Id}),(instance=this).ajax({type:"POST",url:url}).then(onItemUpdated.bind({instance:this,itemId:virtualFolder.Id})).then(function(){instance._userViewsPromise=null});throw new Error("null virtualFolder")}},{key:"addMediaPath",value:function(virtualFolder,pathInfo,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var url,instance;if(pathInfo)return url=this.getUrl(url="Library/VirtualFolders/Paths",{refreshLibrary:!!refreshLibrary}),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null});throw new Error("null pathInfo")}},{key:"updateMediaPath",value:function(virtualFolder,pathInfo){if(!virtualFolder)throw new Error("null virtualFolder");var url,instance;if(pathInfo)return url=this.getUrl(url="Library/VirtualFolders/Paths/Update"),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null});throw new Error("null pathInfo")}},{key:"removeMediaPath",value:function(virtualFolder,mediaPath,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var instance,url;if(mediaPath)return url=(instance=this).getUrl(url="Library/VirtualFolders/Paths/Delete",{refreshLibrary:!!refreshLibrary,path:mediaPath,name:virtualFolder.Name,Id:virtualFolder.Id}),this.ajax({type:"POST",url:url}).then(function(){instance._userViewsPromise=null});throw new Error("null mediaPath")}},{key:"deleteUserSingle",value:function(id){var serverId,instance,url;if(id)return serverId=this.serverId(),url=(instance=this).getUrl("Users/".concat(id,"/Delete")),this.ajax({type:"POST",url:url}).then(function(){!function(userId,serverId){_servicelocator.appStorage.removeItem(getUserCacheKey(userId,serverId))}(id,serverId),instance._userViewsPromise=null});throw new Error("null id")}},{key:"deleteUsers",value:function(items){return Promise.all(items.map(mapToId).map(this.deleteUserSingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"UsersDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))}},{key:"deleteUser",value:function(id){return this.deleteUser([{Id:id}])}},{key:"deleteUserImage",value:function(userId,imageType,imageIndex){if(!userId)throw new Error("null userId");var instance;if(imageType)return imageType=this.getUrl("Users/".concat(userId,"/Images/").concat(imageType)),null!=imageIndex&&(imageType+="/".concat(imageIndex)),(instance=this).ajax({type:"POST",url:imageType+="/Delete"}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null imageType")}},{key:"deleteItemImage",value:function(itemId,imageType,imageIndex){var url;if(imageType)return url=this.getUrl("Items/".concat(itemId,"/Images")),url+="/".concat(imageType),null!=imageIndex&&(url+="/".concat(imageIndex)),this.ajax({type:"POST",url:url+="/Delete"}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null imageType")}},{key:"deleteItems",value:function(items){return this.deleteItemsInternal(items).then(onItemsDeleted.bind({instance:this,items:items}))}},{key:"deleteItemsInternal",value:function(items){if(items)return items=items.map(mapToId).filter(isNotLocalId),this.ajax({type:"POST",url:this.getUrl("Items/Delete",{Ids:items.join(",")})});throw new Error("null itemId")}},{key:"stopActiveEncodings",value:function(playSessionId){var options={deviceId:this.deviceId()},playSessionId=(playSessionId&&(options.PlaySessionId=playSessionId),this.getUrl("Videos/ActiveEncodings/Delete",options));return this.ajax({type:"POST",url:playSessionId})}},{key:"reportCapabilities",value:function(options){var url=this.getUrl("Sessions/Capabilities/Full");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"})}},{key:"updateItemImageFromUrl",value:function(itemId,imageType,imageIndex,imageUrl){if(imageType)return imageIndex=imageIndex||0,this.ajax({type:"POST",url:this.getUrl("Items/".concat(itemId,"/Images/").concat(imageType,"/").concat(imageIndex,"/Url"),{}),data:JSON.stringify({Url:imageUrl}),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null imageType")}},{key:"updateItemImageIndex",value:function(itemId,imageType,imageIndex,newIndex){if(imageType)return newIndex={newIndex:newIndex},imageIndex=imageIndex||0,imageType=this.getUrl("Items/".concat(itemId,"/Images/").concat(imageType,"/").concat(imageIndex,"/Index"),newIndex),this.ajax({type:"POST",url:imageType}).then(onItemUpdated.bind({instance:this,itemId:itemId}));throw new Error("null imageType")}},{key:"getItemImageInfos",value:function(itemId){itemId=this.getUrl("Items/".concat(itemId,"/Images"));return this.getJSON(itemId)}},{key:"getCriticReviews",value:function(itemId,options){if(itemId)return itemId=this.getUrl("Items/".concat(itemId,"/CriticReviews"),options),this.getJSON(itemId);throw new Error("null itemId")}},{key:"getItemDownloadUrl",value:function(itemId,mediaSourceId,serverAddress){if(itemId)return itemId="Items/".concat(itemId,"/Download"),this.getUrl(itemId,{api_key:this.accessToken(),mediaSourceId:mediaSourceId},serverAddress);throw new Error("itemId cannot be empty")}},{key:"getSessions",value:function(options){options=this.getUrl("Sessions",options);return this.getJSON(options)}},{key:"uploadUserImage",value:function(userId,imageType,file){if(!userId)throw new Error("null userId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var instance=this;return new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(_ref3){var _ref3=_ref3.target.result.split(",")[1],url=instance.getUrl("Users/".concat(userId,"/Images/").concat(imageType));instance.ajax({type:"POST",url:url,data:_ref3,contentType:"image/".concat(file.name.substring(file.name.lastIndexOf(".")+1))}).then(function(){updateCachedUser(instance,userId).then(resolve,reject)},reject)},reader.readAsDataURL(file)})}},{key:"uploadItemImage",value:function(itemId,imageType,imageIndex,file){if(!itemId)throw new Error("null itemId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var url=this.getUrl("Items/".concat(itemId,"/Images")),instance=(url+="/".concat(imageType),this);return null!=imageIndex&&(url+="?Index="+imageIndex),new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(_ref4){_ref4=_ref4.target.result.split(",")[1];instance.ajax({type:"POST",url:url,data:_ref4,contentType:"image/".concat(file.name.substring(file.name.lastIndexOf(".")+1))}).then(function(result){onItemUpdated.call({instance:instance,itemId:itemId}),resolve(result)},reject)},reader.readAsDataURL(file)})}},{key:"getInstalledPlugins",value:function(){var url=this.getUrl("Plugins",{});return this.getJSON(url)}},{key:"getCurrentUserCached",value:function(){return getCachedUser(this,this.getCurrentUserId())}},{key:"getUser",value:function(id,enableCache,signal){var cachedUser,instance,url;if(id)return!1!==enableCache&&(cachedUser=getCachedUser(this,id))&&Date.now()-(cachedUser.DateLastFetched||0)<=6e4||(url=(instance=this).getUrl("Users/".concat(id)),url=this.getJSON(url,signal).then(function(user){return saveUserInCache(instance,user),user},function(response){if((!signal||!signal.aborted)&&(!response||!response.status)&&instance.isLoggedIn()){var user=getCachedUser(instance,id);if(user)return Promise.resolve(user)}throw response}),!1!==enableCache&&cachedUser)?Promise.resolve(cachedUser):url;throw new Error("Must supply a userId")}},{key:"getStudio",value:function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Studios/".concat(this.encodeName(name)),options),this.getJSON(userId);throw new Error("null name")}},{key:"getGenre",value:function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Genres/".concat(this.encodeName(name)),options),this.getJSON(userId);throw new Error("null name")}},{key:"getMusicGenre",value:function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("MusicGenres/".concat(this.encodeName(name)),options),this.getJSON(userId);throw new Error("null name")}},{key:"getGameGenre",value:function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("GameGenres/".concat(this.encodeName(name)),options),this.getJSON(userId);throw new Error("null name")}},{key:"getArtist",value:function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Artists/".concat(this.encodeName(name)),options),this.getJSON(userId);throw new Error("null name")}},{key:"getPerson",value:function(name,userId){var options;if(name)return options={},userId&&(options.userId=userId),userId=this.getUrl("Persons/".concat(this.encodeName(name)),options),this.getJSON(userId);throw new Error("null name")}},{key:"getPublicUsersQueryResult",value:function(query,signal){var serverId=this.serverId(),url=this.getUrl("users/public");return this.ajax({type:"GET",url:url,dataType:"json",signal:signal},!1).then(function(users){return setUsersProperties(users,serverId),users}).then(function(users){var totalRecordCount=users.length;return query&&(users=users.slice(query.StartIndex||0),query.Limit)&&users.length>query.Limit&&(users.length=query.Limit),{Items:users,TotalRecordCount:totalRecordCount}})}},{key:"getPublicUsers",value:function(){return this.getPublicUsersQueryResult({}).then(function(result){return result.Items})}},{key:"getUsersQueryResult",value:function(query,signal){var serverId=this.serverId();return this.getJSON(this.getUrl("Users/Query",query),signal).then(function(result){return setUsersProperties(result.Items,serverId),result})}},{key:"getUsersForItemAccess",value:function(query,signal){var serverId=this.serverId();return this.getJSON(this.getUrl("Users/ItemAccess",query),signal).then(function(result){return setUsersProperties(result.Items,serverId),result})}},{key:"getUsers",value:function(query,signal){return this.getUsersQueryResult(query,signal).then(function(result){return result.Items})}},{key:"getUserPrefixes",value:function(query,signal){return this.getJSON(this.getUrl("Users/Prefixes",query),signal)}},{key:"getApiKeys",value:function(query,signal){var instance=this;return this.getJSON(this.getUrl("Auth/Keys",query),signal).then(function(result){return function(instance,response){for(var serverId=instance.serverId(),i=0,length=response.Items.length;i<length;i++){var log=response.Items[i];log.ServerId=serverId,log.Type="ApiKey",log.CanDelete=!0}}(instance,result),result})}},{key:"getLogs",value:function(query,signal){var instance=this;return this.getJSON(this.getUrl("System/Logs/Query",query),signal).then(function(result){return function(instance,items){for(var serverId=instance.serverId(),canDownload=_servicelocator.appHost.supports("filedownload"),i=0,length=items.length;i<length;i++){var log=items[i];log.ServerId=serverId,log.Type="Log",log.Id=log.Name,log.CanDownload=canDownload,log.CanShare=!1}}(instance,result.Items),result})}},{key:"getLogDownloadUrl",value:function(_ref5){var Name=_ref5.Name,Sanitize=_ref5.Sanitize,_ref5=_ref5.SetFilename;return this.getUrl("System/Logs/".concat(Name),{Sanitize:Sanitize,api_key:this.accessToken(),SetFilename:_ref5})}},{key:"getLogLines",value:function(options,signal){var name=options.name,name=(options.name=null,this.getUrl("System/Logs/".concat(name,"/Lines"),options||{}));return this.getJSON(name,signal)}},{key:"getParentalRatings",value:function(){var url=this.getUrl("Localization/ParentalRatings");return this.getJSON(url)}},{key:"getDefaultImageSizes",value:function(){return StandardWidths.slice(0)}},{key:"getImageUrls",value:function(itemId,imageOptions,sourceOptions){for(var sources=[],originalImageOptions=imageOptions,widths=(null==sourceOptions?void 0:sourceOptions.widths)||StandardWidths,i=0,length=widths.length;i<length;i++)(imageOptions=Object.assign({},originalImageOptions)).adjustForPixelRatio=!1,imageOptions.maxWidth=widths[i],sources.push({url:this.getImageUrl(itemId,imageOptions),width:imageOptions.maxWidth});return sources}},{key:"getImageUrl",value:function(itemId,options){if(!itemId)throw new Error("itemId cannot be empty");options=options||{};itemId="Items/".concat(itemId,"/Images/").concat(options.type);return null!=options.index&&(itemId+="/".concat(options.index)),normalizeImageOptions(this,options),delete options.type,delete options.index,this.getUrl(itemId,options)}},{key:"getLogoImageUrl",value:function(item,options,preferredLogoImageTypes){for(var i=0,length=(preferredLogoImageTypes=preferredLogoImageTypes||["LogoLightColor","LogoLight","Logo"]).length;i<length;i++){var logoType=preferredLogoImageTypes[i];if(item.ImageTags&&item.ImageTags[logoType])return options.type=logoType,options.tag=item.ImageTags[logoType],this.getImageUrl(item.Id,options)}return item.ParentLogoImageTag?(options.tag=item.ParentLogoImageTag,options.type="Logo",this.getImageUrl(item.ParentLogoItemId,options)):("TvChannel"===item.Type||"ChannelManagementInfo"===item.Type)&&item.ImageTags&&item.ImageTags.Primary?(options.tag=item.ImageTags.Primary,options.type="Primary",this.getImageUrl(item.Id,options)):null}},{key:"getUserImageUrl",value:function(userId,options){if(!userId)throw new Error("null userId");options=options||{};userId="Users/".concat(userId,"/Images/").concat(options.type);return null!=options.index&&(userId+="/".concat(options.index)),normalizeImageOptions(this,options),delete options.type,delete options.index,this.getUrl(userId,options)}},{key:"getThumbImageUrl",value:function(item,options){if(item)return(options=options||{}).imageType="thumb",item.ImageTags&&item.ImageTags.Thumb?(options.tag=item.ImageTags.Thumb,this.getImageUrl(item.Id,options)):item.ParentThumbItemId?(options.tag=item.ImageTags.ParentThumbImageTag,this.getImageUrl(item.ParentThumbItemId,options)):null;throw new Error("null item")}},{key:"updateUserPassword",value:function(userId,currentPassword,newPassword){var url,instance;return userId?(url=this.getUrl("Users/".concat(userId,"/Password")),(instance=this).ajax({type:"POST",url:url,data:{CurrentPw:currentPassword||"",NewPw:newPassword}}).then(function(){return updateCachedUser(instance,userId)})):Promise.reject()}},{key:"updateProfilePin",value:function(userId,pin){return this.updatePartialUserConfiguration(userId,{ProfilePin:pin||null})}},{key:"updateEasyPassword",value:function(userId,newPassword){var url,instance=this;return!instance.isMinServerVersion("4.8.0.40")&&userId?(url=this.getUrl("Users/".concat(userId,"/EasyPassword")),this.ajax({type:"POST",url:url,data:{NewPw:newPassword}}).then(function(){return updateCachedUser(instance,userId)})):Promise.reject()}},{key:"resetUserPassword",value:function(userId){var url,instance;if(userId)return url=this.getUrl("Users/".concat(userId,"/Password")),(instance=this).ajax({type:"POST",url:url,data:{resetPassword:!0}}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null userId")}},{key:"resetEasyPassword",value:function(userId){var url,instance;if(userId)return url=this.getUrl("Users/".concat(userId,"/EasyPassword")),(instance=this).ajax({type:"POST",url:url,data:{resetPassword:!0}}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null userId")}},{key:"updateServerConfiguration",value:function(configuration){var url;if(configuration)return url=this.getUrl("System/Configuration"),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")}},{key:"updatePartialServerConfiguration",value:function(configuration){var url,instance=this;if(!instance.isMinServerVersion("4.8.8"))return instance.getServerConfiguration().then(function(serverConfiguration){return serverConfiguration=Object.assign(serverConfiguration,configuration),instance.updateServerConfiguration(serverConfiguration)});if(configuration)return url=this.getUrl("System/Configuration/Partial"),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")}},{key:"updateNamedConfiguration",value:function(name,configuration){if(configuration)return name=this.getUrl("System/Configuration/".concat(name)),this.ajax({type:"POST",url:name,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")}},{key:"getTypedUserSettings",value:function(userId,key){userId=this.getUrl("Users/".concat(userId,"/TypedSettings/").concat(key));return this.getJSON(userId)}},{key:"updateTypedUserSettings",value:function(userId,key,configuration){if(configuration)return userId=this.getUrl("Users/".concat(userId,"/TypedSettings/").concat(key)),this.ajax({type:"POST",url:userId,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")}},{key:"getTunerHostConfiguration",value:function(id){return this.getNamedConfiguration("livetv").then(function(config){return config.TunerHosts.filter(function(i){return i.Id===id})[0]})}},{key:"saveTunerHostConfiguration",value:function(tunerHostInfo){return this.ajax({type:"POST",url:this.getUrl("LiveTv/TunerHosts"),data:JSON.stringify(tunerHostInfo),contentType:"application/json",dataType:"json"})}},{key:"getDefaultTunerHostConfiguration",value:function(type){return this.getJSON(this.getUrl("LiveTv/TunerHosts/Default/"+type))}},{key:"updateItem",value:function(item){var url;if(item)return url=this.getUrl("Items/".concat(item.Id)),this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:item.Id}));throw new Error("null item")}},{key:"updatePluginSecurityInfo",value:function(info){var url=this.getUrl("Plugins/SecurityInfo");return this.ajax({type:"POST",url:url,data:JSON.stringify(info),contentType:"application/json"})}},{key:"createUser",value:function(options){var url=this.getUrl("Users/New");return this.ajax({type:"POST",url:url,data:options,dataType:"json"})}},{key:"updateUser",value:function(user){var url;if(user)return url=this.getUrl("Users/".concat(user.Id)),this.ajax({type:"POST",url:url,data:JSON.stringify(user),contentType:"application/json"});throw new Error("null user")}},{key:"updateUserPolicy",value:function(userId,policy){if(!userId)throw new Error("null userId");var url,instance;if(policy)return url=this.getUrl("Users/".concat(userId,"/Policy")),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify(policy),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),updateCachedUser(instance,userId)});throw new Error("null policy")}},{key:"updateUserConfiguration",value:function(userId,configuration){if(!userId)throw new Error("null userId");var url,instance;if(configuration)return url=this.getUrl("Users/".concat(userId,"/Configuration")),(instance=this).ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),updateCachedUser(instance,userId)});throw new Error("null configuration")}},{key:"updatePartialUserConfiguration",value:function(userId,configuration){var url,instance=this;if(!instance.isMinServerVersion("4.8.0.48"))return instance.getUser(userId).then(function(user){return user.Configuration=Object.assign(user.Configuration,configuration),instance.updateUserConfiguration(userId,user.Configuration)});if(!userId)throw new Error("null userId");if(configuration)return url=this.getUrl("Users/".concat(userId,"/Configuration/Partial")),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),function(instance,userId,config){var user=getCachedUser(instance,userId);return user?(user.Configuration=Object.assign(user.Configuration,config||{}),saveUserInCache(instance,user),Promise.resolve()):updateCachedUser(instance,userId)}(instance,userId,configuration)});throw new Error("null configuration")}},{key:"updateScheduledTaskTriggers",value:function(id,triggers){if(!id)throw new Error("null id");if(!triggers)throw new Error("null triggers");for(var i=0,length=(triggers=JSON.parse(JSON.stringify(triggers))).length;i<length;i++){var trigger=triggers[i];trigger.TriggerType&&(trigger.Type=trigger.TriggerType)}id=this.getUrl("ScheduledTasks/".concat(id,"/Triggers"));return this.ajax({type:"POST",url:id,data:JSON.stringify(triggers),contentType:"application/json"}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"ScheduledTaskTriggersUpdated",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:triggers}))}},{key:"updatePluginConfiguration",value:function(id,configuration){if(!id)throw new Error("null Id");if(configuration)return id=this.getUrl("Plugins/".concat(id,"/Configuration")),this.ajax({type:"POST",url:id,data:JSON.stringify(configuration),contentType:"application/json"});throw new Error("null configuration")}},{key:"getAncestorItems",value:function(itemId,userId){var options;if(itemId)return options={},userId&&(options.userId=userId),userId=this.getUrl("Items/".concat(itemId,"/Ancestors"),options),this.getJSON(userId);throw new Error("null itemId")}},{key:"getItems",value:function(userId,options,signal){return options&&null!=options.IsNewOrPremiere&&!this.isMinServerVersion("4.8.0.48")?Promise.resolve({Items:[],TotalRecordCount:0}):(userId="string"===(typeof userId).toString().toLowerCase()?this.getUrl("Users/".concat(userId,"/Items"),options):this.getUrl("Items",options),this.getJSON(userId,signal))}},{key:"getLiveTvChannelTags",value:function(options,signal){(options=options||{}).UserId=this.getCurrentUserId();options=this.getUrl("LiveTv/ChannelTags",options);return this.getJSON(options,signal)}},{key:"getLiveTvChannelTagPrefixes",value:function(options,signal){(options=options||{}).UserId=this.getCurrentUserId();options=this.getUrl("LiveTv/ChannelTags/Prefixes",options);return this.getJSON(options,signal)}},{key:"getResumableItems",value:function(userId,options,signal){return this.getJSON(this.getUrl("Users/".concat(userId,"/Items/Resume"),options),signal)}},{key:"getMovieRecommendations",value:function(options,signal){return this.getJSON(this.getUrl("Movies/Recommendations",options),signal)}},{key:"getUpcomingEpisodes",value:function(options,signal){return this.getJSON(this.getUrl("Shows/Upcoming",options),signal)}},{key:"getMissingEpisodes",value:function(options,signal){return this.isMinServerVersion("4.8.0.59")?this.getJSON(this.getUrl("Shows/Missing",options),signal):Promise.resolve({Items:[],TotalRecordCount:0})}},{key:"getUserViews",value:function(options,userId,signal){var self,currentUserId=this.getCurrentUserId(),currentUserId=!((userId=userId||currentUserId)!==currentUserId||options&&options.IncludeHidden);return currentUserId&&this._userViewsPromise?this._userViewsPromise:(userId=this.getUrl("Users/".concat(userId,"/Views"),options),options=(self=this).getJSON(userId,signal).catch(function(err){return self._userViewsPromise=null,Promise.reject(err)}),currentUserId&&(this._userViewsPromise=options),options)}},{key:"getArtists",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Artists",options);return this.getJSON(userId)}},{key:"getAlbumArtists",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Artists/AlbumArtists",options);return this.getJSON(userId)}},{key:"getGenres",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Genres",options);return this.getJSON(userId)}},{key:"getMusicGenres",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("MusicGenres",options);return this.getJSON(userId)}},{key:"getGameGenres",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("GameGenres",options);return this.getJSON(userId)}},{key:"getPeople",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Persons",options);return this.getJSON(userId)}},{key:"getThumbnails",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve({Thumbnails:[]}):(itemId=this.getUrl("Items/".concat(itemId,"/ThumbnailSet"),options),this.getJSON(itemId))}},{key:"getDeleteInfo",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve({Paths:[]}):(itemId=this.getUrl("Items/".concat(itemId,"/DeleteInfo"),options),this.getJSON(itemId))}},{key:"getStudios",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Studios",options);return this.getJSON(userId)}},{key:"getOfficialRatings",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("OfficialRatings",options);return this.getJSON(userId)}},{key:"getYears",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Years",options);return this.getJSON(userId)}},{key:"getTags",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Tags",options),options=this.getJSON(userId),userId=function(result){for(var serverId=this.serverId(),items=result.Items||result,i=0,length=items.length;i<length;i++){var item=items[i];item.ServerId=serverId,item.Type="Tag"}return result}.bind(this);return options.then(userId)}},{key:"getItemTypes",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("ItemTypes",options);return this.getJSON(userId)}},{key:"getContainers",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Containers",options);return this.getJSON(userId)}},{key:"getAudioCodecs",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("AudioCodecs",options);return this.getJSON(userId)}},{key:"getAudioLayouts",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("AudioLayouts",options),userId=this.getJSON(userId);return this.isMinServerVersion("4.8.0.23")?userId:function(promise,query){return promise.then(function(result){var outerIds=query.OuterIds?query.OuterIds.split(","):[];return outerIds.length&&(result.Items=result.Items.filter(function(i){return outerIds.includes(i.Id)})),result.TotalRecordCount||!1===query.EnableTotalRecordCount||(result.TotalRecordCount=result.Items.length),result})}(userId,options)}},{key:"getStreamLanguages",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("StreamLanguages",options);return this.getJSON(userId)}},{key:"getVideoCodecs",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("VideoCodecs",options);return this.getJSON(userId)}},{key:"getExtendedVideoTypes",value:function(userId,options){if(!this.isMinServerVersion("4.8.0.47"))return Promise.resolve({Items:[],TotalRecordCount:0});if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("ExtendedVideoTypes",options);return this.getJSON(userId)}},{key:"getSubtitleCodecs",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("SubtitleCodecs",options);return this.getJSON(userId)}},{key:"getPrefixes",value:function(userId,options){if(userId)return(options=options||{}).userId=userId,isLocalId(options.ParentId)||isLocalId(options.GenreIds)||isLocalId(options.ArtistIds)||isLocalId(options.StudioIds)?Promise.resolve([]):(userId=this.getUrl("Items/Prefixes",options),this.getJSON(userId));throw new Error("null userId")}},{key:"getArtistPrefixes",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;userId=this.getUrl("Artists/Prefixes",options);return this.getJSON(userId)}},{key:"getLocalTrailers",value:function(userId,itemId){if(!userId)throw new Error("null userId");if(itemId)return userId=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/LocalTrailers")),this.getJSON(userId);throw new Error("null itemId")}},{key:"getAllTrailers",value:function(query,item){return(item.LocalTrailerCount&&!1!==query.LocalTrailers?this.getLocalTrailers(this.getCurrentUserId(),item.Id):Promise.resolve([])).then(function(localTrailers){var trailers=localTrailers.splice(0);if(item.RemoteTrailers&&!1!==query.RemoteTrailers)for(var i=0,length=item.RemoteTrailers.length;i<length;i++)trailers.push(item.RemoteTrailers[i]);var localTrailers=(((item.MediaSources||[])[0]||{}).MediaStreams||[]).filter(function(i){return"Video"===i.Type})[0]||{},aspect=null;localTrailers.Width&&localTrailers.Height&&(aspect=localTrailers.Width/localTrailers.Height);for(var _i=0,_length=trailers.length;_i<_length;_i++){var trailer=trailers[_i];trailer.Name||(trailer.Name="Trailer: "+item.Name),trailer.Type||(trailer.Type="Trailer"),trailer.ServerId||(trailer.ServerId=item.ServerId),trailer.MediaType||(trailer.MediaType="Video"),trailer.PrimaryImageAspectRatio||(trailer.PrimaryImageAspectRatio=aspect),trailer.ImageTags&&trailer.ImageTags.Thumb||(item.ImageTags&&item.ImageTags.Thumb?(trailer.ParentThumbItemId=item.Id,trailer.ParentThumbImageTag=item.ImageTags.Thumb):(trailer.ParentThumbItemId=item.ParentThumbItemId,trailer.ParentThumbImageTag=item.ParentThumbImageTag)),trailer.ParentBackdropImageTags&&trailer.ParentBackdropImageTags.length||(trailer.ParentBackdropItemId=item.Id,trailer.ParentBackdropImageTags=item.BackdropImageTags)}localTrailers=trailers.length;return query&&(trailers=trailers.slice(query.StartIndex||0),query.Limit)&&trailers.length>query.Limit&&(trailers.length=query.Limit),Promise.resolve({Items:trailers,TotalRecordCount:localTrailers})})}},{key:"getGameSystems",value:function(){var options={},userId=this.getCurrentUserId(),userId=(userId&&(options.userId=userId),this.getUrl("Games/SystemSummaries",options));return this.getJSON(userId)}},{key:"getAdditionalVideoParts",value:function(userId,itemId){var options;if(itemId)return isLocalId(itemId)?Promise.resolve([]):(options={},userId&&(options.userId=userId),userId=this.getUrl("Videos/".concat(itemId,"/AdditionalParts"),options),this.getJSON(userId));throw new Error("null itemId")}},{key:"getThemeMedia",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve({ThemeVideosResult:{Items:[],TotalRecordCount:0},ThemeSongsResult:{Items:[],TotalRecordCount:0}}):(itemId=this.getUrl("Items/".concat(itemId,"/ThemeMedia"),options),this.getJSON(itemId))}},{key:"getAudioStreamUrl",value:function(_ref6,_ref7,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){var _ref6=_ref6.Id,Container=_ref7.Container,Protocol=_ref7.Protocol,_ref7=_ref7.AudioCodec,_ref6="Audio/".concat(_ref6,"/universal");return startingPlaySession++,this.getUrl(_ref6,{UserId:this.getCurrentUserId(),DeviceId:this.deviceId(),MaxStreamingBitrate:maxBitrate,Container:directPlayContainers,TranscodingContainer:Container||null,TranscodingProtocol:Protocol||null,AudioCodec:_ref7,MaxAudioSampleRate:maxAudioSampleRate,MaxAudioBitDepth:maxAudioBitDepth,api_key:this.accessToken(),PlaySessionId:startingPlaySession,StartTimeTicks:startPosition||0,EnableRedirection:!0,EnableRemoteMedia:enableRemoteMedia})}},{key:"getAudioStreamUrls",value:function(items,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){for(var streamUrls=[],i=0,length=items.length;i<length;i++){var item=items[i],streamUrl=void 0;"Audio"===item.MediaType&&(streamUrl=this.getAudioStreamUrl(item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia)),streamUrls.push(streamUrl||""),0===i&&(startPosition=0)}return Promise.resolve(streamUrls)}},{key:"getSpecialFeatures",value:function(userId,itemId,options){if(!userId)throw new Error("null userId");if(itemId)return isLocalId(itemId)?Promise.resolve([]):(userId=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/SpecialFeatures"),options),this.getJSON(userId));throw new Error("null itemId")}},{key:"getDateParamValue",value:function(date){function formatDigit(i){return i<10?"0".concat(i):i}return"".concat(date.getFullYear()).concat(formatDigit(date.getMonth()+1)).concat(formatDigit(date.getDate())).concat(formatDigit(date.getHours())).concat(formatDigit(date.getMinutes())).concat(formatDigit(date.getSeconds()))}},{key:"markPlayed",value:function(userId,itemIds,date){if(!userId)throw new Error("null userId");var instance;if(itemIds)return instance=this,itemIds=itemIds.filter(isNotLocalId),Promise.all(itemIds.map(function(itemId){var options={},options=(date&&(options.DatePlayed=instance.getDateParamValue(date)),instance.getUrl("Users/".concat(userId,"/PlayedItems/").concat(itemId),options));return instance.ajax({type:"POST",url:options,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")}},{key:"markUnplayed",value:function(userId,itemIds){if(!userId)throw new Error("null userId");var instance;if(itemIds)return instance=this,itemIds=itemIds.filter(isNotLocalId),Promise.all(itemIds.map(function(itemId){var url=instance.getUrl("Users/".concat(userId,"/PlayedItems/").concat(itemId,"/Delete"));return instance.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")}},{key:"updateFavoriteStatus",value:function(userId,itemIds,isFavorite){if(!userId)throw new Error("null userId");var instance;if(itemIds)return instance=this,itemIds=itemIds.filter(isNotLocalId),Promise.all(itemIds.map(function(itemId){var url=isFavorite?instance.getUrl("Users/".concat(userId,"/FavoriteItems/").concat(itemId)):instance.getUrl("Users/".concat(userId,"/FavoriteItems/").concat(itemId,"/Delete"));return instance.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")}},{key:"updateUserItemRating",value:function(userId,itemId,likes){if(!userId)throw new Error("null userId");if(itemId)return likes=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/Rating"),{likes:likes}),this.ajax({type:"POST",url:likes,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}));throw new Error("null itemId")}},{key:"updateHideFromResume",value:function(itemIds,hide){var userId,instance;if(itemIds)return userId=this.getCurrentUserId(),instance=this,Promise.all(itemIds.map(function(itemId){var url=instance.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/HideFromResume"),{Hide:!1!==hide});return instance.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:instance,userId:userId,itemId:itemId}))}));throw new Error("null itemIds")}},{key:"getItemCounts",value:function(userId){var options={},userId=(userId&&(options.userId=userId),this.getUrl("Items/Counts",options));return this.getJSON(userId)}},{key:"clearUserItemRating",value:function(userId,itemId){if(!userId)throw new Error("null userId");var url;if(itemId)return url=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/Rating/Delete")),this.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}));throw new Error("null itemId")}},{key:"reportPlaybackStart",value:function(options){if(!options)throw new Error("null options");this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing"),url=this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url});return options.ItemId&&!isLocalId(options.ItemId)&&this.ensureWebSocket(),url}},{key:"shouldSkipProgressReport",value:function(eventName,positionTicks){if("timeupdate"===(eventName||"timeupdate")){eventName=Date.now()-(this.lastPlaybackProgressReport||0);if(eventName<=1e4){if(!positionTicks)return Promise.resolve();eventName=1e4*eventName+(this.lastPlaybackProgressReportTicks||0);if(Math.abs((positionTicks||0)-eventName)<5e7)return Promise.resolve()}}return!1}},{key:"reportPlaybackProgress",value:function(options){if(!options)throw new Error("null options");var newPositionTicks=options.PositionTicks;if("timeupdate"===(options.EventName||"timeupdate")){var now=Date.now(),msSinceLastReport=now-(this.lastPlaybackProgressReport||0);if(msSinceLastReport<=1e4){if(!newPositionTicks)return Promise.resolve();msSinceLastReport=1e4*msSinceLastReport+(this.lastPlaybackProgressReportTicks||0);if(Math.abs((newPositionTicks||0)-msSinceLastReport)<5e7)return Promise.resolve()}this.lastPlaybackProgressReport=now}else this.lastPlaybackProgressReport=0;this.lastPlaybackProgressReportTicks=newPositionTicks;msSinceLastReport=this.getUrl("Sessions/Playing/Progress");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:msSinceLastReport})}},{key:"reportOfflineActions",value:function(actions){var url;if(actions)return url=this.getUrl("Sync/OfflineActions"),this.ajax({type:"POST",data:JSON.stringify(actions),contentType:"application/json",url:url});throw new Error("null actions")}},{key:"syncData",value:function(data){var url;if(data)return url=this.getUrl("Sync/Data"),this.ajax({type:"POST",data:JSON.stringify(data),contentType:"application/json",url:url,dataType:"json"});throw new Error("null data")}},{key:"getReadySyncItems",value:function(deviceId){if(deviceId)return deviceId=this.getUrl("Sync/Items/Ready",{TargetId:deviceId}),this.getJSON(deviceId);throw new Error("null deviceId")}},{key:"getSyncJobs",value:function(query){var instance=this,mode=query.mode;return delete query.mode,instance.getJSON(instance.getUrl("Sync/Jobs",query)).then(function(result){for(var items=result.Items,i=0,length=items.length;i<length;i++){var item=items[i];item.SyncJobType="convert"===mode?"Convert":"Download",!function(item,apiClient){item.Type="SyncJob",item.ServerId=apiClient.serverId()}(item,instance)}return result})}},{key:"createSyncJob",value:function(options){return this.ajax({type:"POST",url:this.getUrl("Sync/Jobs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"SyncJobCreated",Data:{IsLocalEvent:!0}}]),result}.bind({instance:this}))}},{key:"reportSyncJobItemTransferred",value:function(syncJobItemId){if(syncJobItemId)return syncJobItemId=this.getUrl("Sync/JobItems/".concat(syncJobItemId,"/Transferred")),this.ajax({type:"POST",url:syncJobItemId});throw new Error("null syncJobItemId")}},{key:"cancelSyncItems",value:function(itemIds,targetId){if(itemIds)return targetId="Sync/".concat(targetId||this.deviceId(),"/Items/Delete"),this.ajax({type:"POST",url:this.getUrl(targetId,{ItemIds:itemIds.join(",")})});throw new Error("null itemIds")}},{key:"clearUserTrackSelections",value:function(userId,type){var instance;if(userId)return type=(instance=this).getUrl("Users/".concat(userId,"/TrackSelections/").concat(type,"/Delete")),this.ajax({type:"POST",url:type}).then(function(){return updateCachedUser(instance,userId)});throw new Error("null userId")}},{key:"reportPlaybackStopped",value:function(options){if(!options)throw new Error("null options");this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing/Stopped");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url})}},{key:"sendPlayCommand",value:function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(options)return sessionId=this.getUrl("Sessions/".concat(sessionId,"/Playing"),options),this.ajax({type:"POST",url:sessionId});throw new Error("null options")}},{key:"sendCommand",value:function(sessionId,command){if(!sessionId)throw new Error("null sessionId");if(command)return(sessionId={type:"POST",url:this.getUrl("Sessions/".concat(sessionId,"/Command"))}).data=JSON.stringify(command),sessionId.contentType="application/json",this.ajax(sessionId);throw new Error("null command")}},{key:"sendMessageCommand",value:function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(options)return(sessionId={type:"POST",url:this.getUrl("Sessions/".concat(sessionId,"/Message"))}).data=JSON.stringify(options),sessionId.contentType="application/json",this.ajax(sessionId);throw new Error("null options")}},{key:"sendPlayStateCommand",value:function(sessionId,command,options){if(!sessionId)throw new Error("null sessionId");if(command)return sessionId=this.getUrl("Sessions/".concat(sessionId,"/Playing/").concat(command),options||{}),this.ajax({type:"POST",url:sessionId});throw new Error("null command")}},{key:"getSavedEndpointInfo",value:function(){return this._endPointInfo}},{key:"getEndpointInfo",value:function(signal){var instance,savedValue=this._endPointInfo;return savedValue?Promise.resolve(savedValue):(instance=this).getJSON(this.getUrl("System/Endpoint"),signal).then(function(endPointInfo){return instance._endPointInfo=endPointInfo})}},{key:"getWakeOnLanInfo",value:function(){return this.getJSON(this.getUrl("System/WakeOnLanInfo"))}},{key:"getLatestItems",value:function(){var options=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};return this.getJSON(this.getUrl("Users/".concat(this.getCurrentUserId(),"/Items/Latest"),options))}},{key:"getPlayQueue",value:function(options){return this.getJSON(this.getUrl("Sessions/PlayQueue",options))}},{key:"supportsWakeOnLan",value:function(){return!!_servicelocator.wakeOnLan.isSupported()&&0<getCachedWakeOnLanInfo(this).length}},{key:"wakeOnLan",value:function(){return function sendNextWakeOnLan(infos,index){var info;return index>=infos.length?Promise.resolve():(info=infos[index],console.log("sending wakeonlan to ".concat(info.MacAddress)),_servicelocator.wakeOnLan.send(info).then(goNext,goNext));function goNext(){return sendNextWakeOnLan(infos,index+1)}}(getCachedWakeOnLanInfo(this),0)}},{key:"getAddToPlaylistInfo",value:function(userId,id,addIds){return this.isMinServerVersion("4.8.0.30")?(id=this.getUrl("Playlists/"+id+"/AddToPlaylistInfo",{Ids:addIds,userId:userId}),this.getJSON(id)):Promise.resolve({ContainsDuplicates:!1,ItemCount:addIds.length})}},{key:"addToList",value:function(userId,type,id,addIds,skipDuplicates){var id=this.getUrl(("BoxSet"===type||"Collection"===type?"Collections":"Playlists")+"/"+id+"/Items"),dataType="Playlist"===type&&this.isMinServerVersion("4.8.0.30")?"json":null;return this.ajax({type:"POST",url:id,dataType:dataType,data:JSON.stringify({Ids:addIds.join(","),userId:userId,SkipDuplicates:"Playlist"===type?skipDuplicates:null}),contentType:"application/json"}).then(function(result){return null==(result=result||{}).ItemAddedCount&&(result.ItemAddedCount=addIds.length),Promise.resolve(result)})}},{key:"createList",value:function(userId,type,name,addIds){type=this.getUrl("BoxSet"===type||"Collection"===type?"Collections":"Playlists",{Name:name,Ids:addIds,userId:userId});return this.ajax({type:"POST",url:type,dataType:"json"}).then(function(result){return null==(result=result||{}).ItemAddedCount&&(result.ItemAddedCount=(addIds||[]).length),Promise.resolve(result)})}},{key:"setSystemInfo",value:function(systemInfo){null!=systemInfo.HasImageEnhancers&&(this.hasImageEnhancers=systemInfo.HasImageEnhancers),systemInfo.WakeOnLanInfo&&onWakeOnLanInfoFetched(this,systemInfo.WakeOnLanInfo),this._serverVersion=systemInfo.Version}},{key:"refreshSystemInfo",value:function(){}},{key:"serverVersion",value:function(){return this._serverVersion}},{key:"isMinServerVersion",value:function(version){var serverVersion=this.serverVersion();return!!serverVersion&&0<=function(a,b){a=a.split("."),b=b.split(".");for(var i=0,length=Math.max(a.length,b.length);i<length;i++){var aVal=parseInt(a[i]||"0"),bVal=parseInt(b[i]||"0");if(aVal<bVal)return-1;if(bVal<aVal)return 1}return 0}(serverVersion,version)}},{key:"handleMessageReceived",value:function(msg){onMessageReceivedInternal(this,msg)}},{key:"getSearchResults",value:function(query){var promises;return!query.SearchTerm||query.SearchTerm.length<1?Promise.resolve({Items:[],TotalRecordCount:0,ItemTypes:[]}):((promises=[]).push(this.getItems(this.getCurrentUserId(),query)),query.StartIndex||query.IncludeItemTypes||!1===query.IncludeSearchTypes||promises.push(this.getItemTypes(this.getCurrentUserId(),query)),Promise.all(promises).then(function(responses){return 1<responses.length&&(responses[0].ItemTypes=responses[1].Items),responses[0]}))}},{key:"getToneMapOptions",value:function(){var url=this.getUrl("Encoding/ToneMapOptions");return this.getJSON(url)}},{key:"moveItemsInPlaylist",value:function(playlistId,items,newIndex){for(var playlistItemIds=[],i=0,length=items.length;i<length;i++)items[i].PlaylistItemId&&playlistItemIds.push(items[i].PlaylistItemId);var playlistItemId=items[0].PlaylistItemId;return this.ajax({url:this.getUrl("Playlists/"+playlistId+"/Items/"+playlistItemId+"/Move/"+newIndex),type:"POST"}).then(function(result){var instance=this.instance,playlistItemIds=this.playlistItemIds,playlistId=this.playlistId;return _events.default.trigger(instance,"message",[{MessageType:"ItemsMovedInPlaylist",Data:{PlaylistId:playlistId,PlaylistItemIds:playlistItemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,playlistItemIds:playlistItemIds,playlistId:playlistId}))}},{key:"removeItemsFromPlaylist",value:function(playlistId,items){for(var playlistItemIds=[],i=0,length=items.length;i<length;i++)items[i].PlaylistItemId&&playlistItemIds.push(items[i].PlaylistItemId);return this.ajax({url:this.getUrl("Playlists/"+playlistId+"/Items/Delete",{EntryIds:playlistItemIds.join(",")}),type:"POST"}).then(function(result){var instance=this.instance,playlistItemIds=this.playlistItemIds,playlistId=this.playlistId;return _events.default.trigger(instance,"message",[{MessageType:"ItemsRemovedFromPlaylist",Data:{PlaylistId:playlistId,PlaylistItemIds:playlistItemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,playlistItemIds:playlistItemIds,playlistId:playlistId}))}},{key:"removeItemsFromCollection",value:function(collectionId,items){for(var itemIds=[],i=0,length=items.length;i<length;i++)itemIds.push(items[i].Id);return this.ajax({url:this.getUrl("Collections/"+collectionId+"/Items/Delete",{Ids:itemIds.join(",")}),type:"POST"}).then(function(result){var instance=this.instance,itemIds=this.itemIds,collectionId=this.collectionId;return _events.default.trigger(instance,"message",[{MessageType:"ItemsRemovedFromCollection",Data:{CollectionId:collectionId,ItemIds:itemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,itemIds:itemIds,collectionId:collectionId}))}},{key:"reconnectTest",value:function(signal){return tryReconnect(this,signal)}},{key:"mergeVersions",value:function(items){var instance=this;return this.ajax({type:"POST",url:this.getUrl("Videos/MergeVersions",{Ids:items.map(mapToId).join(",")})}).then(function(result){return _events.default.trigger(instance,"message",[{MessageType:"ItemsMerged",Data:{Items:items.map(mapToId),IsLocalEvent:!0}}]),result})}},{key:"ungroupVersions",value:function(id){var instance=this;return instance.ajax({type:"POST",url:instance.getUrl("Videos/"+id+"/AlternateSources/Delete")}).then(function(result){return _events.default.trigger(instance,"message",[{MessageType:"ItemsSplit",Data:{Items:[id],IsLocalEvent:!0}}]),result})}},{key:"makePublic",value:function(itemId){return this.ajax({type:"POST",url:this.getUrl("Items/"+itemId+"/MakePublic")}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"makePrivate",value:function(itemId){return this.ajax({type:"POST",url:this.getUrl("Items/"+itemId+"/MakePrivate")}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"updateUserItemAccess",value:function(options){return this.ajax({type:"POST",url:this.getUrl("Items/Access"),data:JSON.stringify(options),contentType:"application/json"})}},{key:"leaveSharedItems",value:function(options){return this.ajax({type:"POST",url:this.getUrl("Items/Shared/Leave"),data:JSON.stringify(options),contentType:"application/json"}).then(onItemsDeleted.bind({instance:this,items:options.ItemIds.map(function(i){return{Id:i}})}))}},{key:"downloadSubtitles",value:function(itemId,mediaSourceId,id){return this.ajax({type:"POST",url:this.getUrl("Items/"+itemId+"/RemoteSearch/Subtitles/"+id,{MediaSourceId:mediaSourceId}),dataType:"json"}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"resetMetadata",value:function(options){return this.ajax({type:"POST",url:this.getUrl("items/metadata/reset"),data:JSON.stringify(options),contentType:"application/json"}).then(function(result){var instance=this.instance,itemIds=this.itemIds;return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:[],ItemsUpdated:itemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,itemIds:options.ItemIds.split(",")}))}},{key:"applyRemoteSearchResult",value:function(itemId,searchResult,options){return this.ajax({type:"POST",url:this.getUrl("Items/RemoteSearch/Apply/"+itemId,options),data:JSON.stringify(searchResult),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"deleteSubtitles",value:function(itemId,mediaSourceId,subtitleStreamIndex){return this.ajax({type:"POST",url:this.getUrl("Videos/"+itemId+"/Subtitles/"+subtitleStreamIndex+"/Delete",{MediaSourceId:mediaSourceId})}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"cancelSyncJobs",value:function(ids){var instance=this;return Promise.all(ids.map(function(id){return instance.ajax({url:instance.getUrl("Sync/Jobs/"+id+"/Delete"),type:"POST"})})).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"SyncJobCancelled",Data:{IsLocalEvent:!0}}]),result}.bind({instance:this}))}},{key:"cancelSyncJobItems",value:function(ids){var instance=this;return Promise.all(ids.map(function(id){return instance.ajax({url:instance.getUrl("Sync/JobItems/"+id+"/Delete"),type:"POST"})})).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"SyncJobItemCancelled",Data:{IsLocalEvent:!0}}]),result}.bind({instance:this}))}},{key:"removeEmbyConnectLink",value:function(userId){return this.ajax({type:"POST",url:this.getUrl("Users/"+userId+"/Connect/Link/Delete")})}},{key:"createApiKey",value:function(options){return this.ajax({type:"POST",url:this.getUrl("Auth/Keys",options)}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"ApiKeyCreated",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this}))}},{key:"deleteApiKeySingle",value:function(accessToken){return this.ajax({type:"POST",url:this.getUrl("Auth/Keys/"+accessToken+"/Delete")})}},{key:"deleteApiKeys",value:function(items){return Promise.all(items.map(mapToAccessToken).map(this.deleteApiKeySingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"ApiKeysDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))}},{key:"deleteDevice",value:function(id){return this.deleteDevices([{Id:id}])}},{key:"deleteDeviceSingle",value:function(id){return this.ajax({type:"POST",url:this.getUrl("Devices/Delete",{Id:id})})}},{key:"deleteDevices",value:function(items){return Promise.all(items.map(mapToId).map(this.deleteDeviceSingle.bind(this))).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"DevicesDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this,items:items}))}},{key:"deleteLiveTVTunerDevice",value:function(id){return this.ajax({type:"POST",url:this.getUrl("LiveTv/TunerHosts/Delete",{Id:id})}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"LiveTVTunerDevicesDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this}))}},{key:"deleteLiveTVGuideSource",value:function(id){return this.ajax({type:"POST",url:this.getUrl("LiveTv/ListingProviders/Delete",{Id:id})}).then(function(result){var instance=this.instance;return _events.default.trigger(instance,"message",[{MessageType:"LiveTVGuideSourcesDeleted",Data:{Ids:[],IsLocalEvent:!0}}]),result}.bind({instance:this}))}},{key:"getConfigurationPages",value:function(options,signal){return null!=options&&options.EnableInUserMenu&&!this.isMinServerVersion("4.8.0.20")?Promise.resolve([]):this.getJSON(this.getUrl("web/configurationpages",Object.assign({PageType:"PluginConfiguration",UserId:this.getCurrentUserId()},options)),signal)}},{key:"getAvailableRecordingOptions",value:function(){return this.isMinServerVersion("4.8.0.58")?this.getJSON(this.getUrl("LiveTV/AvailableRecordingOptions")):Promise.resolve({RecordingFolders:[],MovieRecordingFolders:[],SeriesRecordingFolders:[]})}}])}();ApiClient.prototype.getUrl=getUrl,ApiClient.getUrl=getUrl,ApiClient.prototype.getScaledImageUrl=function(itemId,options){return this.getImageUrl(itemId,options)},ApiClient.isLocalId=isLocalId,ApiClient.isLocalItem=function(item){if(item){item=item.Id;if("string"==typeof item&&isLocalId(item))return!0}return!1},_exports.default=ApiClient});