#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.41.2
visibility:           public
id:                   dhall-1.41.2-KX134RCxuZfIzSaWLmIgvE
key:                  dhall-1.41.2-KX134RCxuZfIzSaWLmIgvE
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  82b05a8fe2ec5baf0cb319d9d54b93bf
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Import.Headers
    Dhall.Marshal.Internal Dhall.Normalize Dhall.Parser.Combinators
    Dhall.Pretty.Internal Dhall.Syntax Dhall.URL Paths_dhall
    Dhall.Import.HTTP Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.41.2-KX134RCxuZfIzSaWLmIgvE
depends:
    Diff-0.4.1-47RlfWGWXds34vUy9hSQS
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    aeson-pretty-0.8.10-1w3bzFq1eKcCRjNt7mV0fD
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE
    atomic-write-0.2.1.0-LOQnifIkDlnBR6ddi82jGu base-4.16.4.0
    base16-bytestring-1.0.2.0-E91HY5tPsI5AcRTlaN47xj
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-C9u4G83SV6G4MBj88LrUbo
    cborg-0.2.9.0-BZoFQ20pvIXBegBretBcdJ
    cborg-json-0.2.5.0-BLIbrLhBxSfIJTe43GwnB8 containers-0.6.5.1
    contravariant-1.5.5-6oWUjmJNxDBFhugVD5s9dq
    cryptohash-sha256-0.11.102.1-AxeJm27ybkeJA19MdDYNLU
    data-fix-0.3.2-DRWkqlruoBu8G3jd6MGomI deepseq-1.4.6.1
    directory-1.3.6.2 dotgen-0.4.3-GrGnAzxXk0NF0mUN2K7zar
    either-5.0.2-IsRu9KijQMsIAtixbpzC7M exceptions-0.10.4
    filepath-1.4.2.2 half-0.3.1-IptsrnsqsMaJKU0FfRAFm8
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3 haskeline-0.8.2
    http-client-0.7.17-JgdZSxk89UYJjfjCxx3dTH
    http-client-tls-0.3.6.3-9tLQnIY72wX7jTuvJ6seUd
    http-types-0.12.4-G97153ZIeGq6X7uXEs2l2V
    indexed-traversable-0.1.4-6wPCwLr0dTz5YsFQcHKUoV
    lens-family-core-2.1.3-1OBIJmYHsnQ2CJGGRserxu
    megaparsec-9.6.1-7WPy93vP8bY6Hp5k3jEfIt
    mmorph-1.2.0-86rQZSuTSAZIoeBosVXsFi mtl-2.2.2
    network-uri-2.6.4.2-EwAfSnfKix9WHRPnJWEEo
    optparse-applicative-0.17.1.0-AgMeQrX7nmlDOnX2xcegDb
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5
    parsers-0.12.11-4w44w2Sx6nXCRdG7Ne8XkK
    pretty-simple-4.1.2.0-3R2e5MieHhb1CbUFehFq5L
    prettyprinter-1.7.1-JEDC7ONR1vQJETgOTWpLZ0
    prettyprinter-ansi-terminal-1.1.3-4WG0PclEa1OHeT9lxo6Wrk
    profunctors-5.6.2-JxKh47DfsCg3BC80FZ7Vhy
    repline-0.4.2.0-8F4hfQj1tzA4brx66W1hS8
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa
    serialise-0.2.6.1-9yUtu9tUhWxC6H0oy4Gc4w template-haskell-2.18.0.0
    text-1.2.5.0 text-manipulate-0.3.1.0-4Z8wqRDnhoy19y7cYb1q6d
    text-short-0.1.6-7dqeCbTHeH0F2s6oD6Dpcz
    th-lift-instances-0.1.20-IADkcbonWiw49hgUprRlYc time-1.11.1.1
    transformers-0.5.6.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    uri-encode-1.5.0.7-8pV3nENV0YrL7vvbizqZdu
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

