/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIServiceConnectionEditor;
import org.jkiss.dbeaver.ui.dialogs.connection.AuthModelSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageWithAuth
extends ConnectionPageAbstract {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private AuthModelSelector authModelSelector;
    private UIServiceConnectionEditor serviceConnectionEditor;

    protected void createAuthPanel(Composite parent, int hSpan) {
        this.createAuthPanel(parent, hSpan, null);
    }

    protected void createAuthPanel(Composite parent, int hSpan, Runnable panelExtender) {
        Assert.isLegal((boolean)this.isAuthEnabled());
        this.authModelSelector = new AuthModelSelector(parent, () -> {
            Dialog.applyDialogFont((Control)this.authModelSelector);
            if (panelExtender != null) {
                panelExtender.run();
            }
        }, () -> this.getSite().updateButtons(), true, this.getIntention());
        this.authModelSelector.setLayoutData(new GridData(768));
        ((GridData)this.authModelSelector.getLayoutData()).horizontalSpan = hSpan;
        this.serviceConnectionEditor = (UIServiceConnectionEditor)DBWorkbench.getService(UIServiceConnectionEditor.class);
        if (this.serviceConnectionEditor != null) {
            this.serviceConnectionEditor.createControl(parent, this.getSite().getActiveDataSource(), () -> this.site.updateButtons());
        }
    }

    protected Composite getAuthPanelComposite() {
        Assert.isLegal((boolean)this.isAuthEnabled());
        return this.authModelSelector.getAuthPanelComposite();
    }

    @Override
    public void loadSettings() {
        DBPAuthModelDescriptor amReplace;
        DBPAuthModelDescriptor selectedAuthModel;
        super.loadSettings();
        if (!this.isAuthEnabled()) {
            return;
        }
        DBPDataSourceContainer dataSource = this.getSite().getActiveDataSource();
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (this.site.isNew() && CommonUtils.isEmpty((String)configuration.getUserName())) {
            configuration.setUserName(dataSource.getDriver().getDefaultUser());
        }
        if ((selectedAuthModel = dataSource.getDriver().getDataSourceProvider().detectConnectionAuthModel(dataSource.getDriver(), configuration)) != null && (amReplace = selectedAuthModel.getReplacedBy(dataSource.getDriver())) != null) {
            log.debug((Object)("Auth model '" + selectedAuthModel.getId() + "' was replaced by '" + amReplace.getId() + "'"));
            selectedAuthModel = amReplace;
            configuration.setAuthModelId(selectedAuthModel.getId());
        }
        this.authModelSelector.loadSettings(dataSource, selectedAuthModel, this.getDefaultAuthModelId(dataSource));
        if (this.serviceConnectionEditor != null) {
            this.serviceConnectionEditor.loadSettings(dataSource);
        }
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "native";
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (!this.isAuthEnabled()) {
            return;
        }
        if (this.authModelSelector != null) {
            DBPAuthModelDescriptor selectedAuthModel = this.authModelSelector.getSelectedAuthModel();
            dataSource.getConnectionConfiguration().setAuthModelId(selectedAuthModel == null ? null : selectedAuthModel.getId());
            this.authModelSelector.saveSettings(dataSource);
        }
        if (this.serviceConnectionEditor != null) {
            this.serviceConnectionEditor.saveSettings(dataSource);
        }
    }

    public boolean isComplete() {
        return !this.isAuthEnabled() || this.authModelSelector != null && this.authModelSelector.isComplete();
    }

    public boolean isExternalConfigurationProvided() {
        return this.serviceConnectionEditor != null && this.serviceConnectionEditor.isExternalConfigurationProvided();
    }

    protected boolean isAuthEnabled() {
        return true;
    }

    protected DBPConnectionEditIntention getIntention() {
        return DBPConnectionEditIntention.DEFAULT;
    }
}

